// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/base/jni_method.cpp,v 1.1.1.1 2001/07/23 07:25:38 xli18 Exp $
//



#include "platform.h"
#include <assert.h>
#include "Class.h"
#include "environment.h"
#include "orp_utils.h"
#include "orp_threads.h"
#include "root_set_enum.h"
#include "ini.h"

#include "jni.h"
#include "jni_utils.h"
#include "jni_direct.h"



jmethodID JNICALL GetMethodID(JNIEnv *env,
                              jclass clazz,
                              const char *name,
                              const char *sig)
{
    Object_Handle h = (Object_Handle)clazz;

    Class *clss = (Class *)h->java_reference;
    if(clss->state != ST_Initialized) {
        class_initialize_from_jni(clss, false);
        if(clss->state == ST_Error) {
            ThrowNew_Quick(env, "java/lang/ExceptionInInitializerError", clss->name->bytes);
            return 0;
        }
    }

    Method *method = class_lookup_method_recursive(clss, name, sig);

    if(!method) {
        ThrowNew_Quick(env, "java/lang/NoSuchMethodError", name);
        return 0;
    }

    assert(!method->is_static());
    return (jmethodID)method;
} //GetMethodID



jmethodID JNICALL GetStaticMethodID(JNIEnv *env,
                                    jclass clazz,
                                    const char *name,
                                    const char *sig)
{
    Object_Handle h = (Object_Handle)clazz;

    Class *clss = (Class *)h->java_reference;
    if(clss->state != ST_Initialized) {
        class_initialize_from_jni(clss, false);
        if(clss->state == ST_Error) {
            ThrowNew_Quick(env, "java/lang/ExceptionInInitializerError", clss->name->bytes);
            return 0;
        }
    }

    Method *method = class_lookup_method_recursive(clss, name, sig);

    if(!method) {
        ThrowNew_Quick(env, "java/lang/NoSuchMethodError", name);
        return 0;
    }

    assert(method->is_static());
    return (jmethodID)method;
} //GetStaticMethodID



/////////////////////////////////////////////////////////////////////////////
// begin Call<Type>MethodA functions


static void call_method_no_ref_result(JNIEnv *env,
                                      jobject obj,
                                      jmethodID methodID,
                                      jvalue *args,
                                      J_Value *result,
                                      int non_virtual)
{
    Method *method = (Method *)methodID;
    Object_Handle h = (Object_Handle)obj;
 
    if ( !non_virtual ) {
        // lookup the underlying "real" (e.g. abstract) method
        method = object_lookup_method( (Java_java_lang_Object *)h->java_reference, 
                                       method->get_name()->bytes, method->get_descriptor() );
    }
    unsigned num_args = method->get_num_args();
    J_Value *direct_args = (J_Value *)orp_malloc_gc_safe(num_args * sizeof(J_Value));

    orp_disable_gc();       //---------------------------------v

    direct_args[0].r = h->java_reference;
    unhandle_jni_args(env, method, direct_args + 1, args, num_args - 1);
    orp_execute_java_method_array(method, result, direct_args);
    orp_free_gc_safe(direct_args);

    orp_enable_gc();        //---------------------------------^
} //call_method_no_ref_result



void JNICALL CallVoidMethod(JNIEnv *env, jobject obj, jmethodID methodID, ...)
{
    va_list args;
    va_start(args, methodID);
    CallVoidMethodV(env, obj, methodID, args);
} //CallVoidMethod



void JNICALL CallVoidMethodV(JNIEnv *env, jobject obj, jmethodID methodID, va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    CallVoidMethodA(env, obj, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
} //CallVoidMethodV



void JNICALL CallVoidMethodA(JNIEnv *env,
                             jobject obj,
                             jmethodID methodID,
                             jvalue *args)
{
    call_method_no_ref_result(env, obj, methodID, args, 0, FALSE);
} //CallVoidMethodA



jobject JNICALL CallObjectMethod(JNIEnv *env, jobject obj, jmethodID methodID, ...)
{
    va_list args;
    va_start(args, methodID);
    return CallObjectMethodV(env, obj, methodID, args);
} //CallObjectMethod



jobject JNICALL CallObjectMethodV(JNIEnv *env, jobject obj, jmethodID methodID, va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jobject result = CallObjectMethodA(env, obj, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallObjectMethodV



jobject JNICALL CallObjectMethodA(JNIEnv *env,
                                  jobject obj,
                                  jmethodID methodID,
                                  jvalue *args)
{
    J_Value result;
    Object_Handle new_handle;
    Method *method = (Method *)methodID; // resolve to actual vtable entry below
    Object_Handle h = (Object_Handle)obj;

    method = object_lookup_method((Java_java_lang_Object *)h->java_reference, 
                                   method->get_name()->bytes,
                                   method->get_descriptor()   );

    unsigned num_args = method->get_num_args();
    J_Value *direct_args = (J_Value *)orp_malloc_gc_safe(num_args * sizeof(J_Value));

    orp_disable_gc();       //---------------------------------v

    direct_args[0].r = h->java_reference;
    unhandle_jni_args(env, method, direct_args + 1, args, num_args - 1);
    orp_execute_java_method_array(method, &result, direct_args);
    if(result.r) {
        new_handle = orp_create_local_object_handle();
        new_handle->java_reference = (Java_java_lang_Object *)result.r;
    } else {
        new_handle = 0;
    }
    orp_free_gc_safe(direct_args);

    orp_enable_gc();        //---------------------------------^

    return new_handle;
} //CallObjectMethodA



jboolean JNICALL CallBooleanMethod(JNIEnv *env, jobject obj, jmethodID methodID, ...)
{
    va_list args;
    va_start(args, methodID);
    return CallBooleanMethodV(env, obj, methodID, args);
} //CallBooleanMethod



jboolean JNICALL CallBooleanMethodV(JNIEnv *env, jobject obj, jmethodID methodID, va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jboolean result = CallBooleanMethodA(env, obj, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallBooleanMethodV



jboolean JNICALL CallBooleanMethodA(JNIEnv *env,
                                    jobject obj,
                                    jmethodID methodID,
                                    jvalue *args)
{
    J_Value result;
    call_method_no_ref_result(env, obj, methodID, args, &result, FALSE);
    return result.z;
} //CallBooleanMethodA



jbyte JNICALL CallByteMethod(JNIEnv *env, jobject obj, jmethodID methodID, ...)
{
    va_list args;
    va_start(args, methodID);
    return CallByteMethodV(env, obj, methodID, args);
} //CallByteMethod



jbyte JNICALL CallByteMethodV(JNIEnv *env, jobject obj, jmethodID methodID, va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jbyte result = CallByteMethodA(env, obj, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallByteMethodV



jbyte JNICALL CallByteMethodA(JNIEnv *env,
                              jobject obj,
                              jmethodID methodID,
                              jvalue *args)
{
    J_Value result;
    call_method_no_ref_result(env, obj, methodID, args, &result, FALSE);
    return result.b;
} //CallByteMethodA




jchar JNICALL CallCharMethod(JNIEnv *env, jobject obj, jmethodID methodID, ...)
{
    va_list args;
    va_start(args, methodID);
    return CallCharMethodV(env, obj, methodID, args);
} //CallCharMethod



jchar JNICALL CallCharMethodV(JNIEnv *env, jobject obj, jmethodID methodID, va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jchar result = CallCharMethodA(env, obj, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallCharMethodV



jchar JNICALL CallCharMethodA(JNIEnv *env,
                              jobject obj,
                              jmethodID methodID,
                              jvalue *args)
{
    J_Value result;
    call_method_no_ref_result(env, obj, methodID, args, &result, FALSE);
    return result.c;
} //CallCharMethodA




jshort JNICALL CallShortMethod(JNIEnv *env, jobject obj, jmethodID methodID, ...)
{
    va_list args;
    va_start(args, methodID);
    return CallShortMethodV(env, obj, methodID, args);
} //CallShortMethod



jshort JNICALL CallShortMethodV(JNIEnv *env, jobject obj, jmethodID methodID, va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jshort result = CallShortMethodA(env, obj, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallShortMethodV



jshort JNICALL CallShortMethodA(JNIEnv *env,
                                jobject obj,
                                jmethodID methodID,
                                jvalue *args)
{
    J_Value result;
    call_method_no_ref_result(env, obj, methodID, args, &result, FALSE);
    return result.s;
} //CallShortMethodA




jint JNICALL CallIntMethod(JNIEnv *env, jobject obj, jmethodID methodID, ...)
{
    va_list args;
    va_start(args, methodID);
    return CallIntMethodV(env, obj, methodID, args);
} //CallIntMethod



jint JNICALL CallIntMethodV(JNIEnv *env, jobject obj, jmethodID methodID, va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jint result = CallIntMethodA(env, obj, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallIntMethodV



jint JNICALL CallIntMethodA(JNIEnv *env,
                              jobject obj,
                              jmethodID methodID,
                              jvalue *args)
{
    J_Value result;
    call_method_no_ref_result(env, obj, methodID, args, &result, FALSE);
    return result.i;
} //CallIntMethodA




jlong JNICALL CallLongMethod(JNIEnv *env, jobject obj, jmethodID methodID, ...)
{
    va_list args;
    va_start(args, methodID);
    return CallLongMethodV(env, obj, methodID, args);
} //CallLongMethod



jlong JNICALL CallLongMethodV(JNIEnv *env, jobject obj, jmethodID methodID, va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jlong result = CallLongMethodA(env, obj, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallLongMethodV



jlong JNICALL CallLongMethodA(JNIEnv *env,
                              jobject obj,
                              jmethodID methodID,
                              jvalue *args)
{
    J_Value result;
    call_method_no_ref_result(env, obj, methodID, args, &result, FALSE);
    return result.j;
} //CallLongMethodA




jfloat JNICALL CallFloatMethod(JNIEnv *env, jobject obj, jmethodID methodID, ...)
{
    va_list args;
    va_start(args, methodID);
    return CallFloatMethodV(env, obj, methodID, args);
} //CallFloatMethod



jfloat JNICALL CallFloatMethodV(JNIEnv *env, jobject obj, jmethodID methodID, va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jfloat result = CallFloatMethodA(env, obj, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallFloatMethodV



jfloat JNICALL CallFloatMethodA(JNIEnv *env,
                                jobject obj,
                                jmethodID methodID,
                                jvalue *args)
{
    J_Value result;
    call_method_no_ref_result(env, obj, methodID, args, &result, FALSE);
    return result.f;
} //CallFloatMethodA




jdouble JNICALL CallDoubleMethod(JNIEnv *env, jobject obj, jmethodID methodID, ...)
{
    va_list args;
    va_start(args, methodID);
    return CallDoubleMethodV(env, obj, methodID, args);
} //CallDoubleMethod



jdouble JNICALL CallDoubleMethodV(JNIEnv *env, jobject obj, jmethodID methodID, va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jdouble result = CallDoubleMethodA(env, obj, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallDoubleMethodV



jdouble JNICALL CallDoubleMethodA(JNIEnv *env,
                                  jobject obj,
                                  jmethodID methodID,
                                  jvalue *args)
{
    J_Value result;
    call_method_no_ref_result(env, obj, methodID, args, &result, FALSE);
    return result.d;
} //CallDoubleMethodA




// end Call<Type>MethodA functions
/////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////
// begin CallNonvirtual<Type>MethodA functions


void JNICALL CallNonvirtualVoidMethod(JNIEnv *env,
                                       jobject obj,
                                       jclass clazz,
                                       jmethodID methodID,
                                       ...)
{
    va_list args;
    va_start(args, methodID);
    CallNonvirtualVoidMethodV(env, obj, clazz, methodID, args);
} //CallNonvirtualVoidMethod



void JNICALL CallNonvirtualVoidMethodV(JNIEnv *env,
                                       jobject obj,
                                       jclass clazz,
                                       jmethodID methodID,
                                       va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    CallNonvirtualVoidMethodA(env, obj, clazz, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
} //CallNonvirtualVoidMethodV



void JNICALL CallNonvirtualVoidMethodA(JNIEnv *env,
                                       jobject obj,
                                       jclass clazz,
                                       jmethodID methodID,
                                       jvalue *args)
{
    call_method_no_ref_result(env, obj, methodID, args, 0, TRUE);
} //CallNonvirtualVoidMethodA



jobject JNICALL CallNonvirtualObjectMethod(JNIEnv *env,
                                           jobject obj,
                                           jclass clazz,
                                           jmethodID methodID,
                                           ...)
{
    va_list args;
    va_start(args, methodID);
    return CallNonvirtualObjectMethodV(env, obj, clazz, methodID, args);
} //CallNonvirtualObjectMethod



jobject JNICALL CallNonvirtualObjectMethodV(JNIEnv *env,
                                            jobject obj,
                                            jclass clazz,
                                            jmethodID methodID,
                                            va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jobject result = CallNonvirtualObjectMethodA(env, obj, clazz, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallNonvirtualObjectMethodV



jobject JNICALL CallNonvirtualObjectMethodA(JNIEnv *env,
                                            jobject obj,
                                            jclass clazz,
                                            jmethodID methodID,
                                            jvalue *args)
{
    J_Value result;
    Object_Handle new_handle;
    Method *method = (Method *)methodID;
    unsigned num_args = method->get_num_args();
    Object_Handle h = (Object_Handle)obj;
    J_Value *direct_args = (J_Value *)orp_malloc_gc_safe(num_args * sizeof(J_Value));

    orp_disable_gc();       //---------------------------------v

    direct_args[0].r = h->java_reference;
    unhandle_jni_args(env, method, direct_args + 1, args, num_args - 1);
    orp_execute_java_method_array(method, &result, direct_args);
    if(result.r) {
        new_handle = orp_create_local_object_handle();
        new_handle->java_reference = (Java_java_lang_Object *)result.r;
    } else {
        new_handle = 0;
    }
    orp_free_gc_safe(direct_args);

    orp_enable_gc();        //---------------------------------^

    return new_handle;
} //CallNonvirtualObjectMethodA



jboolean JNICALL CallNonvirtualBooleanMethod(JNIEnv *env,
                                             jobject obj,
                                             jclass clazz,
                                             jmethodID methodID,
                                             ...)
{
    va_list args;
    va_start(args, methodID);
    return CallNonvirtualBooleanMethodV(env, obj, clazz, methodID, args);
} //CallNonvirtualBooleanMethod



jboolean JNICALL CallNonvirtualBooleanMethodV(JNIEnv *env,
                                              jobject obj,
                                              jclass clazz,
                                              jmethodID methodID,
                                              va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jboolean result = CallNonvirtualBooleanMethodA(env, obj, clazz, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallNonvirtualBooleanMethodV



jboolean JNICALL CallNonvirtualBooleanMethodA(JNIEnv *env,
                                              jobject obj,
                                              jclass clazz,
                                              jmethodID methodID,
                                              jvalue *args)
{
    J_Value result;
    call_method_no_ref_result(env, obj, methodID, args, &result, TRUE);
    return result.z;
} //CallNonvirtualBooleanMethodA



jbyte JNICALL CallNonvirtualByteMethod(JNIEnv *env,
                                       jobject obj,
                                       jclass clazz,
                                       jmethodID methodID,
                                       ...)
{
    va_list args;
    va_start(args, methodID);
    return CallNonvirtualByteMethodV(env, obj, clazz, methodID, args);
} //CallNonvirtualByteMethod



jbyte JNICALL CallNonvirtualByteMethodV(JNIEnv *env,
                                        jobject obj,
                                        jclass clazz,
                                        jmethodID methodID,
                                        va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jbyte result = CallNonvirtualByteMethodA(env, obj, clazz, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallNonvirtualByteMethodV



jbyte JNICALL CallNonvirtualByteMethodA(JNIEnv *env,
                                        jobject obj,
                                        jclass clazz,
                                        jmethodID methodID,
                                        jvalue *args)
{
    J_Value result;
    call_method_no_ref_result(env, obj, methodID, args, &result, TRUE);
    return result.b;
} //CallNonvirtualByteMethodA



jchar JNICALL CallNonvirtualCharMethod(JNIEnv *env,
                                       jobject obj,
                                       jclass clazz,
                                       jmethodID methodID,
                                       ...)
{
    va_list args;
    va_start(args, methodID);
    return CallNonvirtualCharMethodV(env, obj, clazz, methodID, args);
} //CallNonvirtualCharMethod



jchar JNICALL CallNonvirtualCharMethodV(JNIEnv *env,
                                        jobject obj,
                                        jclass clazz,
                                        jmethodID methodID,
                                        va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jchar result = CallNonvirtualCharMethodA(env, obj, clazz, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallNonvirtualCharMethodV



jchar JNICALL CallNonvirtualCharMethodA(JNIEnv *env,
                                        jobject obj,
                                        jclass clazz,
                                        jmethodID methodID,
                                        jvalue *args)
{
    J_Value result;
    call_method_no_ref_result(env, obj, methodID, args, &result, TRUE);
    return result.c;
} //CallNonvirtualCharMethodA



jshort JNICALL CallNonvirtualShortMethod(JNIEnv *env,
                                         jobject obj,
                                         jclass clazz,
                                         jmethodID methodID,
                                         ...)
{
    va_list args;
    va_start(args, methodID);
    return CallNonvirtualShortMethodV(env, obj, clazz, methodID, args);
} //CallNonvirtualShortMethod



jshort JNICALL CallNonvirtualShortMethodV(JNIEnv *env,
                                          jobject obj,
                                          jclass clazz,
                                          jmethodID methodID,
                                          va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jshort result = CallNonvirtualShortMethodA(env, obj, clazz, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallNonvirtualShortMethodV



jshort JNICALL CallNonvirtualShortMethodA(JNIEnv *env,
                                          jobject obj,
                                          jclass clazz,
                                          jmethodID methodID,
                                          jvalue *args)
{
    J_Value result;
    call_method_no_ref_result(env, obj, methodID, args, &result, TRUE);
    return result.s;
} //CallNonvirtualShortMethodA



jint JNICALL CallNonvirtualIntMethod(JNIEnv *env,
                                     jobject obj,
                                     jclass clazz,
                                     jmethodID methodID,
                                     ...)
{
    va_list args;
    va_start(args, methodID);
    return CallNonvirtualIntMethodV(env, obj, clazz, methodID, args);
} //CallNonvirtualIntMethod



jint JNICALL CallNonvirtualIntMethodV(JNIEnv *env,
                                      jobject obj,
                                      jclass clazz,
                                      jmethodID methodID,
                                      va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jint result = CallNonvirtualIntMethodA(env, obj, clazz, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallNonvirtualIntMethodV



jint JNICALL CallNonvirtualIntMethodA(JNIEnv *env,
                                      jobject obj,
                                      jclass clazz,
                                      jmethodID methodID,
                                      jvalue *args)
{
    J_Value result;
    call_method_no_ref_result(env, obj, methodID, args, &result,  TRUE);
    return result.i;
} //CallNonvirtualIntMethodA



jlong JNICALL CallNonvirtualLongMethod(JNIEnv *env,
                                       jobject obj,
                                       jclass clazz,
                                       jmethodID methodID,
                                       ...)
{
    va_list args;
    va_start(args, methodID);
    return CallNonvirtualLongMethodV(env, obj, clazz, methodID, args);
} //CallNonvirtualLongMethod



jlong JNICALL CallNonvirtualLongMethodV(JNIEnv *env,
                                        jobject obj,
                                        jclass clazz,
                                        jmethodID methodID,
                                        va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jlong result = CallNonvirtualLongMethodA(env, obj, clazz, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallNonvirtualLongMethodV



jlong JNICALL CallNonvirtualLongMethodA(JNIEnv *env,
                                        jobject obj,
                                        jclass clazz,
                                        jmethodID methodID,
                                        jvalue *args)
{
    J_Value result;
    call_method_no_ref_result(env, obj, methodID, args, &result, TRUE);
    return result.j;
} //CallNonvirtualLongMethodA



jfloat JNICALL CallNonvirtualFloatMethod(JNIEnv *env,
                                         jobject obj,
                                         jclass clazz,
                                         jmethodID methodID,
                                         ...)
{
    va_list args;
    va_start(args, methodID);
    return CallNonvirtualFloatMethodV(env, obj, clazz, methodID, args);
} //CallNonvirtualFloatMethod



jfloat JNICALL CallNonvirtualFloatMethodV(JNIEnv *env,
                                          jobject obj,
                                          jclass clazz,
                                          jmethodID methodID,
                                          va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jfloat result = CallNonvirtualFloatMethodA(env, obj, clazz, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallNonvirtualFloatMethodV



jfloat JNICALL CallNonvirtualFloatMethodA(JNIEnv *env,
                                            jobject obj,
                                            jclass clazz,
                                            jmethodID methodID,
                                            jvalue *args)
{
    J_Value result;
    call_method_no_ref_result(env, obj, methodID, args, &result, TRUE);
    return result.f;
} //CallNonvirtualFloatMethodA



jdouble JNICALL CallNonvirtualDoubleMethod(JNIEnv *env,
                                           jobject obj,
                                           jclass clazz,
                                           jmethodID methodID,
                                           ...)
{
    va_list args;
    va_start(args, methodID);
    return CallNonvirtualDoubleMethodV(env, obj, clazz, methodID, args);
} //CallNonvirtualDoubleMethod



jdouble JNICALL CallNonvirtualDoubleMethodV(JNIEnv *env,
                                            jobject obj,
                                            jclass clazz,
                                            jmethodID methodID,
                                            va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jdouble result = CallNonvirtualDoubleMethodA(env, obj, clazz, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallNonvirtualDoubleMethodV



jdouble JNICALL CallNonvirtualDoubleMethodA(JNIEnv *env,
                                            jobject obj,
                                            jclass clazz,
                                            jmethodID methodID,
                                            jvalue *args)
{
    J_Value result;
    call_method_no_ref_result(env, obj, methodID, args, &result, TRUE);
    return result.d;
} //CallNonvirtualDoubleMethodA



// end CallNonvirtual<Type>MethodA functions
/////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////
// begin CallStatic<Type>MethodA functions


static void call_static_method_no_ref_result(JNIEnv *env,
                                             jclass clazz,
                                             jmethodID methodID,
                                             jvalue *args,
                                             J_Value *result)
{
    Method *method = (Method *)methodID;
    unsigned num_args = method->get_num_args();
    J_Value *direct_args = (J_Value *)orp_malloc_gc_safe(num_args * sizeof(J_Value));

    orp_disable_gc();       //---------------------------------v

    unhandle_jni_args(env, method, direct_args, args, num_args);
    orp_execute_java_method_array(method, result, direct_args);
    orp_free_gc_safe(direct_args);

    orp_enable_gc();        //---------------------------------^
} //call_static_method_no_ref_result



jobject JNICALL CallStaticObjectMethod(JNIEnv *env, jclass clazz, jmethodID methodID, ...)
{
    va_list args;
    va_start(args, methodID);
    return CallStaticObjectMethodV(env, clazz, methodID, args);
} //CallStaticObjectMethod



jobject JNICALL CallStaticObjectMethodV(JNIEnv *env, jclass clazz, jmethodID methodID, va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jobject result = CallStaticObjectMethodA(env, clazz, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallStaticObjectMethodV



jobject JNICALL CallStaticObjectMethodA(JNIEnv *env,
                                        jclass clazz,
                                        jmethodID methodID,
                                        jvalue *args)
{
    J_Value result;
    Object_Handle new_handle;
    Method *method = (Method *)methodID;
    unsigned num_args = method->get_num_args();
    J_Value *direct_args = (J_Value *)orp_malloc_gc_safe(num_args * sizeof(J_Value));

    orp_disable_gc();       //---------------------------------v

    unhandle_jni_args(env, method, direct_args, args, num_args);
    orp_execute_java_method_array(method, &result, direct_args);
    if(result.r) {
        new_handle = orp_create_local_object_handle();
        new_handle->java_reference = (Java_java_lang_Object *)result.r;
    } else {
        new_handle = 0;
    }
    orp_free_gc_safe(direct_args);

    orp_enable_gc();        //---------------------------------^

    return new_handle;
} //CallStaticObjectMethodA



jboolean JNICALL CallStaticBooleanMethod(JNIEnv *env, jclass clazz, jmethodID methodID, ...)
{
    va_list args;
    va_start(args, methodID);
    return CallStaticBooleanMethodV(env, clazz, methodID, args);
} //CallStaticBooleanMethod



jboolean JNICALL CallStaticBooleanMethodV(JNIEnv *env, jclass clazz, jmethodID methodID, va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jboolean result = CallStaticBooleanMethodA(env, clazz, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallStaticBooleanMethodV



jboolean JNICALL CallStaticBooleanMethodA(JNIEnv *env,
                                          jclass clazz,
                                          jmethodID methodID,
                                          jvalue *args)
{
    J_Value result;
    call_static_method_no_ref_result(env, clazz, methodID, args, &result);
    return result.z;
} //CallStaticBooleanMethodA



jbyte JNICALL CallStaticByteMethod(JNIEnv *env, jclass clazz, jmethodID methodID, ...)
{
    va_list args;
    va_start(args, methodID);
    return CallStaticByteMethodV(env, clazz, methodID, args);
} //CallStaticByteMethod



jbyte JNICALL CallStaticByteMethodV(JNIEnv *env, jclass clazz, jmethodID methodID, va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jbyte result = CallStaticByteMethodA(env, clazz, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallStaticByteMethodV



jbyte JNICALL CallStaticByteMethodA(JNIEnv *env,
                                    jclass clazz,
                                    jmethodID methodID,
                                    jvalue *args)
{
    J_Value result;
    call_static_method_no_ref_result(env, clazz, methodID, args, &result);
    return result.b;
} //CallStaticByteMethodA



jchar JNICALL CallStaticCharMethod(JNIEnv *env, jclass clazz, jmethodID methodID, ...)
{
    va_list args;
    va_start(args, methodID);
    return CallStaticCharMethodV(env, clazz, methodID, args);
} //CallStaticCharMethod



jchar JNICALL CallStaticCharMethodV(JNIEnv *env, jclass clazz, jmethodID methodID, va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jchar result = CallStaticCharMethodA(env, clazz, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallStaticCharMethodV



jchar JNICALL CallStaticCharMethodA(JNIEnv *env,
                                    jclass clazz,
                                    jmethodID methodID,
                                    jvalue *args)
{
    J_Value result;
    call_static_method_no_ref_result(env, clazz, methodID, args, &result);
    return result.c;
} //CallStaticCharMethodA



jshort JNICALL CallStaticShortMethod(JNIEnv *env, jclass clazz, jmethodID methodID, ...)
{
    va_list args;
    va_start(args, methodID);
    return CallStaticShortMethodV(env, clazz, methodID, args);
} //CallStaticShortMethod



jshort JNICALL CallStaticShortMethodV(JNIEnv *env, jclass clazz, jmethodID methodID, va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jshort result = CallStaticShortMethodA(env, clazz, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallStaticShortMethodV



jshort JNICALL CallStaticShortMethodA(JNIEnv *env,
                                      jclass clazz,
                                      jmethodID methodID,
                                      jvalue *args)
{
    J_Value result;
    call_static_method_no_ref_result(env, clazz, methodID, args, &result);
    return result.s;
} //CallStaticShortMethodA



jint JNICALL CallStaticIntMethod(JNIEnv *env, jclass clazz, jmethodID methodID, ...)
{
    va_list args;
    va_start(args, methodID);
    return CallStaticIntMethodV(env, clazz, methodID, args);
} //CallStaticIntMethod



jint JNICALL CallStaticIntMethodV(JNIEnv *env, jclass clazz, jmethodID methodID, va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jint result = CallStaticIntMethodA(env, clazz, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallStaticIntMethodV



jint JNICALL CallStaticIntMethodA(JNIEnv *env,
                                  jclass clazz,
                                  jmethodID methodID,
                                  jvalue *args)
{
    J_Value result;
    call_static_method_no_ref_result(env, clazz, methodID, args, &result);
    return result.i;
} //CallStaticIntMethodA



jlong JNICALL CallStaticLongMethod(JNIEnv *env, jclass clazz, jmethodID methodID, ...)
{
    va_list args;
    va_start(args, methodID);
    return CallStaticLongMethodV(env, clazz, methodID, args);
} //CallStaticLongMethod



jlong JNICALL CallStaticLongMethodV(JNIEnv *env, jclass clazz, jmethodID methodID, va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jlong result = CallStaticLongMethodA(env, clazz, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallStaticLongMethodV



jlong JNICALL CallStaticLongMethodA(JNIEnv *env,
                                    jclass clazz,
                                    jmethodID methodID,
                                    jvalue *args)
{
    J_Value result;
    call_static_method_no_ref_result(env, clazz, methodID, args, &result);
    return result.j;
} //CallStaticLongMethodA



jfloat JNICALL CallStaticFloatMethod(JNIEnv *env, jclass clazz, jmethodID methodID, ...)
{
    va_list args;
    va_start(args, methodID);
    return CallStaticFloatMethodV(env, clazz, methodID, args);
} //CallStaticFloatMethod



jfloat JNICALL CallStaticFloatMethodV(JNIEnv *env, jclass clazz, jmethodID methodID, va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jfloat result = CallStaticFloatMethodA(env, clazz, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallStaticFloatMethodV



jfloat JNICALL CallStaticFloatMethodA(JNIEnv *env,
                                      jclass clazz,
                                      jmethodID methodID,
                                      jvalue *args)
{
    J_Value result;
    call_static_method_no_ref_result(env, clazz, methodID, args, &result);
    return result.f;
} //CallStaticFloatMethodA



jdouble JNICALL CallStaticDoubleMethod(JNIEnv *env, jclass clazz, jmethodID methodID, ...)
{
    va_list args;
    va_start(args, methodID);
    return CallStaticDoubleMethodV(env, clazz, methodID, args);
} //CallStaticDoubleMethod



jdouble JNICALL CallStaticDoubleMethodV(JNIEnv *env, jclass clazz, jmethodID methodID, va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    jdouble result = CallStaticDoubleMethodA(env, clazz, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
    return result;
} //CallStaticDoubleMethodV



jdouble JNICALL CallStaticDoubleMethodA(JNIEnv *env,
                                        jclass clazz,
                                        jmethodID methodID,
                                        jvalue *args)
{
    J_Value result;
    call_static_method_no_ref_result(env, clazz, methodID, args, &result);
    return result.d;
} //CallStaticDoubleMethodA



void JNICALL CallStaticVoidMethod(JNIEnv *env, jclass clazz, jmethodID methodID, ...)
{
    va_list args;
    va_start(args, methodID);
    CallStaticVoidMethodV(env, clazz, methodID, args);
} //CallStaticVoidMethod



void JNICALL CallStaticVoidMethodV(JNIEnv *env, jclass clazz, jmethodID methodID, va_list args)
{
    jvalue *jvalue_args = get_jvalue_arg_array((Method *)methodID, args);
    CallStaticVoidMethodA(env, clazz, methodID, jvalue_args);
    orp_free_gc_safe(jvalue_args);
} //CallStaticVoidMethodV



void JNICALL CallStaticVoidMethodA(JNIEnv *env,
                                   jclass clazz,
                                   jmethodID methodID,
                                   jvalue *args)
{
    call_static_method_no_ref_result(env, clazz, methodID, args, 0);
} //CallStaticVoidMethodA



// end CallStatic<Type>MethodA functions
/////////////////////////////////////////////////////////////////////////////




