// Copyright (C)  2001 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/java_io_ObjectInputStream.cpp,v 1.3 2001/08/17 03:09:32 gwu2 Exp $
//

#ifdef ORP_POSIX
#include <unistd.h>
#endif

#include "platform.h"
#include <assert.h>
#include "object_layout.h"
#include "orp_utils.h"
#include "exceptions.h"
#include "jni.h"

#include <sys/types.h>
#include <sys/stat.h>

#ifdef ORP_NT
#include <io.h>
#endif

#include "native_utils.h"
#include "jni_direct.h"
#include "jni_utils.h"
#include "object_layout.h"

#include <fcntl.h>

#ifdef ORP_NT
#include <direct.h>
#endif

#include <errno.h>
#include "VMSystem.h"
#include "java_io_ObjectInputStream.h"
#include "environment.h"

/*
 * Class:     java_io_ObjectInputStream
 * Method:    allocateObject
 * Signature: (Ljava/lang/Class;)Ljava/lang/Object;
 */
JNIEXPORT jobject JNICALL Java_java_io_ObjectInputStream_allocateObject
  (JNIEnv *jenv, jobject p_this, jclass clazz)
{
	return AllocObject(jenv, clazz);
}

/*
 * Class:     java_io_ObjectInputStream
 * Method:    callConstructor
 * Signature: (Ljava/lang/Class;Ljava/lang/Object;)V
 */
JNIEXPORT void JNICALL Java_java_io_ObjectInputStream_callConstructor
  (JNIEnv *jenv, jobject p_this, jclass clazz, jobject obj)
{
	jmethodID method_id = GetMethodID(jenv, clazz, "<init>", "()V");
	CallNonvirtualVoidMethod(jenv, obj, clazz, method_id);
}

/*
 * Class:     java_io_ObjectInputStream
 * Method:    callReadMethod
 * Signature: (Ljava/lang/Object;Ljava/lang/Class;)V
 */
JNIEXPORT void JNICALL Java_java_io_ObjectInputStream_callReadMethod
  (JNIEnv *jenv, jobject p_this, jobject obj, jclass clazz)
{
	jmethodID method_id = GetMethodID(jenv, 
									clazz,
									"readObject",
									"(Ljava/io/ObjectInputStream;)V" );
  
	if(!method_id)return;
  
	CallNonvirtualVoidMethod(jenv, obj, clazz, method_id, p_this);
}

/*
 * Class:     java_io_ObjectInputStream
 * Method:    currentClassLoader
 * Signature: (Ljava/lang/SecurityManager;)Ljava/lang/ClassLoader;
 */
JNIEXPORT jobject JNICALL Java_java_io_ObjectInputStream_currentClassLoader
  (JNIEnv *jenv, jclass c_this, jobject sm)
{
	jmethodID method_id = GetMethodID(jenv,
									 GetObjectClass(jenv, sm),
									 "currentClassLoader",
									 "()Ljava/lang/ClassLoader;" );

	if(!method_id)return 0;

	jobject clssloader = CallObjectMethod(jenv, sm, method_id);

	return clssloader;
}

/*
 * Class:     java_io_ObjectInputStream
 * Method:    setBooleanField
 * Signature: (Ljava/lang/Object;Ljava/lang/String;Z)V
 */
JNIEXPORT void JNICALL Java_java_io_ObjectInputStream_setBooleanField
  (JNIEnv *jenv, jobject p_this, jobject obj, jstring field_name, jboolean value)
{
	const char* fname = jenv->GetStringUTFChars(field_name, NULL);

	// Access the field's internal class handle (Class):
    jclass clazz = GetObjectClass (jenv, obj);

	jfieldID fieldid = GetFieldID(jenv, clazz, fname, "Z");
	if(!fieldid)return;

	jenv->ReleaseStringUTFChars(field_name, fname);

	SetBooleanField(jenv, obj, fieldid, value);
}

/*
 * Class:     java_io_ObjectInputStream
 * Method:    setByteField
 * Signature: (Ljava/lang/Object;Ljava/lang/String;B)V
 */
JNIEXPORT void JNICALL Java_java_io_ObjectInputStream_setByteField
  (JNIEnv *jenv, jobject p_this, jobject obj, jstring field_name, jbyte value)
{
	const char* fname = jenv->GetStringUTFChars(field_name, NULL);

	// Access the field's internal class handle (Class):
    jclass clazz = GetObjectClass (jenv, obj);

	jfieldID fieldid = GetFieldID(jenv, clazz, fname, "B");
	if(!fieldid)return;

	jenv->ReleaseStringUTFChars(field_name, fname);

	SetByteField(jenv, obj, fieldid, value);
}

/*
 * Class:     java_io_ObjectInputStream
 * Method:    setCharField
 * Signature: (Ljava/lang/Object;Ljava/lang/String;C)V
 */
JNIEXPORT void JNICALL Java_java_io_ObjectInputStream_setCharField
  (JNIEnv *jenv, jobject p_this, jobject obj, jstring field_name, jchar value)
{
	const char* fname = jenv->GetStringUTFChars(field_name, NULL);

	// Access the field's internal class handle (Class):
    jclass clazz = GetObjectClass (jenv, obj);

	jfieldID fieldid = GetFieldID(jenv, clazz, fname, "C");
	if(!fieldid)return;

	jenv->ReleaseStringUTFChars(field_name, fname);

	SetCharField(jenv, obj, fieldid, value);
}

/*
 * Class:     java_io_ObjectInputStream
 * Method:    setDoubleField
 * Signature: (Ljava/lang/Object;Ljava/lang/String;D)V
 */
JNIEXPORT void JNICALL Java_java_io_ObjectInputStream_setDoubleField
  (JNIEnv *jenv, jobject p_this, jobject obj, jstring field_name, jdouble value)
{
	const char* fname = jenv->GetStringUTFChars(field_name, NULL);

	// Access the field's internal class handle (Class):
    jclass clazz = GetObjectClass (jenv, obj);

	jfieldID fieldid = GetFieldID(jenv, clazz, fname, "D");
	if(!fieldid)return;

	jenv->ReleaseStringUTFChars(field_name, fname);

	SetDoubleField(jenv, obj, fieldid, value);
}

/*
 * Class:     java_io_ObjectInputStream
 * Method:    setFloatField
 * Signature: (Ljava/lang/Object;Ljava/lang/String;F)V
 */
JNIEXPORT void JNICALL Java_java_io_ObjectInputStream_setFloatField
  (JNIEnv *jenv, jobject p_this, jobject obj, jstring field_name, jfloat value)
{
	const char* fname = jenv->GetStringUTFChars(field_name, NULL);

	// Access the field's internal class handle (Class):
    jclass clazz = GetObjectClass (jenv, obj);

	jfieldID fieldid = GetFieldID(jenv, clazz, fname, "F");
	if(!fieldid)return;

	jenv->ReleaseStringUTFChars(field_name, fname);

	SetFloatField(jenv, obj, fieldid, value);
}

/*
 * Class:     java_io_ObjectInputStream
 * Method:    setIntField
 * Signature: (Ljava/lang/Object;Ljava/lang/String;I)V
 */
JNIEXPORT void JNICALL Java_java_io_ObjectInputStream_setIntField
  (JNIEnv *jenv, jobject p_this, jobject obj, jstring field_name, jint value)
{
	const char* fname = jenv->GetStringUTFChars(field_name, NULL);

	// Access the field's internal class handle (Class):
    jclass clazz = GetObjectClass (jenv, obj);

	jfieldID fieldid = GetFieldID(jenv, clazz, fname, "I");
	if(!fieldid)return;

	jenv->ReleaseStringUTFChars(field_name, fname);

	SetIntField(jenv, obj, fieldid, value);
}

/*
 * Class:     java_io_ObjectInputStream
 * Method:    setLongField
 * Signature: (Ljava/lang/Object;Ljava/lang/String;J)V
 */
JNIEXPORT void JNICALL Java_java_io_ObjectInputStream_setLongField
  (JNIEnv *jenv, jobject p_this, jobject obj, jstring field_name, jlong value)
{
	const char* fname = jenv->GetStringUTFChars(field_name, NULL);

	// Access the field's internal class handle (Class):
    jclass clazz = GetObjectClass (jenv, obj);

	jfieldID fieldid = GetFieldID(jenv, clazz, fname, "J");
	if(!fieldid)return;

	jenv->ReleaseStringUTFChars(field_name, fname);

	SetLongField(jenv, obj, fieldid, value);
}

/*
 * Class:     java_io_ObjectInputStream
 * Method:    setObjectField
 * Signature: (Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V
 */
JNIEXPORT void JNICALL Java_java_io_ObjectInputStream_setObjectField
  (JNIEnv *jenv, jobject p_this, jobject obj, jstring field_name, jstring type_code, jobject value)
{
	const char* fname = jenv->GetStringUTFChars(field_name, NULL);
	const char* tsig = jenv->GetStringUTFChars(type_code, NULL);

	// Access the field's internal class handle (Class):
    jclass clazz = GetObjectClass (jenv, obj);

	jfieldID fieldid = GetFieldID(jenv, clazz, fname, tsig);
	if(!fieldid)return;

	jenv->ReleaseStringUTFChars(field_name, fname);
	jenv->ReleaseStringUTFChars(type_code, tsig);

	SetObjectField(jenv, obj, fieldid, value);
}

/*
 * Class:     java_io_ObjectInputStream
 * Method:    setShortField
 * Signature: (Ljava/lang/Object;Ljava/lang/String;S)V
 */
JNIEXPORT void JNICALL Java_java_io_ObjectInputStream_setShortField
  (JNIEnv *jenv, jobject p_this, jobject obj, jstring field_name, jshort value)
{
	const char* fname = jenv->GetStringUTFChars(field_name, NULL);

	// Access the field's internal class handle (Class):
    jclass clazz = GetObjectClass (jenv, obj);

	jfieldID fieldid = GetFieldID(jenv, clazz, fname, "S");
	if(!fieldid)return;

	jenv->ReleaseStringUTFChars(field_name, fname);

	SetShortField(jenv, obj, fieldid, value);
}