// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/cg_prepass.h,v 1.2 2001/08/13 09:59:51 xhshi Exp $
//



#ifndef _CG_PREPASS_H_
#define _CG_PREPASS_H_

#include "Mem_Manager.h"
#include "bit_vector.h"

class Recomp_Entry; // forward declaration
class Register_Allocator;

struct Bytecode_Info {
	union {
		struct {
			unsigned depth:16;					// stack depth -- change to 8 XXXJMS
			unsigned is_block_entry:1;			// is start of bb
			unsigned is_label:1;				// is a label (target of cti)
			unsigned is_try_start:1;			// is start of a try block
			unsigned is_try_end:1;				// is end of a try block
			unsigned is_exception_handler_entry:1;
            unsigned is_back_edge_entry:1;      // is the entry of a back edge
		} attr;
		unsigned init;						// set to zero to clear attributes
	};
};

//
// This list is used to handle a problem with Garbage Collection. Currently,
// when EnumerateGcRefs() is called, we enumerate, among other things, all
// variables whose last store into them was an astore. This works fine except
// in one case, which is the astore at the beginning of a finally block. That
// astore is used to save away the return IP for the caller of the
// subroutine. Therefore, that astore should be ignored when marking variables
// for enumeration. Not only that, that astore should kill any other astores
// to the same variable. To determine which astores these are, we need to keep
// track of the bytecode offset of the targets of all jsr instructions. There
// may be redundancies in this list (one jsr for try/catches and one jsr for the
// catch all), but at least the info will be there.......
//
struct Finally_Bytecode_List {
	const unsigned char *bc;
	struct Finally_Bytecode_List *next;
};

// This bitmap says if a given variable holds reference or non-reference variables.
#ifdef VAR_CLONING
struct Local_Var_Info {
	union {
		struct {
			unsigned ref_store: 1;						// store to a reference variable
			unsigned ref_load: 1;						// load from a reference variable
			unsigned non_ref_store: 1;					// store to a non-reference variable
			unsigned non_ref_load: 1;					// load from a non-reference variable
		};
		struct {
			unsigned ref_var: 2;
			unsigned non_ref_var: 2;
		};
	};
};
#endif //VAR_CLONING

class Call_BV_List_Element : public Bit_Vector_List_Element {
public:
	unsigned char stack_ref_in_local_callee;
	Call_BV_List_Element(Bit_Vector *vec, const unsigned char *num) :
	Bit_Vector_List_Element(vec,num), stack_ref_in_local_callee(0){}
	void *operator new(size_t sz,Mem_Manager& m) {
		return m.alloc(sz);
	}
};




class CG_Prepass {
public:
	CG_Prepass(unsigned maxLocals,const unsigned char *first_bc,unsigned code_length,
		Class_Handle class_handle, Method_Handle method_handle,
        Compile_Handle comp, Mem_Manager&, unsigned maxStk,
        class Register_Allocator *regalloc);
	~CG_Prepass();
	Bytecode_Info *bytecode_info(unsigned i) {return &_bytecode_info[i];}
	
	unsigned ro_data_size()	{return _ro_data_size;}
	unsigned rw_data_size()	{return _rw_data_size;}
	static unsigned estimate_mem_size(unsigned byteCodeSize, unsigned maxStk,
		unsigned maxLcls);
	Call_BV_List_Element *find_gc_sites_info(const unsigned char *call_bc,unsigned& hint);
    void mark_entries_of_back_edges(unsigned bc_idx, int offset,
                                    char *ref_stack, unsigned stack_depth);
	//
	// public data members
	//
	Class_Handle const class_handle;
    Compile_Handle const comp_handle;
    Loader_Exception lexc;
	const unsigned char *const first_bc;
	const unsigned code_length;
    unsigned num_get_put_static;    // number of get/put statics
	unsigned num_call_sites;		// number of interruptable call sites
	unsigned num_returns;			// number of {a,i,f,l,d}return bytecodes
	unsigned num_blocks;			// number of basic blocks
	unsigned num_edges;				// number of edges in the control flow graph
    unsigned num_entries_back_edge; // number of entries of back edges
	unsigned maxStack;				// maximum size of the stack
	unsigned *ref_count;
	Call_BV_List_Element **sorted_gc_sites;
	Bit_Vector *is_visited;
	Bit_Vector_List *gc_site_vectors;// info on each gc site's stack location types
    Recomp_Entry *recomp_entries;   // holding ref_stack gc info for recompilation calls
	struct Finally_Bytecode_List *finally_bc_list;

    int prepass_failed;

	unsigned n_aloaded;
	char *aloaded_vars;

#ifdef VAR_CLONING
	char *local_var_info;
	bool var_cloning_failed;
#endif //VAR_CLONING

	Bytecode_Info *_bytecode_info;
private:
	unsigned _ro_data_size, _rw_data_size;
	void find_labels(const unsigned char *bc,unsigned stack_depth);
	void dump_blocks();
	void store_gc_site_info(unsigned stack_depth, const unsigned char *bc);
	void sort_gc_sites_info();
	char *ref_stack;			// size of num_variables, keep trak of object references
	Mem_Manager &_mm;
};

extern unsigned num_words_of_type(Java_Type type);

#endif // _CG_PREPASS_H_
