// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/debugger/jvmdi_ia32.cpp,v 1.3 2001/11/21 07:14:56 xli18 Exp $
//


#include "platform.h"
#include <assert.h>
#include <iostream.h>

#ifdef ORP_NT
#include "orp_process.h"
#endif

#include "object_layout.h"
#include "environment.h"
#include "orp_types.h"
#include "jit_runtime_support.h"
#include "method_lookup.h"
#include "stack_manipulation.h"
#include "orp_threads.h"
#include "orp_utils.h"
#include "orp_synch.h"
#include "jit_intf.h"
#include "jit_intf_cpp.h"
#include "nogc.h"
#include "compile.h"
#include "orp_stats.h"
#include "finalize.h"
#include "Class_Loader.h"

#include "root_set_enum.h"
#include "enum_trampoline.h"
#include "exceptions.h"

#ifdef OBJECT_LOCK_V2
#include "thread_generic_olv2.h"
#else
#include "thread_generic.h"
#endif

#include "jni.h"

#include "jvmdi_clean.h"
#include "debugger_jvmdi_ia32.h"
#include "jit_common.h"

#ifdef USE_IA64_JIT
class Level_1a_JIT {
public:
    void *
    get_address_of_var(Frame_Context    *context,
                       Boolean          is_first,
                       unsigned         var_no)
    { return 0; };

}; //Level_1a_JIT
#else
#include "level_1a_jit_intf.h"
#include "disasm_intf.h"
#endif

#ifdef  USE_IA64_JIT
#else
extern
#endif
JIT  *o1_jit;

void orp_delete_global_object_handle(Object_Handle handle);   // bugbug -- where does this go?

jframeID global_frame;

jvmdi_bp breakpoints[NBREAKPOINTS];
uint8 breakpoints_num;
jvmdi_bp bytecode_breakpoints[NBREAKPOINTS];
uint8 bytecode_breakpoints_num;

#define CODE_SIZE 32

uint8 code1[CODE_SIZE];
uint8 *code = code1;


jvmdiError JNICALL
GetFrameCount(jthread thread, jint *countPtr)
{
    assert(0);

#if 1
    // (mjc 20000519)
    // This tries to access java.lang.Thread's fields directly
    assert(0);
#else
    Object_Handle oh = (Object_Handle)thread;

    ORP_thread *p_thr = get_orp_thread_ptr(oh->java_reference);

    Registers *regs = thread_gc_get_context(p_thr);

    Frame_Context fc;


    fc.esp = regs->esp;
    fc.p_ebp = &(regs->ebp);
    fc.p_eip = &(regs->eip);

    fc.p_edi = &(regs->edi);
    fc.p_esi = &(regs->esi);
    fc.p_ebx = &(regs->ebx);

    fc.ljf = 0;

    fc.eip = regs->eip;

    fc.p_eax = &(regs->eax);
    fc.p_ecx = &(regs->ecx);
    fc.p_edx = &(regs->edx);

    // KEN!
    // true if the frame the first frame on the stack
    // Right now, only jvmdi support uses this field.  It should be used by
    // gc enumeration and exception throwing routines.
    fc.is_first = true;

    *countPtr = (jint)orp_get_stack_depth(&fc, 0, 0, 0, false);

    if (p_thr == 0)
        return JVMDI_ERROR_INVALID_THREAD;
#endif
    return JVMDI_ERROR_NONE;
}


jvmdiError JNICALL
GetCurrentFrame(jthread thread, jframeID *framePtr)
{
    assert(0);

#if 1
    // (mjc 20000519)
    // This tries to access java.lang.Thread's fields directly
    assert(0);
#else
    Object_Handle oh = (Object_Handle)thread;

    ORP_thread *p_thr = get_orp_thread_ptr(oh->java_reference);

    if (p_thr == 0)
        return JVMDI_ERROR_INVALID_THREAD;

    Registers *regs = thread_gc_get_context(p_thr);

    Frame_Context *p_fc;

    jvmdiError stat = Allocate( sizeof(Frame_Context), (jbyte **)&p_fc);
    if (stat != JVMDI_ERROR_NONE)
        assert(0);

    p_fc->esp = regs->esp;
    p_fc->p_ebp = &(regs->ebp);
    p_fc->p_eip = &(regs->eip);

    p_fc->p_edi = &(regs->edi);
    p_fc->p_esi = &(regs->esi);
    p_fc->p_ebx = &(regs->ebx);

    p_fc->ljf = (uint32)p_thr->last_java_frame;

    p_fc->eip = regs->eip;

    p_fc->p_eax = &(regs->eax);
    p_fc->p_ecx = &(regs->ecx);
    p_fc->p_edx = &(regs->edx);


    p_fc->is_first = true;

    if(orp_identify_eip((void *)*(p_fc->p_eip)) != ORP_TYPE_JAVA) 
    {
        Boolean ok = ro_unwind_native_stack_frame(p_fc);

        if(!ok) 
            return JVMDI_ERROR_NO_MORE_FRAMES;

        p_fc->is_first = false;
    }

    framePtr = (jframeID *)p_fc;
#endif
    return JVMDI_ERROR_NONE;
}


jvmdiError JNICALL
GetFrameLocation(jframeID frame, jclass *classPtr, jmethodID *methodPtr,
                       jlocation *locationPtr)
{
    assert(0);

    orp_disable_gc();

    Frame_Context *p_fc = (Frame_Context *)frame;
    JIT_Specific_Info *jit_info = methods.find((void *)*(p_fc->p_eip));

    Method *p_meth = jit_info->get_method();

    Object_Handle new_handle = orp_create_global_object_handle();
    new_handle->java_reference = (Java_java_lang_Object *)p_meth->get_class();

    *classPtr = (jclass)new_handle;

    *locationPtr = (jlocation)( *(p_fc->p_eip) );

    orp_enable_gc();

    return JVMDI_ERROR_NONE;
}


jvmdiError JNICALL
NotifyFramePop(jframeID frame)
{
    assert(0);

    // we currently handle only one frame system wide
    assert(frame->p_eip == 0); 

    memcpy(global_frame, frame, sizeof(jframeID) );

    return (jvmdiError) 0;
}


jvmdiError JNICALL
SetBreakpoint(jclass clazz, jmethodID method, jlocation location)
{
    assert(0);

    int xx;
    for (xx = 0; xx < NBREAKPOINTS; xx++) {
        if (breakpoints[xx].loc == location)
            return JVMDI_ERROR_NONE; // it's already set, do nothing
    }

    for (xx = 0; xx < NBREAKPOINTS; xx++) {

        if (breakpoints[xx].loc == 0) {

            breakpoints[xx].loc = location;
            assert(breakpoints[xx].old_value == 0);

            breakpoints[xx].old_value = *( (jbyte *)(location) );

            return JVMDI_ERROR_NONE;
        }
    }

    return JVMDI_ERROR_INTERNAL;
}


jvmdiError JNICALL
ClearBreakpoint(jclass clazz, jmethodID method, jlocation location)
{
    assert(0);

    for (int xx = 0; xx < NBREAKPOINTS; xx++) {

        if (breakpoints[xx].loc == location) {

            *( (jbyte *)(location) ) = breakpoints[xx].old_value;
            breakpoints[xx].old_value = 0;
            breakpoints[xx].loc = 0;

            return JVMDI_ERROR_NONE;
        }
    }
    return JVMDI_ERROR_INTERNAL;
}


jvmdiError JNICALL
ClearAllBreakpoints()
{
    assert(0);

    for (int xx = 0; xx < NBREAKPOINTS; xx++) {

        *( (jbyte *)(breakpoints[xx].loc) ) = breakpoints[xx].old_value;
        breakpoints[xx].old_value = 0;
        breakpoints[xx].loc = 0;
    }
    return JVMDI_ERROR_NONE;
}



jvmdiError  JNICALL
GetArgumentsSize(jclass clazz, jmethodID method, jint *sizePtr)
{
#ifdef _DEBUG
    assert(0);

    *sizePtr = n_words_of_method_arg_type(method);

#endif // _DEBUG
    return JVMDI_ERROR_NONE;
}




void jvmdi_method_entry()
{
#ifdef _DEBUG
    return;
    assert(0);

    if (p_TLS_orpthread->report_jvmdi_event_method_entry)
    {
        Frame_Context *p_fc;
        Allocate(sizeof(Frame_Context), (jbyte**)&p_fc );
        memset(p_fc, 0, sizeof(Frame_Context) );

        ro_unwind_native_stack_frame(p_fc);

        Object_Handle jt = orp_create_global_object_handle();
        jt->java_reference = (struct Java_java_lang_Object *)
                                p_TLS_orpthread->p_java_lang_thread;
        
        JIT_Specific_Info *jit_info = methods.find((void *)*(p_fc->p_eip));
        Method  *p_meth = jit_info->get_method();
        Class *p_clss = p_meth->get_class();

        Object_Handle jc = orp_create_global_object_handle();
        jc->java_reference = (struct Java_java_lang_Object *)p_clss;

        jmethodID jmid = (jmethodID)p_meth;

        JVMDI_Event *p_event_record = 0;
        Allocate(sizeof(JVMDI_Event), (jbyte**)&p_event_record );
        memset(p_event_record, 0, sizeof(JVMDI_Event) );

        p_event_record->kind = JVMDI_EVENT_METHOD_ENTRY;

        p_event_record->u.frame.thread = jt;
        p_event_record->u.frame.clazz = jc;
        p_event_record->u.frame.method = jmid;
        p_event_record->u.frame.frame = (jframeID)p_fc;

        jvmdi_hook_function( (struct JNIEnv_ *)jni_native_intf, p_event_record);

    }
#endif // _DEBUG
}


void method_exit(jint kind)
{
#ifdef _DEBUG
    return;
    assert(0);
    Frame_Context *p_fc;
    Allocate(sizeof(Frame_Context), (jbyte**)&p_fc );
    memset(p_fc, 0, sizeof(Frame_Context) );

    ro_unwind_native_stack_frame(p_fc);

    Object_Handle jt = orp_create_global_object_handle();
    jt->java_reference = (struct Java_java_lang_Object *)
                            p_TLS_orpthread->p_java_lang_thread;
    
    JIT_Specific_Info *jit_info = methods.find((void *)*(p_fc->p_eip));
    Method  *p_meth = jit_info->get_method();
    Class *p_clss = p_meth->get_class();

    Object_Handle jc = orp_create_global_object_handle();
    jc->java_reference = (struct Java_java_lang_Object *)p_clss;

    jmethodID jmid = (jmethodID)p_meth;

    JVMDI_Event *p_event_record = 0;
    Allocate(sizeof(JVMDI_Event), (jbyte**)&p_event_record );
    memset(p_event_record, 0, sizeof(JVMDI_Event) );

    p_event_record->kind = kind;

    p_event_record->u.frame.thread = jt;
    p_event_record->u.frame.clazz = jc;
    p_event_record->u.frame.method = jmid;
    p_event_record->u.frame.frame = (jframeID)p_fc;

    jvmdi_hook_function( (struct JNIEnv_ *)jni_native_intf, p_event_record);
#endif // _DEBUG
}


void jvmdi_method_exit()
{
#ifdef _DEBUG
    assert(0);

    if (global_frame) {

        Frame_Context frcn;
        ro_unwind_native_stack_frame(&frcn);

        if ( *(frcn.p_eip) == *(global_frame->p_eip) ) {

            memset(global_frame, 0, sizeof(Frame_Context) );
            method_exit(JVMDI_EVENT_FRAME_POP);
        }
    }
    if (p_TLS_orpthread->report_jvmdi_event_method_exit)
        method_exit(JVMDI_EVENT_METHOD_EXIT);
#endif // _DEBUG
}


void  jvmdi_exception(Frame_Context *original_context,
                   volatile Java_java_lang_Object **p_obj,
                   Frame_Context *new_context)                            
{
#ifdef _DEBUG
        if (p_TLS_orpthread->report_jvmdi_event_exception_catch == false)
            return;

        if (jvmdi_hook_function == 0) {  // temporary support

            Global_Env *env = ORP_Global_State::loader_env;

            if ( (*p_obj)->vt->clss == env->JavaLangClass_Class) {

                Class *p_c = (Class *)(*p_obj);
                orp_cout << "exception: " << p_c->name->bytes << endl;
            }
                else
                orp_cout << "exception: " << (*p_obj)->vt->clss->name->bytes <<endl;
            return;
        }

        Object_Handle jt = orp_create_global_object_handle();
        jt->java_reference = (struct Java_java_lang_Object *)
                                p_TLS_orpthread->p_java_lang_thread;
        
        JIT_Specific_Info *jit_info = methods.find((void *)*(original_context->p_eip));
        Method  *p_meth = jit_info->get_method();
        Class *p_clss = p_meth->get_class();

        Object_Handle jc = orp_create_global_object_handle();
        jc->java_reference = (struct Java_java_lang_Object *)p_clss;

        jmethodID jmid = (jmethodID)p_meth;

        jlocation jloc = (jlocation)*(original_context->p_eip);

        Object_Handle je = orp_create_global_object_handle();
        je->java_reference = (struct Java_java_lang_Object *)(*p_obj);

        jit_info = methods.find((void *)*(new_context->p_eip));
        Method *p_catch_meth = jit_info->get_method();
        Class *p_catch_clss = p_catch_meth->get_class();

        Object_Handle jc_catch = orp_create_global_object_handle();
        jc_catch->java_reference = (struct Java_java_lang_Object *)p_catch_clss;

        jmethodID j_catch_mid = (jmethodID)p_catch_meth;

        jlocation j_catch_loc = (jlocation)*(new_context->p_eip);

        JVMDI_Event *p_event_record = 0;
        Allocate(sizeof(JVMDI_Event), (jbyte**)&p_event_record );
        memset(p_event_record, 0, sizeof(JVMDI_Event) );

        p_event_record->kind = JVMDI_EVENT_EXCEPTION_CATCH;

        p_event_record->u.exception.thread = jt;
        p_event_record->u.exception.clazz = jc;
        p_event_record->u.exception.method = jmid;
        p_event_record->u.exception.location = jloc;
        p_event_record->u.exception.exception = je;
        p_event_record->u.exception.catch_clazz = jc_catch;
        p_event_record->u.exception.catch_method = j_catch_mid;
        p_event_record->u.exception.catch_location = j_catch_loc;

        extern const struct JNIEnv_ *jni_native_intf;

        jvmdi_hook_function( (struct JNIEnv_ *)jni_native_intf, p_event_record);
#endif // _DEBUG
}


bool is_it_a_call_opcode(uint8 code[]){ 
    // call opcode include 0xe8 and ff /2
    if (code[0] == 0xe8 ||(code[0]==0xff && (code[1]&0x38)==0x10))
        return true;
    else 
        return false;
}

bool is_it_a_jcc_rel8_opcode(uint8 code[])
{
	switch (code[0]) {

	case 0x74:
	case 0x75:
	case 0x72:
	case 0x76:
	case 0x77:
	case 0x73:
	case 0x78:
	case 0x79:
	case 0x7a:
	case 0x7c:
	case 0x7e:
	case 0x7f:
	case 0x7d:
	case 0x7b:
	{
    	return true;
	}
	default:
		return false;
	}
    return false;
}

bool is_it_a_jcc_rel32_opcode(uint8 code[])
{
	if (code[0] == 0x0f)
        switch (code[1]) {
        case 0x74+0x10:
	    case 0x75+0x10:
	    case 0x72+0x10:
	    case 0x76+0x10:
	    case 0x77+0x10:
	    case 0x73+0x10:
	    case 0x78+0x10:
	    case 0x79+0x10:
	    case 0x7a+0x10:
	    case 0x7c+0x10:
	    case 0x8e     :
	    case 0x7f+0x10:
	    case 0x7d+0x10:
	    case 0x7b+0x10:
	    {
    	    return true;
	    }
	    default:
		    return false;
	}
    return false;
}

#define JMP_RELATIVE32_OPCODE 0xe9
#define JMP_RELATIVE8_OPCODE 0xeb
#define PUSH_RELATIVE_OPCODE 0x68
#define CALL_RELATIVE32_OPCODE 0xe8
#define jcc_rel32_inst_length 5
#define jmp_rel32_inst_length 5

void step_over_the_bp(uint32 *p_eip_arg)
{
    // copy the next executable instruction to code[] buffer, 
    // write a "jmp relative" back to original code as
    // as the following instruction.  Finally reset the eip 
    // to point to &code[0] and return to caller

    uint8 old_value = 0;

    bool is_it_a_breakpoint = false;

    for (int zz = 0; zz < NBREAKPOINTS; zz++) 
    {
        if (breakpoints[zz].loc == *p_eip_arg) {
            is_it_a_breakpoint = true;
            old_value = breakpoints[zz].old_value;
            break;
        }
        if (bytecode_breakpoints[zz].loc == *p_eip_arg) {
            is_it_a_breakpoint = true;
            old_value = bytecode_breakpoints[zz].old_value;
            break;
        }
    }

    bool is_it_a_bytecode_single_step_point = false;
 
    if (is_it_a_breakpoint == false) {

        // only execute this path if there is no breakpoint set
        // because if a bp is set, bytecode_single_step_points[zz].old_value has
        // NOT been set to the old value (breakpoints[zz].old_value "stole" it

        for (int qq = 0; qq < BYTECODE_SINGLE_STEP_PTS; qq++) {

            if (bytecode_single_step_points[qq].loc == *p_eip_arg) {
                is_it_a_bytecode_single_step_point = true;
                old_value = bytecode_single_step_points[qq].old_value;
                break;
            }
        }
    }
    
    bool is_it_a_exception_handler_breakpoint = false;

    if (is_it_a_breakpoint == false && is_it_a_bytecode_single_step_point == false) {

        for (int qq = 0; qq < EXCEPTION_HANDLER_BREAK_PTS; qq++) {

            if (exception_handler_break_points[qq].loc == *p_eip_arg) {
                is_it_a_exception_handler_breakpoint = true;
                old_value = exception_handler_break_points[qq].old_value;
                break;
            }
        }
    }

    bool is_it_a_single_step_point = false;
 
    if (is_it_a_breakpoint == false && is_it_a_bytecode_single_step_point == false
        && is_it_a_exception_handler_breakpoint == false) {

        for (int qq = 0; qq < SINGLE_STEP_PTS; qq++) {

            if (single_step_points[qq].loc == *p_eip_arg) {
                is_it_a_single_step_point = true;
                old_value = single_step_points[qq].old_value;
                break;
            }
        }
    }

    bool is_it_a_bytecode_step_into_breakpoint = false;
    if (is_it_a_breakpoint == false && is_it_a_bytecode_single_step_point == false
        && is_it_a_exception_handler_breakpoint == false && is_it_a_single_step_point == false) {
        
        if (bytecode_step_into_break_point.loc!=0 && bytecode_step_into_break_point.loc == *p_eip_arg){
            is_it_a_bytecode_step_into_breakpoint = true;
            old_value =bytecode_step_into_break_point.old_value;
        }

    }

    if ( is_it_a_breakpoint || is_it_a_bytecode_single_step_point|| is_it_a_exception_handler_breakpoint
            ||is_it_a_single_step_point || is_it_a_bytecode_step_into_breakpoint) {

        memcpy(code, (void *)*p_eip_arg, CODE_SIZE);

        assert(code[0] == 0x6f);  // should still hold the breakpoint/singlestep opcode
        assert(old_value != 0);
        assert(old_value != 0x6f);

        code[0] = old_value;

        int instruction_length = x86_inst_length( (char *)code);
        assert(instruction_length < CODE_SIZE - 16);

        uint8 *p_off;
        
        uint8 temp_code[CODE_SIZE];
        if (is_it_a_call_opcode(code)){     
            memcpy(temp_code,code,CODE_SIZE);
            uint32 ret_addr = (uint32)((uint8 *)*p_eip_arg + instruction_length);  

            p_off = (uint8 *)&ret_addr;

            code[0] = PUSH_RELATIVE_OPCODE;
            code[1] = p_off[0];
            code[2] = p_off[1];
            code[3] = p_off[2];
            code[4] = p_off[3];
            if (temp_code[0] == CALL_RELATIVE32_OPCODE) {   
                code[5] = JMP_RELATIVE32_OPCODE;     
                uint32 *rel_off = (uint32 *)&(temp_code[1]);
                uint32 callee_addr = (uint32)((uint8 *)*p_eip_arg + instruction_length + *rel_off);
                uint32 curr_off = callee_addr -(uint32)&(code[10]);
                p_off = (uint8 *)&curr_off;
                code[6] = p_off[0];
                code[7] = p_off[1];
                code[8] = p_off[2];
                code[9] = p_off[3];
            }
            else {                   // opcode = ff /2;
                for (int i=0;i<instruction_length;i++)
                    code[5+i] = temp_code[i];
                code[6] = (code[6]&0xef)|0x20;      // change the opcode to ff /2(call) to ff /4(jmp);
                
            }
        } else if (is_it_a_jcc_rel8_opcode(code)|| 
                is_it_a_jcc_rel32_opcode(code)){      
            memcpy(temp_code,code,CODE_SIZE);
            uint32 rel_addr;
            if (is_it_a_jcc_rel8_opcode(temp_code)){
                uint8 rel8_addr = temp_code[1];
                rel_addr = rel8_addr;
            } else  {
                uint32 *rel32_addr =(uint32 *)&(temp_code[2]);
                rel_addr = *rel32_addr;
            }

            uint32 callee_addr = *p_eip_arg + instruction_length + rel_addr;
            uint32 curr_rel = callee_addr - (uint32)&(code[jcc_rel32_inst_length]);
            code[0] = 0x0f;
            if (is_it_a_jcc_rel8_opcode(temp_code))
                code[1] = temp_code[0] + 0x10;
            else 
                code[1] = temp_code[1];
            p_off = (uint8 *)&curr_rel;
            code[2] = p_off[0];
            code[3] = p_off[1];
            code[4] = p_off[2];
            code[5] = p_off[3];
        } else if (code[0] == JMP_RELATIVE8_OPCODE||code[0]== JMP_RELATIVE32_OPCODE){      
            memcpy(temp_code,code,CODE_SIZE);
            uint32 rel_addr;
            if (temp_code[0] == JMP_RELATIVE8_OPCODE){
                uint8 rel8_addr = temp_code[1];
                rel_addr = rel8_addr;
            } else  {
                uint32 *rel32_addr = (uint32 *)&(temp_code[1]);
                rel_addr = *rel32_addr;
            }

            uint32 abs_addr = *p_eip_arg + instruction_length + rel_addr;
            uint32 curr_rel = abs_addr - (uint32)&(code[jmp_rel32_inst_length]);
            code[0] = JMP_RELATIVE32_OPCODE;
            p_off = (uint8 *)&curr_rel;
            code[1] = p_off[0];
            code[2] = p_off[1];
            code[3] = p_off[2];
            code[4] = p_off[3];
        } else {
            uint32 relative_offset = (uint8 *)*p_eip_arg + instruction_length  // points to instr after step around
                                        - &(code[instruction_length + 5]); // points to start of jmp instr

            uint8 *p_off = (uint8 *)&relative_offset;

            code[instruction_length + 0] = JMP_RELATIVE32_OPCODE;
            code[instruction_length + 1] = p_off[0];
            code[instruction_length + 2] = p_off[1];
            code[instruction_length + 3] = p_off[2];
            code[instruction_length + 4] = p_off[3];

            
        }
        *p_eip_arg = (uint32)code;
    }
}


void jvmdi_breakpoint(uint32 *p_eip_arg)
{
    orp_enable_gc();
    Object_Handle jt = orp_create_global_object_handle();

    jt->java_reference = (struct Java_java_lang_Object *)
                            p_TLS_orpthread->p_java_lang_thread;
 
    JIT_Specific_Info *jit_info = methods.find((void *)(*p_eip_arg) );
                      
    assert(jit_info);

    Method  *p_meth = jit_info->get_method();
    Class *p_clss = p_meth->get_class();

    Object_Handle jc = orp_create_global_object_handle();
    jc->java_reference = (struct Java_java_lang_Object *)p_clss;

    jmethodID jmid = (jmethodID)p_meth;

    JVMDI_Event *p_event_record = 0;
    Allocate(sizeof(JVMDI_Event), (jbyte**)&p_event_record );
    memset(p_event_record, 0, sizeof(JVMDI_Event) );

    p_event_record->kind = JVMDI_EVENT_BREAKPOINT;

    p_event_record->u.breakpoint.thread = jt;
    p_event_record->u.breakpoint.clazz = jc;
    p_event_record->u.breakpoint.method = jmid;
    p_event_record->u.breakpoint.location = (jlocation)(*p_eip_arg);

#if 1 // testing = 1, normal = 0
    void temp_jvmdi_debugger(void *p_eip_arg);
    temp_jvmdi_debugger( (void *) p_eip_arg);
#else
    jvmdi_hook_function( (struct JNIEnv_ *)jni_native_intf, p_event_record);
#endif

    step_over_the_bp(p_eip_arg);

    orp_disable_gc();
}
