// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/debugger/debugger_jvmdi_ia32.cpp,v 1.2 2001/12/07 00:16:00 xli18 Exp $
//



#include "platform.h"
#include <stdio.h>

#include <sys/types.h>
#include <sys/stat.h>

#include <iostream.h>
#include "environment.h"
#include "orp_types.h"
#include "jit_intf_cpp.h"
#include "object_layout.h"
#include "method_lookup.h"
#include "stack_manipulation.h"
#include "Class.h"
#include "orp_threads.h"
#include "sync_bits.h"

#include "compile.h"
#include "ini.h"

#ifdef ORP_POSIX
#include <unistd.h>

#else
#include <io.h>
//#include <orp_io.h>
#endif

#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "jvmdi_clean.h"
#include "orp_utils.h"

#include "jit_intf.h"
#include "jit_intf_cpp.h"

#include "level_1a_jit_intf.h"

#include "orp_threads.h"

#include "debugger_jvmdi_ia32.h"
#include "debugger_ia32_utils.h"
#include "debugger_ia32_breakpoint.h"
#include "debugger_ia32_list.h"
#include "debugger_ia32_locals.h"

#ifdef ORP_POSIX
#include "platform2.h"
#endif

void dbg(void *p_eip_arg);

bool jvmdi_verbose = true;

jvmdi_ss single_step_points[SINGLE_STEP_PTS];
jvmdi_ss bytecode_single_step_points[BYTECODE_SINGLE_STEP_PTS];
jvmdi_ss exception_handler_break_points[EXCEPTION_HANDLER_BREAK_PTS];
jvmdi_bp bytecode_step_into_break_point;

bool print_exceptions = false;


// Auxiliary function for reading a line from stdin.
void my_gets(char *bp)
{
    assert(bp);
    char c;
    char *p = bp;
    while((c = getchar()) != '\n')
        *p++ = c;
    *p = '\0';
} // my_gets

enum command { cm_help, cm_break,cm_clear,cm_list,cm_next,cm_go,cm_frames,cm_Frames,cm_run,cm_step,
cm_up=11,cm_down,cm_locals,cm_Locals,cm_display,cm_ref,cm_class,cm_dispclass,
cm_disasm=21,cm_where=23,cm_thread,cm_Thread,
cm_i=31,cm_o,
cm_exception=41,cm_lckblk,cm_verbose,cm_x,
cm_breakb=51,cm_clearb,cm_nextb,cm_listb,cm_stepb,cm_stepout,
cm_exit=71};

int get_command_index(const char *comm){
	if ((!strcmp(comm,"?"))||(!strcmp(comm,"help")))
		return 0;
	else if (!strcmp(comm,"break")||!strcmp(comm,"b"))
		return 1;
	else if (!strcmp(comm,"clear")||!strcmp(comm,"c"))
		return 2;
	else if (!strcmp(comm,"list")||!strcmp(comm,"l"))
		return 3;
	else if (!strcmp(comm,"next")||!strcmp(comm,"n"))
		return 4;
	else if (!strcmp(comm,"go")||!strcmp(comm,"g"))
		return 5;
	else if (!strcmp(comm,"frames")||!strcmp(comm,"f"))
		return 6;
	else if (!strcmp(comm,"Frames")||!strcmp(comm,"F"))
		return 7;
	else if (!strcmp(comm,"run"))
		return 8;
    else if (!strcmp(comm,"step")||!strcmp(comm,"s"))
		return 9;
    else if (!strcmp(comm,"up"))
		return 11;
	else if (!strcmp(comm,"down"))
		return 12;
	else if (!strcmp(comm,"locals")||!strcmp(comm,"lo"))
		return 13;
	else if (!strcmp(comm,"Locals")||!strcmp(comm,"Lo"))
		return 14;
	else if (!strcmp(comm,"display")||!strcmp(comm,"d"))
		return 15;
	else if (!strcmp(comm,"ref")||!strcmp(comm,"r"))
		return 16;
    else if (!strcmp(comm,"class")||!strcmp(comm,"c"))
		return 17;
    else if (!strcmp(comm,"dispclass")||!strcmp(comm,"dclass"))
		return 18;
	else if (!strcmp(comm,"disasm")||!strcmp(comm,"Disasm"))
		return 21;
	else if (!strcmp(comm,"where")||!strcmp(comm,"w"))
		return 23;
	else if (!strcmp(comm,"thread")||!strcmp(comm,"t"))
		return 24;
	else if (!strcmp(comm,"i"))
		return 31;
	else if (!strcmp(comm,"o"))
		return 32;
	else if (!strcmp(comm,"exception")||!strcmp(comm,"k"))
		return 41;
	else if (!strcmp(comm,"lckblk"))
		return 42;
	else if (!strcmp(comm,"verbose"))
		return 43;
	else if (!strcmp(comm,"x"))
		return 44;
    else if ((!strcmp(comm,"breakb"))||(!strcmp(comm,"bb")))
		return 51;
    else if (!strcmp(comm,"clearb")||!strcmp(comm,"cb"))
		return 52;
    else if (!strcmp(comm,"nextb")||!strcmp(comm,"nb"))
		return 53;
    else if (!strcmp(comm,"listb")||!strcmp(comm,"lb"))
		return 54;
    else if (!strcmp(comm,"stepb")||!strcmp(comm,"sb"))
		return 55;
    else if (!strcmp(comm,"stepout")||!strcmp(comm,"so"))
		return 56;
    else if (!strcmp(comm,"exit"))
		return 71;
    else return -1;
}

/*
 * use one or more continuous separator to seperate one string to two sub string,
 * the search begin from the head of str.
 */
void separate_str(char *str,char separator,char* sub1,char* sub2){
	while ((*str)&&(*str!=separator)){
		*sub1 = *str;
		sub1++;
		str++;
	}
	*sub1 = 0;
	while (*str&&(*str==separator))
		str++;
	for (;*str;str++,sub2++)
		*sub2 = *str;
	*sub2 = 0;
}

/*
 * use one or more continuous separator to seperate one string to two sub string,
 * but the search begin from end of str.
 */
void separate_str_from_end(char *str,char separator,char* sub1,char* sub2){
	if (!str||!(*str)) 
		return;
	int len = strlen(str);
	char *p = str+len-1;
	while ((p!=str)&&(*p!=separator)){
		p--;
	}
	char *q = p;
	for (q++;*q;q++,sub2++){
		*sub2=*q;
	}
	*sub2 = 0;
	while ((p!=str)&&(*p==separator))
		p--;
	if (p!=str) {
		p++;
		for (;str!=p;str++,sub1++)
			*sub1 = *str;
	}
	*sub1 = 0;
}

/*
 * change all the old_c to new_c in str_chg_chs
 */
void str_chg_chs(char *str,char old_c,char new_c){
	while (*str){
		if (*str==old_c)
			*str = new_c;
		str++;
	}
}

void temp_jvmdi_debugger(void *p_eip_arg)
{
    // remove all breakpoints
    for (int xx = 0; xx < NBREAKPOINTS; xx++) 
    {
        if (breakpoints[xx].loc) {
            uint8 *p_byte = (uint8 *)breakpoints[xx].loc;
            if (*p_byte == 0x6f) {
				assert(breakpoints[xx].old_value != 0x6f);
				
				assert(breakpoints[xx].old_value != 0);
				
				*p_byte = breakpoints[xx].old_value;
			}
        }
        if (bytecode_breakpoints[xx].loc) {
            uint8 *p_byte = (uint8 *)bytecode_breakpoints[xx].loc;
            if (*p_byte == 0x6f) {
				assert(bytecode_breakpoints[xx].old_value != 0x6f);
				
				assert(bytecode_breakpoints[xx].old_value != 0);
				
				*p_byte = bytecode_breakpoints[xx].old_value;
			}
        }
    }

    int yy;
    // remove all bytecode single step points
    for ( yy = 0; yy < BYTECODE_SINGLE_STEP_PTS; yy++) {

        if (bytecode_single_step_points[yy].loc == 0) 
            break;
        uint8 *p_byte = (uint8 *)bytecode_single_step_points[yy].loc;

        if (*p_byte == 0x6f) {
            assert(bytecode_single_step_points[yy].old_value != 0x6f);
            
			assert(bytecode_single_step_points[yy].old_value != 0);
            
			*p_byte = bytecode_single_step_points[yy].old_value;
        }
    }

    for ( yy = 0; yy < EXCEPTION_HANDLER_BREAK_PTS; yy++) {

        if (exception_handler_break_points[yy].loc == 0) 
            break;
        uint8 *p_byte = (uint8 *)exception_handler_break_points[yy].loc;

        if (*p_byte == 0x6f) {
            assert(exception_handler_break_points[yy].old_value != 0x6f);
            
			assert(exception_handler_break_points[yy].old_value != 0);
            
			*p_byte = exception_handler_break_points[yy].old_value;
        }
    }

    // remove all single step points
    for (int qq = 0; qq < SINGLE_STEP_PTS; qq++) {

        if (single_step_points[qq].loc == 0) 
            break;
        uint8 *p_byte = (uint8 *)single_step_points[qq].loc;

        if (*p_byte == 0x6f) {
            assert(single_step_points[qq].old_value != 0x6f);
            
			assert(single_step_points[qq].old_value != 0);
            
			*p_byte = single_step_points[qq].old_value;
        }
    }
    
    // remove 
    if (bytecode_step_into_break_point.loc != 0) {
        uint8 *p_byte = (uint8 *)bytecode_step_into_break_point.loc;

        if (*p_byte == 0x6f) {
            assert(bytecode_step_into_break_point.old_value != 0x6f);
            
			assert(bytecode_step_into_break_point.old_value != 0);
            
			*p_byte = bytecode_step_into_break_point.old_value;
        }
    }
    
    memset(single_step_points, 0, (sizeof(jvmdi_ss) * SINGLE_STEP_PTS) );
    memset(bytecode_single_step_points,0,(sizeof(jvmdi_ss)* BYTECODE_SINGLE_STEP_PTS));
    memset(exception_handler_break_points,0,(sizeof(jvmdi_ss)* EXCEPTION_HANDLER_BREAK_PTS));
    memset(&bytecode_step_into_break_point,0,sizeof(jvmdi_bp));

    
    dbg(p_eip_arg);  //////////// call the main debugger loop

    // set all breakpoints
    for (int zz = 0; zz < NBREAKPOINTS; zz++) 
    {
        if (breakpoints[zz].loc) {
            uint8 *p_byte = (uint8 *)breakpoints[zz].loc;
            if (*p_byte != 0x6f) {
				assert(*p_byte != 0);
				breakpoints[zz].old_value = *p_byte;
				*p_byte = 0x6f;
			}
        }
        if (bytecode_breakpoints[zz].loc) {
            uint8 *p_byte = (uint8 *)bytecode_breakpoints[zz].loc;
            if (*p_byte != 0x6f) {
				assert(*p_byte != 0);
				bytecode_breakpoints[zz].old_value = *p_byte;
				*p_byte = 0x6f;
			}
        }
    }
    
    int tt;
    // set all bytecode single step points
    for ( tt = 0; tt < BYTECODE_SINGLE_STEP_PTS; tt++) {

        if (bytecode_single_step_points[tt].loc == 0) 
            break;
        uint8 *p_byte = (uint8*)bytecode_single_step_points[tt].loc;

        if (*p_byte != 0x6f) {
            
			assert(*p_byte != 0);
            
			bytecode_single_step_points[tt].old_value = *p_byte;
            *p_byte = 0x6f;
        }
    }
    
    for ( tt = 0; tt < EXCEPTION_HANDLER_BREAK_PTS; tt++) {

        if (exception_handler_break_points[tt].loc == 0) 
            break;
        uint8 *p_byte = (uint8*)exception_handler_break_points[tt].loc;

        if (*p_byte != 0x6f) {
            
			assert(*p_byte != 0);
            
			exception_handler_break_points[tt].old_value = *p_byte;
            *p_byte = 0x6f;
        }
    }   

    // set all single step points
    for (int ss = 0; ss < SINGLE_STEP_PTS; ss++) {

        if (single_step_points[ss].loc == 0) 
            break;
        uint8 *p_byte = (uint8*)single_step_points[ss].loc;

        if (*p_byte != 0x6f) {
            
			assert(*p_byte != 0);
            
			single_step_points[ss].old_value = *p_byte;
            *p_byte = 0x6f;
        }
    }

    if (bytecode_step_into_break_point.loc != 0) {
        uint8 *p_byte = (uint8*)bytecode_step_into_break_point.loc;

        if (*p_byte != 0x6f) {
        
		    assert(*p_byte != 0);
        
		    bytecode_step_into_break_point.old_value = *p_byte;
            *p_byte = 0x6f;
        }
    }
}


void dbg(void *p_eip_arg)
{
	Class *curr_class = 0;
	Method *curr_method = 0;
	int curr_frame_num =0;
	char curr_meth_desc[BUFF_SIZE];
	uint32 curr_line_idx ;
    uint32 curr_bytecode_idx ;
	char src_file_path[100];
	strcpy(src_file_path,"");
	strcpy(curr_meth_desc,"");
    cout << flush << endl;

    Frame_Context fct;
    memset(&fct, 0, sizeof(Frame_Context));

    fct.p_eip = p_TLS_orpthread->gc_frame_context.p_eip;
    fct.p_ebp = p_TLS_orpthread->gc_frame_context.p_ebp;
    fct.p_ebx = p_TLS_orpthread->gc_frame_context.p_ebx;
    fct.p_esi = p_TLS_orpthread->gc_frame_context.p_esi;
    fct.p_edi = p_TLS_orpthread->gc_frame_context.p_edi;
    fct.esp   = p_TLS_orpthread->gc_frame_context.esp;    

    if(fct.p_eip != 0) {

        if(orp_identify_eip((void *)*(fct.p_eip)) == ORP_TYPE_JAVA) {
            Method *method = methods.find((void *)*(fct.p_eip))->get_method();
            
			curr_method = method;
			curr_class = method->get_class();
			
			strcat(curr_meth_desc,method->get_class()->name->bytes);
			strcat(curr_meth_desc,".");
			strcat(curr_meth_desc,method->get_name()->bytes);
			strcat(curr_meth_desc,method->get_descriptor());
			curr_line_idx = (int)which_line_is_it(*fct.p_eip, true);
            curr_bytecode_idx = (int)which_bytecode_is_it(*fct.p_eip,true);			
            
        }
    };
    
	orp_cout<<"jvmdi_dbg["<<curr_frame_num<<"]>"; 

    while (true) {
        my_gets(buff);
    
        char sub_str1[BUFF_SIZE];
		char sub_str2[BUFF_SIZE];
		char sptor = ' ';
		separate_str(buff,sptor,sub_str1,sub_str2);
		switch (get_command_index(sub_str1)) {
            
        case cm_help:						// "?" or "help"
            {
                print_help_info();                
                break;
            }
        case cm_where:						// "where"
			{
				orp_cout<<curr_meth_desc<<endl;
               if (curr_line_idx != UNKNOWN_LINE_NUM )
                    orp_cout<<"line:    "<<(int)curr_line_idx<<endl;
               if (curr_bytecode_idx != UNKNOWN_BYTECODE_NUM )
                    orp_cout<<"bytecode:"<<(int)curr_bytecode_idx<<endl;
/*				
                if (jvmdi_verbose) {
					orp_cout << " [eip=" << (void *)*fct.p_eip << "]";
					for (int qq = 0; qq < NBREAKPOINTS; qq++) {
						if (breakpoints[qq].loc == *(uint32 *)p_eip_arg)
							orp_cout << " bp:" << qq;
					};
					orp_cout<<endl;
				}
*/				
				break;
			}

		case cm_clear:							// "clear"
            {
                if (!(*sub_str2))		// show all existed bp
					show_breakpoints(source_level);
				else									//delete one bp or all bps
				    remove_breakpoint(sub_str2,source_level);
				break;
            }
        case cm_clearb:
            {
                if (!(*sub_str2))		// show all existed bp
					show_breakpoints(bytecode_level);
				else									//delete one bp or all bps
				    remove_breakpoint(sub_str2,bytecode_level);
				break;
            }
        case cm_break:								// "break"
            {
                if (breakpoints_num>=NBREAKPOINTS){
	                cout <<"the max number of bp is"<<NBREAKPOINTS<<endl;
	                break;
                }
                set_breakpoint(sub_str2,source_level,curr_method);
                break;
            }
        case cm_list:							// "list"
			{
                if (p_eip_arg == NULL) {
	                orp_cout<<"haven't run!"<<endl;
	                break;
                }
                if (curr_line_idx == UNKNOWN_LINE_NUM){
                    orp_cout<<" unknown current numebr"<<endl;
                    break;
                }
                Frame_Context fc;
                memset(&fc, 0, sizeof(Frame_Context));

                fc.p_eip = p_TLS_orpthread->gc_frame_context.p_eip;
                fc.p_ebp = p_TLS_orpthread->gc_frame_context.p_ebp;
                fc.p_ebx = p_TLS_orpthread->gc_frame_context.p_ebx;
                fc.p_esi = p_TLS_orpthread->gc_frame_context.p_esi;
                fc.p_edi = p_TLS_orpthread->gc_frame_context.p_edi;
                fc.esp   = p_TLS_orpthread->gc_frame_context.esp;
				fc.is_first = true;

                unwind_it(&fc, curr_frame_num);
                
                Method *list_meth = methods.find((void *)*(fc.p_eip))->get_method();
                Class *list_clss = list_meth->get_class();
                uint32 list_line_idx;
                if (fc.is_first)
                    list_line_idx = which_line_is_it((uint32)*(fc.p_eip),true);
                else 
                    list_line_idx = which_line_is_it((uint32)*(fc.p_eip),false);
                bool show_all = false;
                if (!strcmp(sub_str2,"all"))
                    show_all = true;
                list_source_file(list_clss,list_line_idx,src_file_path,show_all);
				break;
			}

		case cm_disasm:						// "disasm" or "Disasm"
            {
                bool start_at_eip = false;
                if (sub_str1[0] == 'd')
                    start_at_eip = true;

                Frame_Context fc;
                memset(&fc, 0, sizeof(Frame_Context));

                fc.p_eip = p_TLS_orpthread->gc_frame_context.p_eip;
                fc.p_ebp = p_TLS_orpthread->gc_frame_context.p_ebp;
                fc.p_ebx = p_TLS_orpthread->gc_frame_context.p_ebx;
                fc.p_esi = p_TLS_orpthread->gc_frame_context.p_esi;
                fc.p_edi = p_TLS_orpthread->gc_frame_context.p_edi;
                fc.esp   = p_TLS_orpthread->gc_frame_context.esp;

                //orp_cout << "    enter a class name (or \"ret\" for current class.method)  >";
                //memset(buff_class, 0, BUFF_SIZE);
                //my_gets(buff_class);

                if ( !(*sub_str2)) {					
                    do_disasm(0, &fc, start_at_eip);
                }
                else {
					memset(buff_class, 0, BUFF_SIZE);
					separate_str_from_end(sub_str2,'.',buff_class,sub_str1);
					str_chg_chs(buff_class,'.','/');
                    String *p_c_str = ORP_Global_State::loader_env->string_pool.lookup(
                                        (const char *)buff_class);

                    Class *p_clss  = ORP_Global_State::loader_env->class_table.lookup(p_c_str);

                    if (p_clss == 0) {
                        Loader_Exception ld_exc;
                        p_clss = load_class(ORP_Global_State::loader_env, p_c_str, &ld_exc);
                        if (p_clss == 0) {
                            orp_cout << "error: can't find class " << buff_class << endl;
                            break;
                        }
                    }
					if (!(*sub_str1)){
						orp_cout << "error: didn't input method"<<endl;
						break;
					}
                    memset(buff_method, 0, BUFF_SIZE);
                    strcpy(buff_method,sub_str1);
					int meths_num=0;
					uint32 selection = -1;
                
					for (uint32 kk = 0; kk < p_clss->n_methods; kk++) {
							Method *p_m = &(p_clss->methods[kk]);
							if ( !strcmp(p_m->get_name()->bytes, buff_method ) ) {
								if (meths_num==0)
									selection = kk;
								meths_num++;
							}               
					}
					if (meths_num>1) {
						for (uint32 kk = 0; kk < p_clss->n_methods; kk++) {
								Method *p_m = &(p_clss->methods[kk]);
								if ( !strcmp(p_m->get_name()->bytes, buff_method ) ) {
									orp_cout << (int)kk << ") " << p_clss->methods[kk].get_descriptor() << endl;
								}               
						}
						orp_cout << "select one of the above(enter to cancel)>";
						my_gets(buff);
						if ( strlen(buff) == 0)
							 break;
						selection = atoi(buff);
						if ((selection > (uint32)(p_clss->n_methods - 1))||(selection<0))
							break;
					}
					Method *p_meth = &(p_clss->methods[selection]);
                
#if 0
                    orp_cout << "    enter the descriptor >";
                    memset(buff_descriptor, 0, BUFF_SIZE);
                    my_gets(buff_descriptor);

                    String *p_d_str = ORP_Global_State::loader_env->string_pool.lookup(
                                        (const char *)buff_descriptor);
                    Signature *sig = ORP_Global_State::loader_env->sig_table.lookup(p_m_str, p_d_str);

                    Method *p_meth = class_lookup_method(p_clss, sig);
#endif
                    if (p_meth == 0) {
                        orp_cout << "error: method does not exist " << endl;
                        break;
                    }
                    do_disasm(p_meth, 0, start_at_eip);
                }
                break;
            }
        case cm_exception:						// "exception"
            {
                ORP_thread *p_thr = p_active_threads_list;

                if (print_exceptions == true) {

                    while (p_thr) {
#ifdef _DEBUG
                        p_thr->report_jvmdi_event_exception_catch = false;
#else
                        assert(0);
#endif
                        p_thr = p_thr->p_active;
                    }
                    print_exceptions = false;
                    orp_cout << "exception reporting off" << endl;
                }
                else {
                    while (p_thr) {
#ifdef _DEBUG
                        p_thr->report_jvmdi_event_exception_catch = true;
#else
                        assert(0);
#endif
                        p_thr = p_thr->p_active;
                    }
                    print_exceptions = true;
                    orp_cout << "exception reporting on" << endl;
                }

                break;
            }
        case cm_lckblk:					// "lckblk"
            {
                printf("   enter a number from [] (first type t command)  >");
                my_gets(buff);
                int xx = atoi(buff);  // the thread number in the "[]"
                ORP_thread *p_thr = p_active_threads_list;
                for(; xx !=0; xx--) {
                    p_thr = p_thr->p_active;
                    if (!p_thr) {
                        printf("\n not a valid thread number\n");
                        break;
                    }   
                }
                if (!p_thr) break;
                
                Lock_Block *p_block = p_thr->p_active_lock_blocks;
                if (p_block == 0) break;

                while (p_block->p_back_link)
                    p_block = p_block->p_back_link;
                volatile uint32 *p_xx = (p_block->p_object_header) + 1;
                Java_java_lang_Object *p_obj = (Java_java_lang_Object *)p_xx;

                printf("object address = 0x%x  class name = ", p_xx);
                for (int zz = 0; zz < p_obj->vt->clss->name->len; zz++)
                    printf("%c", p_obj->vt->clss->name->bytes[zz]);
                printf("\n");

                if (p_block->old_object_header & QUICK_RECURSION_MASK) {
                    // (old_objec_header & QUICK_RECURSION_MASK) is zero means that
                    // nobody is holding the lock and that the only legal Lock_Block's are
                    // waiting_for_the_notify's

                    printf("H = holding the lock, W/L = waiting for the lock, W/N = waiting for a notify\n");
                    printf("STATUS\tRECURSION\tTHREAD ID\tTHREAD NAME\n");

                    printf("H");
                    printf("\t");
                    printf("%d", ( (p_block->old_object_header & QUICK_RECURSION_MASK) >>
                                                    QUICK_RECURSION_LEFT_SHIFT_COUNT)   );
                    printf("\t\t");

                    uint32 index = (p_block->old_object_header & QUICK_THREAD_INDEX_MASK) >>
                                                    QUICK_THREAD_INDEX_LEFT_SHIFT_COUNT;
                    ORP_thread *pjt = quick_thread_id[index].p_orpthread;
                    printf("0x%x", pjt->thread_id);
            
                    printf("\t\t");
#if 1
                    // (mjc 20000519)
                    // This tries to access java.lang.Thread's fields directly
                    assert(0);
#else
                    for(int gg = 0; gg < p_block->p_orp_thread->p_java_lang_thread->name->length; gg++) {
                        char one_char = (char)(pjt->p_java_lang_thread->name->body[gg]);
                        printf("%c", one_char);
                    }
#endif
                    printf("\n");
                }
                else {
                    assert(p_block->lock_or_wait_state == waiting_for_the_notify);
                }

                while (p_block) {
                    
                    switch(p_block->lock_or_wait_state) {
                    case holding_the_lock:
                        printf ("H");
                        break;
                    case waiting_for_the_lock:
                        printf ("W/L");
                        break;
                    case waiting_for_the_notify:
                        printf ("W/N");
                        break;
                    default:
                        assert(0);
                        break;
                    }
                    printf("\t");
                    printf("%d", (p_block->lock_recursion_count_shifted_left >>
                                                QUICK_RECURSION_LEFT_SHIFT_COUNT)   );
                    printf("\t\t");

                    printf("0x%x", p_block->p_orp_thread->thread_id);

                    printf("\t\t");
#if 1
                    // (mjc 20000519)
                    // This tries to access java.lang.Thread's fields directly
                    assert(0);
#else
                    for(int gg = 0; gg < p_block->p_orp_thread->p_java_lang_thread->name->length; gg++) {
                        char one_char = (char)(p_block->p_orp_thread->p_java_lang_thread->name->body[gg]);
                        printf("%c", one_char);
                    }
#endif
                    printf("\n");

                    p_block = p_block->p_forward_link;
                }
                break;
            }

        case cm_ref:									// "ref"
            {
                print_reference();
                break;
            }
        
        case cm_class:                                  // "class"
            {
                //print_class_content();
                break;
            }
        case cm_locals:										// "locals"
            {
                if (p_eip_arg == 0 ) {
					orp_cout <<"the programe didn't run"<<endl;
					break;
				}
				int frame_no = curr_frame_num;
               
                Frame_Context fc;
                memset(&fc, 0, sizeof(Frame_Context));

                fc.p_eip = p_TLS_orpthread->gc_frame_context.p_eip;
                fc.p_ebp = p_TLS_orpthread->gc_frame_context.p_ebp;
                fc.p_ebx = p_TLS_orpthread->gc_frame_context.p_ebx;
                fc.p_esi = p_TLS_orpthread->gc_frame_context.p_esi;
                fc.p_edi = p_TLS_orpthread->gc_frame_context.p_edi;
                fc.esp   = p_TLS_orpthread->gc_frame_context.esp;
				fc.is_first = true;

                unwind_it(&fc, frame_no);

                bool is_first = TRUE;
                if (frame_no != 0)
                    is_first = FALSE;

                show_locals(&fc, is_first);

/*
                printf("   enter (return) or number of local to change >");
                my_gets(buff);

                if (strlen(buff) != 0)
				    change_a_local(&fc, is_first, atoi(buff) );
*/

                break;
            }

		case cm_display:				//"display"
			{
				if (p_eip_arg == 0 ) {
					orp_cout <<"the programe didn't run"<<endl;
					break;
				}
				int frame_no = curr_frame_num;
               
                Frame_Context fc;
                memset(&fc, 0, sizeof(Frame_Context));

                fc.p_eip = p_TLS_orpthread->gc_frame_context.p_eip;
                fc.p_ebp = p_TLS_orpthread->gc_frame_context.p_ebp;
                fc.p_ebx = p_TLS_orpthread->gc_frame_context.p_ebx;
                fc.p_esi = p_TLS_orpthread->gc_frame_context.p_esi;
                fc.p_edi = p_TLS_orpthread->gc_frame_context.p_edi;
                fc.esp   = p_TLS_orpthread->gc_frame_context.esp;
				fc.is_first = true;

                unwind_it(&fc, frame_no);

                bool is_first = TRUE;
                if (frame_no != 0)
                    is_first = FALSE;

                display_one_local(&fc, is_first,sub_str2);
	
				break;
			}

        case cm_dispclass:
            {
                if (sub_str2[0]==0)
                    orp_cout<<"     error,must input class name!"<<endl;
                display_class(sub_str2);
                break;
            }
        case cm_Locals:				// "Locals"
            {
                printf("   enter a thread number  >");
                my_gets(buff);
                int thread_no = atoi(buff); 

                ORP_thread *p_thr = p_active_threads_list;

                for (int yy = 0; yy < thread_no; yy++) {

                    p_thr = p_thr->p_active;
                    if (p_thr == 0) break;
                }
                if (p_thr == 0) break;

                printf("   enter a frame number (or return for current frame) >");
                my_gets(buff);
                int frame_no = 0;
                if (strlen(buff) != 0)
                    frame_no = atoi(buff); 
               
                Frame_Context fc;
                memset(&fc, 0, sizeof(Frame_Context));

                fc.p_eip = p_thr->gc_frame_context.p_eip;
                fc.p_ebp = p_thr->gc_frame_context.p_ebp;
                fc.p_ebx = p_thr->gc_frame_context.p_ebx;
                fc.p_esi = p_thr->gc_frame_context.p_esi;
                fc.p_edi = p_thr->gc_frame_context.p_edi;
                fc.esp   = p_thr->gc_frame_context.esp;

                unwind_it(&fc, frame_no);

                bool is_first = TRUE;
                if (frame_no != 0)
                    is_first = FALSE;

                show_locals(&fc, is_first);

                printf("   enter (return) or number of local to change >");
                my_gets(buff);

                if (strlen(buff) != 0)
				    change_a_local(&fc, is_first, atoi(buff) );

                break;
            }
        case cm_frames:							//"frames"
            {
                Frame_Context fc;
                memset(&fc, 0, sizeof(Frame_Context));

                fc.p_eip = p_TLS_orpthread->gc_frame_context.p_eip;
                fc.p_ebp = p_TLS_orpthread->gc_frame_context.p_ebp;
                fc.p_ebx = p_TLS_orpthread->gc_frame_context.p_ebx;
                fc.p_esi = p_TLS_orpthread->gc_frame_context.p_esi;
                fc.p_edi = p_TLS_orpthread->gc_frame_context.p_edi;
                fc.esp   = p_TLS_orpthread->gc_frame_context.esp;

                void stack_trace(Frame_Context *p_frame);
                stack_trace(&fc);

                break;
            }
        case cm_up:						// "up"
			{
				if (p_eip_arg == 0 ) {
					orp_cout <<"the programe didn't run"<<endl;
					break;
				}
				Frame_Context fc;
                memset(&fc, 0, sizeof(Frame_Context));

                fc.p_eip = p_TLS_orpthread->gc_frame_context.p_eip;
                fc.p_ebp = p_TLS_orpthread->gc_frame_context.p_ebp;
                fc.p_ebx = p_TLS_orpthread->gc_frame_context.p_ebx;
                fc.p_esi = p_TLS_orpthread->gc_frame_context.p_esi;
                fc.p_edi = p_TLS_orpthread->gc_frame_context.p_edi;
                fc.esp   = p_TLS_orpthread->gc_frame_context.esp;

				bool prev_state = orp_disable_gc();      //----------------v

				unsigned depth = orp_get_stack_depth(&fc, 0, 0, 0, TRUE);

				if(prev_state) {
					orp_enable_gc();        //-----------------------------^
				}
				
				int inc_frame_num = 1;
				if (*sub_str2)
					inc_frame_num = atoi(sub_str2);
				if (curr_frame_num+inc_frame_num< (signed)depth)
					curr_frame_num += inc_frame_num;
				else
					orp_cout<<"frame number override"<<endl;
				break;
			}
		case cm_down:						// "down"
			{
				if (p_eip_arg == 0 ) {
					orp_cout <<"the programe didn't run"<<endl;
					break;
				}
				Frame_Context fc;
                memset(&fc, 0, sizeof(Frame_Context));

                fc.p_eip = p_TLS_orpthread->gc_frame_context.p_eip;
                fc.p_ebp = p_TLS_orpthread->gc_frame_context.p_ebp;
                fc.p_ebx = p_TLS_orpthread->gc_frame_context.p_ebx;
                fc.p_esi = p_TLS_orpthread->gc_frame_context.p_esi;
                fc.p_edi = p_TLS_orpthread->gc_frame_context.p_edi;
                fc.esp   = p_TLS_orpthread->gc_frame_context.esp;

				bool prev_state = orp_disable_gc();      //----------------v

				unsigned depth = orp_get_stack_depth(&fc, 0, 0, 0, TRUE);

				if(prev_state) {
					orp_enable_gc();        //-----------------------------^
				}
				
				int dec_frame_num = 1;
				if (*sub_str2)	
					dec_frame_num = atoi(sub_str2);
				if (curr_frame_num-dec_frame_num>=0)
					curr_frame_num -= dec_frame_num;
				else
					orp_cout<<"frame number override"<<endl;
				break;
			}
		case cm_Frames:				//"Frames" 
            {
                printf("   enter a thread number  >");
                my_gets(buff);
                int xx = atoi(buff); 

                ORP_thread *p_thr = p_active_threads_list;

                for (int yy = 0; yy < xx; yy++) {

                    p_thr = p_thr->p_active;
                    if (p_thr == 0) break;
                }
                if (p_thr == 0) break;

                Frame_Context fc;
                memset(&fc, 0, sizeof(Frame_Context));

                fc.p_eip = p_thr->gc_frame_context.p_eip;
                fc.p_ebp = p_thr->gc_frame_context.p_ebp;
                fc.p_ebx = p_thr->gc_frame_context.p_ebx;
                fc.p_esi = p_thr->gc_frame_context.p_esi;
                fc.p_edi = p_thr->gc_frame_context.p_edi;
                fc.esp   = p_thr->gc_frame_context.esp;

                void stack_trace(Frame_Context *p_frame);
                stack_trace(&fc);

                break;
            }
        case cm_go:						// "go"
            {
                enter_the_debugger = false;
                return;
                break;
            }
        case cm_run:                    // "run"
            {
                memset(breakpoints,0,sizeof(jvmdi_bp)*NBREAKPOINTS);
                memset(bytecode_breakpoints,0,sizeof(jvmdi_bp)*NBREAKPOINTS);
                memset(single_step_points,0,sizeof(jvmdi_ss)*SINGLE_STEP_PTS);
                memset(bytecode_single_step_points,0,sizeof(jvmdi_ss)*BYTECODE_SINGLE_STEP_PTS);
                enter_the_debugger = false;
                return;
            }
        case cm_next:						//"next"
            {
                if (set_breakpoint_for_next())
                    return;
                else
                    break;
            }
        case cm_step:
            {
                if (curr_method == NULL){
                    orp_cout<<" programe didn't run!"<<endl;
                    break;
                }

                if (set_breakpoint_for_step(curr_line_idx,curr_bytecode_idx,curr_method))
                    return;
                else
                    break;
            }
        case cm_stepout:
            {
                if (p_eip_arg == 0 ) {
					orp_cout <<"the programe didn't run"<<endl;
					break;
				}
				Frame_Context local_fct;
                orp_copy_frame_context(&local_fct, &fct);
                unsigned depth = orp_get_stack_depth(&local_fct, 0, 0, 0, TRUE);
                if (depth>1){
                    set_breakpoint_for_stepout(&local_fct);
                    return;
                }
                else 
                    orp_cout<<"this is the first java frame"<<endl;
                break;                       
            }
        case cm_thread:			// "thread"
            {
                ORP_thread *p_thr = p_active_threads_list;
                for (int yy = 0; yy < 256; yy++) {
                    printf("%d)\t", yy);
                    printf("(ID 0x%x)\tname = " , p_thr->thread_id);

                    char one_char[2];
                    one_char[1] = 0;
#if 0
                    // (mjc 20000519)
                    // This tries to access java.lang.Thread's fields directly
                    assert(0);
#else
                   // for(int xx = 0; xx < p_thr->p_java_lang_thread->name->length; xx++) {
					
					for(int xx = 0; xx < p_thr->p_java_lang_thread->vt->clss->name->len; xx++) {
                        one_char[0] = 
                            (char)(p_thr->p_java_lang_thread->vt->clss->name->bytes[xx]);
                        printf("%s", one_char);
                    }
#endif
                    if (p_thr == p_TLS_orpthread)
                        orp_cout << " CURRENT THREAD ";
                    printf("\n");
                    p_thr = p_thr->p_active;
                    if (!p_thr) break;
                }
                break;
            }
        case cm_i:		// "i"
            {
                orp_cout << "break on next method entry not implemented" << endl;
                break;
            }

        case cm_o:      //"o"
            {
                orp_cout << "break on method return not implemented" << endl;
                break;
            }
        case cm_verbose:		//"verbose"
            {
                if (jvmdi_verbose) {
                    jvmdi_verbose = false;
                    orp_cout << "verbose off" << endl;
                }
                else {
                    jvmdi_verbose = true;
                    orp_cout << "verbose on" << endl;
                }
                break;
            }
        case cm_x:		// "x"
            {
                printf(" enter an EIP (in hex) >");
                my_gets(buff);
                unsigned long ll = strtoul( buff, 0, 16 );

                int32 *p_EIP = (int32 *)(&ll);
                printf(" 0x%x >> ", *p_EIP);

                if(orp_identify_eip((void *)*p_EIP) == ORP_TYPE_JAVA) {
                    Method *method = methods.find((void *)*p_EIP)->get_method();
                    orp_cout << method->get_class()->name->bytes << ".";
                    orp_cout << method->get_name()->bytes;
                    orp_cout << method->get_descriptor();
                    orp_cout << " #" << (int)which_line_is_it(*p_EIP, false);
			        orp_cout << endl;
                }
                else orp_cout << "not in jitted code" << endl;

                break;
            }
        case cm_breakb:     //"breakb"
            {
                if (bytecode_breakpoints_num>=NBREAKPOINTS){
	                cout <<"the max number of bp is"<<NBREAKPOINTS<<endl;
	                break;
                }
                set_breakpoint(sub_str2,bytecode_level,curr_method);
                break;
            }
        case cm_nextb:
            {
                if (p_eip_arg==NULL){
                    orp_cout<<"     program didn't run!"<<endl;
                    break;
                }
                if (curr_bytecode_idx == UNKNOWN_BYTECODE_NUM){
                    orp_cout<<"the current bytecode index is unknown"<<endl;
                    break;
                }
                if (set_nextb_breakpoint(fct,curr_bytecode_idx,false)){
                    enter_the_debugger = false;
                    return;
                }
                break;
            }
        case cm_stepb:                          // "stepb"
            {
                if (p_eip_arg==NULL){
                    orp_cout<<"     program didn't run!"<<endl;
                    break;
                }
                if (curr_bytecode_idx == UNKNOWN_BYTECODE_NUM){
                    orp_cout<<"the current bytecode index is unknown"<<endl;
                    break;
                }
                if (set_nextb_breakpoint(fct,curr_bytecode_idx,true)){
                    enter_the_debugger = false;
                    return;
                }
                break;
            }
        case cm_listb:
            {
                if (p_eip_arg==NULL){
                    orp_cout<<"     program didn't run!"<<endl;
                    break;
                }
                if (curr_bytecode_idx == UNKNOWN_BYTECODE_NUM){
                    orp_cout<<"the current bytecode index is unknown"<<endl;
                    break;
                }
                
                Frame_Context fc;
                memset(&fc, 0, sizeof(Frame_Context));

                fc.p_eip = p_TLS_orpthread->gc_frame_context.p_eip;
                fc.p_ebp = p_TLS_orpthread->gc_frame_context.p_ebp;
                fc.p_ebx = p_TLS_orpthread->gc_frame_context.p_ebx;
                fc.p_esi = p_TLS_orpthread->gc_frame_context.p_esi;
                fc.p_edi = p_TLS_orpthread->gc_frame_context.p_edi;
                fc.esp   = p_TLS_orpthread->gc_frame_context.esp;
				fc.is_first = true;

                unwind_it(&fc, curr_frame_num);
                
                Method *list_meth = methods.find((void *)*(fc.p_eip))->get_method();
                uint32 list_bytecode_idx;
                if (fc.is_first)
                    list_bytecode_idx = which_bytecode_is_it((uint32)*(fc.p_eip),true);
                else
                    list_bytecode_idx = which_bytecode_is_it((uint32)*(fc.p_eip),false);
                list_bytecode(list_meth,list_bytecode_idx);
                break;
            }
        case cm_exit:
            {
                exit(0);
                break;
            }
        default:
            {
                if (strlen(buff) != 0)
                    orp_cout << "not a valid command" << endl;
                break;
            }
        }
        orp_cout << "jvmdi_dbg[" <<curr_frame_num<<"]>";
    }
}


void init_jvmdi_debugger()
{
    breakpoints_num = 0;
    bytecode_breakpoints_num = 0;
    memset(breakpoints,0,sizeof(jvmdi_bp)*NBREAKPOINTS);
    memset(bytecode_breakpoints,0,sizeof(jvmdi_bp)*NBREAKPOINTS);

#ifdef ORP_NT
    int fd = _open("c:\\temp\\jvmdi_dbg", _O_RDONLY, 
        _S_IREAD | _S_IWRITE  );
#elif defined (ORP_POSIX)
    int fd = open("/tmp/jvmdi_dbg", O_RDONLY, 
        S_IREAD | S_IWRITE  );
#endif

    if (fd != -1) {
#ifdef ORP_NT
        struct _stat buff;
        int stat = _fstat( fd, &buff);
        
        if (buff.st_size != (sizeof(jvmdi_bp) * NBREAKPOINTS)*2 )  
        {
            printf("not restoring breakpoints, c:\\temp\\jvmdi_dbg corrupted\n");
            stat = _close(fd);
            printf("deleting c:\\temp\\jvmdi_dbg\n");
            _unlink("c:\\temp\\jvmdi_dbg");
        }
        else {
            stat = _read(fd, breakpoints, buff.st_size/2);
            stat = _read(fd, bytecode_breakpoints, buff.st_size/2);
        }
        stat = _close(fd);

#elif defined(ORP_POSIX)
        struct _stat buff;
        int stat = fstat( fd, &buff);
        
        if (buff.st_size != (sizeof(jvmdi_bp) * NBREAKPOINTS)*2 )  
        {
            printf("not restoring breakpoints, /tmp/jvmdi_dbg corrupted\n");
            stat = close(fd);
            printf("deleting /tmp/jvmdi_dbg\n");
            unlink("/tmp/jvmdi_dbg");
        }
        else {
            stat = read(fd,breakpoints,buff.st_size/2 );
            stat = read(fd,bytecode_breakpoints,buff.st_size/2 );
        }
        stat = close(fd);
#endif
		
		int xx;
        for ( xx = 0; xx < NBREAKPOINTS; xx++) {
            breakpoints[breakpoints_num].method_handle = 0;  // DO NOT read in method handles from previous run
            breakpoints[breakpoints_num].loc = 0; // DO NOT read in executable address from previous run
            breakpoints[breakpoints_num].old_value = 0; // ditto

            if (breakpoints[breakpoints_num].buff_descriptor[0] == 0)
                break;

			
            String *p_m_str = ORP_Global_State::loader_env->string_pool.lookup(
                                (const char *)breakpoints[breakpoints_num].buff_method);

            String *p_d_str = ORP_Global_State::loader_env->string_pool.lookup(
                                (const char *)breakpoints[breakpoints_num].buff_descriptor);

            Signature *sig = ORP_Global_State::loader_env->sig_table.lookup(p_m_str, p_d_str);

            String *p_c_str = ORP_Global_State::loader_env->string_pool.lookup(
                                (const char *)breakpoints[breakpoints_num].buff_class);

            Class *p_clss  = ORP_Global_State::loader_env->class_table.lookup(p_c_str);
			bool bp_alive = true;
            if (p_clss == 0) {
                Loader_Exception ld_exc;
                p_clss = load_class(ORP_Global_State::loader_env, p_c_str, &ld_exc);
                if (p_clss == 0) {
					bp_alive = false;
                    //orp_cout << "warning: can't find class " << breakpoints[breakpoints_num].buff_class << endl;
                    //break;
                }
            }
			if (p_clss!=0){
				Method *p_meth = class_lookup_method(p_clss, sig);
				if (p_meth == 0)
					bp_alive = false;
				else
					breakpoints[breakpoints_num].method_handle = (void *)p_meth;
			}
			if (!bp_alive){
				for (int j=breakpoints_num;j<NBREAKPOINTS-1;j++){
					memcpy(&breakpoints[j],&breakpoints[j+1],sizeof(jvmdi_bp));
				}
				memset(&breakpoints[NBREAKPOINTS-1],0,sizeof(jvmdi_bp));
			} else
				breakpoints_num++;
        }
    
        for ( xx = 0; xx < NBREAKPOINTS; xx++) {
            bytecode_breakpoints[bytecode_breakpoints_num].method_handle = 0;  // DO NOT read in method handles from previous run
            bytecode_breakpoints[bytecode_breakpoints_num].loc = 0; // DO NOT read in executable address from previous run
            bytecode_breakpoints[bytecode_breakpoints_num].old_value = 0; // ditto

            if (bytecode_breakpoints[bytecode_breakpoints_num].buff_descriptor[0] == 0)
                break;

		    
            String *p_m_str = ORP_Global_State::loader_env->string_pool.lookup(
                                (const char *)bytecode_breakpoints[bytecode_breakpoints_num].buff_method);

            String *p_d_str = ORP_Global_State::loader_env->string_pool.lookup(
                                (const char *)bytecode_breakpoints[bytecode_breakpoints_num].buff_descriptor);

            Signature *sig = ORP_Global_State::loader_env->sig_table.lookup(p_m_str, p_d_str);

            String *p_c_str = ORP_Global_State::loader_env->string_pool.lookup(
                                (const char *)bytecode_breakpoints[bytecode_breakpoints_num].buff_class);

            Class *p_clss  = ORP_Global_State::loader_env->class_table.lookup(p_c_str);
		    bool bp_alive = true;
            if (p_clss == 0) {
                Loader_Exception ld_exc;
                p_clss = load_class(ORP_Global_State::loader_env, p_c_str, &ld_exc);
                if (p_clss == 0) {
				    bp_alive = false;
                    //orp_cout << "warning: can't find class " << bytecode_breakpoints[bytecode_breakpoints_num].buff_class << endl;
                    //break;
                }
            }
		    if (p_clss!=0){
			    Method *p_meth = class_lookup_method(p_clss, sig);
			    if (p_meth == 0)
				    bp_alive = false;
			    else
				    bytecode_breakpoints[bytecode_breakpoints_num].method_handle = (void *)p_meth;
		    }
		    if (!bp_alive){
			    for (int j=bytecode_breakpoints_num;j<NBREAKPOINTS-1;j++){
				    memcpy(&bytecode_breakpoints[j],&bytecode_breakpoints[j+1],sizeof(jvmdi_bp));
			    }
			    memset(&bytecode_breakpoints[NBREAKPOINTS-1],0,sizeof(jvmdi_bp));
		    } else
			    bytecode_breakpoints_num++;
        }
    }
    int i;
	for (i =breakpoints_num;i<NBREAKPOINTS;i++)
        memset(&breakpoints[i],0,sizeof(jvmdi_bp));
    for (i =bytecode_breakpoints_num;i<NBREAKPOINTS;i++)
        memset(&bytecode_breakpoints[i],0,sizeof(jvmdi_bp));
    memset(single_step_points, 0, (sizeof(jvmdi_ss) * SINGLE_STEP_PTS) );

    if (enter_the_debugger) 
        temp_jvmdi_debugger( (void *)0);
}


