// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/base/ini_iA32.cpp,v 1.6 2001/12/20 01:28:17 gwu2 Exp $
//


#include "platform.h"
#include <iostream.h>
#include <stdio.h>
#include <assert.h>

#include "orp_types.h"
#include "Class.h"
#include "exceptions.h"
#include "root_set_enum.h"
#include "orp_threads.h"
#include "orp_synch.h"
#include "compile.h"
#include "nogc.h"
#include "../x86/x86.h"
#include "ini.h"

#ifdef ORP_VTUNE_SUPPORT
//M:
#include "orp_vtune.h"
#endif


#ifdef ORP_POSIX
#include "platform2.h"
#endif

#ifdef USE_IA64_JIT
#error This file shouldnt be used with the iA64 JIT
#endif



static char orp_atomic_compare_exchange_code[100];

void *getaddress__orp_atomic_compare_exchange()
{
    static void *addr = 0;
    if (addr) {
        return addr;
    }

    const int stub_size = 60;
#ifdef ORP_VTUNE_SUPPORT
    //M: 
    char *stub = (char *)gc_malloc_fixed_code_for_class_loading(stub_size);
#else
    char *stub = orp_atomic_compare_exchange_code;
#endif //ORP_VTUNE_SUPPORT
#ifdef _DEBUG
    memset(stub, 0xcc /*int 3*/, stub_size);
#endif
    char *ss = stub;

    // Load the address for the cmpxchg
    ss = mov(ss, &ecx_opnd, &M_Base_Opnd(esp_reg, 4));

    // Load the value to be stored
    ss = mov(ss, &edx_opnd, &M_Base_Opnd(esp_reg, 8));

    // Load the value to copare agains
    ss = mov(ss, &eax_opnd, &M_Base_Opnd(esp_reg, 12));

    ss = prefix(ss, lock_prefix);
    ss = cmpxchg(ss, &M_Base_Opnd(ecx_reg, 0), &edx_opnd);

    //ss = mov(ss, &edx_opnd, &eax_opnd);

    ss = ret(ss);

    addr = stub;
    assert((ss - stub) < stub_size);
#ifdef ORP_VTUNE_SUPPORT
    //M:
    vtune_notify_stub_load_finished("getaddress__orp_atomic_compare_exchange",(Byte*) stub,ss-stub);
#endif
    return addr;
} //getaddress__orp_atomic_compare_exchange



void *getaddress__float_result()
{
    static void *addr = 0;
    if (addr) {
        return addr;
    }

    const int stub_size = 1024;
    char *stub = (char *)gc_malloc_fixed_code_for_class_loading(stub_size);
#ifdef _DEBUG
    memset(stub, 0xcc /*int 3*/, stub_size);
#endif
    char *ss = stub;

    ss = push(ss, &ebp_opnd);
    ss = mov(ss, &ebp_opnd, &esp_opnd);
    ss = push(ss, &ecx_opnd);
    ss = push(ss, &ebx_opnd);
    ss = push(ss, &esi_opnd);
    ss = push(ss, &edi_opnd);

    ss = fst(ss, &M_Base_Opnd(ebp_reg, -4), 0, 1);

    ss = mov(ss, &eax_opnd, &M_Base_Opnd(ebp_reg, +8));
    ss = mov(ss, &ecx_opnd, &M_Base_Opnd(ebp_reg, -4));
    ss = mov(ss, &M_Base_Opnd(eax_reg, 0), &ecx_opnd);

    ss = pop(ss, &edi_opnd);
    ss = pop(ss, &esi_opnd);
    ss = pop(ss, &ebx_opnd);

    ss = mov(ss, &esp_opnd, &ebp_opnd);

    ss = pop(ss, &ebp_opnd);
    
    ss = ret(ss);
    
    addr = stub;
#ifdef ORP_VTUNE_SUPPORT
    //M:
    vtune_notify_stub_load_finished("getaddress__float_result",(Byte*) stub,ss-stub);
#endif
    return addr;
} //getaddress__float_result


void *getaddress__double_result()
{
    static void *addr = 0;
    if (addr) {
        return addr;
    }

    const int stub_size = 1024;
    char *stub = (char *)gc_malloc_fixed_code_for_class_loading(stub_size);
#ifdef _DEBUG
    memset(stub, 0xcc /*int 3*/, stub_size);
#endif
    char *ss = stub;

    ss = push(ss, &ebp_opnd);
    ss = mov(ss, &ebp_opnd, &esp_opnd);
    ss = alu(ss, sub_opc, &esp_opnd, &Imm_Opnd(8));
    ss = push(ss, &ebx_opnd);
    ss = push(ss, &esi_opnd);
    ss = push(ss, &edi_opnd);

    ss = mov(ss, &M_Base_Opnd(ebp_reg, -8), &Imm_Opnd(0));
    ss = mov(ss, &M_Base_Opnd(ebp_reg, -4), &Imm_Opnd(0));

    ss = fst(ss, &M_Base_Opnd(ebp_reg, -8), 1, 1);

    ss = mov(ss, &eax_opnd, &M_Base_Opnd(ebp_reg, +8));
    ss = mov(ss, &ecx_opnd, &M_Base_Opnd(ebp_reg, -8));
    ss = mov(ss, &M_Base_Opnd(eax_reg, 0), &ecx_opnd);
    ss = mov(ss, &edx_opnd, &M_Base_Opnd(ebp_reg, -4));
    ss = mov(ss, &M_Base_Opnd(eax_reg, +4), &edx_opnd);

    ss = pop(ss, &edi_opnd);
    ss = pop(ss, &esi_opnd);
    ss = pop(ss, &ebx_opnd);

    ss = mov(ss, &esp_opnd, &ebp_opnd);

    ss = pop(ss, &ebp_opnd);
    
    ss = ret(ss);
    
    addr = stub;
#ifdef ORP_VTUNE_SUPPORT
    //M:
    vtune_notify_stub_load_finished("getaddress__double_result",(Byte*) stub,ss-stub);
#endif
    return addr;
} //getaddress__double_result


#if 0 // keep this around -- used for debug/development
void asm__float_result(float *fres)
{
    float fff = 0;
    __asm {
        fstp fff
    }
    *fres = fff;
}


void asm__double_result(double *dres)
{
    double ddd = 0;
    __asm {
        fstp    ddd
    }
    *dres = ddd;
}
#endif // 0


void * getaddress__push_more_all()
{
    static void *addr = 0;
    if (addr) {
        return addr;
    }

    const int stub_size = 1024;
    char *stub = (char *)gc_malloc_fixed_code_for_class_loading(stub_size);
#ifdef _DEBUG
    memset(stub, 0xcc /*int 3*/, stub_size);
#endif
    char *ss = stub;    

    ss = push(ss, &ebp_opnd);
    ss = mov(ss, &ebp_opnd, &esp_opnd);
    ss = push(ss, &ebx_opnd);
    ss = push(ss, &esi_opnd);
    ss = push(ss, &edi_opnd);

    ss = mov(ss, &ecx_opnd, &M_Base_Opnd(ebp_reg, +8) );
    ss = mov(ss, &eax_opnd, &M_Base_Opnd(ebp_reg, +0x0c) );

//push_more_args:
    char *address_push_more_args = (char *)ss;

    ss = alu(ss, or_opc, &ecx_opnd, &ecx_opnd);

    ss = branch8(ss, cc_eq, &Imm_Opnd(0), 0);    //je pushed_all_args
    char *backpatch_address__pushed_all_args = ((char *)ss) - 1;

    ss = push(ss, &M_Base_Opnd(eax_reg, 0));
    ss = dec(ss, &R_Opnd(ecx_reg) );
    ss = alu(ss, add_opc, &eax_opnd, &Imm_Opnd(4) );
    
    signed offset = (signed)address_push_more_args - (signed)ss - 2;
    ss = jump8(ss, &Imm_Opnd(offset) ); // jmp push_more_args

//pushed_all_args:
    offset = (signed)ss - (signed)backpatch_address__pushed_all_args - 1;
    *backpatch_address__pushed_all_args = offset;

    ss = call(ss, &M_Base_Opnd(ebp_reg, +0x10) );

    ss = mov(ss, &ecx_opnd, &M_Base_Opnd(ebp_reg, +0x18) );
    ss = mov(ss, &M_Base_Opnd(ecx_reg, 0), &eax_opnd );
    ss = mov(ss, &ecx_opnd, &M_Base_Opnd(ebp_reg, +0x1c) );
    ss = mov(ss, &M_Base_Opnd(ecx_reg, 0), &edx_opnd );

    ss = call(ss, (char *)get_current_thread_exception );

    ss = alu(ss, or_opc, &eax_opnd, &eax_opnd);
    
    ss = branch8(ss, cc_eq, &Imm_Opnd(0), 0); // je no_exception
    char *backpatch_address__no_exception = ((char *)ss) - 1;

    ss = alu(ss, add_opc, &esp_opnd, &M_Base_Opnd(ebp_reg, +0x14)  );
//no_exception:
    offset = (signed)ss - (signed)backpatch_address__no_exception -1;
    *backpatch_address__no_exception = offset;

    ss = pop(ss, &edi_opnd);
    ss = pop(ss, &esi_opnd);
    ss = pop(ss, &ebx_opnd);
    ss = pop(ss, &ebp_opnd);

    ss = ret(ss);

    addr = stub;
#ifdef ORP_VTUNE_SUPPORT
    //M: 
    vtune_notify_stub_load_finished("getaddress__push_more_all",(Byte*) stub,ss-stub);
#endif
    return addr;    
} //getaddress__push_more_all

#if 0  // save for debugging purposes
void asm__push_more_all(unsigned num_arg_words, uint32 *p_arg_words, 
                   void *meth_addr, unsigned get_num_arg_bytes,
                   uint32 *p_eax_var, uint32 *p_edx_var)
{
    __asm {
        // Push all arguments
        mov     ecx, num_arg_words
        mov     eax, p_arg_words

push_more_args:
        or      ecx, ecx
        jz      pushed_all_args
        push    dword ptr [eax]
        dec     ecx
        add     eax, 4
        jmp     push_more_args

pushed_all_args:
        // All arguments are on the stack

        // Arguments are pushed on the stack and the references are registered,
        // it is safe to invoke the method now.
        call    dword ptr [meth_addr]

        // In case a value was returned
        mov     ecx, [p_eax_var]
        mov     [ecx], eax
        mov     ecx, [p_edx_var]
        mov     [ecx], edx

        call    get_current_thread_exception
        or      eax, eax
        jz      no_exception
        add     esp, get_num_arg_bytes
no_exception:

    }
}
#endif


void
orp_execute_java_method_array(Method   *meth,
                              void     *return_value,
                              J_Value   args[])
{
    assert(!orp_is_gc_enabled(p_TLS_orpthread));

    // Arguments which are references
    unsigned num_ref_args = 0;
    uint32 arg_words[255];
    uint32 *p_arg_words = arg_words;

    Arg_List_Iterator iter = meth->get_argument_list();
    Java_Type ret_type = meth->get_return_java_type();
    void *meth_addr = meth->get_code_addr();
    unsigned num_arg_words = 0;

    uint32 i32;
    uint64 i64;
	float  f32;

    Java_Type typ;
    unsigned arg_num = 0;

    if(!meth->is_static()) {
        // this pointer
        i32 = (uint32)args[arg_num++].r;
        arg_words[num_arg_words++] = i32;
        num_ref_args++;
    }

    while((typ = curr_arg(iter)) != JAVA_TYPE_END) {
        switch(typ) {
        case JAVA_TYPE_LONG:
        case JAVA_TYPE_DOUBLE:
            i64 = args[arg_num++].j;
            arg_words[num_arg_words++] = (uint32)(i64 >> 32);
            arg_words[num_arg_words++] = (uint32)i64;
            break;
        case JAVA_TYPE_CLASS:
        case JAVA_TYPE_ARRAY:
            i32 = (uint32)args[arg_num++].r;
            arg_words[num_arg_words++] = i32;
            num_ref_args++;
            break;
        case JAVA_TYPE_FLOAT:
            f32 = args[arg_num++].f;
            arg_words[num_arg_words++] = *((int32*)&f32);
            break;
        case JAVA_TYPE_SHORT:
            i32 = (uint32)args[arg_num++].s;
            arg_words[num_arg_words++] = i32;
            break;
        case JAVA_TYPE_CHAR:
            i32 = (uint32)args[arg_num++].c;
            arg_words[num_arg_words++] = i32;
            break;
        case JAVA_TYPE_BYTE:
            i32 = (uint32)args[arg_num++].b;
            arg_words[num_arg_words++] = i32;
            break;
        case JAVA_TYPE_BOOLEAN:
            i32 = (uint32)args[arg_num++].z;
            arg_words[num_arg_words++] = i32;
            break;
        default:
            i32 = (uint32)args[arg_num++].i;
            arg_words[num_arg_words++] = i32;
            break;
        }
        iter = advance_arg_iterator(iter);
    }

    // Return value
    uint32 eax_var, edx_var;

    unsigned get_num_arg_bytes = meth->get_num_arg_bytes();


    void (*gapma)(unsigned num_arg_words, uint32 *p_arg_words, 
                   void *meth_addr, unsigned get_num_arg_bytes,
                   uint32 *p_eax_var, uint32 *p_edx_var);

    gapma = (void ( *)(unsigned num_arg_words, uint32 *p_arg_words, 
                   void *meth_addr, unsigned get_num_arg_bytes,
                   uint32 *p_eax_var, uint32 *p_edx_var) )  getaddress__push_more_all();

   // asm__push_more_all(num_arg_words, p_arg_words, meth_addr, get_num_arg_bytes, &eax_var, &edx_var); //-- used for debug/development

    assert( get_current_thread_exception() == 0);

    gapma(num_arg_words, p_arg_words, 
                   meth_addr, get_num_arg_bytes,
                   &eax_var, &edx_var);


    if(get_current_thread_exception()) {
        return;
    }

    J_Value *result = (J_Value *)return_value;
    switch(ret_type) {
    case JAVA_TYPE_LONG:
        {
            uint64 hi = edx_var;
            uint64 lo = eax_var;
            uint64 r = lo + (hi << 32);
            result->j = (int64)r;
        }
        break;

    case JAVA_TYPE_FLOAT:
        {
            float float_result = 0.0f;

            //asm__float_result(&float_result); -- used for debug/development
            void (*gafr)(float *fr);
            gafr = (void ( *)(float *) )  getaddress__float_result();
            gafr(&float_result);

            result->f = float_result;
        }
        break;

    case JAVA_TYPE_DOUBLE:
        {
            double double_result = 0.0;

            //asm__double_result(&double_result); -- used for debug/development
            void (*gadr)(double *dr);
            gadr = (void ( *)(double *) )  getaddress__double_result();
            gadr(&double_result);

            result->d = double_result;
        }
        break;

    case JAVA_TYPE_VOID:
        break;
    default:
        *(uint32 *)return_value = eax_var;
        break;
    }
} //orp_execute_java_method_array



