/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


#pragma hdrstop
#include "View.h"
#include "Math3D.h"

#define D3D_GETR(val) (((val)>>16)&0xff)
#define D3D_GETG(val) (((val)>>8)&0xff)
#define D3D_GETB(val) ((val)&0xff)
#define D3D_GETA(val) (((val)>>24)&0xff)

extern D3DMATRIX initViewMatrix;

CView::CView(CDirect3D *d3d)
{
	D3D=d3d;
	x=0; y=0; z=0; ax=0; ay=0; az=0;
	isActive=0;
	update=1;

	memcpy(&matrix,&initViewMatrix,sizeof(D3DMATRIX));

	// Set up the viewport
	vd.dwX=0;
	vd.dwY=0;
	vd.dwWidth=D3D->GetDDraw()->GetScrnX();
	vd.dwHeight=D3D->GetDDraw()->GetScrnY();
	vd.dvMinZ=0.0;
	vd.dvMaxZ=1.0;
}

CView::~CView()
{
}

void CView::SetViewRect(RECT r)
{
	// Change the viewport data to reflect the new size
	vd.dwX=r.left;
	vd.dwY=r.top;
	vd.dwWidth=r.right-r.left;
	vd.dwHeight=r.bottom-r.top;
	vd.dvMinZ=0;
	vd.dvMaxZ=1;
}

void CView::GoForward(float d)
{
	Vector forward(0,0,d);
	D3DMATRIX transform;

	memcpy(&transform,&initViewMatrix,sizeof(D3DMATRIX));
	MatrixRotateZ(transform,-az);
	MatrixRotateY(transform,-ay);
//	MatrixRotateX(transform,-ax);
	TransformVector(forward,transform);
	AddXPos(forward.x);
	AddYPos(forward.y);
	AddZPos(forward.z);
	update=1;
}

void CView::GoSide(float d)
{
	Vector forward(d,0,0);
	D3DMATRIX transform;

	memcpy(&transform,&initViewMatrix,sizeof(D3DMATRIX));
	MatrixRotateZ(transform,-az);
	MatrixRotateY(transform,-ay);
//	MatrixRotateX(transform,-ax);
	TransformVector(forward,transform);
	AddXPos(forward.x);
	AddYPos(forward.y);
	AddZPos(forward.z);
	update=1;
}

void CView::Update()
{
	if (!update) return;
	memcpy(&matrix,&initViewMatrix,sizeof(D3DMATRIX));
	matrix._41=-x; matrix._42=-y; matrix._43=-z;
	MatrixRotateZ(matrix,-az);
	MatrixRotateY(matrix,-ay);
	MatrixRotateX(matrix,-ax);
	if (isActive)
	{
		if (D3D->GetD3DDevice()->SetTransform(D3DTRANSFORMSTATE_VIEW,
			&matrix)!=DD_OK)
			throw "Could not set view matrix";
	}
	update=0;
}

void CView::SetBackgroundColor(D3DCOLOR color)
{
    
}

void CView::Translate(Vector& pt)
{
	TransformVector(pt,matrix);
}

void CView::Restore(CDirect3D *d3d)
{
	D3D=d3d;
	isActive=0;
	update=1;
	vd.dwX=0;
	vd.dwY=0;
	vd.dwWidth=D3D->GetDDraw()->GetScrnX();
	vd.dwHeight=D3D->GetDDraw()->GetScrnY();
	vd.dvMinZ=0;
	vd.dvMaxZ=1;
}
