/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


#include <math.h>
#include "Render.h"
#include "map.h"

#define SPRITE 0
#define WINDOW 1

static MATRIX initViewMatrix={1, 0, 0, 0,
                              0, 1, 0, 0,
			      0, 0, 1, 0,
			      0, 0, 0, 1};

Render::Render()
{
}

Render::~Render()
{
}

int Render::Initialized()
{
    return 0;
}

void Render::MarkSpritesInSector(Map *map,int sectNum)
{
    for (int i=0;i<map->numSprites;i++)
    {
        if (map->sprite[i].sectnum==sectNum)
        {
            map->MakeSpriteFaceViewer(i);
            spritesToDraw[numSpritesToDraw].type=SPRITE;
            spritesToDraw[numSpritesToDraw].spriteIndex=i;
            float xd=GetXPos()-map->sprite[i].x/64.0;
            float yd=GetZPos()+map->sprite[i].y/64.0;
            float dist=xd*xd+yd*yd;
            spritesToDraw[numSpritesToDraw++].distSq=dist;
        }
    }
}

void Render::RenderSector(Map *map,int sectNum)
{
    RenderPolyList(map->sectorPolys[sectNum]);
    if (map->sectorWindowPolys[sectNum].first)
    {
        spritesToDraw[numSpritesToDraw].type=WINDOW;
        spritesToDraw[numSpritesToDraw].spriteIndex=sectNum;
        float xd=GetXPos()-map->sectorWindowPolys[sectNum].first->poly.v[0].x;
        float yd=GetZPos()-map->sectorWindowPolys[sectNum].first->poly.v[0].z;
        float dist=xd*xd+yd*yd;
        spritesToDraw[numSpritesToDraw++].distSq=dist;
    }
    MarkSpritesInSector(map,sectNum);
}

int Render::RenderVisibleSectors(Map *map,int sectNum,float sx,float sy,float ex,float ey)
{
    if (map->sectorDrawn[sectNum]) return 0;
    int sectCount=0;
    RenderSector(map,sectNum);
    sectCount++;
    map->sectorDrawn[sectNum]=1;
    if ((sx==0)&&(sy==0))
    {
        for (int i=map->sector[sectNum].wallptr;i<map->sector[sectNum].wallptr+map->sector[sectNum].wallnum;i++)
        {
            if (map->wall[i].nextsector!=-1)
                sectCount+=RenderVisibleSectors(map,map->wall[i].nextsector,0,0,0,0);
        }
    }
    else
    {
        for (int i=map->sector[sectNum].wallptr;i<map->sector[sectNum].wallptr+map->sector[sectNum].wallnum;i++)
        {
            if (map->wall[i].nextsector!=-1)
                sectCount+=RenderVisibleSectors(map,map->wall[i].nextsector,sx,sy,ex,ey);
        }
    }
    return sectCount;
}

int _USERENTRY spriteCmp(const void *a,const void *b)
{
    if (((SpriteToDraw*)a)->distSq<((SpriteToDraw*)b)->distSq)
        return 1;
    if (((SpriteToDraw*)a)->distSq>((SpriteToDraw*)b)->distSq)
        return -1;
    return 0;
}

int Render::RenderMap(Map *map,int sectNum)
{
    BeginScene();
    memset(map->sectorDrawn,0,4*map->numSectors);
    numSpritesToDraw=0;
    int sectDrawn;
    if (sectNum==-1)
    {
        for (int i=0;i<map->numSectors;i++)
            RenderSector(map,i);
        sectDrawn=map->numSectors;
    }
    else
        sectDrawn=RenderVisibleSectors(map,sectNum,0,0,0,0);
    qsort(spritesToDraw,numSpritesToDraw,sizeof(SpriteToDraw),spriteCmp);
    for (int i=0;i<numSpritesToDraw;i++)
    {
        if (spritesToDraw[i].type==SPRITE)
            RenderPolyList(map->spritePolys[spritesToDraw[i].spriteIndex]);
        else
            RenderPolyList(map->sectorWindowPolys[spritesToDraw[i].spriteIndex]);
    }
    EndScene();
    return sectDrawn;
}

void Render::LoadPalette(int i,unsigned short *pal)
{
}

static void MatrixRotateX(MATRIX& mat,float a)
{
	MATRIX temp;
	float s=sin(a);
	float c=cos(a);

	temp._12=mat._12*c+mat._13*s;
	temp._22=mat._22*c+mat._23*s;
	temp._32=mat._32*c+mat._33*s;
	temp._42=mat._42*c+mat._43*s;
	temp._13=mat._12*-s+mat._13*c;
	temp._23=mat._22*-s+mat._23*c;
	temp._33=mat._32*-s+mat._33*c;
	temp._43=mat._42*-s+mat._43*c;

	mat._12=temp._12; mat._22=temp._22; mat._32=temp._32;
	mat._42=temp._42; mat._13=temp._13; mat._23=temp._23;
	mat._33=temp._33; mat._43=temp._43;
}

static void MatrixRotateY(MATRIX& mat,float a)
{
	MATRIX temp;
	float s=sin(a);
	float c=cos(a);

	temp._11=mat._11*c+mat._13*-s;
	temp._21=mat._21*c+mat._23*-s;
	temp._31=mat._31*c+mat._33*-s;
	temp._41=mat._41*c+mat._43*-s;
	temp._13=mat._11*s+mat._13*c;
	temp._23=mat._21*s+mat._23*c;
	temp._33=mat._31*s+mat._33*c;
	temp._43=mat._41*s+mat._43*c;

	mat._11=temp._11; mat._21=temp._21; mat._31=temp._31;
	mat._41=temp._41; mat._13=temp._13; mat._23=temp._23;
	mat._33=temp._33; mat._43=temp._43;
}

static void MatrixRotateZ(MATRIX& mat,float a)
{
	MATRIX temp;
	float s=sin(a);
	float c=cos(a);

	temp._11=mat._11*c+mat._12*s;
	temp._21=mat._21*c+mat._22*s;
	temp._31=mat._31*c+mat._32*s;
	temp._41=mat._41*c+mat._42*s;
	temp._12=mat._11*-s+mat._12*c;
	temp._22=mat._21*-s+mat._22*c;
	temp._32=mat._31*-s+mat._32*c;
	temp._42=mat._41*-s+mat._42*c;

	mat._11=temp._11; mat._21=temp._21; mat._31=temp._31;
	mat._41=temp._41; mat._12=temp._12; mat._22=temp._22;
	mat._32=temp._32; mat._42=temp._42;
}

static void TransformVector(Vector& v,MATRIX& mat)
{
//	v=Vector(v.x*mat._11+v.y*mat._12+v.z*mat._13+mat._41,
//			 v.x*mat._21+v.y*mat._22+v.z*mat._23+mat._42,
//			 v.x*mat._31+v.y*mat._32+v.z*mat._33+mat._43);
	v=Vector(v.x*mat._11+v.y*mat._21+v.z*mat._31+mat._41,
			 v.x*mat._12+v.y*mat._22+v.z*mat._32+mat._42,
			 v.x*mat._13+v.y*mat._23+v.z*mat._33+mat._43);
}

void Render::TranslateVertex(Vertex &vert)
{
    float x=vert.x; float y=vert.y; float z=vert.z;
    vert.x=x*viewMatrix._11+y*viewMatrix._21+z*viewMatrix._31+viewMatrix._41;
    vert.y=x*viewMatrix._12+y*viewMatrix._22+z*viewMatrix._32+viewMatrix._42;
    vert.z=x*viewMatrix._13+y*viewMatrix._23+z*viewMatrix._33+viewMatrix._43;
}

void Render::UpdateViewMatrix()
{
    memcpy(&viewMatrix,&initViewMatrix,sizeof(viewMatrix));
    viewMatrix._41-=GetXPos();
    viewMatrix._42-=GetYPos();
    viewMatrix._43-=GetZPos();
    MatrixRotateZ(viewMatrix,-GetZRotate());
    MatrixRotateY(viewMatrix,-GetYRotate());
    MatrixRotateX(viewMatrix,-GetXRotate());
}

void Render::ScreenShot()
{
}
