/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


//---------------------------------------------------------------------------
#pragma hdrstop

#include <string.h>
#include "GroupFile.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)


GroupFile::~GroupFile()
{
  _Cleanup();
}

// open a group file
bool GroupFile::Open(char *fname)
{
  _GFile gfile;
  _File file;
  char sig[13], name[13];
  int i,
      offset;

  gfile.fp = fopen(fname, "rb");
  if (!gfile.fp)
    return false;
  fread(sig, 12, 1, gfile.fp);
  sig[12] = 0;
  if (strcmp(sig, "KenSilverman"))
  {
    _Cleanup();
    return false;
  }
  fread(&gfile.files, 4, 1, gfile.fp);
  offset = 16 + (gfile.files * 16);
  for(i = 0; i < gfile.files; i++)
  {
    fread(&name, 12, 1, gfile.fp);
    name[12] = 0;
    fread(&file.size, 4, 1, gfile.fp);
    file.offset = offset;
    offset += file.size;
    gfile.file[_strtolower(name)] = file;
  }
  if (ferror(gfile.fp))
  {
    fclose(gfile.fp);
    _Cleanup();
    return false;
  }
  _files.push_back(gfile);

  return true;
}

// return number of files in group
int GroupFile::NumFiles()
{
  vector<_GFile>::iterator i;
  int n;

  n = 0;
  for(i = _files.begin(); i != _files.end(); i++)
    n += i->files;

  return n;
}

// return char array[13] with file names
void GroupFile::FileList(char *list)
{
  vector<_GFile>::iterator g;
  map<string, _File>::iterator f;

  for(g = _files.begin(); g != _files.end(); g++)
    for(f = g->file.begin(); f != g->file.end(); f++)
    {
      memcpy(list, f->first.c_str(), 12);
      list += 12;
      *list = 0;
      list++;
    }
}

// return size of a file
int GroupFile::FileSize(char *name)
{
  FILE *fp;
  int i;
  vector<_GFile>::iterator g;

  for(g = _files.begin(); g != _files.end(); g++)
    if (g->file.count(_strtolower(name)))
      return g->file[_strtolower(name)].size;

  fp = fopen(name, "rb");
  if (!fp)
    return -1;
  fseek(fp, 0L, SEEK_END);
  i = ftell(fp);
  fclose(fp);

  return i;
}

// return array with file contents
bool GroupFile::LoadFile(char *name, char *buf)
{
  return LoadFileB(name, buf, 0, FileSize(name));
}

// load block
bool GroupFile::LoadFileB(char *name, char *buf, int start, int len)
{
  FILE *fp;
  vector<_GFile>::iterator g;

  for(g = _files.begin(); g != _files.end(); g++)
    if (g->file.count(_strtolower(name)))
    {
      fseek(g->fp, g->file[_strtolower(name)].offset + start, SEEK_SET);
      fread(buf, len, 1, g->fp);
      if (ferror(g->fp))
      {
        _Cleanup();
        return false;
      }
      return true;
    }

  fp = fopen(name, "rb");
  if (!fp)
    return false;
  fseek(fp, start, SEEK_SET);
  fread(buf, len, 1, fp);
  fclose(fp);

  return true;
}

// cleanup for destruction/errors
void GroupFile::_Cleanup()
{
  vector<_GFile>::iterator i;

  i = _files.begin();
  while (i != _files.end())
  {
    fclose(i->fp);
    i++;
  }
  _files.clear();
}

string GroupFile::_strtolower(char *str)
{
  string s;
  size_t i;

  for(i = 0; i < strlen(str); i++)
    s += (char)tolower(str[i]);

  return s;
}

