/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


#ifndef __TEXTURE_H__
#define __TEXTURE_H__

#include "Direct3D.h"

#define ALPHA_NONE 0
#define ALPHA_ONEBIT 1
#define ALPHA_FULL 2

class CTexture
{
	IDirectDrawSurface7* lpTexture;
	CDirect3D *D3D;
public:
    char *fn,*afn;
	CTexture(CDirect3D *d3d);
	~CTexture();
	int Create(int width,int height,int alpha=ALPHA_NONE,
		int hint=0,int mipMap=1);
    void LoadFromFile(char *filename);
    void LoadFromFileWithAlpha(char *filename,char *alphaname);
    void LoadFromMemoryTexture(Texture *tex);
    void UpdateMemoryTexture(Texture *tex);
    void Reload(CDirect3D *d3d);
	void *Lock();
	void Unlock();
    IDirectDrawSurface7* GetTexture() { return lpTexture; }
    void GenerateMipMap();
    char* GetName() { return fn; }
};

#endif
