/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


//---------------------------------------------------------------------------

#ifndef EditH
#define EditH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Buttons.hpp>
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
#include <Menus.hpp>
#include "GroupFile.h"
#include "Render.h"
#include "DirectInput.h"
#include "map.h"
#include "Sound.h"
#include "art.h"
#include <Dialogs.hpp>
#include <ToolWin.hpp>
#include <ImgList.hpp>
#include <Grids.hpp>
//---------------------------------------------------------------------------
class TEditWnd : public TForm
{
__published:	// IDE-managed Components
    TMainMenu *MainMenu1;
    TMenuItem *File1;
    TMenuItem *Open1;
    TPanel *View3DPanel;
    TSplitter *Splitter1;
    TPanel *Panel1;
    TPanel *View2DPanel;
    TSplitter *Splitter2;
    TPanel *Panel2;
    TPageControl *PageControl1;
    TTabSheet *LightSheet;
    TPanel *Panel3;
    TLabel *Label1;
    TListBox *LightList;
    TPanel *Panel4;
    TLabel *Label2;
    TShape *LightColor;
    TPanel *Panel5;
    TButton *LightProperties;
    TMenuItem *View1;
    TMenuItem *Software1;
    TMenuItem *Direct3D1;
    TMenuItem *OpenGL1;
    TMenuItem *N1;
    TMenuItem *Exit1;
    TMenuItem *Save1;
    TMenuItem *Saveas1;
    TPaintBox *PaintBox1;
    TMenuItem *N2;
    TMenuItem *StandardLighting1;
    TOpenDialog *OpenDialog1;
    TPaintBox *PaintBox2D;
    TMenuItem *OpenfromDuke3Dgrp1;
    TToolBar *ToolBar1;
    TStatusBar *StatusBar1;
    TSpeedButton *AddLight;
    TSpeedButton *ArrowButton;
    TToolButton *ToolButton1;
    TColorDialog *ColorDialog1;
    TTabSheet *SoundSheet;
    TListBox *SoundList;
    TPanel *Panel6;
    TLabel *Label3;
    TSpeedButton *SoundPlay;
    TTabSheet *MusicSheet;
    TPanel *Panel7;
    TLabel *Label4;
    TSpeedButton *MusicPlay;
    TListBox *MusicList;
    TSpeedButton *MusicStop;
    TTabSheet *TextureSheet;
    TDrawGrid *TextureGrid;
    TLabel *Label5;
    TComboBox *TextureGroup;
    TButton *Button2;
    TButton *Button3;
    TMenuItem *Showusinglightmaps1;
    TMenuItem *Nolighting1;
    TMenuItem *Regeneratelightmaps1;
    TMenuItem *Optimizelevel1;
    TMenuItem *New1;
    TMenuItem *Level1;
    TMenuItem *N3;
    TMenuItem *Levelproperties1;
    void __fastcall FormCreate(TObject *Sender);
    void __fastcall View3DPanelMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
    void __fastcall View3DPanelMouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
    void __fastcall View3DPanelResize(TObject *Sender);
    void __fastcall PaintBox1Paint(TObject *Sender);
    void __fastcall StandardLighting1Click(TObject *Sender);
    void __fastcall Open1Click(TObject *Sender);
    void __fastcall PaintBox2DPaint(TObject *Sender);
    void __fastcall PaintBox2DMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
    void __fastcall PaintBox2DMouseUp(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
    void __fastcall View2DPanelResize(TObject *Sender);
    void __fastcall Exit1Click(TObject *Sender);
    void __fastcall OpenfromDuke3Dgrp1Click(TObject *Sender);
    void __fastcall LightColorMouseUp(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
    void __fastcall SoundListDblClick(TObject *Sender);
    void __fastcall MusicListDblClick(TObject *Sender);
    void __fastcall MusicStopClick(TObject *Sender);
    void __fastcall TextureGridDrawCell(TObject *Sender, int ACol, int ARow,
          TRect &Rect, TGridDrawState State);
    void __fastcall TextureGridDblClick(TObject *Sender);
private:	// User declarations
    GroupFile *group;
    SoundEngine *sound;
    CDirectInput *di;
    Art art;
    int useDirectInput;
    bool minimized;
    Map *curMap;
    char directory[256];
    int curSect;
    int b1,b2;
    bool move3D,move2D;
    Graphics::TBitmap *bmp2D;
    int gridSize;
    float zoom,centerX,centerY;
    POINT oldMousePos;
    int distanceMovedX,distanceMovedY;
public:		// User declarations
    __fastcall TEditWnd(TComponent* Owner);
    void __fastcall OnIdle(TObject *,bool& done);
    void __fastcall FormMinimize(TObject *);
    void __fastcall FormRestore(TObject *);
    void __fastcall MCIWindowProc(TMessage&);
};
//---------------------------------------------------------------------------
extern PACKAGE TEditWnd *EditWnd;
//---------------------------------------------------------------------------
#endif
