/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


#ifndef __DDRAW_H__
#define __DDRAW_H__

#include <windows.h>
#include <ddraw.h>

#define WINDOWED 0

class CDirectDraw
{
	IDirectDraw7 *lpDD;
	IDirectDrawSurface7* lpFrontBuffer;
	IDirectDrawSurface7* lpBackBuffer;
    LPDIRECTDRAW lpDD3;
    LPDIRECTDRAWSURFACE lpFrontBuffer3;
    LPDIRECTDRAWSURFACE lpBackBuffer3;
    int old;
    LPDIRECTDRAWCLIPPER lpClipper;
	int scrnX,scrnY,scrnDepth,inAWindow,allowFlip;
    int x1,x2,y1,y2;
	HWND hWnd;
public:
	CDirectDraw(HWND _hWnd,int sx,int sy,int depth,bool old=false);
	~CDirectDraw();
    void ChangeResolution(HWND _hWnd,int sx,int sy,int depth);
    IDirectDraw7* GetDD();
    LPDIRECTDRAW GetDD3();
	void Update();
	int GetScrnX();
	int GetScrnY();
	int GetScrnDepth();
	HWND GetWindow();
	void BeginGDI();
	void EndGDI();
	IDirectDrawSurface7* GetBackBuffer();
	LPDIRECTDRAWSURFACE GetBackBuffer3();
    void Flip();
    inline void DisableBufferFlip() { allowFlip=0; if (!inAWindow) { if (old) lpFrontBuffer3->SetClipper(lpClipper); else lpFrontBuffer->SetClipper(lpClipper); } }
    inline void EnableBufferFlip() { allowFlip=1; if (!inAWindow) { if (old) lpFrontBuffer3->SetClipper(NULL); else lpFrontBuffer->SetClipper(NULL); } }
    void SetViewport(int x,int y,int w,int h);
    void ResetViewport();
};

#endif

