/*********************************************************
 * Copyright (C) 1998-2005 VMware, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation version 2.1 and no later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the Lesser GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA.
 *
 *********************************************************/


#ifndef VM_TOOLS_VERSION_H
#define VM_TOOLS_VERSION_H

#ifndef RC_INVOKED
#define INCLUDE_ALLOW_USERLEVEL
#define INCLUDE_ALLOW_VMMEXT
#define INCLUDE_ALLOW_MODULE
#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMNIXMOD
#define INCLUDE_ALLOW_VMKERNEL
#define INCLUDE_ALLOW_VMKDRIVERS
#define INCLUDE_ALLOW_VMCORE
#include "includeCheck.h"

#include "buildNumber.h"
#include "vm_basic_types.h"
#endif /* RC_INVOKED */

/*
 * WARNING: The installer perl script PARSE_VM_TOOLS_VERSION.PL
 *          is dependent on the format of this file. So if
 *          reformating or changing macro names is being performed
 *          please run the perl script to ensure it succeeds.
 */


/*
 * VERSION_MAGIC: 0x1 build-034 (beta-1)
 *                0x2 build-049 (beta-2)
 *                0x3 build-066 (beta-3)
 *                0x4 build-084
 *                0x5 build-093 (pre-public beta)
 *                0x6 build-096 (new layout of cross page)
 */


/*
 * XXX
 * XXX Don't ever change this number unless you want to
 * XXX force an upgrade of the VMware tools
 */

#define VERSION_MAGIC      0x6


#ifndef RC_INVOKED

typedef uint32 ToolsVersion;

#endif

/*
 * Reserve the highest possible Tools version for Tools whose lifecycle isn't
 * to be managed by VMware's platform.
 *
 * Even though the ToolsVersion type is defined as uint32 above, the VMX had,
 * for a long time, scanned it via sscanf(3) using "%d". To preserve backwards
 * compatibility with such a VMX, the "highest possible" version is defined to
 * be the largest signed 32-bit integer instead of the largest unsigned 32-bit
 * integer.
 */
#define TOOLS_VERSION_UNMANAGED 0x7fffffff

#define STRINGER(MJR, MNR, BASE)     #MJR "." #MNR "." #BASE
#define TOOLS_VERSION_STRINGER(MJR, MNR, BASE)    STRINGER(MJR, MNR, BASE)

#define TOOLS_VERSION_CSV(MJR, MNR, BASE)  MJR, MNR, BASE

/*
 * Generate the CSV define from the base variant defines.
 * E.g #define DRIVER_VERSION_CSV   TOOLS_VERSION_TO_CSV(TOOLS_VERSION_WS60_FF)
 * Result is: DRIVER_VERSION_CSV set to 7,2,0
 */
#define TOOLS_VERSION_TO_CSV(BASE_VARIANT)     \
   TOOLS_VERSION_CSV(BASE_VARIANT##_V_MJR,BASE_VARIANT##_V_MNR,BASE_VARIANT##_V_BASE)

/*
 * Generate the dotted STRING define from the base variant defines.
 * E.g #define DRIVER_VERSION_STR   TOOLS_VERSION_TO_STR(TOOLS_VERSION_WS60_FF)
 * Result is: DRIVER_VERSION_STR set to "7.2.0"
 */
#define TOOLS_VERSION_TO_STR(BASE_VARIANT)     \
   TOOLS_VERSION_STRINGER(BASE_VARIANT##_V_MJR,BASE_VARIANT##_V_MNR,BASE_VARIANT##_V_BASE)


#define TOOLS_VERSION_UINT(MJR, MNR, BASE)    (((MJR) << 10) + ((MNR) << 5) + (BASE))

/*
 * Allocate 5 bits to each sub-version in the dotted tools version. This
 * should take care of us for any reasonable usage: 32 x 32 x 32.
 * This macro takes the base variant appended with _V suffix and 
 * constructs the version number defines for the version.
 * It then passes the version numbers into the UINT construct macro above.
 */
#define TOOLS_VERSION_TO_UINT(BASE_VARIANT_VER)   \
   TOOLS_VERSION_UINT(BASE_VARIANT_VER##_MJR,BASE_VARIANT_VER##_MNR,BASE_VARIANT_VER##_BASE) 



/*
 * The different tools versions that could be installed. Tools newer than
 * those contained in the install package will have version > CURRENT
 */
/*
 * Legacy (pre-dotted) versions.
 *
 * Note: Do **NOT** change any of these values, they are used in some
 * legacy code and will break if changed.
 */
#define   TOOLS_VERSION_NONE         0   // indicates no tools
#define   TOOLS_VERSION_OLD          1   // indicates pre-versioned tools
#define   TOOLS_VERSION_WS30_FF      2
#define   TOOLS_VERSION_WS30_BETA2   3
#define   TOOLS_VERSION_WS30         4
#define   TOOLS_VERSION_WS31_BETA    5

/* 
 * Versions:-
 * For non-RC compiled variant:
 * Define each version component pass to macro with BASENAME+SUFFIX (_V).
 * Where BASENAME describes the version and append 
 * the appropriate suffix:_V
 * For RC and non-RC define BASENAME_V and append _MJR or _MNR or _BASE.
 * Set each version number accordingly.
 */
#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS31_RC1       TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS31_RC1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS31_RC1_V_MJR       1
#define   TOOLS_VERSION_WS31_RC1_V_MNR       0
#define   TOOLS_VERSION_WS31_RC1_V_BASE      0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS32           TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS32_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS32_V_MJR           1
#define   TOOLS_VERSION_WS32_V_MNR           0
#define   TOOLS_VERSION_WS32_V_BASE          1

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX15_BETA     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX15_BETA_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX15_BETA_V_MJR     2
#define   TOOLS_VERSION_ESX15_BETA_V_MNR     0
#define   TOOLS_VERSION_ESX15_BETA_V_BASE    0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_GSX20_BETA     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_GSX20_BETA_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_GSX20_BETA_V_MJR     3
#define   TOOLS_VERSION_GSX20_BETA_V_MNR     0
#define   TOOLS_VERSION_GSX20_BETA_V_BASE    0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WKS40_FF       TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WKS40_FF_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WKS40_FF_V_MJR       4
#define   TOOLS_VERSION_WKS40_FF_V_MNR       0
#define   TOOLS_VERSION_WKS40_FF_V_BASE      0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WKS40_BETA1    TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WKS40_BETA1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WKS40_BETA1_V_MJR    4
#define   TOOLS_VERSION_WKS40_BETA1_V_MNR    0
#define   TOOLS_VERSION_WKS40_BETA1_V_BASE   1

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WKS40_BETA2    TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WKS40_BETA2_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WKS40_BETA2_V_MJR    4
#define   TOOLS_VERSION_WKS40_BETA2_V_MNR    0
#define   TOOLS_VERSION_WKS40_BETA2_V_BASE   2

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WKS40_BETA3    TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WKS40_BETA3_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WKS40_BETA3_V_MJR    4
#define   TOOLS_VERSION_WKS40_BETA3_V_MNR    0
#define   TOOLS_VERSION_WKS40_BETA3_V_BASE   3

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WKS40_RELEASE  TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WKS40_RELEASE_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WKS40_RELEASE_V_MJR  4
#define   TOOLS_VERSION_WKS40_RELEASE_V_MNR  0
#define   TOOLS_VERSION_WKS40_RELEASE_V_BASE 4

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WKS401_RELEASE    TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WKS401_RELEASE_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WKS401_RELEASE_V_MJR    4
#define   TOOLS_VERSION_WKS401_RELEASE_V_MNR    0
#define   TOOLS_VERSION_WKS401_RELEASE_V_BASE   5

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX20_BETA1    TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX20_BETA1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX20_BETA1_V_MJR    5
#define   TOOLS_VERSION_ESX20_BETA1_V_MNR    0
#define   TOOLS_VERSION_ESX20_BETA1_V_BASE   1

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX20_BETA2    TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX20_BETA2_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX20_BETA2_V_MJR    5
#define   TOOLS_VERSION_ESX20_BETA2_V_MNR    0
#define   TOOLS_VERSION_ESX20_BETA2_V_BASE   2

#ifndef RC_INVOKED
#define   TOOLS_VERSION_VPX_BETA1      TOOLS_VERSION_TO_UINT(TOOLS_VERSION_VPX_BETA1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_VPX_BETA1_V_MJR      5
#define   TOOLS_VERSION_VPX_BETA1_V_MNR      0
#define   TOOLS_VERSION_VPX_BETA1_V_BASE     3

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX20_RELEASE  TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX20_RELEASE_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX20_RELEASE_V_MJR  5
#define   TOOLS_VERSION_ESX20_RELEASE_V_MNR  0
#define   TOOLS_VERSION_ESX20_RELEASE_V_BASE 4

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX20_PATCH1   TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX20_PATCH1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX20_PATCH1_V_MJR   5
#define   TOOLS_VERSION_ESX20_PATCH1_V_MNR   0
#define   TOOLS_VERSION_ESX20_PATCH1_V_BASE  5

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX20_PATCH2   TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX20_PATCH2_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX20_PATCH2_V_MJR   5
#define   TOOLS_VERSION_ESX20_PATCH2_V_MNR   0
#define   TOOLS_VERSION_ESX20_PATCH2_V_BASE  6

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX20_PATCH3   TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX20_PATCH3_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX20_PATCH3_V_MJR   5
#define   TOOLS_VERSION_ESX20_PATCH3_V_MNR   0
#define   TOOLS_VERSION_ESX20_PATCH3_V_BASE  7

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WKS41_BETA1    TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WKS41_BETA1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WKS41_BETA1_V_MJR    5
#define   TOOLS_VERSION_WKS41_BETA1_V_MNR    1
#define   TOOLS_VERSION_WKS41_BETA1_V_BASE   0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX21_RELEASE  TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX21_RELEASE_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX21_RELEASE_V_MJR  5
#define   TOOLS_VERSION_ESX21_RELEASE_V_MNR  1
#define   TOOLS_VERSION_ESX21_RELEASE_V_BASE 1

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX21_PATCH1   TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX21_PATCH1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX21_PATCH1_V_MJR   5
#define   TOOLS_VERSION_ESX21_PATCH1_V_MNR   1
#define   TOOLS_VERSION_ESX21_PATCH1_V_BASE  2

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX21_PATCH2   TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX21_PATCH2_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX21_PATCH2_V_MJR   5
#define   TOOLS_VERSION_ESX21_PATCH2_V_MNR   1
#define   TOOLS_VERSION_ESX21_PATCH2_V_BASE  3

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX21_PATCH3   TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX21_PATCH3_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX21_PATCH3_V_MJR   5
#define   TOOLS_VERSION_ESX21_PATCH3_V_MNR   1
#define   TOOLS_VERSION_ESX21_PATCH3_V_BASE  4

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WKS452_GSX31_B    TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WKS452_GSX31_B_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WKS452_GSX31_B_V_MJR    5
#define   TOOLS_VERSION_WKS452_GSX31_B_V_MNR    2
#define   TOOLS_VERSION_WKS452_GSX31_B_V_BASE   0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_GSX31_REL      TOOLS_VERSION_TO_UINT(TOOLS_VERSION_GSX31_REL_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_GSX31_REL_V_MJR      5
#define   TOOLS_VERSION_GSX31_REL_V_MNR      2
#define   TOOLS_VERSION_GSX31_REL_V_BASE     1

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WKS452_REL     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WKS452_REL_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WKS452_REL_V_MJR     5
#define   TOOLS_VERSION_WKS452_REL_V_MNR     2
#define   TOOLS_VERSION_WKS452_REL_V_BASE    2

#ifndef RC_INVOKED
#define   TOOLS_VERSION_GSX32_BETA     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_GSX32_BETA_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_GSX32_BETA_V_MJR     5
#define   TOOLS_VERSION_GSX32_BETA_V_MNR     2
#define   TOOLS_VERSION_GSX32_BETA_V_BASE    3

#ifndef RC_INVOKED
#define   TOOLS_VERSION_GSX32_RC       TOOLS_VERSION_TO_UINT(TOOLS_VERSION_GSX32_RC_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_GSX32_RC_V_MJR       5
#define   TOOLS_VERSION_GSX32_RC_V_MNR       2
#define   TOOLS_VERSION_GSX32_RC_V_BASE      4

#ifndef RC_INVOKED
#define   TOOLS_VERSION_GSX32_REL      TOOLS_VERSION_TO_UINT(TOOLS_VERSION_GSX32_REL_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_GSX32_REL_V_MJR      5
#define   TOOLS_VERSION_GSX32_REL_V_MNR      2
#define   TOOLS_VERSION_GSX32_REL_V_BASE     5

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WKS50_FF       TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WKS50_FF_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WKS50_FF_V_MJR       6
#define   TOOLS_VERSION_WKS50_FF_V_MNR       0
#define   TOOLS_VERSION_WKS50_FF_V_BASE      0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX25_RELEASE  TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX25_RELEASE_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX25_RELEASE_V_MJR  6
#define   TOOLS_VERSION_ESX25_RELEASE_V_MNR  1
#define   TOOLS_VERSION_ESX25_RELEASE_V_BASE 0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX25_PATCH1   TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX25_PATCH1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX25_PATCH1_V_MJR   6
#define   TOOLS_VERSION_ESX25_PATCH1_V_MNR   1
#define   TOOLS_VERSION_ESX25_PATCH1_V_BASE  1

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ACE_RC2        TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ACE_RC2_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ACE_RC2_V_MJR        6
#define   TOOLS_VERSION_ACE_RC2_V_MNR        2
#define   TOOLS_VERSION_ACE_RC2_V_BASE       0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ACE101_BETA    TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ACE101_BETA_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ACE101_BETA_V_MJR    6
#define   TOOLS_VERSION_ACE101_BETA_V_MNR    2
#define   TOOLS_VERSION_ACE101_BETA_V_BASE   1

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ACE101_REL     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ACE101_REL_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ACE101_REL_V_MJR     6
#define   TOOLS_VERSION_ACE101_REL_V_MNR     2
#define   TOOLS_VERSION_ACE101_REL_V_BASE    2

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS50_BETA2     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS50_BETA2_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS50_BETA2_V_MJR     6
#define   TOOLS_VERSION_WS50_BETA2_V_MNR     3
#define   TOOLS_VERSION_WS50_BETA2_V_BASE    0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS50_RC1       TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS50_RC1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS50_RC1_V_MJR       6
#define   TOOLS_VERSION_WS50_RC1_V_MNR       4
#define   TOOLS_VERSION_WS50_RC1_V_BASE      0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX251_RC1     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX251_RC1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX251_RC1_V_MJR     6
#define   TOOLS_VERSION_ESX251_RC1_V_MNR     5
#define   TOOLS_VERSION_ESX251_RC1_V_BASE    0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX251_PATCH1  TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX251_PATCH1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX251_PATCH1_V_MJR  6
#define   TOOLS_VERSION_ESX251_PATCH1_V_MNR  5
#define   TOOLS_VERSION_ESX251_PATCH1_V_BASE 1

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX252_RC      TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX252_RC_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX252_RC_V_MJR      6
#define   TOOLS_VERSION_ESX252_RC_V_MNR      5
#define   TOOLS_VERSION_ESX252_RC_V_BASE     5

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX252_PATCH1  TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX252_PATCH1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX252_PATCH1_V_MJR  6
#define   TOOLS_VERSION_ESX252_PATCH1_V_MNR  5
#define   TOOLS_VERSION_ESX252_PATCH1_V_BASE 6

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX252_RHELPATCH     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX252_RHELPATCH_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX252_RHELPATCH_V_MJR  6
#define   TOOLS_VERSION_ESX252_RHELPATCH_V_MNR  5
#define   TOOLS_VERSION_ESX252_RHELPATCH_V_BASE 7

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX253_RC      TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX253_RC_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX253_RC_V_MJR      6
#define   TOOLS_VERSION_ESX253_RC_V_MNR      5
#define   TOOLS_VERSION_ESX253_RC_V_BASE     9

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS50_RC2       TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS50_RC2_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS50_RC2_V_MJR       6
#define   TOOLS_VERSION_WS50_RC2_V_MNR       6
#define   TOOLS_VERSION_WS50_RC2_V_BASE      0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS50_RELEASE   TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS50_RELEASE_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS50_RELEASE_V_MJR   6
#define   TOOLS_VERSION_WS50_RELEASE_V_MNR   7
#define   TOOLS_VERSION_WS50_RELEASE_V_BASE  0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS55_BETA1     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS55_BETA1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS55_BETA1_V_MJR     6
#define   TOOLS_VERSION_WS55_BETA1_V_MNR     8
#define   TOOLS_VERSION_WS55_BETA1_V_BASE    0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS55_BETA2     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS55_BETA2_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS55_BETA2_V_MJR     6
#define   TOOLS_VERSION_WS55_BETA2_V_MNR     8
#define   TOOLS_VERSION_WS55_BETA2_V_BASE    1

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS55_RC1       TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS55_RC1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS55_RC1_V_MJR       6
#define   TOOLS_VERSION_WS55_RC1_V_MNR       8
#define   TOOLS_VERSION_WS55_RC1_V_BASE      2

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS55_RC2       TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS55_RC2_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS55_RC2_V_MJR       6
#define   TOOLS_VERSION_WS55_RC2_V_MNR       8
#define   TOOLS_VERSION_WS55_RC2_V_BASE      3

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS55_RELEASE   TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS55_RELEASE_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS55_RELEASE_V_MJR   6
#define   TOOLS_VERSION_WS55_RELEASE_V_MNR   8
#define   TOOLS_VERSION_WS55_RELEASE_V_BASE  4

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS552_BETA1    TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS552_BETA1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS552_BETA1_V_MJR    6
#define   TOOLS_VERSION_WS552_BETA1_V_MNR    9
#define   TOOLS_VERSION_WS552_BETA1_V_BASE   0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_VSERVER_BETA1  TOOLS_VERSION_TO_UINT(TOOLS_VERSION_VSERVER_BETA1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_VSERVER_BETA1_V_MJR  6
#define   TOOLS_VERSION_VSERVER_BETA1_V_MNR  12
#define   TOOLS_VERSION_VSERVER_BETA1_V_BASE 0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_VSERVER_RC1    TOOLS_VERSION_TO_UINT(TOOLS_VERSION_VSERVER_RC1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_VSERVER_RC1_V_MJR    6
#define   TOOLS_VERSION_VSERVER_RC1_V_MNR    12
#define   TOOLS_VERSION_VSERVER_RC1_V_BASE   1

#ifndef RC_INVOKED
#define   TOOLS_VERSION_VSERVER_REL    TOOLS_VERSION_TO_UINT(TOOLS_VERSION_VSERVER_REL_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_VSERVER_REL_V_MJR    6
#define   TOOLS_VERSION_VSERVER_REL_V_MNR    12
#define   TOOLS_VERSION_VSERVER_REL_V_BASE   2

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX30_BETA1    TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX30_BETA1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX30_BETA1_V_MJR    7
#define   TOOLS_VERSION_ESX30_BETA1_V_MNR    0
#define   TOOLS_VERSION_ESX30_BETA1_V_BASE   0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX30_BETA2    TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX30_BETA2_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX30_BETA2_V_MJR    7
#define   TOOLS_VERSION_ESX30_BETA2_V_MNR    0
#define   TOOLS_VERSION_ESX30_BETA2_V_BASE   1

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX30_RC1      TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX30_RC1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX30_RC1_V_MJR      7
#define   TOOLS_VERSION_ESX30_RC1_V_MNR      0
#define   TOOLS_VERSION_ESX30_RC1_V_BASE     2

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX30_RC2      TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX30_RC2_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX30_RC2_V_MJR      7
#define   TOOLS_VERSION_ESX30_RC2_V_MNR      0
#define   TOOLS_VERSION_ESX30_RC2_V_BASE     3

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX30_RELEASE  TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX30_RELEASE_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX30_RELEASE_V_MJR  7
#define   TOOLS_VERSION_ESX30_RELEASE_V_MNR  0
#define   TOOLS_VERSION_ESX30_RELEASE_V_BASE 4

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX301_RC1     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX301_RC1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX301_RC1_V_MJR     7
#define   TOOLS_VERSION_ESX301_RC1_V_MNR     1
#define   TOOLS_VERSION_ESX301_RC1_V_BASE    0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX301_RELEASE    TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX301_RELEASE_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX301_RELEASE_V_MJR    7
#define   TOOLS_VERSION_ESX301_RELEASE_V_MNR    1
#define   TOOLS_VERSION_ESX301_RELEASE_V_BASE   1

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX301_PATCH    TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX301_PATCH_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX301_PATCH_V_MJR    7
#define   TOOLS_VERSION_ESX301_PATCH_V_MNR    1
#define   TOOLS_VERSION_ESX301_PATCH_V_BASE   2

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX302_GA    TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX302_GA_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX302_GA_V_MJR    7
#define   TOOLS_VERSION_ESX302_GA_V_MNR    1
#define   TOOLS_VERSION_ESX302_GA_V_BASE   2

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX303_GA    TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX303_GA_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX303_GA_V_MJR    7
#define   TOOLS_VERSION_ESX303_GA_V_MNR    1
#define   TOOLS_VERSION_ESX303_GA_V_BASE   3

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS60_FF        TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS60_FF_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS60_FF_V_MJR        7
#define   TOOLS_VERSION_WS60_FF_V_MNR        2
#define   TOOLS_VERSION_WS60_FF_V_BASE       0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS60_BETA1     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS60_BETA1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS60_BETA1_V_MJR     7
#define   TOOLS_VERSION_WS60_BETA1_V_MNR     2
#define   TOOLS_VERSION_WS60_BETA1_V_BASE    1

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS60_BETA2     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS60_BETA2_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS60_BETA2_V_MJR     7
#define   TOOLS_VERSION_WS60_BETA2_V_MNR     2
#define   TOOLS_VERSION_WS60_BETA2_V_BASE    2

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS60_BETA3     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS60_BETA3_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS60_BETA3_V_MJR     7
#define   TOOLS_VERSION_WS60_BETA3_V_MNR     2
#define   TOOLS_VERSION_WS60_BETA3_V_BASE    3

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS60_RC1     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS60_RC1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS60_RC1_V_MJR     7
#define   TOOLS_VERSION_WS60_RC1_V_MNR     2
#define   TOOLS_VERSION_WS60_RC1_V_BASE    4

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS60_RC2     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS60_RC2_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS60_RC2_V_MJR     7
#define   TOOLS_VERSION_WS60_RC2_V_MNR     2
#define   TOOLS_VERSION_WS60_RC2_V_BASE    5

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS60_RELEASE      TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS60_RELEASE_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS60_RELEASE_V_MJR     7
#define   TOOLS_VERSION_WS60_RELEASE_V_MNR     2
#define   TOOLS_VERSION_WS60_RELEASE_V_BASE    6

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS601_BETA1      TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS601_BETA1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS601_BETA1_V_MJR     7
#define   TOOLS_VERSION_WS601_BETA1_V_MNR     2
#define   TOOLS_VERSION_WS601_BETA1_V_BASE    7

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS601_RELEASE      TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS601_RELEASE_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS601_RELEASE_V_MJR     7
#define   TOOLS_VERSION_WS601_RELEASE_V_MNR     2
#define   TOOLS_VERSION_WS601_RELEASE_V_BASE    8

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS603_RELEASE      TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS603_RELEASE_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS603_RELEASE_V_MJR     7
#define   TOOLS_VERSION_WS603_RELEASE_V_MNR     2
#define   TOOLS_VERSION_WS603_RELEASE_V_BASE    9

#ifndef RC_INVOKED
#define   TOOLS_VERSION_FUSION10_BETA4     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_FUSION10_BETA4_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_FUSION10_BETA4_V_MJR     7
#define   TOOLS_VERSION_FUSION10_BETA4_V_MNR     3
#define   TOOLS_VERSION_FUSION10_BETA4_V_BASE    0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_FUSION10_RC1     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_FUSION10_RC1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_FUSION10_RC1_V_MJR     7
#define   TOOLS_VERSION_FUSION10_RC1_V_MNR     3
#define   TOOLS_VERSION_FUSION10_RC1_V_BASE    1

#ifndef RC_INVOKED
#define   TOOLS_VERSION_FUSION10_RELEASE     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_FUSION10_RELEASE_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_FUSION10_RELEASE_V_MJR     7
#define   TOOLS_VERSION_FUSION10_RELEASE_V_MNR     3
#define   TOOLS_VERSION_FUSION10_RELEASE_V_BASE    2

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX310_BETA1     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX310_BETA1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX310_BETA1_V_MJR     7
#define   TOOLS_VERSION_ESX310_BETA1_V_MNR     4
#define   TOOLS_VERSION_ESX310_BETA1_V_BASE    0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX310_BETA2     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX310_BETA2_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX310_BETA2_V_MJR     7
#define   TOOLS_VERSION_ESX310_BETA2_V_MNR     4
#define   TOOLS_VERSION_ESX310_BETA2_V_BASE    1

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX310_RC1     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX310_RC1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX310_RC1_V_MJR     7
#define   TOOLS_VERSION_ESX310_RC1_V_MNR     4
#define   TOOLS_VERSION_ESX310_RC1_V_BASE    2

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX310_RELEASE     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX310_RELEASE_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX310_RELEASE_V_MJR     7
#define   TOOLS_VERSION_ESX310_RELEASE_V_MNR     4
#define   TOOLS_VERSION_ESX310_RELEASE_V_BASE    3

#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX310_UPDATE1    TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX310_UPDATE1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX310_UPDATE1_V_MJR     7
#define   TOOLS_VERSION_ESX310_UPDATE1_V_MNR     4
#define   TOOLS_VERSION_ESX310_UPDATE1_V_BASE    4

#ifndef RC_INVOKED
#define   TOOLS_VERSION_SERVER20_FF     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_SERVER20_FF_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_SERVER20_FF_V_MJR     7
#define   TOOLS_VERSION_SERVER20_FF_V_MNR     5
#define   TOOLS_VERSION_SERVER20_FF_V_BASE    0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_FUSION11_BETA1     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_FUSION11_BETA1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_FUSION11_BETA1_V_MJR     7
#define   TOOLS_VERSION_FUSION11_BETA1_V_MNR     6
#define   TOOLS_VERSION_FUSION11_BETA1_V_BASE    0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_FUSION11_RC1     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_FUSION11_RC1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_FUSION11_RC1_V_MJR     7
#define   TOOLS_VERSION_FUSION11_RC1_V_MNR     6
#define   TOOLS_VERSION_FUSION11_RC1_V_BASE    1

#ifndef RC_INVOKED
#define   TOOLS_VERSION_FUSION11_RELEASE     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_FUSION11_RELEASE_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_FUSION11_RELEASE_V_MJR     7
#define   TOOLS_VERSION_FUSION11_RELEASE_V_MNR     6
#define   TOOLS_VERSION_FUSION11_RELEASE_V_BASE    2

#ifndef RC_INVOKED
#define   TOOLS_VERSION_SERVER20_BETA1     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_SERVER20_BETA1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_SERVER20_BETA1_V_MJR     7
#define   TOOLS_VERSION_SERVER20_BETA1_V_MNR     7
#define   TOOLS_VERSION_SERVER20_BETA1_V_BASE    0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_SERVER20_BETA2     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_SERVER20_BETA2_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_SERVER20_BETA2_V_MJR     7
#define   TOOLS_VERSION_SERVER20_BETA2_V_MNR     7
#define   TOOLS_VERSION_SERVER20_BETA2_V_BASE    1

#ifndef RC_INVOKED
#define   TOOLS_VERSION_SERVER20_RC1       TOOLS_VERSION_TO_UINT(TOOLS_VERSION_SERVER20_RC1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_SERVER20_RC1_V_MJR     7
#define   TOOLS_VERSION_SERVER20_RC1_V_MNR     7
#define   TOOLS_VERSION_SERVER20_RC1_V_BASE    2

#ifndef RC_INVOKED
#define   TOOLS_VERSION_SERVER20_RC2       TOOLS_VERSION_TO_UINT(TOOLS_VERSION_SERVER20_RC2_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_SERVER20_RC2_V_MJR     7
#define   TOOLS_VERSION_SERVER20_RC2_V_MNR     7
#define   TOOLS_VERSION_SERVER20_RC2_V_BASE    3

#ifndef RC_INVOKED
#define   TOOLS_VERSION_SERVER20_RELEASE       TOOLS_VERSION_TO_UINT(TOOLS_VERSION_SERVER20_RELEASE_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_SERVER20_RELEASE_V_MJR     7
#define   TOOLS_VERSION_SERVER20_RELEASE_V_MNR     7
#define   TOOLS_VERSION_SERVER20_RELEASE_V_BASE    4


/*
 * XXX: Chromium (WS 6.5) releases should have 7.8.x numbers.
 * We still haven't used that range (beta 1 was released with 7.7.1).
 */

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS65_BETA1     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS65_BETA1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS65_BETA1_V_MJR     7
#define   TOOLS_VERSION_WS65_BETA1_V_MNR     8
#define   TOOLS_VERSION_WS65_BETA1_V_BASE    0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS65_BETA2     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS65_BETA2_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS65_BETA2_V_MJR     7
#define   TOOLS_VERSION_WS65_BETA2_V_MNR     8
#define   TOOLS_VERSION_WS65_BETA2_V_BASE    1

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS65_RC1     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS65_RC1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS65_RC1_V_MJR     7
#define   TOOLS_VERSION_WS65_RC1_V_MNR     8
#define   TOOLS_VERSION_WS65_RC1_V_BASE    2

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS65_RELEASE     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS65_RELEASE_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS65_RELEASE_V_MJR     7
#define   TOOLS_VERSION_WS65_RELEASE_V_MNR     8
#define   TOOLS_VERSION_WS65_RELEASE_V_BASE    3

#ifndef RC_INVOKED
#define   TOOLS_VERSION_WS65_UPDATE1     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_WS65_UPDATE1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_WS65_UPDATE1_V_MJR     7
#define   TOOLS_VERSION_WS65_UPDATE1_V_MNR     8
#define   TOOLS_VERSION_WS65_UPDATE1_V_BASE    4

#ifndef RC_INVOKED
#define   TOOLS_VERSION_FUSION15_BETA1     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_FUSION15_BETA1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_FUSION15_BETA1_V_MJR     7
#define   TOOLS_VERSION_FUSION15_BETA1_V_MNR     9
#define   TOOLS_VERSION_FUSION15_BETA1_V_BASE    0

#ifndef RC_INVOKED
#define   TOOLS_VERSION_FUSION15_BETA2     TOOLS_VERSION_TO_UINT(TOOLS_VERSION_FUSION15_BETA2_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_FUSION15_BETA2_V_MJR     7
#define   TOOLS_VERSION_FUSION15_BETA2_V_MNR     9
#define   TOOLS_VERSION_FUSION15_BETA2_V_BASE    1

#ifndef RC_INVOKED
#define   TOOLS_VERSION_FUSION15_RC1    TOOLS_VERSION_TO_UINT(TOOLS_VERSION_FUSION15_RC1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_FUSION15_RC1_V_MJR      7
#define   TOOLS_VERSION_FUSION15_RC1_V_MNR      9
#define   TOOLS_VERSION_FUSION15_RC1_V_BASE     2

#ifndef RC_INVOKED
#define   TOOLS_VERSION_FUSION15_RELEASE    TOOLS_VERSION_TO_UINT(TOOLS_VERSION_FUSION15_RELEASE_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_FUSION15_RELEASE_V_MJR      7
#define   TOOLS_VERSION_FUSION15_RELEASE_V_MNR      9
#define   TOOLS_VERSION_FUSION15_RELEASE_V_BASE     3

#ifndef RC_INVOKED
#define   TOOLS_VERSION_FUSION15_UPDATE1    TOOLS_VERSION_TO_UINT(TOOLS_VERSION_FUSION15_UPDATE1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_FUSION15_UPDATE1_V_MJR      7
#define   TOOLS_VERSION_FUSION15_UPDATE1_V_MNR      9
#define   TOOLS_VERSION_FUSION15_UPDATE1_V_BASE     4

/*
 * At the request of CPD, ESX 4.0 receives its own major version (8.0.0).
 */
#ifndef RC_INVOKED
#define   TOOLS_VERSION_ESX40_RC1      TOOLS_VERSION_TO_UINT(TOOLS_VERSION_ESX40_RC1_V)
#endif /* RC_INVOKED */
#define   TOOLS_VERSION_ESX40_RC1_V_MJR      8
#define   TOOLS_VERSION_ESX40_RC1_V_MNR      0
#define   TOOLS_VERSION_ESX40_RC1_V_BASE     0

#define   TOOLS_VERSION_CURRENT        TOOLS_VERSION_ESX40_RC1
#define   TOOLS_VERSION_CURRENT_STR    TOOLS_VERSION_TO_STR(TOOLS_VERSION_ESX40_RC1)
#define   TOOLS_VERSION_CURRENT_CSV    TOOLS_VERSION_TO_CSV(TOOLS_VERSION_ESX40_RC1)


/*
 * The extended Tools version is the current Tools version with the
 * build number appended. Useful until the PRODUCT_VERSION
 * vs. PRODUCT_VERSION_STRING mess in vm_version.h is sorted out.
 *
 * For Windows tools, the fourth component of the version number must
 * be < 65k (circa), so we use PRODUCT_BUILD_NUMBER instead of
 * BUILD_NUMBER.
 */

#define TOOLS_VERSION_EXT_CURRENT_CSV \
   TOOLS_VERSION_CURRENT_CSV,PRODUCT_BUILD_NUMBER_NUMERIC
#define TOOLS_VERSION_EXT_CURRENT_STR \
   TOOLS_VERSION_CURRENT_STR "." PRODUCT_BUILD_NUMBER_NUMERIC_STRING

#endif /* VM_TOOLS_VERSION_H */
