/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.xslt.model.impl;

import org.netbeans.modules.xslt.model.AttributeValueTemplate;
import org.netbeans.modules.xslt.model.Sort;
import org.netbeans.modules.xslt.model.XslComponent;
import org.netbeans.modules.xslt.model.XslVisitor;
import org.netbeans.modules.xslt.model.enums.TBoolean;
import org.w3c.dom.Element;


/**
 * @author ads
 *
 */
class SortImpl extends SequenceElementConstructorImpl implements Sort {

    SortImpl( XslModelImpl model, Element element ) {
        super( model , element );
    }
    
    SortImpl( XslModelImpl model ) {
        super( model , XslElements.SORT );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.impl.XslComponentImpl#accept(org.netbeans.modules.xslt.model.XslVisitor)
     */
    @Override
    public void accept( XslVisitor visitor )
    {
        visitor.visit( this );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.impl.XslComponentImpl#getComponentType()
     */
    @Override
    public Class<? extends XslComponent> getComponentType()
    {
        return Sort.class;
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.CollationSpec#getCollation()
     */
    public String getCollation() {
        return getAttribute( XslAttributes.COLLATION );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.CollationSpec#setCollation(java.lang.String)
     */
    public void setCollation( String value ) {
        setAttribute( XslAttributes.COLLATION, value );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.LangSpec#getLang()
     */
    public AttributeValueTemplate getLang() {
        return AttributeValueTemplateImpl.creatAttributeValueTemplate( this, 
                XslAttributes.LANG );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.LangSpec#setLang(org.netbeans.modules.xslt.model.AttributeValueTemplate)
     */
    public void setLang( AttributeValueTemplate avt ) {
        setAttribute( XslAttributes.LANG, avt);
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.Sort#getCaseOrder()
     */
    public AttributeValueTemplate getCaseOrder() {
        return AttributeValueTemplateImpl.creatAttributeValueTemplate( this , 
                XslAttributes.CASE_ORDER );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.Sort#getDataType()
     */
    public AttributeValueTemplate getDataType() {
        return AttributeValueTemplateImpl.creatAttributeValueTemplate( this , 
                XslAttributes.DATA_TYPE );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.Sort#getOrder()
     */
    public AttributeValueTemplate getOrder() {
        return AttributeValueTemplateImpl.creatAttributeValueTemplate( this , 
                XslAttributes.ORDER );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.Sort#getStable()
     */
    public TBoolean getStable() {
        return TBoolean.forString( getAttribute(XslAttributes.STABLE ));
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.Sort#setCaseOrder(org.netbeans.modules.xslt.model.AttributeValueTemplate)
     */
    public void setCaseOrder( AttributeValueTemplate value ) {
        setAttribute( XslAttributes.CASE_ORDER, value);
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.Sort#setDataType(org.netbeans.modules.xslt.model.AttributeValueTemplate)
     */
    public void setDataType( AttributeValueTemplate value ) {
        setAttribute( XslAttributes.DATA_TYPE, value);
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.Sort#setOrder(org.netbeans.modules.xslt.model.AttributeValueTemplate)
     */
    public void setOrder( AttributeValueTemplate value ) {
        setAttribute( XslAttributes.ORDER, value);
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.Sort#setStable(org.netbeans.modules.xslt.model.enums.TBoolean)
     */
    public void setStable( TBoolean value ) {
        setAttribute( XslAttributes.STABLE, value);
    }
    
}
