/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.xslt.model;


/**
 * <pre>
 * &lt;xs:element name="decimal-format" substitutionGroup="xsl:declaration">
 *      &lt;xs:complexType>
 *          &lt;xs:complexContent>
 *              &lt;xs:extension base="xsl:element-only-versioned-element-type">
 *                  &lt;xs:attribute name="name" type="xsl:QName"/>
 *                  &lt;xs:attribute name="decimal-separator" type="xsl:char" default="."/>
 *                  &lt;xs:attribute name="grouping-separator" type="xsl:char" default=","/>
 *                  &lt;xs:attribute name="infinity" type="xs:string" default="Infinity"/>
 *                  &lt;xs:attribute name="minus-sign" type="xsl:char" default="-"/>
 *                  &lt;xs:attribute name="NaN" type="xs:string" default="NaN"/>
 *                  &lt;xs:attribute name="percent" type="xsl:char" default="%"/>
 *                  &lt;xs:attribute name="per-mille" type="xsl:char" default="&#x2030;"/>
 *                  &lt;xs:attribute name="zero-digit" type="xsl:char" default="0"/>
 *                  &lt;xs:attribute name="digit" type="xsl:char" default="#"/>
 *                  &lt;xs:attribute name="pattern-separator" type="xsl:char" default=";"/>
 *              &lt;/xs:extension>
 *          &lt;/xs:complexContent>
 *      &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 * @author ads
 *
 */
public interface DecimalFormat extends Declaration, QualifiedNameable {
    
    String DECIMAL_SEPARATOR = "decimal-separator";     // NOI18N
    
    String INFINITY = "infinity";                       // NOI18N
    
    String MINUS_SIGN = "minus-sign";                   // NOI18N
    
    String NAN = "NaN";                                 // NOI18N
    
    String PERCENT = "percent";                         // NOI18N
    
    String ZERO_DIGIT = "zero-digit";                   // NOI18N
    
    String PER_MILLE = "per-mille";                     // NOI18N
    
    String DIGIT = "digit";                             // NOI18N
    
    String PATTERN_SEPARATOR = "pattern-separator";     // NOI18N
    
    String GROUPING_SEPARATOR = "grouping-separator";   // NOI18N
    
    /**
     * @return "infinity" attribute value
     */
    String getInfinity();
    
    /**
     * Set "infinity" attribute value.
     * @param value new value
     */
    void setInfinity( String value );
    
    /**
     * @return "NaN" attribute value
     */
    String getNaN();
    
    /**
     * Set "NaN" attribute value.
     * @param nan new value
     */
    void setNaN( String nan );

}
