/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.visualweb.websvcmgr.actions;

import org.netbeans.modules.visualweb.api.designerapi.DesignerServiceHack;
import java.awt.datatransfer.Transferable;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.netbeans.modules.visualweb.websvcmgr.util.Util;
import org.netbeans.modules.websvc.manager.model.WebServiceData;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

/**
 * The action invoked when the user clicks on "Add to Page"
 * menu item on a method node
 */
public class AddDataProviderToFormAction extends NodeAction {
    
   protected boolean enable(Node[] activatedNodes) {
       /*
       if( activatedNodes != null && activatedNodes.length > 0 ) {
           Node node = null;
           if(activatedNodes[0] instanceof FilterNode){
               node = activatedNodes[0].getCookie(WebServiceMethodNode.class);
           }else{
               node = activatedNodes[0];
           }
           if (node instanceof WebServiceMethodNode ) {
               return ((WebServiceMethodNode)node).isMethodDroppable() && DesignerServiceHack.getDefault().canDrop(null);
           }
       }
       return DesignerServiceHack.getDefault().canDrop(null);
       */
       return true;
    }

    public org.openide.util.HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
        // If you will provide context help then use:
        // return new AddToFormAction.class);
    }

    protected String iconResource() {
        return "org/netbeans/modules/visualweb/websvcmgr/resources/MyActionIcon.gif";
    }

    public String getName() {
        return NbBundle.getMessage(AddToFormAction.class, "Add_to_Form");
    }

    protected void performAction(Node[] activatedNodes) {
        if( activatedNodes != null && activatedNodes.length > 0 ) {
            for( int i = 0; i < activatedNodes.length; i ++ ) {
                try {
                    boolean isJavaEE5 = JsfProjectUtils.isJavaEE5Project(Util.getActiveProject());
                    WebServiceData wsData = activatedNodes[i].getLookup().lookup(WebServiceData.class);
                    
                    if ( (isJavaEE5 && wsData != null && wsData.isJaxWsEnabled()) ||
                         (!isJavaEE5 && wsData != null && wsData.isJaxRpcEnabled())) {
                        Transferable transferable = activatedNodes[i].clipboardCopy();
                        if (transferable != null) {
                            DesignerServiceHack.getDefault().drop(transferable);
                        }
                    }
                }catch (java.io.IOException ex) {
                }
            }
        }
    }

    /** @return <code>false</code> to be performed in event dispatch thread */
    protected boolean asynchronous() {
        return false;
    }
}
