/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.visualweb.designer.jsf;


/**
 * <p>
 * Handle grid positioning manipulations: updating left/right/top/bottom
 * properties on the elements via CSS to effecting resizing, moving
 * a set of components, etc.
 * <p>
 *
 * @author Tor Norbye
 * @todo Fix grid snapping when working with nested grid areas (e.g.
 *  one grid positioning panel within another)
 * @todo Fix issue where a component being dropped has margins: I need to
 *  be able to compute the margins for the rendered HTML. The problem
 *  is that when setInitialPosition is called, I haven't yet rendered the component
 *  so I don't have access to en HTML element to look up margins for. I
 *  could call into FacesSupport to render it, but unless I can share this
 *  with the DomSynchronizer that's possibly a big performance overhead on
 *  component drop (especially for large components like table).
 * @todo Get rid of suspend updates etc. now that I'm batching CSS anyway
 */
public class GridHandler /*implements PropertyChangeListener, PreferenceChangeListener, DomProvider.CoordinateTranslator*/ {
    /** Singleton instance */
//    private static GridHandler instance;
//    private final DesignerSettings setting = DesignerSettings.getInstance();
//    private final WebForm webForm;

    private static final GridHandler INSTANCE = new GridHandler();
    
    private int gridTraceWidth;
    private int gridTraceHeight;
    private int gridWidth;
    private int gridHeight;
    private int gridOffset = 0;
    private boolean grid = true;
    private boolean snap = true; // XXX what should the default be?

    /** Creates new GridHandler instance. */
    private /*public*/ GridHandler(/*WebForm webForm*/) {
//        if (webForm == null) {
//            throw new NullPointerException("WebForm parameter is null!"); // NOI18N
//        }
//
//        this.webForm = webForm;

//        DesignerSettings setting = DesignerSettings.getInstance();
//
////        setting.addPropertyChangeListener(WeakListeners.propertyChange(this, setting));
//        setting.addWeakPreferenceChangeListener(this);

        JsfDesignerPreferences preferences = JsfDesignerPreferences.getInstance();
        setGrid(preferences.getGridShow());
        setSnap(preferences.getGridSnap());
        setGridWidth(preferences.getGridWidth());
        setGridHeight(preferences.getGridHeight());
    }
    
    public static GridHandler getDefault() {
        return INSTANCE;
    }

//    /** Listener for the options panel */
////    public void propertyChange(PropertyChangeEvent evt) {
//    public void preferenceChange(PreferenceChangeEvent evt) {
////        String name = evt.getPropertyName();
//        String name = evt.getKey();
//
//        if (name == null) {
//            return;
//        }
//
//        // XXX Get rid of these duplicatations.
//        if (name.equals(DesignerSettings.PROP_GRID_SHOW)) {
////            setGrid(((Boolean)evt.getNewValue()).booleanValue());
//            setGrid(DesignerSettings.getInstance().getGridShow());
//        } else if (name.equals(DesignerSettings.PROP_GRID_SNAP)) {
////            setSnap(((Boolean)evt.getNewValue()).booleanValue());
//            setSnap(DesignerSettings.getInstance().getGridSnap());
//        } else if (name.equals(DesignerSettings.PROP_GRID_WIDTH)) {
////            setGridWidth(((Integer)evt.getNewValue()).intValue());
//            setGridWidth(DesignerSettings.getInstance().getGridWidth());
//        } else if (name.equals(DesignerSettings.PROP_GRID_HEIGHT)) {
////            setGridHeight(((Integer)evt.getNewValue()).intValue());
//            setGridHeight(DesignerSettings.getInstance().getGridHeight());
//        }
//    }

//    /** Return default instance of the GridHandler.
//     * @return The instance of the GridHandler
//     */
//    public static GridHandler getInstance() {
//        if (instance == null) {
//            instance = new GridHandler();
//        }
//
//        return instance;
//    }

    /** Return true iff grid is visible */
//    public boolean grid() {
    public boolean isGrid() {
        return grid;
    }

    /** Set whether or not grid is visible */
    public /*private*/ void setGrid(boolean grid) {
        this.grid = grid;
    }

    /** Return true iff components should be snapped to the grid */
//    public boolean snap() {
    public boolean isSnap() {
        return snap;
    }

    /** Set whether or not components should be snapped to the grid */
    public /*private*/ void setSnap(boolean snap) {
        this.snap = snap;
    }

    /** Return the width of the grid (e.g. width of each grid square)
     */
    public int getGridWidth() {
        return gridWidth;
    }

    /** Set the width of the grid (e.g. width of each grid square)
     */
    public /*private*/ void setGridWidth(int gridWidth) {
        int i;
        int nt;

        this.gridWidth = gridWidth;

        gridTraceWidth = gridWidth;

        for (i = 2; (nt = gridWidth / i) >= 8; i++) {
            gridTraceWidth = nt;
        }
    }

    /** Return the height of the grid (e.g. height of each grid square)
     */
    public int getGridHeight() {
        return gridHeight;
    }

    /** Set the height of the grid (e.g. height of each grid square)
     */
    public /*private*/ void setGridHeight(int gridHeight) {
        int i;
        int nt;

        this.gridHeight = gridHeight;

        gridTraceHeight = gridHeight;

        for (i = 2; (nt = gridHeight / i) >= 8; i++) {
            gridTraceHeight = nt;
        }
    }

    /** Return the size of the grid trace interval (these will always
     * be smaller than the gridsize; the grid is drawn using smaller
     * trace dots along the lines; the interval between each trace
     * is what this number represents.  The gridsize will always
     * be a multiple of the grid trace size.
     */
    public int getGridTraceWidth() {
        return gridTraceWidth;
    }

//    /** Set the size of the grid trace interval (these will always
//     * be smaller than the gridsize; the grid is drawn using smaller
//     * trace dots along the lines; the interval between each trace
//     * is what this number represents.  The gridsize will always
//     * be a multiple of the grid trace size.
//     */
//    public void setGridTraceWidth(int gridTraceWidth) {
//        this.gridTraceWidth = gridTraceWidth;
//    }

    /** Return the size of the grid trace interval (these will always
     * be smaller than the gridsize; the grid is drawn using smaller
     * trace dots along the lines; the interval between each trace
     * is what this number represents.  The gridsize will always
     * be a multiple of the grid trace size.
     */
    public int getGridTraceHeight() {
        return gridTraceHeight;
    }

//    /** Set the size of the grid trace interval (these will always
//     * be smaller than the gridsize; the grid is drawn using smaller
//     * trace dots along the lines; the interval between each trace
//     * is what this number represents.  The gridsize will always
//     * be a multiple of the grid trace size.
//     */
//    public void setGridTraceHeight(int gridTraceHeight) {
//        this.gridTraceHeight = gridTraceHeight;
//    }

    /** Return the "offset" of the grid - e.g. how far from (0,0) the top
     * left grid corner should be. */
    public int getGridOffset() {
        return gridOffset;
    }

//    /** Set the "offset" of the grid - e.g. how far from (0,0) the top
//     * left grid corner should be. */
//    public void setGridOffset(int gridOffset) {
//        this.gridOffset = gridOffset;
//    }

//    /** Snap the given X position. If snap to grid is turned off, it simply
//     * returns the original position.
//     * @param x The horizontal position to be snapped to the grid
//     * @param parent A positioning parent to snap to, or null to use
//     *   the default viewport (0,0)
//     * @todo Handle case where the x coordinate is less than the parent box left.
//     *   This can happen when the user drags the component outside the grid area.
//     */
////    public int snapX(int x, CssBox parent) {
//    public int snapX(int x, Box parent) {
//        return doSnapX(x, parent == null ? 0 : parent.getAbsoluteX(), snap, gridWidth, gridOffset);
//    }
//    
//    public int snapX(int x) {
//        return snapX(x, null);
//    }
//    
//    private static int doSnapX(int x, int absX, boolean snap, int gridWidth, int gridOffset) {
////        int root = 0; // X coordinate of positioning parent
//
////        if (parent != null) {
////            root = parent.getAbsoluteX();
////            x -= root;
////        }
//        // X coordinate of positioning parent
//        int root = absX;
//        x -= root;
//
//        if (snap) {
//            x = (((x + gridOffset + (gridWidth / 2)) / gridWidth) * gridWidth) - gridOffset;
//        }
//
//        x += root;
//
//        return x;
//    }
//
//    /** Snap the given Y position. If snap to grid is turned off, it simply
//     * returns the original position.
//     * @param y The vertical position to be snapped to the grid
//     * @param parent A positioning parent to snap to, or null to use
//     *   the default viewport (0,0)
//     * @todo Handle case where the y coordinate is less than the parent box top.
//     *   This can happen when the user drags the component above the grid area.
//     */
////    public int snapY(int y, CssBox parent) {
//    public int snapY(int y, Box parent) {
//        return doSnapY(y, parent == null ? 0 : parent.getAbsoluteY(), snap, gridHeight, gridOffset);
//    }
//    
//    public int snapY(int y) {
//        return snapY(y, null);
//    }
//    
//    private static int doSnapY(int y, int absY, boolean snap, int gridHeight, int gridOffset) {
////        int root = 0; // Y coordinate of positioning parent
//
////        if (parent != null) {
////            root = parent.getAbsoluteY();
////            y -= root;
////        }
//        // Y coordinate of positioning parent
//        int root = absY;
//        y -= root;
//
//        if (snap) {
//            y = (((y + gridOffset + (gridHeight / 2)) / gridHeight) * gridHeight) - gridOffset;
//        }
//
//        y += root;
//
//        return y;
//    }

//    /** Adjust the given mouse X position to account for insets in parent
//     * components etc., such that the resulting position matches the canvas
//     * pixel in the view the mouse is over.
//     */
//    public int adjustX(int x) {
//        x += DesignerPane.getAdjustX();
//
//        return x;
//    }
//
//    /** Adjust the given mouse X position to account for insets in parent
//     * components etc., such that the resulting position matches the canvas
//     * pixel in the view the mouse is over.
//     */
//    public int adjustY(int y) {
//        y += DesignerPane.getAdjustY();
//
//        return y;
//    }

    // CSS2 support code

//    /** Drag a set of components from to a new position - either a grid position (newX,newY),
//     *  or a document flow position (pos). If pos is Position.NONE, use CSS grid positioning.
//     * <p>
//     * @param editor The DesignerPane where the drag operation is being performed
//     * @param beans A list of beans that should be moved
//     * @param offsetRectangles A list of positions corresponding to the beans, relative to
//     *       the mouse pointer position (newX, newY). These specify the border box extends
//     *       of the elements being repositioned.
//     * @param boxes A list of boxes corresponding to the beans being moved
//     * @param pos A target caret position where the beans should be moved (which means
//     *       to ignore the newX,newY point) or Position.NONE.
//     * @param newX The new X location of the mouse pointer. All the beans should be
//     *       repositioned such that their offsetRectangles are relative to this point.
//     * @param newY The new Y location of the mouse pointer. All the beans should be
//     *       repositioned such that their offsetRectangles are relative to this point.
//     * @param snapDisabled If true, disable any snap-to-grid mode that may be in effect
//     * <p>
//     * @todo Should I use floating point coordinates instead?
//     */
//    public void move(final DesignerPane editor, /*List<MarkupDesignBean> beans,*/
////        List<CssBox> boxes, Position pos, int newX, int newY, boolean snapDisabled) {
//     Point[] offsetPoints, CssBox[] boxes, DomPosition pos, int newX, int newY, boolean snapDisabled) {
//        
////        // XXX First process the snapping.
////        for (int i = 0; i < offsetPoints.length; i++) {
////            Point offset = offsetPoints[i];
////            CssBox box = boxes[i];
////            int x = newX + offset.x;
////            int y = newY + offset.y;
////
////            if (!snapDisabled) {
////                x = snapX(x, box.getPositionedBy());
////                y = snapY(y, box.getPositionedBy());
////            }
////            offsetPoints[i] = new Point(x, y);
////        }
//        
//        webForm.getDomDocument().moveComponents(webForm, boxes, offsetPoints, pos, newX, newY, !snapDisabled);
//        
////        // Locate a grid layout parent
//////        Document doc = editor.getDocument();
//////        WebForm webform = doc.getWebForm();
////        WebForm webform = editor.getWebForm();
////        
//////        int numMoved = beans.size();
//////        int numMoved = boxes.size();
////        int numMoved = boxes.length;
////        
//////        Rectangle boundingBox = null;
////
////        String description;
////        if (numMoved > 1) {
////            description = NbBundle.getMessage(GridHandler.class, "MoveComponents");
////        } else {
////            description = NbBundle.getMessage(GridHandler.class, "MoveComponent");
////        }
//////        UndoEvent undoEvent = webform.getModel().writeLock(description);
////        DomProvider.WriteLock writeLock = webform.writeLock(description);
////        try {
//////            String description;
//////
//////            if (numMoved > 1) {
//////                description = NbBundle.getMessage(GridHandler.class, "MoveComponents");
//////            } else {
//////                description = NbBundle.getMessage(GridHandler.class, "MoveComponent");
//////            }
//////
//////            doc.writeLock(description);
////
////            // Move the components
////            for (int i = 0; i < numMoved; i++) {
//////                MarkupDesignBean bean = beans.get(i);
//////                Rectangle offset = offsetRectangles.get(i);
//////                CssBox box = boxes.get(i);
////                CssBox box = boxes[i];
//////                Rectangle offset = offsetRectangles[i];
////                Point offset = offsetPoints[i];
////                
////                Element componentRootElement = CssBox.getElementForComponentRootCssBox(box);
//////                Element e = box.getElement();
//////
//////                if (e == null) {
//////                    e = bean.getElement();
//////                }
////
//////                int x = newX + offset.x;
//////                int y = newY + offset.y;
//////
//////                if (!snapDisabled) {
//////                    x = snapX(x, box.getPositionedBy());
//////                    y = snapY(y, box.getPositionedBy());
//////                }
////                
////                int x = offset.x;
////                int y = offset.y;
////
////                CssBox parentBox = box.getParent();
////
//////                if (boundingBox == null) {
//////                    boundingBox = new Rectangle(x, y, box.getWidth(), box.getHeight());
//////                } else {
//////                    boundingBox.add(x, y);
//////                    boundingBox.add(x + box.getWidth(), y + box.getHeight());
//////                }
////
////                try {
////                    boolean moveSucceeded = true;
////
//////                    if ((pos != null) && (pos != Position.NONE)) {
////                    if ((pos != null) && (pos != DomPosition.NONE)) {
////                        // TODO: better batch handling here
//////                        moveSucceeded = doc.reparent(bean, e, pos);
//////                        moveSucceeded = reparentComponent(componentRootElement, /*e,*/ pos, webform);
////                        moveSucceeded = webForm.getDomDocument().reparentComponent(componentRootElement, /*e,*/ pos);
////                    } else if (!isAbsolutelyPositioned(componentRootElement)) {
////                        // Looks like we've moved a flow position element
////                        // out to grid
//////                        CssBox pb = null;
////                        Element parent = null;
//////                        Element element = box.getDesignBean().getElement();
////                        // XXX Possible NPE?
//////                        Element element = CssBox.getMarkupDesignBeanForCssBox(box).getElement();
////                        Element boxComponentRootElement = CssBox.getElementForComponentRootCssBox(box);
////                        // XXX Get rid of using source elements in the designer.
////                        Element element = MarkupService.getSourceElementForElement(boxComponentRootElement);
////
////                        if ((element.getParentNode() != null) &&
////                                (element.getParentNode().getNodeType() == org.w3c.dom.Node.ELEMENT_NODE) &&
////                                element.getParentNode().getNodeName().equals(HtmlTag.FSUBVIEW.name)) {
//////                            pb = parentBox;
////                            parent = (Element)element.getParentNode();
//////                        } else if ((parentBox != null) && (parentBox.getDesignBean() != null)) {
//////                            MarkupDesignBean parentBean = parentBox.getDesignBean();
////                        } else {
//////                            MarkupDesignBean parentMarkupDesignBean = CssBox.getMarkupDesignBeanForCssBox(parentBox);
////                            Element parentComponentRootElement = CssBox.getElementForComponentRootCssBox(parentBox);
////                            if (parentComponentRootElement != null) {
////                                Element parentElement = MarkupService.getSourceElementForElement(parentComponentRootElement);
////
////                                if ((parentElement != null) &&
////                                        (parentElement.getTagName().equals(HtmlTag.FORM.name))) {
//////                                    pb = parentBox;
////                                    parent = parentBox.getSourceElement();
////                                }
////                            }
////                        }
////
//////                        if (pb == null) {
////                        if (parent == null) {
//////                            CssBox currentBox = webform.getMapper().findBox(x, y);
////                            CssBox currentBox = ModelViewMapper.findBox(webform.getPane().getPageBox(), x, y);
////
////                            for (int j = 0, m = currentBox.getBoxCount(); j < m; j++) {
////                                HtmlTag tag = currentBox.getBox(j).getTag();
////
////                                if (tag == HtmlTag.FORM) {
//////                                    pb = currentBox.getBox(j);
////                                    parent = currentBox.getSourceElement();
////
////                                    break;
////                                }
////                            }
////
//////                            if (pb == null) {
//////                                pb = currentBox;
//////                            }
////                            if (parent == null) {
////                                parent = currentBox.getSourceElement();
////                            }
////                        }
////
//////                        if (parent == null) {
//////                            parent = pb.getSourceElement();
//////                        }
////
////                        if (element.getParentNode() != parent) {
////                            moveSucceeded =
//////                                doc.reparent(bean, e, new Position(parent, 0, Bias.FORWARD));
//////                                reparentComponent(componentRootElement, /*e,*/ new Position(parent, 0, Bias.FORWARD), webform);
//////                                reparentComponent(componentRootElement, /*e,*/ Position.create(parent, 0, Bias.FORWARD), webform);
//////                                reparentComponent(componentRootElement, /*e,*/ webForm.createDomPosition(parent, 0, Bias.FORWARD), webform);
////                                webForm.getDomDocument().reparentComponent(componentRootElement, /*e,*/ webForm.createDomPosition(parent, 0, Bias.FORWARD));
////                        }
////
//////                        parentBox = pb;
////                        CssBox pb = webForm.findCssBoxForElement(parent);
////                        if (pb != null) {
////                            parentBox = pb;
////                        }
////                    }
////
////                    // prevent multiple updates for the same element -
////                    // only need a single refresh especially when just changing
////                    // from one grid position to another
//////                    webform.getDomSynchronizer().setUpdatesSuspended(bean, true);
////                    webform.setUpdatesSuspended(componentRootElement, true);
////
////                    List<StyleData> set = new ArrayList<StyleData>(3);
////                    List<StyleData> remove = new ArrayList<StyleData>(3);
////
//////                    if ((pos != null) && (pos != Position.NONE)) {
////                    if ((pos != null) && (pos != DomPosition.NONE)) {
////                        if (moveSucceeded) {
////                            remove.add(new StyleData(XhtmlCss.POSITION_INDEX));
////                            remove.add(new StyleData(XhtmlCss.LEFT_INDEX));
////                            remove.add(new StyleData(XhtmlCss.TOP_INDEX));
////                        } else {
////                            java.awt.Toolkit.getDefaultToolkit().beep();
////                        }
////                    } else if (moveSucceeded) {
////                        // Translate coordinates from absolute/viewport
////                        // to absolute coordinates relative to the target
////                        // grid container
////                        set.add(new StyleData(XhtmlCss.POSITION_INDEX,
//////                                CssConstants.CSS_ABSOLUTE_VALUE));
////                                CssProvider.getValueService().getAbsoluteValue()));
////                        set.add(getHorizontalCssSetting(x, box.getWidth(), box, parentBox, componentRootElement));
////                        set.add(getVerticalCssSetting(y, box.getHeight(), box, parentBox, componentRootElement));
////                    }
////
//////                    XhtmlCssEngine engine = webform.getMarkup().getCssEngine();
////// <removing design bean manipulation in engine>
//////                    engine.updateLocalStyleValues((RaveElement)e, set, remove);
////// ====
//////                    Util.updateLocalStyleValuesForElement(e,
//////                            (StyleData[])set.toArray(new StyleData[set.size()]),
//////                            (StyleData[])remove.toArray(new StyleData[remove.size()]));
////                    WebForm.getDomProviderService().updateLocalStyleValuesForElement(componentRootElement,
////                            set.toArray(new StyleData[set.size()]),
////                            remove.toArray(new StyleData[remove.size()]));
////// </removing design bean manipulation in engine>
////                } finally {
//////                    webform.getDomSynchronizer().setUpdatesSuspended(bean, false);
////                    webform.setUpdatesSuspended(componentRootElement, false);
////                }
////            }
////        } finally {
//////            doc.writeUnlock();
//////            webform.getModel().writeUnlock(undoEvent);
////            webform.writeUnlock(writeLock);
////        }
////
////        // XXX #91531 User didn't want to have this kind of autoscroll behavior.
//////        final Rectangle rect = boundingBox;
//////	// #6331237 NPE.
//////	if(rect != null) {
//////	    SwingUtilities.invokeLater(new Runnable() {
//////		public void run() {
//////		    editor.scrollRectToVisible(rect);
//////		}
//////	    });
//////	}
//    }

//    // XXX Copy also in designer/jsf/../DomDocumentImpl.
//    /**
//     * Given a target position (referring to the border top left corner) for
//     * a box, update its horizontal CSS position properties (left/right) to
//     * make the box appear at the target position.
//     * This not only converts the coordinates to the margin edge (since the
//     * CSS properties are relative to it), but also ensures that if a component
//     * is for example only constrained on the right, the "right" property is
//     * updated rather than "left".
//     */
//    private StyleData getHorizontalCssSetting(int x, int newWidth, CssBox box, CssBox parentBox,
//        Element e) {
////        int left = CssLookup.getLength(e, XhtmlCss.LEFT_INDEX);
////        int right = CssLookup.getLength(e, XhtmlCss.RIGHT_INDEX);
//        int left = CssUtilities.getCssLength(e, XhtmlCss.LEFT_INDEX);
//        int right = CssUtilities.getCssLength(e, XhtmlCss.RIGHT_INDEX);
//
//        if ((left == CssBox.AUTO) && (right != CssBox.AUTO)) {
////            int rx = right - (x - box.getX()) - (width - box.getWidth());
////            Point p = translateCoordinates(parentBox, rx, 0);
////            rx = p.x;
////
////            // The CSS "right" property is relative to the Margin edge
////            rx += box.getRightMargin();
//            int rx = translateRight(right, x, newWidth, box, parentBox);
//
//            return new StyleData(XhtmlCss.RIGHT_INDEX, Integer.toString(rx) + "px"); // NOI18N
//        } else {
////            Point p = translateCoordinates(parentBox, x, 0);
////            x = p.x;
////
////            // The CSS "left" property is relative to the Margin edge
////            x -= box.getLeftMargin();
//            int rx = translateLeft(x, box, parentBox);
//
////            return new StyleData(XhtmlCss.LEFT_INDEX, Integer.toString(x) + "px"); // NOI18N
//            return new StyleData(XhtmlCss.LEFT_INDEX, Integer.toString(rx) + "px"); // NOI18N
//        }
//    }
//
//    // XXX Copy also in designer/jsf/../DomDocumentImpl.
//    private int translateRight(int right, int x, int newWidth, CssBox box, CssBox parentBox) {
//        int rx = right - (x - box.getX()) - (newWidth - box.getWidth());
//        Point p = translateCoordinates(parentBox, rx, 0);
//        rx = p.x;
//
//        // The CSS "right" property is relative to the Margin edge
//        rx += box.getRightMargin();
//        return rx;
//    }
//    
//    // XXX Copy also in designer/jsf/../DomDocumentImpl.
//    private int translateLeft(int x, CssBox box, CssBox parentBox) {
//        Point p = translateCoordinates(parentBox, x, 0);
//        x = p.x;
//
//        // The CSS "left" property is relative to the Margin edge
//        x -= box.getLeftMargin();
//        return x;
//    }
//
//    // XXX Copy also in designer/jsf/../DomDocumentImpl
//    /** Same as setHorizontalCssPosition, but for the vertical dimension with
//     * CSS top/bottom properties */
//    private StyleData getVerticalCssSetting(int y, int newHeight, CssBox box, CssBox parentBox,
//        Element e) {
////        int top = CssLookup.getLength(e, XhtmlCss.TOP_INDEX);
////        int bottom = CssLookup.getLength(e, XhtmlCss.BOTTOM_INDEX);
//        int top = CssUtilities.getCssLength(e, XhtmlCss.TOP_INDEX);
//        int bottom = CssUtilities.getCssLength(e, XhtmlCss.BOTTOM_INDEX);
//
//        if ((top == CssBox.AUTO) && (bottom != CssBox.AUTO)) {
////            int ry = bottom - (y - box.getY()) - (height - box.getHeight());
////            Point p = translateCoordinates(parentBox, 0, ry);
////            ry = p.y;
////
////            // The CSS "bottom" property is relative to the Margin edge
////            ry += box.getEffectiveTopMargin();
//            int ry = translateBottom(bottom, y, newHeight, box, parentBox);
//
//            return new StyleData(XhtmlCss.BOTTOM_INDEX, Integer.toString(ry) + "px"); // NOI18N
//        } else {
////            Point p = translateCoordinates(parentBox, 0, y);
////            y = p.y;
////
////            // The CSS "top" property is relative to the Margin edge
////            y -= box.getEffectiveTopMargin();
//            int ry = translateTop(y, box, parentBox);
//
////            return new StyleData(XhtmlCss.TOP_INDEX, Integer.toString(y) + "px"); // NOI18N
//            return new StyleData(XhtmlCss.TOP_INDEX, Integer.toString(ry) + "px"); // NOI18N
//        }
//    }
//    
//    // XXX Copy also in designer/jsf/../DomDocumentImpl
//    private int translateBottom(int bottom, int y, int newHeight, CssBox box, CssBox parentBox) {
//        int ry = bottom - (y - box.getY()) - (newHeight - box.getHeight());
//        Point p = translateCoordinates(parentBox, 0, ry);
//        ry = p.y;
//
//        // The CSS "bottom" property is relative to the Margin edge
//        ry += box.getEffectiveTopMargin();
//        return ry;
//    }
//
//    // XXX Copy also in designer/jsf/../DomDocumentImpl
//    private int translateTop(int y, CssBox box, CssBox parentBox) {
//        Point p = translateCoordinates(parentBox, 0, y);
//        y = p.y;
//
//        // The CSS "top" property is relative to the Margin edge
//        y -= box.getEffectiveTopMargin();
//        return y;
//    }
//
//    // XXX Copy also in designer/jsf/../DomDocumentImpl.
//    /** Report whether the given element is absolutely positioned */
//    private boolean isAbsolutelyPositioned(Element element) {
//        boolean absolute;
////        Value val = CssLookup.getValue(element, XhtmlCss.POSITION_INDEX);
//        CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(element, XhtmlCss.POSITION_INDEX);
//
////        if ((val == CssValueConstants.ABSOLUTE_VALUE) || (val == CssValueConstants.FIXED_VALUE)) {
//        if (CssProvider.getValueService().isAbsoluteValue(cssValue)
//        || CssProvider.getValueService().isFixedValue(cssValue)) {
//            absolute = true;
//        } else {
//            absolute = false;
//        }
//
//        return absolute;
//    }

    
//    public Point translateCoordinates(Element parent, int x, int y) {
////        CssBox parentBox = CssBox.getBox(parent);
//        CssBox parentBox = webForm.findCssBoxForElement(parent);
//
//        if (parentBox != null) {
//            // Translate coordinates from absolute/viewport
//            // to absolute coordinates relative to the target
//            // grid container
////                Point p = translateCoordinates(parentBox, x, y);
//            return translateCoordinates(parentBox, x, y);
//        }
//        
//        return new Point(x, y);
//    }
//
//    // XXX Copy also in designer/jsf/../DomDocumentImpl
//    /** Given absolute coordinates x,y in the viewport, compute
//     * the CSS coordinates to assign to a box if it's parented by
//     * the given parentBox such that the coordinates will result
//     * in a box showing up at the absolute coordinates.
//     * That was a really convoluted explanation, so to be specific:
//     * If you have an absolutely positioned <div> at 100, 100,
//     * and you drag a button into it such that it's its child,
//     * and you drag it to screen coordinate 75, 150, then, in order
//     * for the button to be rendered at 75, 150 and be a child of
//     * the div its top/left coordinates must be -25, 50.
//     */
//    private Point translateCoordinates(CssBox parentBox, int x, int y) {
//        while (parentBox != null) {
//            if (parentBox.getBoxType().isPositioned()) {
//                x -= parentBox.getAbsoluteX();
//                y -= parentBox.getAbsoluteY();
//
//                return new Point(x, y);
//            }
//
//            if (parentBox.getPositionedBy() != null) {
//                parentBox = parentBox.getPositionedBy();
//            } else {
//                parentBox = parentBox.getParent();
//            }
//        }
//
//        return new Point(x, y);
//    }

//    /** Drag a set of components from to a new position (newX,newY).
//     *
//     * <p>
//     * @todo Should I use floating point coordinates instead?
//     */
//    private void moveTo(DesignerPane editor, /*MarkupDesignBean bean,*/ CssBox box, int x, int y/*, boolean snapDisabled*/) {
//        // TODO - don't position elements that can't be positioned!
//        // For example, if you select a set of table cells, these
//        // can't be aligned with a separate button.
//        // Locate a grid layout parent
////        Document doc = editor.getDocument();
////        WebForm webform = doc.getWebForm();
//        WebForm webform = editor.getWebForm();
//        
////        Element e = box.getElement();
////        Element componentRootElement = CssBox.getElementForComponentRootCssBox(box);
//
////        if (e == null) {
////            e = bean.getElement();
////        }
//
////        if (!snapDisabled) {
////            x = snapX(x, box.getPositionedBy());
////            y = snapY(y, box.getPositionedBy());
////        }
//
//        // XXX Moved to DomDocumentImpl
////        // We should already have a locked buffer with a user visible
////        // undo event when this methhod is called
////        // XXX Not here.
//////        assert webform.getModel().isWriteLocked();
////        if (!webform.isWriteLocked()) {
////            ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL,
////                    new IllegalStateException("This method has to be called under write lock! It is not.")); // NOI18N
////        }
////
////        // prevent multiple updates for the same element - only need a single refresh
////        try {
//////            webform.getDomSynchronizer().setUpdatesSuspended(bean, true);
////            webform.setUpdatesSuspended(componentRootElement, true);
////
////            CssBox parentBox = box.getParent();
////            List<StyleData> set = new ArrayList<StyleData>(3);
//////            set.add(new StyleData(XhtmlCss.POSITION_INDEX, CssConstants.CSS_ABSOLUTE_VALUE));
////            set.add(new StyleData(XhtmlCss.POSITION_INDEX, CssProvider.getValueService().getAbsoluteValue()));
////            set.add(getHorizontalCssSetting(x, box.getWidth(), box, parentBox, componentRootElement));
////            set.add(getVerticalCssSetting(y, box.getHeight(), box, parentBox, componentRootElement));
////
//////            XhtmlCssEngine engine = webform.getMarkup().getCssEngine();
////// <removing design bean manipulation in engine>
//////            engine.updateLocalStyleValues((RaveElement)e, set, null);
////// ====
//////            Util.updateLocalStyleValuesForElement(e,
//////                    (StyleData[])set.toArray(new StyleData[set.size()]), null);
////            WebForm.getDomProviderService().updateLocalStyleValuesForElement(componentRootElement,
////                    set.toArray(new StyleData[set.size()]), null);
////// </removing design bean manipulation in engine>
////        } finally {
//////            webform.getDomSynchronizer().setUpdatesSuspended(bean, false);
////            webform.setUpdatesSuspended(componentRootElement, false);
////        }
//        webform.getDomDocument().moveComponentTo(box, x, y);
//    }

    // XXX Moved to designer/jsf/../DomDocumentImpl
//    /** Front the given set of components
//     */
////    public void back(WebForm webform, List<CssBox> boxes) {
//    public void back(WebForm webform, CssBox[] boxes) {
////        Document doc = webform.getDocument();
//
////        UndoEvent undoEvent = webform.getModel().writeLock(NbBundle.getMessage(GridHandler.class, "SendToBack")); // NOI18N
//        DomProvider.WriteLock writeLock = webform.writeLock(NbBundle.getMessage(GridHandler.class, "SendToBack")); // NOI18N
//        try {
////            doc.writeLock(NbBundle.getMessage(GridHandler.class, "SendToBack")); // NOI18N
//
////            int num = boxes.size();
//            int num = boxes.length;
//
////            for (int i = 0; i < num; i++) {
////                CssBox box = boxes.get(i);
//            for (CssBox box : boxes) {
////                MarkupDesignBean bean = box.getDesignBean();
////                MarkupDesignBean bean = CssBox.getMarkupDesignBeanForCssBox(box);
//                Element componentRootElement = CssBox.getElementForComponentRootCssBox(box);
////                assert bean != null;
//
////                Element e = box.getElement();
////                Element e = componentRootElement;
//
////                if (e == null) {
////                    e = bean.getElement();
////                }
//
////                assert e != null;
//                if (componentRootElement == null) {
//                    ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL,
//                            new NullPointerException("There is no component root element for box=" + box));
//                    continue;
//                }
//
//                // Locate the lowest z index in box' parent
//                // XXX is auto less than 0?
//                int lowest = CssBox.AUTO;
//                CssBox parent = box.getParent();
//
//                // #6358276 NPE.
//                if(parent != null) {
//                    for (int j = 0, m = parent.getBoxCount(); j < m; j++) {
//                        CssBox sibling = parent.getBox(j);
//
//                        if (sibling == box) {
//                            continue;
//                        }
//
//                        if ((lowest == CssBox.AUTO) ||
//                                ((sibling.getZ() != CssBox.AUTO) && (sibling.getZ() < lowest))) {
//                            lowest = sibling.getZ();
//                        }
//                    }
//                }
//
//                if (lowest == CssBox.AUTO) {
//                    lowest = 500;
//                } else {
//                    lowest--;
//                }
//
//                try {
////                    webform.getDomSynchronizer().setUpdatesSuspended(bean, true);
//                    webform.setUpdatesSuspended(componentRootElement, true);
//
////                    XhtmlCssEngine engine = webform.getMarkup().getCssEngine();
//                    
//                    List<StyleData> set = new ArrayList<StyleData>(1);
//                    set.add(new StyleData(XhtmlCss.Z_INDEX, Integer.toString(lowest)));
//// <removing design bean manipulation in engine>
////                    engine.updateLocalStyleValues((RaveElement)e, set, null);
//// ====
////                    Util.updateLocalStyleValuesForElement(e,
////                            (StyleData[])set.toArray(new StyleData[set.size()]), null);
//                    WebForm.getDomProviderService().updateLocalStyleValuesForElement(componentRootElement,
//                            set.toArray(new StyleData[set.size()]), null);
//// </removing design bean manipulation in engine>
//                } finally {
////                    webform.getDomSynchronizer().setUpdatesSuspended(bean, false);
//                    webform.setUpdatesSuspended(componentRootElement, false);
//                }
//            }
//        } finally {
////            doc.writeUnlock();
////            webform.getModel().writeUnlock(undoEvent);
//            webform.writeUnlock(writeLock);
//        }
//    }

    // XXX Moved to designer/jsf/../DomDocumentImpl.
//    /** Front the given set of components
//     */
////    public void front(WebForm webform, List<CssBox> boxes) {
//    public void front(WebForm webform, CssBox[] boxes) {
////        Document doc = webform.getDocument();
//
////        UndoEvent undoEvent = webform.getModel().writeLock(NbBundle.getMessage(GridHandler.class, "BringToFront")); // NOI18N
//        DomProvider.WriteLock writeLock = webform.writeLock(NbBundle.getMessage(GridHandler.class, "BringToFront")); // NOI18N
//        try {
////            doc.writeLock(NbBundle.getMessage(GridHandler.class, "BringToFront")); // NOI18N
//
////            int num = boxes.size();
//            int num = boxes.length;
//
////            for (int i = 0; i < num; i++) {
////                CssBox box = boxes.get(i);
//            for (CssBox box : boxes) {
////                MarkupDesignBean bean = box.getDesignBean();
////                MarkupDesignBean bean = CssBox.getMarkupDesignBeanForCssBox(box);
//                Element componentRootElement = CssBox.getElementForComponentRootCssBox(box);
//                
////                assert bean != null;
//
////                Element e = box.getElement();
//
////                if (e == null) {
////                    e = bean.getElement();
////                }
//
////                assert e != null;
//                if (componentRootElement == null) {
//                    ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL,
//                            new NullPointerException("There is no component root element for box=" + box));
//                    continue;
//                }
//
//                // Locate the highest z index in box' parent
//                int highest = CssBox.AUTO;
//                CssBox parent = box.getParent();
//
//                // #6358276 NPE.
//                if(parent != null) {
//                    for (int j = 0, m = parent.getBoxCount(); j < m; j++) {
//                        CssBox sibling = parent.getBox(j);
//
//                        if (sibling == box) {
//                            continue;
//                        }
//
//                        if ((highest == CssBox.AUTO) ||
//                                ((sibling.getZ() != CssBox.AUTO) && (sibling.getZ() > highest))) {
//                            highest = sibling.getZ();
//                        }
//                    }
//                }
//
//                if (highest == CssBox.AUTO) {
//                    highest = 500;
//                } else {
//                    highest++;
//                }
//
//                try {
////                    doc.getWebForm().getDomSynchronizer().setUpdatesSuspended(bean, true);
////                    doc.getWebForm().setUpdatesSuspended(componentRootElement, true);
//                    webform.setUpdatesSuspended(componentRootElement, true);
//
////                    XhtmlCssEngine engine = webform.getMarkup().getCssEngine();
//                    
//                    List<StyleData> set = new ArrayList<StyleData>(1);
//                    set.add(new StyleData(XhtmlCss.Z_INDEX, Integer.toString(highest)));
//// <removing design bean manipulation in engine>
////                    engine.updateLocalStyleValues((RaveElement)e, set, null);
//// ====
////                    Util.updateLocalStyleValuesForElement(e,
////                            (StyleData[])set.toArray(new StyleData[set.size()]), null);
//                    WebForm.getDomProviderService().updateLocalStyleValuesForElement(componentRootElement,
//                            set.toArray(new StyleData[set.size()]), null);
//// </removing design bean manipulation in engine>
//                } finally {
////                    doc.getWebForm().getDomSynchronizer().setUpdatesSuspended(bean, false);
////                    doc.getWebForm().setUpdatesSuspended(componentRootElement, false);
//                    webform.setUpdatesSuspended(componentRootElement, false);
//                }
//            }
//        } finally {
////            doc.writeUnlock();
////            webform.getModel().writeUnlock(undoEvent);
//            webform.writeUnlock(writeLock);
//        }
//    }

//    /**
//     * Set the initial position for a given component.
//     * It is assumed that the bean does not already have an associated position.
//     *
//     * @param editor The designer pane containing the element
//     * @param element The element we want to set a style attribute for
//     * @param pos The point where we want the element positioned. If null,
//     *              this method has no effect.
//     * @param size The size to assign to the component. If null, don't set a
//     *              size, use the intrinsic size.
//     */
//    public void setInitialPosition(/*DesignerPane editor*/WebForm webform, MarkupDesignBean bean, Element element,
//        Point pos, Dimension size) {
//        if (pos == null) {
//            return;
//        }
//
//        DesignProperty styleProp = bean.getProperty("style"); // NOI18N
//
//        if (styleProp == null) {
//            // No style property - can't set position!!
//            return;
//        }
//
//        String style = (String)styleProp.getValue();
//        StringBuffer sb = new StringBuffer();
//
//        if ((style != null) && (style.length() > 0)) {
//            sb.append(style);
//            sb.append("; ");
//        }
//
//        // Locate a grid layout parent
////        Document doc = editor.getDocument();
////        WebForm webform = doc.getWebForm();
////        XhtmlCssEngine engine = webform.getMarkup().getCssEngine();
//
//        // This model should already be locked when we attempt to do this
//        assert webform.getModel().isWriteLocked();
//
//        int x = pos.x;
//        int y = pos.y;
//
//        // See if we should translate the coordinates
//        if (element.getParentNode() instanceof Element) {
//            Element parent = (Element)element.getParentNode();
//            CssBox parentBox = CssBox.getBox(parent);
//
//            if (parentBox != null) {
//                // Translate coordinates from absolute/viewport
//                // to absolute coordinates relative to the target
//                // grid container
//                Point p = translateCoordinates(parentBox, x, y);
//                x = p.x;
//                y = p.y;
//            }
//        }
//
//        x = snapX(x);
//        y = snapY(y);
//
//        // prevent multiple updates for the same element - only need a single refresh
//        try {
////            webform.getDomSynchronizer().setUpdatesSuspended(bean, true);
//            webform.setUpdatesSuspended(bean, true);
//
//            // TODO: Find the -rendered- element; I have to look up margins on it
//            // since it could come from style classes. For example, for a Braveheart
//            // button, if I have a CSS rule   .Btn2 { margin: 200px }  I won't find
//            // this style looking at the JSP element (ui:button) I need to do lookup
//            // on the rendered <input class="Btn2" ...> element.
//            // The "top" and "left" properties are relative to the margin edge of the
//            // component yet the position is specified relative to the border (visible) area
////            int leftMargin = CssLookup.getLength(element, XhtmlCss.MARGIN_LEFT_INDEX);
////            int topMargin = CssLookup.getLength(element, XhtmlCss.MARGIN_TOP_INDEX);
//            int leftMargin = CssUtilities.getCssLength(element, XhtmlCss.MARGIN_LEFT_INDEX);
//            int topMargin = CssUtilities.getCssLength(element, XhtmlCss.MARGIN_TOP_INDEX);
//            x -= leftMargin;
//            y -= topMargin;
//
//            List set = new ArrayList(5);
//            List remove = new ArrayList(3);
//
//            sb.append("position: absolute; ");
//            sb.append("left: ");
//            sb.append(Integer.toString(x));
//            sb.append("px; ");
//            sb.append("top: ");
//            sb.append(Integer.toString(y));
//            sb.append("px");
//
//            if (size != null) {
//                if (!setDesignProperty(bean, HtmlAttribute.WIDTH, size.width)) {
//                    sb.append("; width: ");
//                    sb.append(Integer.toString(size.width));
//                    sb.append("px"); // NOI18N
//                } else {
//                    // Do I need to try to delete the width from the existing value string?
//                    // The only way this could get here is if the component has had a chance
//                    // to set widths/sizes with the create customizers
//                }
//
//                if (!setDesignProperty(bean, HtmlAttribute.HEIGHT, size.height)) {
//                    sb.append("; height: ");
//                    sb.append(Integer.toString(size.height));
//                    sb.append("px"); // NOI18N
//                } else {
//                    // Do I need to try to delete the width from the existing value string?
//                    // The only way this could get here is if the component has had a chance
//                    // to set widths/sizes with the create customizers
//                }
//            }
//
//            styleProp.setValue(sb.toString());
//        } finally {
////            webform.getDomSynchronizer().setUpdatesSuspended(bean, false);
//            webform.setUpdatesSuspended(bean, false);
//        }
//    }
//
//    /** Attempt to set the given attribute on the bean to the given length
//     * and return true iff it succeeds.
//     */
//    private static boolean setDesignProperty(DesignBean bean, String attribute, int length) {
//        DesignProperty prop = bean.getProperty(attribute);
//
//        if (prop != null) {
//            PropertyDescriptor desc = prop.getPropertyDescriptor();
//            Class clz = desc.getPropertyType();
//
//            // I can do == instead of isAssignableFrom because
//            // both String and Integer are final!
//            if (clz == String.class) {
//                prop.setValue(Integer.toString(length));
//
//                return true;
//            } else if (clz == Integer.TYPE) {
//                prop.setValue(new Integer(length));
//
//                return true;
//            }
//        }
//
//        return false;
//    }

    // XXX Moved to designer/jsf/../DomDocumentImpl.
//    /** Resize the given component to new dimensions.
//     * Note that the x,y position might change too, for example, when
//     * you resize the component by dragging a selection handle on the
//     * top or left edges of the component.
//     *
//     * <p>
//     * @param editor The editor containing the resized component
//     * @param component Component being resized
//     * @param element The DOM element for the component
//     * @param newX The left edge of the component after resize
//     * @param xMoved True iff the left edge position changed during the resize
//     * @param newY The top edge of the component after resize
//     * @param yMoved True iff the top edge position moved during the resize
//     * @param newWidth The new width after resize
//     * @param newHeight The new height after resize
//     * @param box Box being resized
//     * @param snapDisabled If true, skip snapping
//     * @todo Should I use floating point coordinates instead?
//     */
//    public void resize(DesignerPane editor, Element componentRootElement, /*MarkupDesignBean bean,*/ int newX, boolean xMoved,
//        int newY, boolean yMoved, int newWidth, boolean widthChanged, int newHeight,
//        boolean heightChanged, CssBox box, boolean snapDisabled) {
//        // Locate a grid layout parent
////        Document doc = editor.getDocument();
////        WebForm webform = doc.getWebForm();
//        WebForm webform = editor.getWebForm();
//
//        int x = newX;
//        int y = newY;
//
//        if (!snapDisabled) {
//            x = snapX(newX, box.getPositionedBy());
//            y = snapY(newY, box.getPositionedBy());
//        }
//
//        Element element = box.getElement();
//
//        if (element == null) {
////            element = bean.getElement();
//            element = componentRootElement;
//        }
//
//        boolean absolute = isAbsolutelyPositioned(element);
//
////        UndoEvent undoEvent = webform.getModel().writeLock(NbBundle.getMessage(GridHandler.class, "ResizeComponent")); // NOI18N
//        DomProvider.WriteLock writeLock = webform.writeLock(NbBundle.getMessage(GridHandler.class, "ResizeComponent")); // NOI18N
//        // Gotta set width and height attributes!
//        try {
////            doc.writeLock(NbBundle.getMessage(GridHandler.class, "ResizeComponent")); // NOI18N
//
//            // prevent multiple updates for the same element - only need a single refresh
////            webform.getDomSynchronizer().setUpdatesSuspended(bean, true);
//            webform.setUpdatesSuspended(componentRootElement, true);
//
//            List<StyleData> set = new ArrayList<StyleData>(5);
//            List<StyleData> remove = new ArrayList<StyleData>(3);
//
//            if (absolute && (xMoved || yMoved)) {
////                set.add(new StyleData(XhtmlCss.POSITION_INDEX, CssConstants.CSS_ABSOLUTE_VALUE));
//                set.add(new StyleData(XhtmlCss.POSITION_INDEX, CssProvider.getValueService().getAbsoluteValue()));
//
//                CssBox parentBox = box.getParent();
//
//                if (xMoved) {
//                    set.add(getHorizontalCssSetting(x, newWidth, box, parentBox, element));
//                }
//
//                if (yMoved) {
//                    set.add(getVerticalCssSetting(y, newHeight, box, parentBox, element));
//                }
//            }
//
//            if (widthChanged) {
////                if (!DndHandler.setDesignProperty(bean, HtmlAttribute.WIDTH, newWidth, webform)) {
////                if (!WebForm.getDomProviderService().setDesignProperty(bean, HtmlAttribute.WIDTH, newWidth)) {
//                if (!WebForm.getDomProviderService().setStyleAttribute(componentRootElement, HtmlAttribute.WIDTH, newWidth)) {
//                    set.add(new StyleData(XhtmlCss.WIDTH_INDEX, Integer.toString(newWidth) + "px")); // NOI18N
//                } else {
//                    // Ensure that we don't have a conflict
//                    remove.add(new StyleData(XhtmlCss.WIDTH_INDEX));
//                }
//            }
//
//            if (heightChanged) {
////                if (!DndHandler.setDesignProperty(bean, HtmlAttribute.HEIGHT, newHeight, webform)) {
////                if (!WebForm.getDomProviderService().setDesignProperty(bean, HtmlAttribute.HEIGHT, newHeight)) {
//                if (!WebForm.getDomProviderService().setStyleAttribute(componentRootElement, HtmlAttribute.HEIGHT, newHeight)) {
//                    set.add(new StyleData(XhtmlCss.HEIGHT_INDEX, Integer.toString(newHeight) + "px")); // NOI18N
//                } else {
//                    // Ensure that we don't have a conflict
//                    remove.add(new StyleData(XhtmlCss.HEIGHT_INDEX));
//                }
//            }
//
////            XhtmlCssEngine engine = webform.getMarkup().getCssEngine();
//            
//// <removing design bean manipulation in engine>
////            engine.updateLocalStyleValues((RaveElement)element, set, remove);
//// ====
////            Util.updateLocalStyleValuesForElement(element,
////                    (StyleData[])set.toArray(new StyleData[set.size()]),
////                    (StyleData[])remove.toArray(new StyleData[remove.size()]));
//            WebForm.getDomProviderService().updateLocalStyleValuesForElement(element,
//                    set.toArray(new StyleData[set.size()]),
//                    remove.toArray(new StyleData[remove.size()]));
//// </removing design bean manipulation in engine>
//        } finally {
////            webform.getDomSynchronizer().setUpdatesSuspended(bean, false);
//            webform.setUpdatesSuspended(componentRootElement, false);
////            doc.writeUnlock();
////            webform.getModel().writeUnlock(undoEvent);
//            webform.writeUnlock(writeLock);
//        }
//    }

//    /**
//     * Report whether the given position is in grid context
//     */
//    public static boolean isGridContext(DesignBean parent, MarkupPosition pos) {
//        if (parent.getInstance() instanceof javax.faces.component.UIForm ||
//                parent.getInstance() instanceof org.netbeans.modules.visualweb.xhtml.Form) {
//            // Look at its parent
//            parent = parent.getBeanParent();
//
//            if (parent == null) {
//                return false;
//            }
//        }
//
//        Element element = FacesSupport.getElement(parent);
//
//        if (element == null) {
//            return false;
//        }
//
////        Value val = CssLookup.getValue(element, XhtmlCss.RAVELAYOUT_INDEX);
//        CssValue cssValue = CssProvider.getEngineService().getComputedValueForElement(element, XhtmlCss.RAVELAYOUT_INDEX);
//
////        return val == CssValueConstants.GRID_VALUE;
//        return CssProvider.getValueService().isGridValue(cssValue);
//    }
    
    // XXX Moved from Document, then to DomDocumentImpl, and DesginerCaret.
//    /** Transfer the given element such that it's parented at the given position */
////    private boolean reparent(DesignBean bean, Element element, Position pos, WebForm webform) {
////    private boolean reparentComponent(Element componentRootElement, /*Element element,*/ Position pos, WebForm webform) {
//    private static boolean reparentComponent(Element componentRootElement, /*Element element,*/ DomPosition pos, WebForm webform) {
////        if (pos == Position.NONE) {
//        if (pos == DomPosition.NONE) {
//            return false;
//        }
//
//        // First see where it's currently located
////        Position currPos = Position.create(element, false);
////        Position currPos = Position.create(componentRootElement, false);
//        DomPosition currPos = webform.createDomPosition(componentRootElement, false);
//
//        if (pos.equals(currPos)) {
//            return true; // Already in the right place - done
//        }
//
////        if (pos.isRendered()) {
//        if (MarkupService.isRenderedNode(pos.getNode())) {
//            pos = pos.getSourcePosition();
//        }
//
////        if (pos == Position.NONE) {
//        if (pos == DomPosition.NONE) {
//            return false;
//        }
//
//        Node node = pos.getNode();
//
//        // Ensure the node is not in a DocumentFragment - if it is, moving
//        // an element here is going to remove it from the jsp!!
//        Node curr = node;
//
//        while (curr.getParentNode() != null) {
//            curr = curr.getParentNode();
//        }
//
//        //if (curr instanceof DocumentFragment) {
//        if (curr != webform.getJspDom()) {
//            return false;
//        }
//
//        Node parentNode = node;
//        Node before = null;
//
//        if (node instanceof Text) {
//            parentNode = node.getParentNode();
//
//            if (pos.getOffset() == 0) {
//                before = node;
//            } else {
//                Text txt = (Text)node;
//
//                if (pos.getOffset() < txt.getLength()) {
//                    before = txt.splitText(pos.getOffset());
//                } else {
//                    // Ugh, what if it's the last node here??
//                    // XXX won't work right!
//                    before = txt.getNextSibling();
//                }
//            }
//        } else {
//            before = parentNode.getFirstChild();
//
//            for (int i = 0, n = pos.getOffset(); i < n; i++) {
//                if (before == null) {
//                    break;
//                }
//
//                before = before.getNextSibling();
//            }
//        }
//
////        if (before == element) {
//        // XXX Comparing rendered with source element can never fit.
//        if (before == componentRootElement) {
//            return true;
//        }
//
////        LiveUnit lu = webform.getModel().getLiveUnit();
////        MarkupPosition markupPos = new MarkupPosition(parentNode, before);
////        DesignBean parentBean = null;
////        Node e = parentNode;
////
////        while (e != null) {
//////            if (e instanceof RaveElement) {
//////                parentBean = ((RaveElement)e).getDesignBean();
////            if (e instanceof Element) {
//////                parentBean = InSyncService.getProvider().getMarkupDesignBeanForElement((Element)e);
////                parentBean = WebForm.getDomProviderService().getMarkupDesignBeanForElement((Element)e);
////                
////                if (parentBean != null) {
////                    break;
////                }
////            }
////
////            e = e.getParentNode();
////        }
////
////        if (bean == parentBean) {
////            return false;
////        }
////
////        boolean success = lu.moveBean(bean, parentBean, markupPos);
//        boolean success = webform.moveComponent(componentRootElement, parentNode, before);
//
////        if (webform.getPane().getCaret() != null) {
//        if (webform.getPane().hasCaret()) {
//            pos = ModelViewMapper.getFirstDocumentPosition(webform, false);
////            webform.getPane().getCaret().setDot(pos);
//            webform.getPane().setCaretDot(pos);
//        }
//
//        return success;
//    }

    // XXX Moved to designer/jsf/../DomDocumentImpl.
//    void snapToGrid() {
////        GridHandler handler = GridHandler.getInstance();
////        DesignerPane editor = webForm.getPane();
//        SelectionManager sm = webForm.getSelection();
////        Iterator it = sm.iterator();
//        Element[] componentRootElements = sm.getSelectedComponentRootElements();
////        ModelViewMapper mapper = webform.getMapper();
//        boolean haveMoved = false;
////        Document doc = webform.getDocument();
//
////        UndoEvent undoEvent = webform.getModel().writeLock(NbBundle.getMessage(AlignAction.class, "LBL_SnapToGrid")); // NOI18N
//        DomProvider.WriteLock writeLock = webForm.writeLock(NbBundle.getMessage(GridHandler.class, "LBL_SnapToGrid")); // NOI18N
//        try {
////            doc.writeLock(NbBundle.getMessage(AlignAction.class, "LBL_SnapToGrid")); // NOI18N
//
////            while (it.hasNext()) {
////                MarkupDesignBean bean = (MarkupDesignBean)it.next();
//            for (Element componentRootElement : componentRootElements) {
////                MarkupDesignBean bean = WebForm.getDomProviderService().getMarkupDesignBeanForElement(componentRootElement);
////                CssBox box = mapper.findBox(bean);
//                CssBox box = ModelViewMapper.findBoxForComponentRootElement(webForm.getPane().getPageBox(), componentRootElement);
//
//                if (box == null) {
//                    continue;
//                }
//
//                boolean canAlign = box.getBoxType().isAbsolutelyPositioned();
//
//                if (!canAlign) {
//                    continue;
//                }
//
//                int x = box.getAbsoluteX();
//                int y = box.getAbsoluteY();
//
//                // Snap to grid.
//                x = snapX(x, box.getPositionedBy());
//                y = snapY(y, box.getPositionedBy());
//                
////                moveTo(editor, /*bean,*/ box, x, y /*, false*/);
//                webForm.getDomDocument().moveComponentTo(box, x, y);
//                
//                haveMoved = true;
//            }
//        } finally {
////            doc.writeUnlock();
////            webform.getModel().writeUnlock(undoEvent);
//            webForm.writeUnlock(writeLock);
//        }
//
//        if (!haveMoved) {
//            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GridHandler.class, "MSG_AlignAbsolute"));
//            UIManager.getLookAndFeel().provideErrorFeedback(webForm.getPane());
//        }
//    }

    // XXX Moved to designer/jsf/../DomDocumentImpl.
//    void align(Designer.Alignment alignment) {
//        // Primary
//        SelectionManager sm = webForm.getSelection();
//
//        if (sm.isSelectionEmpty()) {
//            return;
//        }
//
//        sm.pickPrimary();
//
////        ModelViewMapper mapper = webform.getMapper();
////        CssBox primaryBox = mapper.findBox(sm.getPrimary());
//        CssBox primaryBox = ModelViewMapper.findBox(webForm.getPane().getPageBox(), sm.getPrimary());
//
//        if (primaryBox == null) {
//            return;
//        }
//
//        boolean haveMoved = false;
////        Document doc = webform.getDocument();
//
////        UndoEvent undoEvent = webform.getModel().writeLock(NbBundle.getMessage(SelectionManager.class, "Align")); // NOI18N
//        DomProvider.WriteLock writeLock = webForm.writeLock(NbBundle.getMessage(SelectionManager.class, "Align")); // NOI18N
//        try {
////            doc.writeLock(NbBundle.getMessage(SelectionManager.class, "Align")); // NOI18N
//
////            GridHandler handler = GridHandler.getInstance();
////            DesignerPane editor = webForm.getPane();
//            boolean canAlign = primaryBox.getBoxType().isAbsolutelyPositioned();
//            int x = primaryBox.getAbsoluteX();
//            int y = primaryBox.getAbsoluteY();
//            int w = primaryBox.getWidth();
//            int h = primaryBox.getHeight();
////            Iterator it = sm.iterator();
////
////            while (canAlign && it.hasNext()) {
////                MarkupDesignBean bean = (MarkupDesignBean)it.next();
//            for (Element componentRootElement : sm.getSelectedComponentRootElements()) {
////                MarkupDesignBean bean = WebForm.getDomProviderService().getMarkupDesignBeanForElement(componentRootElement);
////                CssBox box = mapper.findBox(bean);
//                CssBox box = ModelViewMapper.findBoxForComponentRootElement(webForm.getPane().getPageBox(), componentRootElement);
//
//                if (box == null) {
//                    continue;
//                }
//
//                // XXX Should I use isPositioned() instead? (e.g. are relative
//                // positioned boxes alignable?
//                if (!box.getBoxType().isAbsolutelyPositioned()) {
//                    continue;
//                }
//
//                haveMoved = true;
//
//                /*
//                 Element element = FacesSupport.getElement(fob.component);
//                 if (element == null) {
//                 continue;
//                 }
//                 */
//                switch (alignment) {
//                case TOP:
////                    moveTo(editor, /*bean,*/ box, box.getAbsoluteX(), y/*, true*/);
//                    webForm.getDomDocument().moveComponentTo(box, box.getAbsoluteX(), y);
//
//                    break;
//
//                case MIDDLE:
////                    moveTo(editor, /*bean,*/ box, box.getAbsoluteX(),
////                        (y + (h / 2)) - (box.getHeight() / 2)/*, true*/);
//                    webForm.getDomDocument().moveComponentTo(box, box.getAbsoluteX(), (y + (h / 2)) - (box.getHeight() / 2));
//
//                    break;
//
//                case BOTTOM:
////                    moveTo(editor, /*bean,*/ box, box.getAbsoluteX(),
////                        (y + h) - box.getHeight()/*, true*/);
//                    webForm.getDomDocument().moveComponentTo(box, box.getAbsoluteX(), (y + h) - box.getHeight());
//
//                    break;
//
//                case LEFT:
////                    moveTo(editor, /*bean,*/ box, x, box.getAbsoluteY()/*, true*/);
//                    webForm.getDomDocument().moveComponentTo(box, x, box.getAbsoluteY());
//
//                    break;
//
//                case CENTER:
////                    moveTo(editor, /*bean,*/ box, (x + (w / 2)) - (box.getWidth() / 2),
////                        box.getAbsoluteY()/*, true*/);
//                    webForm.getDomDocument().moveComponentTo(box, (x + (w / 2)) - (box.getWidth() / 2), box.getAbsoluteY());
//
//                    break;
//
//                case RIGHT:
////                    moveTo(editor, /*bean,*/ box, (x + w) - box.getWidth(), box.getAbsoluteY()/*, true*/);
//                    webForm.getDomDocument().moveComponentTo(box, (x + w) - box.getWidth(), box.getAbsoluteY());
//
//                    break;
//                }
//            }
//        } finally {
////            doc.writeUnlock();
////            webform.getModel().writeUnlock(undoEvent);
//            webForm.writeUnlock(writeLock);
//        }
//
//        if (!haveMoved) {
//            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GridHandler.class,"MSG_AlignAbsolute"));
//            UIManager.getLookAndFeel().provideErrorFeedback(webForm.getPane());
//        }
//    }

}
