
-- DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.

-- Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.

-- The contents of this file are subject to the terms of either the GNU
-- General Public License Version 2 only ("GPL") or the Common
-- Development and Distribution License("CDDL") (collectively, the
-- "License"). You may not use this file except in compliance with the
-- License. You can obtain a copy of the License at
-- http://www.netbeans.org/cddl-gplv2.html
-- or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
-- specific language governing permissions and limitations under the
-- License.  When distributing the software, include this License Header
-- Notice in each file and include the License file at
-- nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
-- particular file as subject to the "Classpath" exception as provided
-- by Sun in the GPL Version 2 section of the License file that
-- accompanied this code. If applicable, add the following below the
-- License Header, with the fields enclosed by brackets [] replaced by
-- your own identifying information:
-- "Portions Copyrighted [year] [name of copyright owner]"

-- Contributor(s):

-- The Original Software is NetBeans. The Initial Developer of the Original
-- Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
-- Microsystems, Inc. All Rights Reserved.

-- If you wish your version of this file to be governed by only the CDDL
-- or only the GPL Version 2, indicate your decision by adding
-- "[Contributor] elects to include this software in this distribution
-- under the [CDDL or GPL Version 2] license." If you do not indicate a
-- single choice of license, a recipient has the option to distribute
-- your version of this file under either the CDDL, the GPL Version 2 or
-- to extend the choice of license to its licensees as provided above.
-- However, if you add GPL Version 2 code and therefore, elected the GPL
-- Version 2 license, then the option applies only if the new code is
-- made subject to such option by the copyright holder.

-- populate JSC tables
-- Assumes you have created the tables already


-- Populate PART TYPE table

insert into jsc.partType values (1, 'Color', 'Select color for the frame:',
                                'resources/icn_color_down.gif',
                                'resources/icn_color_up.gif');
insert into jsc.partType values (2, ' Sit ', 'Select seat type:',
                                'resources/icn_sit_down.gif',
                                'resources/icn_sit_up.gif');
insert into jsc.partType values (3, 'Spin ', 'Select your favorite wheels:',
                                'resources/icn_spin_down.gif',
                                'resources/icn_spin_up.gif');
insert into jsc.partType values (4, 'Grip ', 'Select the handlebar grips:',
                                'resources/icn_grip_down.gif',
                                'resources/icn_grip_up.gif');
insert into jsc.partType values (5, ' Add ', 'Finish with an accessory package:',
                                'resources/icn_color_down.gif',
                                'resources/icn_color_up.gif');

-- Populate the PART table

insert into jsc.part values ( 1, 1, 'Blue Suede Shoes',   'COLOR-1', 129.00,
                             'resources/img_price_color_1.png',
                             'resources/img_opt_color_1.png',
                             'resources/img_bike_frame_blue.png');
insert into jsc.part values ( 2, 1, 'Commando Green',     'COLOR-2', 139.00,
                             'resources/img_price_color_2.png',
                             'resources/img_opt_color_2.png',
                             'resources/img_bike_frame_green.png');
insert into jsc.part values ( 3, 1, 'Bubblegum Pink',     'COLOR-3', 149.00,
                             'resources/img_price_color_3.png',
                             'resources/img_opt_color_3.png',
                             'resources/img_bike_frame_pink.png');

-- Note that the artist supplied square and rectangle images in
-- different orders for the second and third options here.  Rather
-- than try to rename the files, just make the database entries
-- point at the correct images.
insert into jsc.part values ( 4, 2, 'Bananas Forever',    'SIT-1', 39.00,
                             'resources/img_price_sit_1.png',
                             'resources/img_opt_sit_1.png',
                             'resources/img_bike_sit_banana.png');
insert into jsc.part values ( 5, 2, 'Cushy Tushy',        'SIT-2', 49.00,
                             'resources/img_price_sit_3.png',
                             'resources/img_opt_sit_2.png',
                             'resources/img_bike_sit_red.png');
insert into jsc.part values ( 6, 2, 'Hillclimber',       'SIT-3', 29.00,
                             'resources/img_price_sit_2.png',
                             'resources/img_opt_sit_3.png',
                             'resources/img_bike_sit_stock.png');

insert into jsc.part values ( 7, 3, 'Heavy Tread',       'SPIN-1', 79.00,
                             'resources/img_price_spin_1.png',
                             'resources/img_opt_spin_1.png',
                             'resources/img_bike_wheels_stock.png');
insert into jsc.part values ( 8, 3, 'Skinny Street',     'SPIN-2', 89.00,
                             'resources/img_price_spin_2.png',
                             'resources/img_opt_spin_2.png',
                             'resources/img_bike_wheels_road.png');
insert into jsc.part values ( 9, 3, 'Super Fat Boys',    'SPIN-3', 99.00,
                             'resources/img_price_spin_3.png',
                             'resources/img_opt_spin_3.png',
                             'resources/img_bike_wheels_fat.png');

insert into jsc.part values (10, 4, 'Jumpstart Extreme', 'GRIP-1', 59.00,
                             'resources/img_price_grip_1.png',
                             'resources/img_opt_grip_1.png',
                             'resources/img_bike_grip_mtn.png');
insert into jsc.part values (11, 4, 'Bar-B''s',          'GRIP-2', 59.00,
                             'resources/img_price_grip_2.png',
                             'resources/img_opt_grip_2.png',
                             'resources/img_bike_grip_tassle.png');
insert into jsc.part values (12, 4, 'Hog Bars',          'GRIP-3', 59.00,
                             'resources/img_price_grip_3.png',
                             'resources/img_opt_grip_3.png',
                             'resources/img_bike_grip_high.png');

insert into jsc.part values (13, 5, 'Diva Package',      'ADD-1', 59.00,
                             'resources/img_price_add_1.png',
                             'resources/img_opt_add_1.png',
                             'resources/img_bike_add_diva.png');
insert into jsc.part values (14, 5, 'All-Terrain Package', 'ADD-2', 59.00,
                             'resources/img_price_add_2.png',
                             'resources/img_opt_add_2.png',
                             'resources/img_bike_add_explorer.png');
insert into jsc.part values (15, 5, 'Search and Rescue Package', 'ADD-3', 59.00,
                             'resources/img_price_add_3.png',
                             'resources/img_opt_add_3.png',
                             'resources/img_bike_add_emergency.png');

-- Special parts for unconfigured options (distinguished by
-- DESCRIPTION being NULL)
insert into jsc.part values (16, 1, 'Not Configured',    NULL, 0.00,
                             'resources/img_price_color_up.png',
                             'resources/img_bike_blank.png',
                             'resources/img_bike_blank.png');
insert into jsc.part values (17, 2, 'Not Configured',    NULL, 0.00,
                             'resources/img_price_sit_up.png',
                             'resources/img_bike_blank.png',
                             'resources/img_bike_blank.png');
insert into jsc.part values (18, 3, 'Not Configured',    NULL, 0.00,
                             'resources/img_price_spin_up.png',
                             'resources/img_bike_blank.png',
                             'resources/img_bike_blank.png');
insert into jsc.part values (19, 4, 'Not Configured',    NULL, 0.00,
                             'resources/img_price_grip_up.png',
                             'resources/img_bike_blank.png',
                             'resources/img_bike_blank.png');
insert into jsc.part values (20, 5, 'Not Configured',    NULL, 0.00,
                             'resources/img_price_add_up.png',
                             'resources/img_bike_blank.png',
                             'resources/img_bike_blank.png');

-- creditCardTypes

INSERT INTO jsc.creditCardType ( creditCardTypeId, name )
    VALUES ( 1, 'AMEX');
INSERT INTO jsc.creditCardType ( creditCardTypeId, name )
    VALUES ( 2, 'Diners Club');
INSERT INTO jsc.creditCardType ( creditCardTypeId, name )
    VALUES ( 3, 'MasterCard');
INSERT INTO jsc.creditCardType ( creditCardTypeId, name )
    VALUES ( 4, 'Visa');

-- customer
INSERT INTO jsc.customer ( customerId, userId, lastName, firstName, emailAddress, password, creditCardNo, expirationDate, securityCode, cardTypeId ) 
    VALUES ( 101, 'jd', 'Doe', 'John', 'jdoe@bignum.com', 'jd', '1234 4567 8989 5555', '2006-08-01', '999', 4);


INSERT INTO jsc.customer ( customerId, userId, lastName, firstName, emailAddress, password, creditCardNo, expirationDate, securityCode, cardTypeId ) 
    VALUES ( 102, 'ht', 'Trails', 'Happy', 'ht@HappyTrailsTours.com', 'ht', '1234 4567 8989 5555', '2006-08-01', '999', 2);


INSERT INTO jsc.customer ( customerId, userId, lastName, firstName, emailAddress, password, creditCardNo, expirationDate, securityCode, cardTypeId ) 
    VALUES ( 103, 'cabo', 'Bikes', 'Cabo', 'cabowabo@CaboBikes.com', 'wabo', '1234 4567 8989 5555', '2006-08-01', '999', 1);


-- addressType
INSERT INTO jsc.addressType ( addressTypeId, name )
    VALUES ( 1, 'billing' );

INSERT INTO jsc.addressType ( addressTypeId, name )
    VALUES ( 2, 'shipping' );


-- address
INSERT INTO jsc.address  ( addressId, customerId, addressTypeId, line1, line2, city, state, postalCode, country, fax, phone, phoneExt )
    VALUES ( 1, 101, 1, '65 Santa Cruz Ave', '', 'Menlo Park', 'CA', '94025', 'United States', '650-555-5678', '650-555-1234', '' );

INSERT INTO jsc.address  ( addressId, customerId, addressTypeId, line1, line2, city, state, postalCode, country, fax, phone, phoneExt )
    VALUES ( 2, 101, 2, '65 Santa Cruz Ave', '', 'Menlo Park', 'CA', '94025', 'United States', '650-555-5678', '650-555-1234', '' );

INSERT INTO jsc.address  ( addressId, customerId, addressTypeId, line1, line2, city, state, postalCode, country, fax, phone, phoneExt )
    VALUES ( 3, 102, 1, '900 Main Street', '', 'Portland', 'OR', '97221', 'United States', '503-555-5678', '503-555-1234', '' );

INSERT INTO jsc.address  ( addressId, customerId, addressTypeId, line1, line2, city, state, postalCode, country, fax, phone, phoneExt )
    VALUES ( 4, 102, 2, '301 Ocean Vista Way', '', 'Yachats', 'OR', '97498', 'United States', '541-555-5678', '541-555-1234', '' );

INSERT INTO jsc.address  ( addressId, customerId, addressTypeId, line1, line2, city, state, postalCode, country, fax, phone, phoneExt )
    VALUES ( 5, 103, 1, 'P.O. Box 460', '', 'Cabo San Lucas', '', '23410', 'Mexico', '(52) 624 14 5 77 00', '(52) 624 14 5 77 22', '' );

INSERT INTO jsc.address  ( addressId, customerId, addressTypeId, line1, line2, city, state, postalCode, country, fax, phone, phoneExt )
    VALUES ( 6, 103, 2, '22 Calle Paradiso', '', 'Cabo San Lucas', '', '23410', 'Mexico', '(52) 624 14 5 77 00', '(52) 624 14 5 77 22', '' );



-- bikeOrder
INSERT INTO jsc.bikeOrder ( orderId, customerId, orderCreatedDate, shipToAddressId, shippingCost, tax, total,  specialInstructions, orderShippedDate  )
    VALUES ( 1001, 102, '2005-05-01', 3, 12.53, 32.40, 756.20, '', NULL );

INSERT INTO jsc.bikeOrder ( orderId, customerId, orderCreatedDate, shipToAddressId, shippingCost, tax, total,  specialInstructions, orderShippedDate  )
    VALUES ( 1002, 102, '2005-05-15', 3, 12.53, 32.40, 756.20, '', '2005-05-21' );

INSERT INTO jsc.bikeOrder ( orderId, customerId, orderCreatedDate, shipToAddressId, shippingCost, tax, total,  specialInstructions, orderShippedDate  )
    VALUES ( 1003, 102, '2005-06-01', 3, 12.53, 32.40, 756.20, '', NULL );

INSERT INTO jsc.bikeOrder ( orderId, customerId, orderCreatedDate, shipToAddressId, shippingCost, tax, total,  specialInstructions, orderShippedDate  )
    VALUES ( 1004, 102, '2005-06-03', 3, 12.53, 32.40, 756.20, '', '2005-06-10' );

INSERT INTO jsc.bikeOrder ( orderId, customerId, orderCreatedDate, shipToAddressId, shippingCost, tax, total,  specialInstructions, orderShippedDate  )
    VALUES ( 1005, 101, '2005-06-01', 1, 45.27, 142.76, 999.120, '', NULL );

-- orderLineItem
INSERT INTO jsc.orderLineItem ( orderLineItemId, orderId, partId, quantity)
	VALUES ( 1, 1001, 2, 1);
INSERT INTO jsc.orderLineItem ( orderLineItemId, orderId, partId, quantity)
	VALUES ( 2, 1001, 6, 1);
INSERT INTO jsc.orderLineItem ( orderLineItemId, orderId, partId, quantity)
	VALUES ( 3, 1001, 9, 1);
INSERT INTO jsc.orderLineItem ( orderLineItemId, orderId, partId, quantity)
	VALUES ( 4, 1001, 12, 1);
INSERT INTO jsc.orderLineItem ( orderLineItemId, orderId, partId, quantity)
	VALUES ( 5, 1001, 15, 1);

INSERT INTO jsc.orderLineItem ( orderLineItemId, orderId, partId, quantity)
	VALUES ( 6, 1002, 2, 1);
INSERT INTO jsc.orderLineItem ( orderLineItemId, orderId, partId, quantity)
	VALUES ( 7, 1002, 6, 1);
INSERT INTO jsc.orderLineItem ( orderLineItemId, orderId, partId, quantity)
	VALUES ( 8, 1002, 9, 1);
INSERT INTO jsc.orderLineItem ( orderLineItemId, orderId, partId, quantity)
	VALUES ( 9, 1002, 12, 1);
INSERT INTO jsc.orderLineItem ( orderLineItemId, orderId, partId, quantity)
	VALUES ( 10, 1002, 15, 1);

INSERT INTO jsc.orderLineItem ( orderLineItemId, orderId, partId, quantity)
	VALUES ( 11, 1003, 2, 1);
INSERT INTO jsc.orderLineItem ( orderLineItemId, orderId, partId, quantity)
	VALUES ( 12, 1003, 6, 1);
INSERT INTO jsc.orderLineItem ( orderLineItemId, orderId, partId, quantity)
	VALUES ( 13, 1003, 9, 1);
INSERT INTO jsc.orderLineItem ( orderLineItemId, orderId, partId, quantity)
	VALUES ( 14, 1003, 12, 1);
INSERT INTO jsc.orderLineItem ( orderLineItemId, orderId, partId, quantity)
	VALUES ( 15, 1003, 15, 1);

INSERT INTO jsc.orderLineItem ( orderLineItemId, orderId, partId, quantity)
	VALUES ( 16, 1004, 3, 1);
INSERT INTO jsc.orderLineItem ( orderLineItemId, orderId, partId, quantity)
	VALUES ( 17, 1004, 4, 1);
INSERT INTO jsc.orderLineItem ( orderLineItemId, orderId, partId, quantity)
	VALUES ( 18, 1004, 7, 1);
INSERT INTO jsc.orderLineItem ( orderLineItemId, orderId, partId, quantity)
	VALUES ( 19, 1004, 11, 1);
INSERT INTO jsc.orderLineItem ( orderLineItemId, orderId, partId, quantity)
	VALUES ( 20, 1004, 13, 1);

-- end


