/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.uml.ui.products.ad.compartments;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.uml.common.Util;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamespace;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.NbBundle;


/**
 *
 * @author  Craig Conover, craig.conover@sun.com
 */
public class DuplicateElementRenamePanel extends javax.swing.JPanel
    implements DocumentListener, ActionListener
{
    private INamespace targetNamespace = null;
    private INamedElement sourceElement = null;
    
    /**
     * 
     * @param targetNamespace The target parent element being dropped on.
     * @param sourceElement The element being DnD'ed.
     * @param dupeName The offending, duplicated name of the element being DnD'ed.
     */
    public DuplicateElementRenamePanel(
        INamespace targetNamespace,
        INamedElement sourceElement,
        String dupeName)
    {
        this.targetNamespace = targetNamespace;
        this.sourceElement = sourceElement;
        
        initComponents();
        newNameText.getDocument().addDocumentListener(this);
        newNameText.setText(dupeName);
        
        enable = false;
        valid = false;
        notifyPropertyListeners();
        
        messageLabel.setText(NbBundle.getMessage(
            DuplicateElementRenamePanel.class, 
            "MSG_DuplicateElementRenameMessage", dupeName));
    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents()
    {

        projectTypeButtonGroup = new javax.swing.ButtonGroup();
        messageLabel = new javax.swing.JLabel();
        newNameLabel = new javax.swing.JLabel();
        newNameText = new javax.swing.JTextField();
        statusLabel = new javax.swing.JLabel();

        messageLabel.setText("(Duplicate Rename Message)");

        newNameLabel.setLabelFor(newNameText);
        org.openide.awt.Mnemonics.setLocalizedText(newNameLabel, org.openide.util.NbBundle.getMessage(DuplicateElementRenamePanel.class, "LBL_TargetProject")); // NOI18N

        statusLabel.setForeground(new java.awt.Color(0, 0, 255));
        statusLabel.setText("<field validation status message>");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(messageLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 303, Short.MAX_VALUE)
                    .add(statusLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 303, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(10, 10, 10)
                        .add(newNameLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(newNameText, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 195, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(messageLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(newNameLabel)
                    .add(newNameText, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(statusLabel))
        );

        messageLabel.getAccessibleContext().setAccessibleDescription("");
        newNameLabel.getAccessibleContext().setAccessibleName("");
        newNameLabel.getAccessibleContext().setAccessibleDescription(null);
        newNameText.getAccessibleContext().setAccessibleName("");
        newNameText.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(DuplicateElementRenamePanel.class, "ACSD_NewName")); // NOI18N
        statusLabel.getAccessibleContext().setAccessibleName("Dialog field validation message");
        statusLabel.getAccessibleContext().setAccessibleDescription("Reports the validation messages for all of the input fields of this dialog.");
    }// </editor-fold>//GEN-END:initComponents

    public void requestFocus()
    {
        newNameText.requestFocus();
        updateValidStatus();
    }
    
    private void initListeners()
    {
    }

    // DocumentListener interface implementation
    ////////////////////////////////////////////
    
    public void changedUpdate(DocumentEvent event)
    {
        updateTexts(event);
        
        if (newNameText.getDocument() == event.getDocument())
        {
            firePropertyChange(
                DuplicateElementRenameDescriptor.PROP_NEW_NAME,
                null, newNameText.getText());
       }
    }
    
    public void insertUpdate( DocumentEvent event )
    {
        updateTexts(event);
        
        if (newNameText.getDocument() == event.getDocument())
        {
            firePropertyChange(
                DuplicateElementRenameDescriptor.PROP_NEW_NAME, 
                null, newNameText.getText());
        }
    }
    
    public void removeUpdate(DocumentEvent event)
    {
        updateTexts(event);
        
        if (newNameText.getDocument() == event.getDocument())
        {
            firePropertyChange(
                DuplicateElementRenameDescriptor.PROP_NEW_NAME, 
                null, newNameText.getText());
        }
    }
    
    
    /** 
     * Handles changes in the Project name and project directory
     */
    private void updateTexts(DocumentEvent event)
    {
        Document doc = event.getDocument();
        
        if (doc == newNameText.getDocument())
        {
            updateValidStatus();
        }
    }
    

    // OK or Cancel button clicked
    public void actionPerformed(ActionEvent event)
    {
//        if (event.getActionCommand().equals("OK")) // NOI18N
//        {
//            // TODO: do something ???
//        }
    }

    /**
     * 
     * @return The new name provided by the user.
     */
    public String getNewName()
    {
        return newNameText.getText();
    }


    private boolean updateValidStatus()
    {
        enable = true;
        statusMsg = " "; // NOI18N
        
        if (newNameText.getText() == null || 
            newNameText.getText().trim().equals("") ||
            Util.invalidIdentifier(newNameText.getText()))
        {
            enable = Boolean.FALSE;
            statusMsg = "ERR_INVALID_NAME"; // NOI18N
        }

        else if (Util.containsSimilarElement(
            targetNamespace, newNameText.getText(), 
            sourceElement.getElementType(), sourceElement))
        {
            enable = Boolean.FALSE;
            statusMsg = "ERR_SimilarElement"; // NOI18N
        }
        
        return notifyPropertyListeners();
    }
    
    private boolean notifyPropertyListeners()
    {
        firePropertyChange(
            NotifyDescriptor.PROP_VALID, !enable, enable);

        if (!statusMsg.trim().equals(""))
        {
            statusLabel.setText(NbBundle.getMessage(
                DuplicateElementRenamePanel.class, statusMsg));
        }
        
        else
            statusLabel.setText(statusMsg);
        
        valid = enable;
        return valid;

    }

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel messageLabel;
    private javax.swing.JLabel newNameLabel;
    private javax.swing.JTextField newNameText;
    private javax.swing.ButtonGroup projectTypeButtonGroup;
    private javax.swing.JLabel statusLabel;
    // End of variables declaration//GEN-END:variables

    private boolean valid = true;
    private String statusMsg = " "; // NOI18N
    private boolean enable = false;
    
    private String PROP_NEW_NAME = "PROP_PROJECT_NAME"; // NOI18N

}
