/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.j2ee.websphere6.config;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.xml.namespace.NamespaceContext;
import org.netbeans.modules.j2ee.deployment.plugins.api.*;
import org.netbeans.modules.j2ee.websphere6.config.sync.EjbSynchronizer;
import org.netbeans.modules.j2ee.websphere6.dd.beans.WSEjbBnd;
import org.netbeans.modules.j2ee.websphere6.dd.beans.WSEjbExt;
import org.netbeans.modules.j2ee.websphere6.util.*;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.*;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import org.openide.util.Exceptions;

/**
 * EJB module deployment configuration handles ws-ejb-jar-bnd.xmi and
 * ws-ebj-jar-ext.xmi configuration files creation.
 *
 *
 * @author dlipin
 * @author ksorokin
 */
public class EjbDeploymentConfiguration extends WSDeploymentConfiguration {
    private File[] files;
    
    private WSEjbExt WSEjbJarExt;
    private WSEjbBnd WSEjbJarBnd;
    
    
    private String IDENTITY_XSLT_WITH_INDENT =
            "<xsl:stylesheet version='1.0' " +                     //NOI18N
            "xmlns:xsl='http://www.w3.org/1999/XSL/Transform' " +  //NOI18N
            "xmlns:xalan='http://xml.apache.org/xslt' " +          //NOI18N
            "exclude-result-prefixes='xalan'>" +                   //NOI18N
            "<xsl:output method='xml' indent='yes' " +             //NOI18N
            "xalan:indent-amount='4'/>" +                          //NOI18N
            "<xsl:template match='@*|node()'>" +                   //NOI18N
            "<xsl:copy>" +                                         //NOI18N
            "<xsl:apply-templates select='@*|node()'/>" +          //NOI18N
            "</xsl:copy>" +                                        //NOI18N
            "</xsl:template>" +                                    //NOI18N
            "</xsl:stylesheet>";                                   //NOI18N
    
    
    /**
     * Creates a new instance of EjbDeploymentConfiguration
     */
    public EjbDeploymentConfiguration(DeploymentManager dm,
            DeployableObject deployableObject,
            InstanceProperties ip) throws InvalidModuleException{
        super(dm,deployableObject,ip);
    }
    
    /**
     * EjbDeploymentConfiguration initialization. This method should be called
     * before this class is used.
     *
     * @param files deployment descriptor files
     */
    public void init(File[] files) {
        this.files = files;
        getWSEjbJarExt();
        getWSEjbJarBnd();
        
        String path =
                ((files.length > 0) ? files[0].getParent() : "");     // NOI18N
        
        File ejbJar =
                new File(path + File.separator + "ejb-jar.xml");      // NOI18N
        
        File ibmejbjarbndFile = null;
        
        if (files.length > 0) {
            if (dataObjects == null) {
                dataObjects = new DataObject[files.length];
                try {
                    for (int i = 0; i < dataObjects.length; i++) {
                        dataObjects[i] = dataObjects[i].find(
                                FileUtil.toFileObject(files[i]));
                    }
                } catch(DataObjectNotFoundException donfe) {
                    Exceptions.printStackTrace(donfe);
                }
            }
            
            for (int i = 0; i < files.length; i++) {
                WSDebug.notify(files[i].getName());
                if (files[i].getName().equals("ibm-ejb-jar-bnd.xmi")) {
                    ibmejbjarbndFile = files[i];
                }
            }
        }
        
        if (ejbJar.exists()) {
            String contents = WSUtil.readFile(ejbJar);
            
            String ID = "id=\"ID_ejb_jar\"";
            if(contents!=null && contents.indexOf(ID)==-1) {
                String EjbJarTagOpen = "<ejb-jar";
                String EjbJarTagClose = ">";
                int startIndex = contents.indexOf(EjbJarTagOpen);
                if(startIndex!=-1) {
                    String afterTageOpen = contents.substring(startIndex + EjbJarTagOpen.length());
                    String tag = afterTageOpen.substring(0,afterTageOpen.indexOf(EjbJarTagClose));
                    if(tag.indexOf(ID)==-1) {
                        WSUtil.writeFile(ejbJar , contents.replaceFirst(EjbJarTagOpen + " ",
                                EjbJarTagOpen + " " + ID +" \n    "));
                    }
                }
            }
            
            final EjbSynchronizer ejbSync = new EjbSynchronizer(ejbJar, ibmejbjarbndFile);
            ejbSync.addSyncFile(ejbJar);            
        }
    }
    
    /**
     * Return WSEjbJarExt graph. If it was not created yet, load it from the
     * files and cache it. If the files does not exist, generate it.
     *
     * @return WSEjbJarExt graph or null if the ws-ejb-jar-ext.xml files is not
     * parseable.
     */
    public synchronized WSEjbExt getWSEjbJarExt() {
        if (WSEjbJarExt == null) {
            try {
                for (int i = 0; i < files.length; i++) {
                    if (!files[i].getName().equals("ibm-ejb-jar-ext.xmi")) {
                        continue;
                    }
                    if (files[i].exists()) {
                        try {
                            WSEjbJarExt = new WSEjbExt(files[i], false);
                        }
                        catch (IOException ioe) {
                            Exceptions.printStackTrace(ioe);
                        }
                        catch (RuntimeException re) {
                        }
                    } else {
                        // create WS-ejb-jar.xml if it does not exist yet
                        WSEjbJarExt = new WSEjbExt();
                        WSEjbJarExt.setDefaults();
                        writefile(files[i], WSEjbJarExt);
                    }
                }
            } catch (ConfigurationException ce) {
                Exceptions.printStackTrace(ce);
            }
        }
        
        return WSEjbJarExt;
    }
    
    /**
     * Return WSEjbJarBnd graph. If it was not created yet, load it from the
     * files and cache it. If the files does not exist, generate it.
     *
     * @return WSEjbJarBnd graph or null if the ws-ejb-jar-bnd.xml files is not
     * parseable.
     */
    public synchronized WSEjbBnd getWSEjbJarBnd() {
        if (WSEjbJarBnd == null) {
            try {
                for (int i = 0; i < files.length; i++) {
                    if (!files[i].getName().equals("ibm-ejb-jar-bnd.xmi")) {
                        continue;
                    }
                    if (files[i].exists()) {
                        try {
                            WSEjbJarBnd = new WSEjbBnd(files[i], false);
                        }
                        catch (IOException ioe) {
                            Exceptions.printStackTrace(ioe);
                        }
                        catch (RuntimeException re) {
                        }
                    } else {
                        WSEjbJarBnd = new WSEjbBnd();
                        WSEjbJarBnd.setDefaults();
                        writefile(files[i], WSEjbJarBnd);
                    }
                }
            } catch (ConfigurationException ce) {
                Exceptions.printStackTrace(ce);
            }
        }
        
        return WSEjbJarBnd;
    }
    private class EjbJarNSC implements NamespaceContext {
        public String getPrefix(String namespaceURI) {
            return "ejbbnd";
        }
        public String getNamespaceURI(String prefix) {
            return "ejbbnd.xmi";
        }
        public Iterator getPrefixes(String namespaceURI) {
            return null;
        }
    }
    
}
