/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
/*
 * ServletRefCustomizer.java
 *
 * Created on September 4, 2003, 5:28 PM
 */

package org.netbeans.modules.j2ee.sun.share.configbean.customizers;
import java.util.ResourceBundle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JLabel;

import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.ServletRef;
import org.netbeans.modules.j2ee.sun.share.configbean.ServletVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.BaseCustomizer;


/**
 *
 * @author Peter Williams
 */
public class ServletRefCustomizer extends BaseCustomizer implements 
	PropertyChangeListener {
	
	private final ResourceBundle customizerBundle = ResourceBundle.getBundle(
		"org.netbeans.modules.j2ee.sun.share.configbean.customizers.Bundle");	// NOI18N

	private ServletRef theBean;
	private boolean servlet24FeaturesVisible;

    // true if AS 9.0+ fields are visible.
    private boolean as90FeaturesVisible;
    
	/** Creates new form ServletRefCustomizer */
	public ServletRefCustomizer() {
		initComponents();
		initUserComponents();
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        jLblName = new javax.swing.JLabel();
        jTxtName = new javax.swing.JTextField();
        jLblRoleUsageDescription = new javax.swing.JLabel();
        jLblRunAsRoleName = new javax.swing.JLabel();
        jTxtRunAsRoleName = new javax.swing.JTextField();
        jLblPrincipalName = new javax.swing.JLabel();
        jTxtPrincipalName = new javax.swing.JTextField();
        jLblClassNameUsageDesc = new javax.swing.JLabel();
        jLblClassName = new javax.swing.JLabel();
        jTxtClassName = new javax.swing.JTextField();
        jLblEndpointHelp = new javax.swing.JLabel();
        jPnlFiller = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jLblName.setLabelFor(jTxtName);
        jLblName.setText(customizerBundle.getString("LBL_ServletName_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel1.add(jLblName, gridBagConstraints);

        jTxtName.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        jPanel1.add(jTxtName, gridBagConstraints);
        jTxtName.getAccessibleContext().setAccessibleName(customizerBundle.getString("ACSN_ServletName"));
        jTxtName.getAccessibleContext().setAccessibleDescription(customizerBundle.getString("ACSD_ServletName"));

        jLblRoleUsageDescription.setLabelFor(jTxtPrincipalName);
        jLblRoleUsageDescription.setText(customizerBundle.getString("LBL_ServletRunAsDescription"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        jPanel1.add(jLblRoleUsageDescription, gridBagConstraints);

        jLblRunAsRoleName.setLabelFor(jTxtRunAsRoleName);
        jLblRunAsRoleName.setText(customizerBundle.getString("LBL_RunAsRole_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        jPanel1.add(jLblRunAsRoleName, gridBagConstraints);

        jTxtRunAsRoleName.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPanel1.add(jTxtRunAsRoleName, gridBagConstraints);
        jTxtRunAsRoleName.getAccessibleContext().setAccessibleName(customizerBundle.getString("ACSN_RunAsRole"));
        jTxtRunAsRoleName.getAccessibleContext().setAccessibleDescription(customizerBundle.getString("ACSD_RunAsRole"));

        jLblPrincipalName.setLabelFor(jTxtPrincipalName);
        jLblPrincipalName.setText(customizerBundle.getString("LBL_PrincipalName_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        jPanel1.add(jLblPrincipalName, gridBagConstraints);

        jTxtPrincipalName.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jTxtPrincipalNameKeyReleased(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPanel1.add(jTxtPrincipalName, gridBagConstraints);
        jTxtPrincipalName.getAccessibleContext().setAccessibleName(customizerBundle.getString("ACSN_PrincipalName"));
        jTxtPrincipalName.getAccessibleContext().setAccessibleDescription(customizerBundle.getString("ACSD_PrincipalName"));

        jLblClassNameUsageDesc.setLabelFor(jTxtClassName);
        jLblClassNameUsageDesc.setText(customizerBundle.getString("LBL_PrincipalClassNameDesc"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        jPanel1.add(jLblClassNameUsageDesc, gridBagConstraints);

        jLblClassName.setLabelFor(jTxtClassName);
        jLblClassName.setText(customizerBundle.getString("LBL_ClassName_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        jPanel1.add(jLblClassName, gridBagConstraints);

        jTxtClassName.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jTxtClassNameKeyReleased(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPanel1.add(jTxtClassName, gridBagConstraints);
        jTxtClassName.getAccessibleContext().setAccessibleName(customizerBundle.getString("ACSN_ClassName"));
        jTxtClassName.getAccessibleContext().setAccessibleDescription(customizerBundle.getString("ACSD_ClassName"));

        jLblEndpointHelp.setText(customizerBundle.getString("LBL_EndpointHelp"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        jPanel1.add(jLblEndpointHelp, gridBagConstraints);
        jLblEndpointHelp.getAccessibleContext().setAccessibleName(customizerBundle.getString("ACSN_EndpointHelp"));
        jLblEndpointHelp.getAccessibleContext().setAccessibleDescription(customizerBundle.getString("ACSD_EndpointHelp"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 5, 5);
        add(jPanel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(jPnlFiller, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents

    private void jTxtClassNameKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTxtClassNameKeyReleased
		// Add your handling code here:
		if(theBean != null) {
			try {
				theBean.setClassName(jTxtClassName.getText());
				validateField(ServletRef.FIELD_PRINCIPAL_CLASS_NAME);
			} catch(java.beans.PropertyVetoException exception) {
				jTxtClassName.setText(theBean.getClassName());
			}
		}	
    }//GEN-LAST:event_jTxtClassNameKeyReleased

	private void jTxtPrincipalNameKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTxtPrincipalNameKeyReleased
		// Add your handling code here:
		if(theBean != null) {
			try {
				theBean.setPrincipalName(jTxtPrincipalName.getText());
			} catch(java.beans.PropertyVetoException exception) {
				jTxtPrincipalName.setText(theBean.getPrincipalName());
			}
		}		
	}//GEN-LAST:event_jTxtPrincipalNameKeyReleased

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLblClassName;
    private javax.swing.JLabel jLblClassNameUsageDesc;
    private javax.swing.JLabel jLblEndpointHelp;
    private javax.swing.JLabel jLblName;
    private javax.swing.JLabel jLblPrincipalName;
    private javax.swing.JLabel jLblRoleUsageDescription;
    private javax.swing.JLabel jLblRunAsRoleName;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPnlFiller;
    private javax.swing.JTextField jTxtClassName;
    private javax.swing.JTextField jTxtName;
    private javax.swing.JTextField jTxtPrincipalName;
    private javax.swing.JTextField jTxtRunAsRoleName;
    // End of variables declaration//GEN-END:variables

	private void initUserComponents() {
		as90FeaturesVisible = true;
		servlet24FeaturesVisible = true;
        
		// Add title panel
		addTitlePanel(customizerBundle.getString("TITLE_Servlet"));	// NOI18N
		getAccessibleContext().setAccessibleName(customizerBundle.getString("ACSN_Servlet"));	// NOI18N
		getAccessibleContext().setAccessibleDescription(customizerBundle.getString("ACSD_Servlet"));	// NOI18N

		// Add error panel
		addErrorPanel();
	}

	protected void initFields() {
		jTxtName.setText(theBean.getServletName());

        if(ASDDVersion.SUN_APPSERVER_9_0.compareTo(theBean.getAppServerVersion()) <= 0) {
            showAS90Fields();
        } else {
            hideAS90Fields();
        }
        
        handleRoleFields();
		
		if(theBean.getJ2EEModuleVersion().compareTo(ServletVersion.SERVLET_2_4) >= 0) {
			showWebServiceEndpointInformation();
		} else {
			hideWebServiceEndpointInformation();
		}
	}
	
	private void handleRoleFields() {
		String runAsRole = theBean.getRunAsRoleName();
		if(Utils.notEmpty(runAsRole)) {
            enableRoleFields(true, runAsRole, theBean.getPrincipalName(), theBean.getClassName());
		} else {
            enableRoleFields(false, "", "", "");
		}
	}
    
    private void enableRoleFields(boolean enabled, String runAs, String pn, String cn) {
        jLblRunAsRoleName.setEnabled(enabled);
        jTxtRunAsRoleName.setText(runAs);
        jLblPrincipalName.setEnabled(enabled);
        jTxtPrincipalName.setEditable(enabled);
        jTxtPrincipalName.setEnabled(enabled);
        jTxtPrincipalName.setText(pn);
        jLblClassName.setEnabled(enabled);
        jTxtClassName.setEditable(enabled);
        jTxtClassName.setEnabled(enabled);
        jTxtClassName.setText(cn);
    }
	
	private void showWebServiceEndpointInformation() {
		if(!servlet24FeaturesVisible) {
            jLblEndpointHelp.setVisible(true);
			servlet24FeaturesVisible = true;
		}
	}
	
	private void hideWebServiceEndpointInformation() {
		if(servlet24FeaturesVisible) {
            jLblEndpointHelp.setVisible(false);
			servlet24FeaturesVisible = false;
		}
	}

    private void showAS90Fields() {
        if(!as90FeaturesVisible) {
            jLblClassNameUsageDesc.setVisible(true);
            jLblClassName.setVisible(true);
            jTxtClassName.setVisible(true);
            as90FeaturesVisible = true;
        }
    }
    
    private void hideAS90Fields() {
        if(as90FeaturesVisible) {
            jLblClassNameUsageDesc.setVisible(false);
            jLblClassName.setVisible(false);
            jTxtClassName.setVisible(false);
            as90FeaturesVisible = false;
        }
    }
    
	public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
		String eventName = propertyChangeEvent.getPropertyName();
		
		if(ServletRef.SERVLET_NAME.equals(eventName)) {
			jTxtName.setText(theBean.getServletName());
		} else if(ServletRef.RUN_AS_ROLE_NAME.equals(eventName)) {
			handleRoleFields();
		}
	}
	
	protected void addListeners() {
		super.addListeners();
		theBean.addPropertyChangeListener(this);
	}
	
	protected void removeListeners() {
		super.removeListeners();
		theBean.removePropertyChangeListener(this);
	}
	
	protected boolean setBean(Object bean) {
		boolean result = super.setBean(bean);
		
		if(bean instanceof ServletRef) {
			theBean = (ServletRef) bean;
			result = true;
		} else {
			// if bean is not a ServletRef, then it shouldn't have passed Base either.
			assert (result == false) : 
				"ServletRefCustomizer was passed wrong bean type in setBean(Object bean)";	// NOI18N
				
			theBean = null;
			result = false;
		}
		
		return result;
	}	
	
	public String getHelpId() {
		return "AS_CFG_Servlet";	// NOI18N
	}
}
