/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.JavaToCOMBridge;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 * DeOrphanize class fixes the orphan elements (elements without namespaces) issue in SAP DI COM service
 *  Used for post processing of SAP DI COM service SOAP 1.2 output.
 * AB: 09-May-07 : fixed xmlns
 * @author Ashish Banerjee
 */
public class DeOrphanize {
    private String ns;
    /**
     *
     */
    public static final String DIS_NS = "http://www.sap.com/SBO/DIS";
    /**
     *
     */
    public DeOrphanize() {
        ns = DIS_NS ;
    }
    /**
     *
     * @param targetNS
     */
    public DeOrphanize(String targetNS) {
        ns = targetNS;
    }
    /**
     * fixes default namespace in the input XML string, after converting it into DOM object,
     * @param in
     * @return
     * @throws javax.xml.transform.TransformerConfigurationException
     * @throws javax.xml.transform.TransformerException
     * @throws javax.xml.parsers.ParserConfigurationException
     * @throws java.io.IOException
     * @throws org.xml.sax.SAXException
     */
    public String transform(String in) throws TransformerConfigurationException, TransformerException, ParserConfigurationException, IOException, SAXException {
        DocumentBuilder docBuild =  DocumentBuilderFactory.newInstance().newDocumentBuilder();
        ByteArrayInputStream bis = new ByteArrayInputStream(in.getBytes());
        Document doc = docBuild.parse(bis);
        //Document doc =  docBuild.newDocument();
        // Node ndx = doc.importNode(doc1.getDocumentElement(), true); //.getFirstChild()
        Node ndx =  doc.getDocumentElement();
        NSSetter settr = new NSSetter(ns);
        settr.modify(ndx);
        //doc.appendChild(ndx);
        
        return Dom2String(doc);
    }
    /**
     * Converts a DOM object to a string
     * @param dox Document which is converted to a string
     * @return
     * @throws javax.xml.transform.TransformerConfigurationException
     * @throws javax.xml.transform.TransformerException
     */
    public static String Dom2String(Document dox) throws TransformerConfigurationException, TransformerException {
        Transformer xfor = TransformerFactory.newInstance().newTransformer() ;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamResult rez = new StreamResult(bos);
        Source source = new DOMSource(dox);
        xfor.transform(source, rez);
        return bos.toString();
    }
}
/**
 *  Helper class that provides default namespace to the elements without a namespace.
 */
class NSSetter {
    private String ns;
    public NSSetter(String ns) {
        this.ns = ns;
    }
    /**
     * Fixes the Node and all its children.
     */
    public void modify(Node ndx) {
        NodeList lst = ndx.getChildNodes();
        int numEle = lst.getLength();
        for(int i=0; i < numEle; i++) {
            Node nd = lst.item(i);
            //System.out.println("node= "+nd.getNodeName());
            if(Node.ELEMENT_NODE == nd.getNodeType()){
                //System.out.println("attr = " + ((Element)nd).getPrefix());
                 // TODO: if(nd.getPrefix() == null)  always is true, why?
                if(nd.getNodeName().indexOf(':') < 0 ) {                   
                   // System.out.println("setting "+nd.getNodeName());
                  //  System.out.println("ns uri = "+nd.getNamespaceURI() );
                    ((Element)nd).setAttribute("xmlns", ns);
                }
                //System.out.println(((Element)nd).getChildNodes().getLength());
                if( nd.getChildNodes().getLength() >= 1)
                    modify(nd);
            }
        }
    }
}
