/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.JavaToCOMBridge;

import java.io.*;
import java.net.*;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.xml.transform.TransformerException;

/**
 * This Servlet is a DI Server COM service wrapper.
 *
 * Change History: AB: 26Apr07: Added DeOrphanizer code, to cater to SOAP 1.2 binding and no default NS issue.
 *                 AB: 21 May 07: Added WSDL extraction emulation feature.
 *                 AB: 23 May 07: Minor changes to support extended class
 * @author Ashish Banerjee/ Archana Saxena
 * @version 1.2
 */
public class JavaToCOMBridgeServlet extends HttpServlet {
    INode node=ClassFactory.createNode();
    XSLTWrapper xf_pre = null;
    //XSLTWrapper xf_post = null;
    DeOrphanize xf_post = null;
    
    public static final String WSDL_DIR ="WEB-INF/wsdl";
    /**
     * The WSDL file to serve when we get ?wsdl get request
     */
    public static final String WSDL_FILE ="JavaToCOMService.wsdl";
    private String wsdlRealPath = null;
    private String wsdlFileContent = null;
    protected String wsdl_file = WSDL_FILE;
    
    private static final String XSLT_PRE_FILE = "WEB-INF/xslt/diservice_pre.xsl";
    private static final String XSLT_POST_FILE = "WEB-INF/xslt/diservice_post.xsl";
   private String file2String(String realPath) throws ServletException {
        java.io.FileInputStream fin = null;
        java.lang.String ret = null;
        try {
            
            java.io.File fx = new java.io.File(realPath);
            if (!fx.exists()) {
                throw new javax.servlet.ServletException("Response File [" + realPath + "] does not exists");
            }
            int len = (int) fx.length();
            byte[] arr = new byte[len];
            fin = new java.io.FileInputStream(fx);
            if (fin.read(arr) != len) {
                throw new ServletException("could not readfully");
            }
            ret = new java.lang.String(arr);
            
        } catch (IOException ex) {
            Logger.getLogger("global").log(Level.SEVERE, null, ex);
        } finally {
            try {
                if(fin != null)
                   fin.close();
            } catch (IOException ex) {
                Logger.getLogger("global").log(Level.SEVERE, null, ex);
            }
        }
        if(ret == null)
            throw new ServletException("ERR: Cant load["+realPath+"]");
        return ret;
    }
    
    public void init() throws  ServletException  {
        try {
            javax.servlet.ServletContext ctx = getServletContext();
            java.lang.String path_pre = ctx.getRealPath(XSLT_PRE_FILE);
            java.io.File fx_pre = new java.io.File(path_pre);
            if (!fx_pre.exists()) {
                throw new javax.servlet.ServletException("XSLT File [" + path_pre + "] does not exists");
            }
            xf_pre = new org.netbeans.modules.JavaToCOMBridge.XSLTWrapper(fx_pre);
            xf_post = new org.netbeans.modules.JavaToCOMBridge.DeOrphanize();
            wsdlRealPath = ctx.getRealPath(WSDL_DIR);
            File wsdlDir = new File(wsdlRealPath);
            if(wsdlDir.isDirectory()) {
                wsdlFileContent = file2String(wsdlRealPath + "/" + wsdl_file );
            }else {
                throw new ServletException("ERR: WSDL dir ["+wsdlRealPath+"] does not exists");
            }
        } catch (TransformerException ex) {
            Logger.getLogger("global").log(Level.SEVERE, null, ex);
            throw new javax.servlet.ServletException(ex);
        }
        
    }
    
    /** Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     *  The request is the SOAP request which is transformed and sent to DI COM Service
     *  and the SOAP reply from the COM Service is sent back to the response after transformation.
     *
     * @param request servlet request
     * @throws javax.servlet.ServletException
     * @throws java.io.IOException
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        System.out.println("Inside Process Request"); // TODO: Use log4j instead of console msg.
        // String login1="<?xml version=\"1.0\" encoding=\"UTF-16\"?><env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope\"><env:Body><dis:Login xmlns:dis=\"http://www.sap.com/SBO/DIS\"><DatabaseServer>localhost</DatabaseServer><DatabaseName>SBODemoUS</DatabaseName><DatabaseType>dst_MSSQL2005</DatabaseType><DatabaseUsername>sa</DatabaseUsername><DatabasePassword>B1Admin</DatabasePassword><CompanyUsername>manager</CompanyUsername><CompanyPassword>manager</CompanyPassword><Language>ln_English</Language><LicenseServer></LicenseServer></dis:Login></env:Body></env:Envelope>";
        
        BufferedInputStream bInStream = new BufferedInputStream(request.getInputStream());
        if(request.getContentLength()>0) {
            
            byte[] arr = new byte[request.getContentLength()];
            bInStream.read(arr);
            String soap_in = new String(arr);
            System.out.println("The Input is :"+ soap_in);
            //response.setContentType("text/xml;charset=UTF-16");
            response.setContentType("application/soap+xml;charset=UTF-16"); //AB: modified to SOAP 1.2
            
            //Now transfor this string using the XSLT,so that correct string is reaching the DI server
            String trans_soap_in= null;
            PrintWriter out =null;
            try {
                trans_soap_in = xf_pre.transform(soap_in);
                //String nsSoap12 = "http://www.w3.org/2003/05/soap-envelope";
                //String nsSoap11 = "http://schemas.xmlsoap.org/soap/envelope/";
                //trans_soap_in =  trans_soap_in.replaceAll(nsSoap12, nsSoap11);
                System.out.println("Transformed SOAP input : "+trans_soap_in);
                String soap_out =node.interact(trans_soap_in);
                System.out.println(" SOAP output :"+soap_out);
                String trans_soap_out = xf_post.transform(soap_out);
                trans_soap_out = trans_soap_out.replaceAll("UTF-8","UTF-16");
                System.out.println("Transformed SOAP output :"+trans_soap_out);
                
                //Trannsforming the SOAP Version
                //String finalOutput= trans_soap_out.replaceAll("http://www.w3.org/2003/05/soap-envelope","http://schemas.xmlsoap.org/soap/envelope");
                //response.setContentType("text/xml;charset=UTF-16");
                out = response.getWriter();
                out.print(trans_soap_out);
                
            } catch( Exception ex) {
                ex.printStackTrace();
                out.println("<?xml version=\"1.0\"  encoding=\"UTF-16\" ?> <env:Envelope xmlns:env=\"http://www.w3.org/2003/05/soap-envelope\"><env:Body><env:Fault>");
                out.println("<env:Code><env:Value>env:Sender</env:Value></env:Code> <env:Reason><env:Text xml:lang=\"en\">Sender Exception</env:Text></env:Reason><env:Detail>");
                out.print(ex);
                out.println("</env:Detail> </env:Fault></env:Body></env:Envelope>");
            }finally {
                try { out.close();} catch(Exception xx) {}
            }
        }
        
    }
    
    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @throws javax.servlet.ServletException 
     * @throws java.io.IOException 
     * @param response servlet response
     */
      protected void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        // processRequest(request, response);
        String qry =  request.getQueryString();
        //System.out.println(qry);
        response.setContentType("text/xml;charset=UTF-8");
         PrintWriter out = response.getWriter();
       //System.out.println(ctxPath);

        if(qry != null) {
            if(qry.equalsIgnoreCase("WSDL")) {
                 out.println(wsdlFileContent);
                
            } 
        }
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @throws javax.servlet.ServletException 
     * @throws java.io.IOException 
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     * @return 
     */
    public String getServletInfo() {
        return "SAP DI COM Bridge Servlet. Assumes WSDL 1.1 with SOAP 1.2. Also assumes that DI SOAP has orphan elements. ";
    }
    // </editor-fold>
}
