/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.scripting.php.dbginterface.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.EditorKit;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;


/**
 * A GUI panel for customizing a Watch.

 * @author Maros Sandor
 * @author Peter Williams - copied from JPDA and modified for PHP debugger support.
 *    I'm going to find a way to generalize this panel, so most clients can use
 *    a common class with a few parameters.
 */
public class WatchPanel {

    private JPanel panel;
    private JEditorPane editorPane;
    private String expression;

    public WatchPanel(String expression) {
        this.expression = expression;
    }
    
    public static void setupContext(JEditorPane editorPane) {
        // !PW Not sure exactly why the JPDA debugger was doing this... it appears
        // to be setting StreamDescriptionProperty to the the DataObject of some
        // Java file on the callstack (probably topmost, but whatever getURL(csf, "Java")
        // returns.  StreamDescriptionProperty is part of the editor api and enables
        // _something_, maybe code completion.
        //
        // TODO figure out what we want to do here.  Watch context is very important
        // to get this right (and FWIW, in my experience, JPDA does not necessarily get
        // it right.)
//        DebuggerEngine en = DebuggerManager.getDebuggerManager ().getCurrentEngine();
//        JPDADebugger d = (JPDADebugger) en.lookupFirst(null, JPDADebugger.class);
//        CallStackFrame csf = d.getCurrentCallStackFrame();
//        if (csf != null) {
//            DataObject dobj = null;
//            SourcePath sp = (SourcePath) en.lookupFirst(null, SourcePath.class);
//            String url = sp.getURL(csf, "Java");
//            FileObject file;
//            try {
//                file = URLMapper.findFileObject (new URL (url));
//                if (file != null) {
//                    try {
//                        dobj = DataObject.find (file);
//                    } catch (DataObjectNotFoundException ex) {
//                        // null dobj
//                    }
//                }
//            } catch (MalformedURLException e) {
//                // null dobj
//            }
//            editorPane.getDocument().putProperty(javax.swing.text.Document.StreamDescriptionProperty, dobj);
//        }
    }

    public JComponent getPanel() {
        if (panel != null) return panel;

        panel = new JPanel();
        ResourceBundle bundle = NbBundle.getBundle(WatchPanel.class);

        panel.getAccessibleContext ().setAccessibleDescription (bundle.getString ("ACSD_WatchPanel")); // NOI18N
        JLabel textLabel = new JLabel();
        Mnemonics.setLocalizedText(textLabel, bundle.getString ("CTL_Watch_Name")); // NOI18N

        editorPane = new JEditorPane("text/javascript", expression); // NOI18N
        EditorKit kit = editorPane.getEditorKit();
        if(kit == null || kit.getClass().getSimpleName().contains("PlainEditorKit")) { // NOI18N
            editorPane.setContentType("text/x-javascript"); // NOI18N
        }
        editorPane.setKeymap(new FilteredKeymap(editorPane.getKeymap()));
        
        setupContext(editorPane);
        
        JScrollPane sp = new JScrollPane(editorPane, JScrollPane.VERTICAL_SCROLLBAR_NEVER,
                                                     JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        
        textLabel.setBorder (new EmptyBorder (0, 0, 5, 0));
        panel.setLayout (new BorderLayout ());
        panel.setBorder (new EmptyBorder (11, 12, 1, 11));
        panel.add (BorderLayout.NORTH, textLabel);
        panel.add (BorderLayout.CENTER, sp);
        
        FontMetrics fm = editorPane.getFontMetrics(editorPane.getFont());
        int size = 2*fm.getLeading() + fm.getMaxAscent() + fm.getMaxDescent() + 4;
        
        editorPane.setPreferredSize(new Dimension(30*size, (int) (1*size)));
        
        editorPane.getAccessibleContext ().setAccessibleDescription (bundle.getString ("ACSD_CTL_Watch_Name")); // NOI18N
        editorPane.setBorder (
            new CompoundBorder (editorPane.getBorder (),
            new EmptyBorder (2, 0, 2, 0))
        );
        editorPane.setText (expression);
        editorPane.selectAll ();

        textLabel.setLabelFor (editorPane);
        editorPane.requestFocus ();
        
        return panel;
    }

    public String getExpression() {
        return editorPane.getText().trim();
    }
}
