/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.scripting.php.dbginterface.breakpoints;

import org.netbeans.modules.scripting.php.dbginterface.ModelSupport;
import org.netbeans.modules.scripting.php.dbginterface.Utils;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.netbeans.spi.debugger.ui.Constants;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;

/**
 *
 * @author Matt Stevens (inspired by Ant Debugger)
 * @author Peter Williams
 */
public class BreakpointModel extends ModelSupport
        implements NodeModel, TableModel { //, TreeModel {

    public static final String LINE_BREAKPOINT =
        "org/netbeans/modules/debugger/resources/editor/Breakpoint"; // NOI18N
    public static final String LINE_BREAKPOINT_PC =
        "org/netbeans/modules/debugger/resources/editor/Breakpoint+PC"; // NOI18N
    public static final String DISABLED_LINE_BREAKPOINT =
        "org/netbeans/modules/debugger/resources/editor/DisabledBreakpoint"; // NOI18N

    // ------------------------------------------------------------------------
    // NodeModel implementation
    // ------------------------------------------------------------------------
    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof PhpBreakpoint) {
            PhpBreakpoint breakpoint = (PhpBreakpoint)node;
            FileObject fileObject = (FileObject)breakpoint.getLine().getLookup().lookup(FileObject.class);
            return fileObject.getNameExt() + ":" + (breakpoint.getLine().getLineNumber() + 1);
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof PhpBreakpoint) {
            PhpBreakpoint breakpoint = (PhpBreakpoint)node;
            if(!breakpoint.isEnabled()) {
                return DISABLED_LINE_BREAKPOINT;
            }
            Line line = Utils.getCurrentLine();
            if(line != null && line.getLineNumber() == breakpoint.getLine().getLineNumber()) {
                return LINE_BREAKPOINT_PC;
            }
            return LINE_BREAKPOINT;
        }

        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof PhpBreakpoint) {
            return ((PhpBreakpoint)node).getLine().getDisplayName();
        }

        throw new UnknownTypeException(node);
    }

    // ------------------------------------------------------------------------
    // TableModel implementation
    // ------------------------------------------------------------------------
    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node instanceof PhpBreakpoint) {
            if (columnID.equals(Constants.BREAKPOINT_ENABLED_COLUMN_ID)) {
                return Boolean.valueOf(((PhpBreakpoint)node).isEnabled());
            } else {
                System.out.println("BreakpointModel.getValueAt(node=" + node + ", columnId=" + columnID + ")");
            }
        }

        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if (node instanceof PhpBreakpoint) {
            if (columnID.equals(Constants.BREAKPOINT_ENABLED_COLUMN_ID)) {
                return false;
            } else {
                System.out.println("BreakpointModel.getValueAt(node=" + node + ", columnId=" + columnID + ")");
            }
        }

        throw new UnknownTypeException(node);
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        if(node instanceof PhpBreakpoint) {
            if(columnID.equals(Constants.BREAKPOINT_ENABLED_COLUMN_ID)) {
                if(((Boolean)value).equals(Boolean.TRUE)) {
                    ((PhpBreakpoint)node).enable();
                } else {
                    ((PhpBreakpoint)node).disable();
                }
            }
        } else {
            throw new UnknownTypeException(node);
        }
    }

    // ------------------------------------------------------------------------
    // TreeModel implementation
    // ------------------------------------------------------------------------
//    public Object getRoot() {
//    }
//
//    public Object[] getChildren(Object object, int i, int i0) throws UnknownTypeException {
//    }
//
//    public boolean isLeaf(Object object) throws UnknownTypeException {
//    }
//
//    public int getChildrenCount(Object object) throws UnknownTypeException {
//    }
}
