/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */ 


/*
 * SVGUtils.java
 *
 * Created on January 18, 2007, 9:46 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.microedition.testme.svg.support;

import javax.microedition.lcdui.Image;
import javax.microedition.m2g.SVGAnimator;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;

/**
 * Various JSR226 utility methods 
 * @author breh
 */
public class SVGUtils {
    private static final int RASTER = 5;    
    public static final String VIEWBOX_TRAIT = "viewBox";
    public static final int RGB_MASK = 0x00FFFFFF;

    
    
    private SVGUtils() {
    }
    
    /**
     * Computes coordinate transformation matrix from user to screen coordinate
     * system. 
     *
     * @param svgsvg root svg element
     * @param viewportWidth 
     * @param viewportHeight
     *
     * @return computed coordinate transformation matrix (should has the same value as svgsvg.getScreenCTM())
     */
    public static SVGMatrix computeCTMatrixFromView(SVGSVGElement svgsvg, int viewportWidth, int viewportHeight) {
    
        final SVGRect viewport = svgsvg.createSVGRect();
        SVGRect viewBox = svgsvg.getRectTrait("viewBox");
        
        // compute transformatino matrix for this one
        
        //System.out.println("viewportWidth="+viewportWidth+", viewportHeight="+viewportHeight);
        //System.out.println("currentViwBox="+SVGUtils.toString(viewBox));
        /*System.out.println("preserveAspectRatio="+svgsvg.getTrait("preserveAspectRatio")
                +",zoomAndPan="+svgsvg.getTrait("zoomAndPan"));
         */
        
        // compute aspect ratios and compute the actual viewport width/height
        float viewportAR = (float)viewportWidth/(float)viewportHeight;
        float viewboxAR = viewBox.getWidth()/viewBox.getHeight();        
        int actualViewportWidth = viewportWidth;
        int actualViewportHeight = viewportHeight;
        if (viewportAR < viewboxAR) {
            actualViewportHeight = (int)(((float)viewportHeight)/viewboxAR*viewportAR);
        } else {
            actualViewportWidth = (int)(((float)viewportWidth)/viewportAR*viewboxAR);
        }
        //System.out.println("actualViewportWidth="+actualViewportWidth+", actualViewportHeight="+actualViewportHeight);
        
        // compute scale and translate cooeficients
        float scale = ((float)actualViewportWidth)/viewBox.getWidth();
        float translateX = -viewBox.getX()*scale + ((float)(viewportWidth - actualViewportWidth))/2f;
        float translateY = -viewBox.getY()*scale + ((float)(viewportHeight - actualViewportHeight))/2f;;
        //System.out.println("scale="+scale+", tx="+translateX+", ty="+translateY);
        // create the matrix
        SVGMatrix computedMX = svgsvg.createSVGMatrixComponents(1f,0f,0f,1f,0f,0f).mTranslate(translateX,translateY).mScale(scale);
        return computedMX;
    }
    
    
    /**
     * Resizes current viewbox of the image (using update thread, so the animation
     * needs to be playing
     * 
     * @param animator SVGAnimator playing the image to be zoomed
     * @param svgsvg SVG root element of the image to be zoomed
     * @param x new X coordinate for view box
     * @param y new Y coordinate for view box
     * @param width new width for view box
     * @param height new height
     */
    public static void resizeViewbox(SVGAnimator animator, final SVGSVGElement svgsvg, float x, float y, float width, float height) throws InterruptedException {
        final SVGRect viewport = svgsvg.createSVGRect();
        viewport.setX(x);
        viewport.setY(y);
        viewport.setWidth(width);
        viewport.setHeight(height);
        animator.invokeAndWait(new Runnable() {
           public void run() {
               svgsvg.setRectTrait(VIEWBOX_TRAIT,viewport);
           } 
        });
    }
    
    
    /**
     * Transforms x coordinate of the point using supplied matrix
     * @param x x coordiante of the point
     * @param y y coordinate of the point
     * @param matrix transformation matrix
     * @return transformed x coordinate of the point
     */
    public static float transformXUsingMX(float x, float y, SVGMatrix matrix) {
        float newX = matrix.getComponent(0)*x + matrix.getComponent(2)*y + matrix.getComponent(4);
        return newX;
    }
    
    /**
     * Transforms y coordinate of the point using supplied matrix
     * @param x x coordiante of the point
     * @param y y coordinate of the point
     * @param matrix transformation matrix
     * @return transformed y coordinate of the point
     */
    public static float transformYUsingMX(float x, float y, SVGMatrix matrix) {
        float newY = matrix.getComponent(1)*x + matrix.getComponent(3)*y + matrix.getComponent(5);
        return newY;
    }    
    
    
    /**
     * Transform rectangle using supplied matrix
     *
     * @param svgsvgElement SVG root element
     * @param rect rectangle to transformed
     * @param matrix transformation matrix to be used
     * @return transformed SVGRect 
     */
    public static SVGRect transformUsingMX(SVGSVGElement svgsvgElement, SVGRect rect, SVGMatrix matrix) {
        float newX = transformXUsingMX(rect.getX(),rect.getY(),matrix);
        float newY = transformYUsingMX(rect.getX(),rect.getY(),matrix);
        float widthX = rect.getX() + rect.getWidth();
        float heightY = rect.getY() + rect.getHeight();
        //
        float newWidth = transformXUsingMX(widthX,heightY,matrix) - newX;
        float newHeight = transformYUsingMX(widthX,heightY,matrix) - newY;
        SVGRect newRect = svgsvgElement.createSVGRect();
        newRect.setX(newX);
        newRect.setY(newY);
        newRect.setWidth(newWidth);
        newRect.setHeight(newHeight);
        return newRect;
    }
    
    
    
    
    /**
     * Convenience method for creating SVGRect objects
     */
    public static SVGRect createSVGRect(SVGSVGElement svgsvg, float x, float y, float width, float height) {
        SVGRect r = svgsvg.createSVGRect();
        r.setX(x);
        r.setY(y);
        r.setWidth(width);
        r.setHeight(height);
        return r;
    }
    
    
    /**
     * Tests equality of two rectangled
     */
    public static boolean equals(SVGRect r1, SVGRect r2) {
        if (r1 == r2) return true;
        if ((r1 != null) && (r2 != null)) {
           if (   (r1.getX() == r2.getX()) 
               && (r1.getY() == r2.getY())
               && (r1.getWidth() == r2.getWidth())
               && (r1.getHeight() == r2.getHeight()) ) {
                   return true;
               }
        } // else
        return false; 
    }
        
    /**
     * Tests equality of two matrices
     */
    public static boolean equals(SVGMatrix m1, SVGMatrix m2) {
        if (m1 == m2) return true;
        if ((m1 != null) && (m2 != null)) {
            for (int i=0; i < 6; i++) {
                if (m1.getComponent(i) != m2.getComponent(i)) {
                    return false;
                }
            } // else
            return true;
        } else {
            return false;
        }
    }
    
    /*
     * Test if the given image is empty (i.e. all white). Check only pixels
     * on the specified grid for faster execution.
     */
    public static boolean isImageEmpty(Image img) {
        int w = img.getWidth();
        int h = img.getHeight();
        int [] rgb = new int[1];
        
        for (int i = 0; i < w; i+=RASTER) {
            for (int j = 0; j < h; j+=RASTER) {
                //read single pixel to achive lower memory requirements and faster 
                //response for non empty images
                img.getRGB(rgb, 0, 1, i, j, 1, 1);
                if ((rgb[0] & 0xFFFFFF) != 0xFFFFFF) {
                    int p = rgb[0] & 0xFFFFFF;
                    /*
                    System.out.println( (p >> 16) & 0xFF);
                    System.out.println( (p >> 8) & 0xFF);
                    System.out.println( p & 0xFF);
                     */
                    return false;
                }
            }
        }
        return true;
    }
    
    public static int getPixelColor(Image img, int x, int y) {
        int [] pixelHolder = new int[1];
        img.getRGB( pixelHolder, 0, 1, x, y, 1, 1);
        return pixelHolder[0];
    }
    
    /**
     * Test if the two given images are identical.
     */ 
    public static boolean imagesAreEqual(Image img1, Image img2) {
        int w1 = img1.getWidth();
        int h1 = img1.getHeight();
        int w2 = img2.getWidth();
        int h2 = img2.getHeight();

        if (w1 != w2 || h1 != h2) {
            return false;
        }

        int [] rgb = new int[2];
        
        for (int i = 0; i < w1; i++) {
            for (int j = 0; j < h1; j++) {
                //read single pixel to achive lower memory requirements and faster 
                //response for different images
                img1.getRGB(rgb, 0, 1, i, j, 1, 1);
                img2.getRGB(rgb, 1, 1, i, j, 1, 1);
                if ((rgb[0] & 0xFFFFFF) != (rgb[1] & 0xFFFFFF)) {
                    return false;
                }
            }
        }
        return true;
    }
    
    /**
     * converts rectangle to human readable String
     */
    public static String toString(SVGRect rect) {
        if (rect == null) {
            return "[null]";
        } else {
            return "SVGRect["+rect.getX()+","+rect.getY()+","+rect.getWidth()+","+rect.getHeight()+"]";
        }
    }    
    
    /**
     * converts matrix to human readable String
     */
    public static String toString(SVGMatrix m) {
        if (m == null) {
            return "[null]";
        } else {
            return "SVGMatrix["+m.getComponent(0)+","+m.getComponent(1)
            +","+m.getComponent(2)+","+m.getComponent(3)
            +","+m.getComponent(4)+","+m.getComponent(5)+"]";
        }
    }
    
    /**
     * converts point to human readable String
     */
    public static String toString(SVGPoint p) {
        if (p == null) {
            return "[null]";
        } else {
            return "SVGPoint["+p.getX()+","+p.getY()+"]";
        }
    }

    
    /*
    public static SVGRect convertToUserUnits(SVGSVGElement svgsvg, SVGRect screenBBox, SVGRect viewBox, int viewportWidth, int viewportHeight) {
        SVGRect convertedRect = svgsvg.createSVGRect();
        //float ratioX = imageViewport.getWidth()/(float)displayWidth;
        
        float x = screenBBox.getX() * viewBox.getWidth()/((float)viewportWidth) + viewBox.getX();
        float y = screenBBox.getY() * viewBox.getHeight()/((float)viewportHeight) + viewBox.getY();
        float width = screenBBox.getWidth() * viewBox.getWidth()/((float)viewportWidth);
        float height = screenBBox.getHeight() *  viewBox.getHeight()/((float)viewportHeight);
        convertedRect.setX(x);
        convertedRect.setY(y);
        convertedRect.setWidth(width);
        convertedRect.setHeight(height);
        return convertedRect;
    } */
    
    
}
