/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */ 
package org.netbeans.microedition.testme.svg.support;

import javax.microedition.lcdui.*;
import javax.microedition.m2g.SVGAnimator;
import javax.microedition.m2g.SVGImage;
import javax.microedition.m2g.ScalableGraphics;
import org.netbeans.microedition.testme.TestMIDlet;
import org.netbeans.microedition.testme.svg.tests.UseDefsTest;

/**
 *
 * @author  PavelBenes
 * @version
 */
public abstract class SVGTestMIDlet extends TestMIDlet {
    private SVGImage     m_svgImage;
    private SVGAnimator  m_svgAnimator;
    private final String m_imagePath;

    protected SVGTestMIDlet(String title, int testNum, String imagePath, boolean isAsynchronous) throws Exception {
        super(title, testNum, isAsynchronous);
        m_imagePath = imagePath;
    }
    
    /**
     * setup method (executed before each test)
     */
    protected void setUp() {
        //getSVGCanvas().setFullScreenMode(true);
        getSVGImage().setViewportWidth(getSVGCanvas().getWidth());
        getSVGImage().setViewportHeight(getSVGCanvas().getHeight());  
        getDisplay().setCurrent(getSVGCanvas());
        getSVGAnimator().play();
    }
    
    /**
     * tear down method executed after each test
     */
    protected void tearDown() {
        getSVGAnimator().stop();
        clearImage();
    }
        
    // utility methods
    protected synchronized SVGImage getSVGImage() {
        if (m_svgImage == null) {                       
            try {     
                m_svgImage = (SVGImage) SVGImage.createImage(UseDefsTest.class.getResourceAsStream("/res/" + m_imagePath), null);
            } catch (Exception exception) {
                exception.printStackTrace();
            }                      
        }                       
        return m_svgImage;
    }               
        
    protected synchronized SVGAnimator getSVGAnimator() {
        if (m_svgAnimator == null) {
            m_svgAnimator = SVGAnimator.createAnimator(getSVGImage());
        }
        return m_svgAnimator;
    }
    
    protected Canvas getSVGCanvas() {
        return (Canvas)getSVGAnimator().getTargetComponent();
    }  
    
    protected synchronized Image takeScreenshot() {
        Image img = Image.createImage( getSVGCanvas().getWidth(), getSVGCanvas().getHeight() );
        Graphics buffer = img.getGraphics();
        buffer.setColor(0xFF, 0xFF, 0xFF);
        buffer.fillRect(0, 0, img.getWidth(), img.getHeight());
        ScalableGraphics scalableGraphics = ScalableGraphics.createInstance();
        scalableGraphics.bindTarget( buffer);
        scalableGraphics.render( 0, 0, getSVGImage());
        scalableGraphics.releaseTarget();
        return img;
    }
        
    protected void clearImage() {
        m_svgAnimator = null;
        m_svgImage    = null;
    }  
}
