/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.server.uihandler;

import java.io.*;
import java.net.*;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.*;
import javax.servlet.http.*;
import org.netbeans.lib.uihandler.MultiPartHandler;

/**
 *
 * @author Jaroslav Tulach
 * @version
 */
public class UploadLogs extends HttpServlet {
    private static Logger LOG = Logger.getLogger(UploadLogs.class.getName());
    
    @Override
    public void init() throws ServletException {
        LOG.info("Initializing UploadLogs servlet");
        try {
            LogsManager.getDefault();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
        LOG.info("Done Initializing UploadLogs servlet");
    }

    
    /** Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        String uploadDir = Utils.getVariable("dir", String.class);
        if (uploadDir == null) {
            String msg = "UploadServlet.doPost: dir is null."; 
            LOG.warning(msg);
            request.setAttribute("error", msg);
            response.sendRedirect(request.getContextPath() + "/error.jsp");
            return;
        }
        File dir = new File(uploadDir);
        if (!dir.isDirectory() && !dir.mkdirs()) {
            String msg = "UploadServlet.doPost: " + dir + " is not directory: " + dir.isDirectory(); 
            LOG.warning(msg);
            request.setAttribute("error", msg);
            response.sendRedirect(request.getContextPath() + "/error.jsp");
            return;
        }
        
        
        int maxUploadSize = 1024 * 1024;
        {
            String max = getInitParameter("maxSize"); // NOI18N
            if (max != null) {
                maxUploadSize = Integer.valueOf(max).intValue();
            }
        }
        
        String id = "";
        String contentType = request.getContentType();
        LOG.info("accepting: " + contentType);
        if (contentType != null && contentType.toLowerCase().startsWith("multipart/form-data")) {
            
            RequestFacadeImpl facade = new RequestFacadeImpl(request);
            MultiPartHandler multiReq = new MultiPartHandler(facade, uploadDir, maxUploadSize);
            multiReq.parseMultipartUpload();

            // the file is uploaded as arguments "logs"
            File appFile = multiReq.getFile("logs"); // NOI18N
            long len = 0;
            if (appFile != null) {
                 len = appFile.length();
                 LogsManager.getDefault().addLog(appFile,getIP(request));
            }
            
            String[] idAndSer = appFile.getName().split("\\.");
            id = idAndSer[0];
        }            
        
        request.setAttribute("redirect",  Boolean.TRUE);
        request.setAttribute("id",  id);
        request.getRequestDispatcher("/uploaddone.jsp").forward(request, response);
    }
    
    protected String getIP(HttpServletRequest request){
        String headerIP = request.getHeader("x-forwarded-for");
        if (headerIP == null){
            return request.getRemoteHost();// no Lighttpd
        }
        return headerIP;
    }
    
    private static final class RequestFacadeImpl implements MultiPartHandler.RequestFacade {
        private final HttpServletRequest request;
        private InputFacadeImpl in;
        
        public RequestFacadeImpl(HttpServletRequest req) {
            this.request = req;
        }
        
        public int getContentLength() {
            return request.getContentLength();
        }

        public String getContentType() {
            return request.getContentType();
        }
        public MultiPartHandler.InputFacade getInput() throws IOException {
            if (in == null) {
                in = new InputFacadeImpl(request.getInputStream());
            }
            return in;
        }
        
        private static final class InputFacadeImpl implements MultiPartHandler.InputFacade {
            private final ServletInputStream in;
            
            public InputFacadeImpl(ServletInputStream in) {
                this.in = in;
            }

            public int readLine(byte[] arr, int off, int len) throws IOException {
                return in.readLine(arr, off, len);
            }

            public InputStream getInputStream() {
                return in;
            }
        }
    }
    
    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Uploads Logs Generated By UI Logger - http://logger.netbeans.org/welcome/";
    }
    // </editor-fold>
}
