
package org.netbeans.server.componentsmatch;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/**
 * Package with assigned components. 
 * @author pzajac
 */
public final class Package {
    Map<Component,Component> components = new TreeMap<Component,Component>();
    String name;
    
    Component firstComponent;
    /** Creates a new instance of Package */
    
    public Package(String name) {
        this.name = name;
    }
    
    public void addComponent(Component comp) {
        Component oldComp = components.get(comp);
        if (oldComp == null) {
            components.put(comp,comp);
        } else {
            oldComp.add(comp);
        }
        firstComponent = null;
    }
    
    /** @return component with bigger issues count
     */
    public Component getFirstComponent() {
        if (firstComponent == null) {
            for (Component c : components.keySet()) {
              if (firstComponent == null) {
                  firstComponent = c;
              } else if (c.getIssues() > firstComponent.getIssues()) {
                  firstComponent = c;
              }
            }
        }
        return firstComponent;
    }
    
    public String getName() {
        return name;
    }
    
    public Set<Component> getComponents() {
        return components.keySet();
    }
}
