/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Ralph Krueger.
 */

package org.netbeans.modules.changelog.html;

import java.awt.Image;
import java.beans.*;
import java.io.File;
import java.util.ResourceBundle;

import org.openide.util.NbBundle;

/** Object that provides beaninfo for ChangeLogHTMLService.
*
* @author ralphk
*/
public class ChangeLogHTMLServiceBeanInfo extends SimpleBeanInfo {
    private static Image icon;
    private static Image icon32;


    public BeanInfo[] getAdditionalBeanInfo () {
        return null;
    }

    public BeanDescriptor getBeanDescriptor () {
        BeanDescriptor descr = new BeanDescriptor (ChangeLogHTMLService.class);
        ResourceBundle bundle = NbBundle.getBundle(ChangeLogHTMLServiceBeanInfo.class);
        descr.setDisplayName (bundle.getString ("LAB_ChangeLogHTMLService"));
        descr.setShortDescription (bundle.getString ("HINT_ChangeLogHTMLService"));
        descr.setValue ("helpID", org.netbeans.modules.changelog.html.ChangeLogHTMLService.class.getName ()); // NOI18N
        return descr;
    }

    /** Provides the Jar's icon */
    public Image getIcon(int type) {
        if (icon == null) {
            icon = loadImage("/org/netbeans/modules/changelog/resources/type.gif"); // NOI18N
            icon32 = loadImage("/org/netbeans/modules/changelog/resources/type.gif"); // NOI18N
        }

        if ((type == java.beans.BeanInfo.ICON_COLOR_16x16) || (type == java.beans.BeanInfo.ICON_MONO_16x16))
            return icon;
        else
            return icon32;
    }
}
