/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.refactoring.safedelete;

import java.io.IOException;
import java.text.MessageFormat;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.dd.api.webservices.DDProvider;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponentHandler;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.refactoring.DefaultPositionBoundsResolver;
import org.netbeans.modules.j2ee.refactoring.J2EERefactoring;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;

/**
 * Safe delelete refactoring for web service message handlers. Takes care
 * of propagating changes to webservices.xml.
 *
 * @author Erno Mononen
 */
public class WebservicesXmlSafeDeleteRefactoring implements J2EERefactoring {
    
    private Element element;
    private SafeDeleteRefactoring safeDeleteRefactoring;
    private Webservices webservicesXmlDD;
    private FileObject webservicesXmlFO;
    
    public WebservicesXmlSafeDeleteRefactoring(Element element, SafeDeleteRefactoring safeDeleteRefactoring) {
        this.element = element;
        this.safeDeleteRefactoring = safeDeleteRefactoring;
        FileObject fo = JavaModel.getFileObject(element.getResource());
        WebServicesSupport wsm = WebServicesSupport.getWebServicesSupport(fo);
        if (wsm != null){
            this.webservicesXmlFO = wsm.getWebservicesDD();
            try {
                this.webservicesXmlDD = DDProvider.getDefault().getDDRoot(webservicesXmlFO);
            } catch (IOException ioe) {
                ErrorManager.getDefault().notify(ioe);
            }
        }
    }
    
    public Problem preCheck() {
        return null;
    }
    
    public Problem checkParameters() {
        return null;
    }
    
    public Problem fastCheckParameters() {
        return null;
    }
    
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        
        if (webservicesXmlDD == null){
            return null;
        } else if (webservicesXmlDD.getStatus() == Webservices.STATE_INVALID_UNPARSABLE) {
            return new Problem(false, NbBundle.getMessage(WebservicesXmlSafeDeleteRefactoring.class, "TXT_WebservicesXmlInvalid", webservicesXmlFO.getPath()));
        }
        
        for (Object elem : element.getResource().getClassifiers()) {
            String name = ((JavaClass) elem).getName();
            
            for (WebserviceDescription webService : webservicesXmlDD.getWebserviceDescription()) {
                
                for (PortComponent portComponent : webService.getPortComponent()){
                    
                    for(PortComponentHandler handler : portComponent.getHandler()){
                        
                        if (name.equals(handler.getHandlerClass())){
                            RefactoringElementImplementation refactoringElem =
                                    new WebserviceXmlSafeDeleteRefactoringElement(webservicesXmlDD, portComponent, handler, webservicesXmlFO);
                            refactoringElementsBag.add(safeDeleteRefactoring, refactoringElem);
                        }
                    }
                }
            }
        }
        return null;
        
    }
    
    static class WebserviceXmlSafeDeleteRefactoringElement extends AbstractSafeDeleteRefactoringElement implements ExternalChange {
        
        protected Webservices webservicesXmlDD;
        private PortComponentHandler handler;
        private PortComponent portComponent;
        
        public WebserviceXmlSafeDeleteRefactoringElement(Webservices webservicesXmlDD, PortComponent portComponent, PortComponentHandler handler, FileObject parentFile) {
            this.webservicesXmlDD = webservicesXmlDD;
            this.handler = handler;
            this.portComponent = portComponent;
            this.parentFile = parentFile;
        }
        
        public String getDisplayText() {
            return MessageFormat.format(NbBundle.getMessage(WebservicesXmlSafeDeleteRefactoring.class, "TXT_WebservicesXmlHandlerSafeDelete"), handler.getHandlerName());
        }
        
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }
        
        public void performExternalChange() {
            portComponent.removeHandler(handler);
            write();
        }
        
        public void undoExternalChange() {
            portComponent.addHandler(handler);
            write();
        }
        
        private void write(){
            try {
                webservicesXmlDD.write(parentFile);
            } catch (IOException ioe) {
                ErrorManager.getDefault().notify(ioe);
            }
        }
        
        public PositionBounds getPosition() {
            try {
                return new DefaultPositionBoundsResolver(DataObject.find(getParentFile()), handler.getHandlerClass()).getPositionBounds();
            } catch (DataObjectNotFoundException ex) {
                ErrorManager.getDefault().notify(ex);
            }
            return null;
        }
        
    }
    
}
