/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.refactoring.safedelete;

import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.refactoring.J2EERefactoring;
import org.netbeans.modules.j2ee.refactoring.jaxwssupport.JaxWsXmlRefactoringSupport;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.openide.util.NbBundle;

/**
 * This class handles safe delete refactoring of a web service implementation class
 * that is listed in jax-ws.xml. To be specific, this class does not delete reference to the
 * removed class but collects its usages from jax-ws.xml for displaying these
 * as problems to the user.
 *
 * @author Erno Mononen
 */
public class JaxWsXmlSafeDeleteRafactoring extends JaxWsXmlRefactoringSupport implements J2EERefactoring {
    
    /**
     * The java class that's being removed.
     */
    private JavaClass javaClass;
    
    /**
     * Creates a new instance of JaxWsXmlSafeDeleteRafactoring
     */
    public JaxWsXmlSafeDeleteRafactoring(JavaClass javaClass) {
        this.javaClass = javaClass;
    }
    
    /**
     * Checks whether the java class to be removed is listed as an implementation 
     * class in jax-ws.xml and returns appropriate problem (warning) if it is.
     */
    public Problem preCheck() {
        JaxWsModel model = getModel(javaClass);
        if (!isWebSvcFromWsdl(javaClass) || model == null){
            return null;
        }
        
        if (model.findServiceByImplementationClass(javaClass.getName()) == null){
            return null;
        }
        
        return new Problem(false, NbBundle.getMessage(JaxWsXmlSafeDeleteRafactoring.class,
                "TXT_JaxWsXmlSafeDeleteWarning", javaClass.getName(), model.getJaxWsFile().getNameExt()));  //NOI18N
        
    }
    
    public Problem checkParameters() {
        return null;
    }
    
    public Problem fastCheckParameters() {
        return null;
    }
    
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        return null;
    }
    
}
