/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.refactoring.safedelete;

import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.Query;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.util.NbBundle;
import org.openide.ErrorManager;

/**
 * @author pfiala
 */
public class EjbQueryMethodSafeDeleteRefactoring extends BaseRefactoring {

    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.safedelete");   // NOI18N
    private Entity entity;
    private Query query;

    public EjbQueryMethodSafeDeleteRefactoring(EjbHelper helper, Entity entity, Query query) {
        super(helper);
        this.entity = entity;
        this.query = query;
    }

    protected Problem preCheckThis() {
        return new Problem(false, NbBundle.getMessage(EjbQueryMethodSafeDeleteRefactoring.class,
            "TXT_QueryMethodWarningSafeDelete", query.getQueryMethod().getMethodName()));
    }

    public Problem prepareThis(RefactoringElementsBag refactoringElementsBag) {
        helper.addRefactoringElement(refactoringElementsBag, new EjbJarRefactoringElement());
        return null;
    }

    public final class EjbJarRefactoringElement extends AbstractSafeDeleteRefactoringElement implements ExternalChange {

        public EjbJarRefactoringElement() {
            super(helper.getFileObject());
        }

        /** Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            return NbBundle.getMessage(EjbQueryMethodSafeDeleteRefactoring.class,
                    "TXT_EjbJarQueryMethodSafeDelete", query.getQueryMethod().getMethodName());  //NOI18N
        }

        /** Performs the change represented by this refactoring element.
         */
        public void performChange() {
            JavaMetamodel.getManager().registerExtChange(this);
        }

        public void performExternalChange() {
            entity.removeQuery(query);
            helper.writeDD();
        }

        public void undoExternalChange() {
            entity.addQuery(query);
            helper.writeDD();
        }
    }
}
