/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.refactoring.rename;

import java.text.MessageFormat;
import java.util.List;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.JMIGenerationUtil;
import org.netbeans.modules.j2ee.refactoring.EntityAnnotationReference;
import org.netbeans.modules.j2ee.refactoring.EntityAssociationResolver;
import org.netbeans.modules.j2ee.refactoring.PersistenceRefactoringUtil;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/**
 * This class provides rename refactoring support for entity annotations.
 *
 * @author Erno Mononen
 */
public class EntityRenameRefactoring {
    
    /**
     * Creates a new instance of EntityRenameRefactoring
     */
    public EntityRenameRefactoring() {
    }
    
    public Problem prepare(AbstractRefactoring refactoring, RefObject refObject,
            String newName, RefactoringElementsBag refactoringElements) {
        
        if (!(refObject instanceof Feature)){
            return null;
        }
        
        JMIUtils.beginJmiTransaction();
        boolean rollback = true;
        try{
            Feature property = (Feature) refObject;
            JavaClass jc = null;
            if  (property.refImmediateComposite() instanceof JavaClass){
                jc = (JavaClass) property.refImmediateComposite();
            }
            
            if (jc != null && PersistenceRefactoringUtil.isEntity(jc)){
                List allEntities = PersistenceRefactoringUtil.getEntitiesInProject(jc);
                EntityAssociationResolver resolver = new EntityAssociationResolver(jc, allEntities);
                List<EntityAnnotationReference> references = resolver.getMappedByReferences(property);
                
                for (EntityAnnotationReference elem : references) {
                    Resource res = elem.getReferring().getResource();
                    FileObject fo = JavaModel.getFileObject(res);
                    
                    RefactoringElementImplementation refactoringElem =
                            new EntityRenameRefactoringElement(elem, property.getName(), newName, fo);
                    refactoringElements.add(refactoring, refactoringElem);
                    
                }
            }
            rollback = false;
        } finally {
            JMIUtils.endJmiTransaction(rollback);
        }
        
        return null;
    }
    
    /**
     * Rename element for entity annotation.
     */
    private static class EntityRenameRefactoringElement extends AbstractRenameRefactoringElement implements ExternalChange {
        
        private EntityAnnotationReference reference;
        /**
         * New value for the annotation attribute value, i.e. new name of the method 
         * that's being renamed without 'get' prefix.
         */
        private String newPropertyName;
        
        public EntityRenameRefactoringElement(EntityAnnotationReference reference,
                String oldName,  String newName, FileObject parentFile) {
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
            this.reference = reference;
            this.newPropertyName = Utility.getPropertyName(newName);
        }
        
        /**
         * @return the old value of the annotation attribute value that is to
         * be renamed.
         */
        private String getOldValue(){
            JMIUtils.beginJmiTransaction();
            boolean rollback = true;
            String oldValue = null;
            try{
                oldValue = ((StringLiteral) reference.getAttributeValue().getValue()).getValue();
                rollback = false;
            } finally {
                JMIUtils.endJmiTransaction(rollback);
            }
            return oldValue;
        }
        
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), getOldValue(), newPropertyName};
            return MessageFormat.format(NbBundle.getMessage(EntityRenameRefactoring.class, "TXT_EntityAnnotationRename"), args);
        }
        
        public void performExternalChange() {
        }
        
        
        public void undoExternalChange() {
        }
        
        public void performChange() {
            JMIUtils.beginJmiTransaction(true);
            boolean rollback = true;
            StringLiteral stringLiteral = null;
            try{
                String newPropertyName = Utility.getPropertyName(newName);
                stringLiteral = ((JavaModelPackage) reference.getAnnotation().refImmediatePackage()).getStringLiteral().createStringLiteral(newPropertyName);
                reference.getAttributeValue().setValue(stringLiteral);
                rollback = false;
            } finally {
                JMIUtils.endJmiTransaction(rollback);
            }
        }
    }
}
