/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.refactoring;

import java.util.Collection;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.j2ee.refactoring.whereused.EjbJarWhereUsedRefactoring;
import org.netbeans.modules.j2ee.refactoring.whereused.EntityWhereUsedRefactoring;
import org.netbeans.modules.j2ee.refactoring.whereused.JaxWsXmlWhereUsedRefactoring;
import org.netbeans.modules.j2ee.refactoring.whereused.PersistenceXmlWhereUsedRefactoring;
import org.netbeans.modules.j2ee.refactoring.whereused.SunJaxWsXmlWhereUsedRefactoring;
import org.netbeans.modules.j2ee.refactoring.whereused.TldWhereUsedRefactoring;
import org.netbeans.modules.j2ee.refactoring.whereused.WebXmlWhereUsedRefactoring;
import org.netbeans.modules.j2ee.refactoring.whereused.WebservicesXmlWhereUsedRefactoring;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;


/**
 *
 * @author Martin Grebac
 */
public class J2EEWhereUsedRefactoringPlugin implements RefactoringPlugin {
    
    /** This one is important creature - makes sure that cycles between plugins won't appear */
    private static ThreadLocal semafor = new ThreadLocal();
    
    private EjbJarWhereUsedRefactoring ejbJarWhereUsedRefactor;
    private WebXmlWhereUsedRefactoring webXmlWhereUsedRefactor;
    private TldWhereUsedRefactoring tldWhereUsedRefactor;
    private WebservicesXmlWhereUsedRefactoring webservicesXmlWhereUsedRefactor;
    private JaxWsXmlWhereUsedRefactoring jaxWsXmlWhereUsedRefactor;
    private PersistenceXmlWhereUsedRefactoring persistenceXmlWhereUsedRefactor;
    private SunJaxWsXmlWhereUsedRefactoring sunJaxWsXmlWhereUsedRefactor;
    private EntityWhereUsedRefactoring entityWhereUsedRefactor;
    
    public void cancelRequest() {
        
    }
    
    public Problem fastCheckParameters() {
        return null;
    }
    
    private AbstractRefactoring refactoring;
    private static ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.whereused");   // NOI18N
    
    /** Creates a new instance of J2EEWhereUsedRefactoringPlugin */
    public J2EEWhereUsedRefactoringPlugin(AbstractRefactoring refactoring) {
        this.refactoring = refactoring;
    }
    
    /** Checks pre-conditions of the refactoring and returns problems.
     * @return Problems found or null (if no problems were identified)
     */
    public Problem preCheck() {
        return null;
    }
    
    /** Checks parameters of the refactoring.
     * @return Problems found or null (if no problems were identified)
     */
    public Problem checkParameters() {
        Problem problem = null;
        if (semafor.get() == null) {
            semafor.set(new Object());
            WhereUsedQuery whereUsedRefactor = ((WhereUsedQuery)refactoring);
            RefObject refObject = (RefObject) whereUsedRefactor.getRefactoredObject();
            try {
                if (Utility.isEjb30((refObject)) && Utility.hasEjbJar(refObject)){
                    Problem ejbJarProblem = new Problem(false, NbBundle.getMessage(J2EEWhereUsedRefactoringPlugin.class, "TXT_EjbJarWhereUsedWarning"));  //NOI18N
                    problem = Utility.addProblemsToEnd(problem, ejbJarProblem);
                }
            }finally {
                semafor.set(null);
            }
        }
        return problem;
    }
    
    /** Collects refactoring elements for a given refactoring.
     * @param refactoringElements Collection of refactoring elements - the implementation of this method
     * should add refactoring elements to this collections. It should make no assumptions about the collection
     * content.
     * @return Problems found or null (if no problems were identified)
     */
    public Problem prepare(RefactoringElementsBag refactoringElements) {
        if (semafor.get() != null) {
            return null;
        }
        semafor.set(new Object());
        try {
            WhereUsedQuery whereUsedRefactor = ((WhereUsedQuery)refactoring);
            
            if (!whereUsedRefactor.isFindUsages()) { // there are no subtype definitions in server specific files, so we return something only when direct usages are to be found
                return null;
            }
            
            Problem problem = null;
            
            RefObject refO = (RefObject) whereUsedRefactor.getRefactoredObject();
            err.log("refO: " + refO);
            
            Problem webXmlProblem = getWebXmlWhereUsedRefactor().prepare(whereUsedRefactor, refO, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, webXmlProblem);
            
            Problem tldProblem = getTldWhereUsedRefactor().prepare(whereUsedRefactor, refO, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, tldProblem);
            
            if (!Utility.isEjb30(refO)){
                Problem ejbJarProblem = getEjbJarWhereUsedRefactor().prepare(whereUsedRefactor, refO, refactoringElements);
                problem = Utility.addProblemsToEnd(problem, ejbJarProblem);
            }
            
            Problem webservicesProblem = getWebservicesXmlWhereUsedRefactor().prepare(whereUsedRefactor, refO, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, webservicesProblem);
            
            Problem jaxWsXmlProblem = getJaxWsXmlWhereUsedRefactoring().prepare(whereUsedRefactor, refO, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, jaxWsXmlProblem);
            
            Problem persistenceXmlProblem = getPersistenceXmlWhereUsedRefactoring().prepare(whereUsedRefactor, refO, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, persistenceXmlProblem);
            
            Problem sunJaxWsXmlProblem = getSunJaxWsXmlWhereUsedRefactoring().prepare(whereUsedRefactor, refO, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, sunJaxWsXmlProblem);
            
            Problem entityProblem = getEntityWhereUsedRefactor().prepare(whereUsedRefactor, refO, refactoringElements);
            problem = Utility.addProblemsToEnd(problem, entityProblem );
            
            
            
            // Method to be looked for
            if (refO instanceof Method) {
                Method method = (Method)refO;
                method.getName();
            }
            
            err.log("Gonna return problem: " + problem);
            return problem;
        } finally {
            semafor.set(null);
        }
    }
    
    private EjbJarWhereUsedRefactoring getEjbJarWhereUsedRefactor() {
        if (ejbJarWhereUsedRefactor == null) {
            ejbJarWhereUsedRefactor = new EjbJarWhereUsedRefactoring();
        }
        return ejbJarWhereUsedRefactor;
    }
    
    private WebXmlWhereUsedRefactoring getWebXmlWhereUsedRefactor() {
        if (webXmlWhereUsedRefactor == null) {
            webXmlWhereUsedRefactor = new WebXmlWhereUsedRefactoring();
        }
        return webXmlWhereUsedRefactor;
    }
    
    private TldWhereUsedRefactoring getTldWhereUsedRefactor() {
        if (tldWhereUsedRefactor == null) {
            tldWhereUsedRefactor = new TldWhereUsedRefactoring();
        }
        return tldWhereUsedRefactor;
    }
    
    private WebservicesXmlWhereUsedRefactoring getWebservicesXmlWhereUsedRefactor() {
        if (webservicesXmlWhereUsedRefactor == null) {
            webservicesXmlWhereUsedRefactor = new WebservicesXmlWhereUsedRefactoring();
        }
        return webservicesXmlWhereUsedRefactor;
    }
    
    private JaxWsXmlWhereUsedRefactoring getJaxWsXmlWhereUsedRefactoring() {
        if (jaxWsXmlWhereUsedRefactor == null) {
            jaxWsXmlWhereUsedRefactor = new JaxWsXmlWhereUsedRefactoring();
        }
        return jaxWsXmlWhereUsedRefactor;
    }
    
    private PersistenceXmlWhereUsedRefactoring getPersistenceXmlWhereUsedRefactoring(){
        if (persistenceXmlWhereUsedRefactor == null){
            persistenceXmlWhereUsedRefactor = new PersistenceXmlWhereUsedRefactoring();
        }
        return persistenceXmlWhereUsedRefactor;
    }
    
    private SunJaxWsXmlWhereUsedRefactoring getSunJaxWsXmlWhereUsedRefactoring() {
        if (sunJaxWsXmlWhereUsedRefactor == null) {
            sunJaxWsXmlWhereUsedRefactor = new SunJaxWsXmlWhereUsedRefactoring();
        }
        return sunJaxWsXmlWhereUsedRefactor;
    }
    
    private EntityWhereUsedRefactoring getEntityWhereUsedRefactor() {
        if (entityWhereUsedRefactor == null){
            entityWhereUsedRefactor = new EntityWhereUsedRefactoring();
        }
        return entityWhereUsedRefactor;
    }
    
    
    
}
