package org.netbeans.modules.prjwizard.snmp;

import com.sun.management.snmp.SnmpVarBindList;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.netbeans.spi.project.ui.templates.support.Templates;
//import org.apache.tools.ant.BuildException;

public class DeviceManagerWizardPanel4 extends JPanel implements WizardDescriptor.FinishablePanel {

    /**
     * The visual component that displays this panel. If you need to access the
     * component from this class, just use getComponent().
     */
    private DeviceManagerVisualPanel4 component;
    public WizardDescriptor wd;
    public SnmpVarBindList list;
    protected final Set listeners = new HashSet(1);
    private SourceGroup[] folders;
    private boolean isFolder;
    private FileObject mFolderRoot = null;
    Project project;
    
        private static final long serialVersionUID = 1L;
        protected JTextField textField;
        protected String title;
        protected SNMPWizardImpl owner;
        private int UTF;

    class NameFieldKeyAdapter extends KeyAdapter {
        /**
         * Overrides default implementation to notify listeners of new collab name value in
         * associated textfield.
         * 
         * @param e KeyEvent to be handled
         */
        public void keyReleased(final KeyEvent e) {
            final String collaborationName = DeviceManagerWizardPanel4.this.textField.getText();

            if (collaborationName != null && collaborationName.trim().length() != 0) {
                DeviceManagerWizardPanel4.this.collabName = collaborationName.trim();
                System.out.println("collabName"+collabName);
            } else {
                DeviceManagerWizardPanel4.this.collabName = null;
                System.out.println("collabName"+collabName);
            }

            DeviceManagerWizardPanel4.this.fireChangeEvent();
        }
    }

    protected String collabName;
    
    DeviceManagerWizardPanel4() {
        this.textField = new JTextField();
        this.textField.addKeyListener(new NameFieldKeyAdapter());
        
        //throw new UnsupportedOperationException("Not yet implemented");
    }

    //DeviceManagerWizardPanel4(SNMPWizardImpl aThis, String message) {
        //throw new UnsupportedOperationException("Not yet implemented");
   // }

    DeviceManagerWizardPanel4(Project project, SourceGroup[] folders, Object object, boolean b) {
        this.project = project;
        this.folders = folders;    
        //throw new UnsupportedOperationException("Not yet implemented");
    }
     public DeviceManagerWizardPanel4(final SNMPWizardImpl myOwner, final String panelTitle) {
        this();

        this.title = panelTitle;
        this.setName(this.title);
        this.owner = myOwner;
    }

    // Get the visual component for the panel. In this template, the component
    // is kept separate. This can be more efficient: if the wizard is created
    // but never displayed, or not all panels are displayed, it is better to
    // create only those which really need to be visible.
    public DeviceManagerVisualPanel4 getComponent() {
        if (component == null) {
            component = new DeviceManagerVisualPanel4();
        }
        return component;
    }
    public String getCollabName() {
        return this.collabName;
    }

    public HelpCtx getHelp() {
        // Show no Help button for this panel:
        return HelpCtx.DEFAULT_HELP;
        // If you have context help:
        // return new HelpCtx(SampleWizardPanel1.class);
    }

    public boolean isValid() {
        // If it is always OK to press Next or Finish, then:
        return true;
        // If it depends on some condition (form filled out...), then:
        // return someCondition();
        // and when this condition changes (last form field filled in...) then:
        // fireChangeEvent();
        // and uncomment the complicated stuff below.
    }

    @SuppressWarnings("unchecked")
    public final void addChangeListener(ChangeListener l) {
          synchronized (this.listeners) {
            this.listeners.add(l);
        }
    }
    
     public void fireChangeEvent() {
        Iterator it;

        synchronized (this.listeners) {
            it = new HashSet(this.listeners).iterator();
        }

        final ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener) it.next()).stateChanged(ev);
        }
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    /*
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1); // or can use ChangeSupport in NB 6.0
    public final void addChangeListener(ChangeListener l) {
    synchronized (listeners) {
    listeners.add(l);
    }
    }
    public final void removeChangeListener(ChangeListener l) {
    synchronized (listeners) {
    listeners.remove(l);
    }
    }
    protected final void fireChangeEvent() {
    Iterator<ChangeListener> it;
    synchronized (listeners) {
    it = new HashSet<ChangeListener>(listeners).iterator();
    }
    ChangeEvent ev = new ChangeEvent(this);
    while (it.hasNext()) {
    it.next().stateChanged(ev);
    }
    }
     */
    // You can use a settings object to keep track of state. Normally the
    // settings object will be the WizardDescriptor, so you can use
    // WizardDescriptor.getProperty & putProperty to store information entered
    // by the user.
    public void readSettings(Object settings) {
        
        if (settings instanceof SNMPWizardContext) {
            final SNMPWizardContext wizardContext = (SNMPWizardContext) settings;
            //System.out.println(" name wizard "+ wizardcontext.)
            wd = (WizardDescriptor) wizardContext.getProperty(SNMPWizardContext.WIZARD_DESCRIPTOR);
        } else if (settings instanceof WizardDescriptor) {
            wd = (WizardDescriptor) settings;
            list = DeviceManagerWizardPanel3.snmpconnect.doRequest(true);
            System.out.println("list "+list.getVarBindAt(0).getStringValue().toString());
            String osName = list.getVarBindAt(0).getStringValue().toString();
            String OIDObject = list.getVarBindAt(1).getStringValue().toString();
            String IPaddress = (String)wd.getProperty(SNMPWizardImpl.IP_ADDRESS);
            String sysName = list.getVarBindAt(2).getStringValue().toString();
            component.getJTable1().setValueAt(osName, 3, 1);
            component.getJTable1().setValueAt(osName,4 ,1);
            component.getJTable1().setValueAt(OIDObject,6 ,1);
            component.getJTable1().setValueAt(sysName,1,1);
            component.getJTable1().setValueAt(IPaddress,0 ,1);
            component.getJTable1().setValueAt("CISCO",2 ,1);
            component.getJTable1().setValueAt("TRUE",5 ,1);
        }

        if (wd != null) {
       //     final String myCollabName = (String) wd.getProperty(SNMPWizardImpl.COLLABORATION_NAME);
         //   this.textField.setText(myCollabName);
        }
    }
    

    public void storeSettings(Object settings) {
       if (settings instanceof SNMPWizardContext) {
            final SNMPWizardContext wizardContext = (SNMPWizardContext) settings;
            wd = (WizardDescriptor) wizardContext.getProperty(SNMPWizardContext.WIZARD_DESCRIPTOR);
        } else if (settings instanceof SNMPWizardDescriptor) {
            wd = (SNMPWizardDescriptor) settings;
            System.out.println(wd.getProperty(SNMPWizardImpl.TRANSPORT_TYPE));
            this.owner.setDescriptor(wd);
        }

        if (wd != null) {

            final Object selectedOption = wd.getValue();
            if (NotifyDescriptor.CANCEL_OPTION == selectedOption || NotifyDescriptor.CLOSED_OPTION == selectedOption) {
                return;
            }
            
            // get the folder where to store the generated xml file 
            //< Normally its the project folder by default>
             Sources sources = ProjectUtils.getSources(project);
            folders = sources.getSourceGroups(Sources.TYPE_GENERIC);
            
            if ((folders == null) || (folders.length < 1)) {
                folders = sources.getSourceGroups(Sources.TYPE_GENERIC);
            }
            
            FileObject preselectedFolder = Templates.getTargetFolder(this.wd);
            SourceGroup preselectedGroup = getPreselectedGroup(folders, preselectedFolder);
            System.out.println("\n\n Preselected group"+preselectedGroup.getRootFolder().getPath());
            System.out.println("\n\n Preselected Folder"+preselectedFolder.getPath());
            String relativeName = getRelativeNativeName(preselectedGroup.getRootFolder(), preselectedFolder);
            try{
                generateXMLFile(preselectedFolder.getPath());
            }catch(Exception e){
                System.out.println("Exception cought"+e.getMessage());
            }
        }
    }
    
    private String getRelativeNativeName(FileObject root, FileObject folder) {
        if (root == null) {
            throw new IllegalArgumentException("null root passed to getRelativeNativeName"); // NOI18N
        }
        String path;
        if (folder == null) {
            path = ""; // NOI18N
        } else {
            path = FileUtil.getRelativePath(root, folder);
        }
        return path == null ? "" : path.replace('/', File.separatorChar); // NOI18N
    }
    // End of variables declaration
    private SourceGroup getPreselectedGroup(SourceGroup[] groups, FileObject folder) {
        for (int i = 0; folder != null && i < groups.length; i++) {
            if (FileUtil.isParentOf(groups[i].getRootFolder(), folder)) {
                return groups[i];
            }
        }

        return groups[0];
    }
    
    private void generateXMLFile(String relativeName) throws FileNotFoundException, UnsupportedEncodingException, IOException{
        
        FileOutputStream fos = null;
            try{
                System.out.println("relativepath "+relativeName);
                StringBuffer sb = new StringBuffer();
                sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                
                sb.append(">\n");
                String osName = list.getVarBindAt(0).getStringValue().toString();
                String OIDObject = list.getVarBindAt(1).getStringValue().toString();
                String IPaddress = (String)wd.getProperty(SNMPWizardImpl.IP_ADDRESS);
                String sysName = list.getVarBindAt(2).getStringValue().toString();
                String port = (String)wd.getProperty(SNMPWizardImpl.DEVICE_PORT);
                sb.append("<DB>\n");
                sb.append("<NetworkElement>\n");
                if (IPaddress != null) {
                        sb.append("        <IPaddress>" +IPaddress);
                        sb.append("<IPaddress/>\n");
                }
                if(port !=null){
                        sb.append("        <PortNumber>"+port);
                        sb.append("<PortNumber/>\n");
                }
                if(sysName != null){
                     sb.append("        <SystemName>" +sysName);
                        sb.append("<SystemName/>\n");
                }
                if(OIDObject != null){
                    sb.append("        <OIDObjectNumber>"+OIDObject);
                        sb.append("<OIDObjectNumber/>\n");
                }
                if(osName != null){
                    sb.append("        <OSNameAndVersion>"+osName);
                        sb.append("<OSNameAndVersion/>\n");
                }

                sb.append("    </NetworkElement>\n");
                sb.append(" </DB>\n");
                String content = sb.toString();
                //String buildDir = getBuildDirectory();
                //if (buildDir == null || "".equals(buildDir)) {
                //throw new BuildException("build directory shouldn't be null or empty");
                //}

            File DeviceDB = new File(relativeName+"/deviceDB.xml");
             fos = new FileOutputStream(DeviceDB);
                store(content.getBytes("UTF-8"), fos);
            } finally {
                if (fos != null) {
                    fos.close();
                } 
        }
    }
     private static void store(byte input[], OutputStream output)
        throws IOException
    {

        ByteArrayInputStream in = new ByteArrayInputStream(input);
        byte buf[] = new byte[4096];
        for(int n = 0; (n = in.read(buf)) != -1;) {
            output.write(buf, 0, n);
        }

        output.flush();
    }

    public boolean isFinishPanel() {
        return true;
        //throw new UnsupportedOperationException("Not supported yet.");
    }
}