/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.script.project.nodes;


import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.script.project.ScriptproConstants;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileEvent;

import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;

//import org.netbeans.modules.bpel.project.ui.customizer.IcanproProjectProperties;
import static org.netbeans.modules.script.project.ScriptproConstants.*;
import org.openide.filesystems.FileChangeListener;
import org.openide.loaders.DataObject;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.VisibilityQuery;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;

/**
 *
 * @author Raghunadh Teegavarapu
 * @version 1.0
 */
public class IcanproViews {
    private static Logger logger = Logger.getLogger(IcanproViews.class.getName());
    
    private static final DataFilter NO_FOLDERS_FILTER = new NoFoldersDataFilter();
    
    private IcanproViews() {
    }
    
    public static final class LogicalViewChildren extends Children.Keys implements FileChangeListener {
        
        private static final String KEY_SOURCE_DIR = "srcDir"; // NOI18N
        private static final String KEY_DOC_BASE = "docBase"; //NOI18N
        private static final String KEY_EJBS = "ejbKey"; //NOI18N
        private static final String WEBSERVICES_DIR = "webservicesDir"; // NOI18N
        private static final String SCRIPT_TRANSFORM_NODE_KEY  = "scriptTransformNodeKey"; // NOI18N
        private static final String KEY_SETUP_DIR = "setupDir"; //NOI18N
        
        private AntProjectHelper helper;
        private final PropertyEvaluator evaluator;
        private FileObject projectDir;
        private Project project;
        
        public LogicalViewChildren(AntProjectHelper helper, PropertyEvaluator evaluator, Project project) {
            assert helper != null;
            this.helper = helper;
            projectDir = helper.getProjectDirectory();
            this.evaluator = evaluator;
            this.project = project;
        }
        
        protected void addNotify() {
            super.addNotify();
            projectDir.addFileChangeListener(this);
// TODO r
//            projectDir.getFileObject("src").addFileChangeListener(this);
            createNodes();
        }
        
        public void reload() {
            createNodes();
        }
        
        private void createNodes() {
            List<Object> l = new ArrayList<Object>();
            /*
            l.add(KEY_EJBS);
             */
            
            DataFolder docBaseDir = getFolder(META_INF);
            if (docBaseDir != null) {
                /*
                l.add(KEY_DOC_BASE);
                 */
            }
            
            DataFolder srcDir = getFolder(SRC_DIR);
            if (srcDir != null) {
                l.add(KEY_SOURCE_DIR);
            }
            
            FileObject setupFolder = getSetupFolder();
            if (setupFolder != null && setupFolder.isFolder()) {
                l.add(KEY_SETUP_DIR);
            }
/*
            l.add(WEBSERVICES_DIR);
 */
// TODO r
//            l.add(SCRIPT_TRANSFORM_NODE_KEY);
            
            FileObject scriptMapFo = getScriptmapFO();
//            Lookup projectLookup = project.getLookup();
//            System.out.println("projectLookup: "+projectLookup);
            if (scriptMapFo != null) {
                l.add(SCRIPT_TRANSFORM_NODE_KEY);
            }
            
            if (l.size() > 0) {
                setKeys(l);
            }
            
        }
        
        private FileObject getSetupFolder() {
            return projectDir.getFileObject("setup"); //NOI18N
        }
        
        protected void removeNotify() {
            setKeys(Collections.EMPTY_SET);
            projectDir.removeFileChangeListener(this);
            // todo r
//            projectDir.getFileObject("src").removeFileChangeListener(this);
            super.removeNotify();
        }
        
        protected Node[] createNodes(Object key) {
            List<Node> nodes = new ArrayList<Node>();
            Node n = null;

            if (key == KEY_SOURCE_DIR) {
                FileObject srcRoot = helper.resolveFileObject(evaluator.getProperty(SRC_DIR));
                Project p = FileOwnerQuery.getOwner(srcRoot);
                Sources s = ProjectUtils.getSources(p);
                SourceGroup sgs [] = ProjectUtils.getSources(p).getSourceGroups(ScriptproConstants.SOURCES_TYPE_ICANPRO);
                for (int i = 0; i < sgs.length; i++) {
                    if (sgs [i].contains(srcRoot)) {
                        try {
                            FileObject folder = sgs[i].getRootFolder();
                            DataObject dobj = DataObject.find(folder);
                            Children children = ((DataFolder) dobj)
                                        .createNodeChildren(NO_FOLDERS_FILTER);
// todo m
                            FileObject scriptmapFile = srcRoot.getFileObject(ScriptproConstants.SCRIPTMAP_XML);
//                            n = new RootNode(dobj.getNodeDelegate(), (DataFolder) dobj);
                            Node scriptTransformationsNode = NodeFactory.createScriptTransformationsNode(scriptmapFile);
                            if (scriptTransformationsNode != null) {
                                children.add(new Node[] {scriptTransformationsNode});
                            }
                            
                            n = new RootNode(srcRoot, dobj.getNodeDelegate(), children);
                        } catch (DataObjectNotFoundException ex) {
                        }
                        break;
                    }
                }
            } 
////            else if (key == SCRIPT_TRANSFORM_NODE_KEY) {
////                FileObject scriptmapFile = getScriptmapFO();
////                if (scriptmapFile != null) {
////                    Project project = FileOwnerQuery.getOwner(scriptmapFile);
////                    if (project != null ) {
////                        Children children = new TransformationsChildren(project);
////                        
////                        DataObject dObj;
////                        try {
////                            dObj = DataObject.find(scriptmapFile);
////                            if (dObj != null) {
////                                nodes.add(new scriptTransformationsNode(dObj, children));
////                            }
////                        } catch (DataObjectNotFoundException ex) {
//////                            System.out.println("can't find scriptmap assoc dataobject ");
////                        }
////                    }
////                }
////            }
            
            if (n != null) {
                nodes.add(n);
            }

            return nodes.toArray(new Node[nodes.size()]);
        }
        
        private FileObject getScriptmapFO() {
            DataFolder srcDir = getFolder(SRC_DIR);
            if (srcDir != null) {
                FileObject srcFO = srcDir.getPrimaryFile();
                if (srcFO == null) {
                    return null;
                }
                
                // TODO m
                return srcFO.getFileObject(ScriptproConstants.SCRIPTMAP_XML);
            }
            return null;
        }
        
        private DataFolder getFolder(String propName) {
            String propertyValue = evaluator.getProperty(propName);
            if (propertyValue != null ) {
                FileObject fo = helper.resolveFileObject(evaluator.getProperty(propName));
                if ( fo != null && fo.isValid()) {
                    try {
                        DataFolder df = DataFolder.findFolder(fo);
                        return df;
                    }catch (Exception ex) {
                        logger.fine(ex.getMessage());
                    }
                }
            }
            return null;
        }
        
        // file change events in the project directory
        public void fileAttributeChanged(org.openide.filesystems.FileAttributeEvent fe) {
        }
        
        public void fileChanged(org.openide.filesystems.FileEvent fe) {
            createNodes();
        }
        
        public void fileDataCreated(org.openide.filesystems.FileEvent fe) {
        }
        
        public void fileDeleted(org.openide.filesystems.FileEvent fe) {
//            if (!projectDir.isValid()){
//                    org.netbeans.api.project.ui.OpenProjects.getDefault().close(new Project[] { project });
//            }
            createNodes();
            // TODO m
//            refreshKey(KEY_SOURCE_DIR);
        }
        
        public void fileFolderCreated(org.openide.filesystems.FileEvent fe) {
            // setup folder could be created
            createNodes();
            // TODO m
//            refreshKey(KEY_SOURCE_DIR);
        }
        
        public void fileRenamed(org.openide.filesystems.FileRenameEvent fe) {
            // setup folder could be renamed
            createNodes();
            // TODO m
//            refreshKey(KEY_SOURCE_DIR);
        }
    }
    
    private static final class RootNode extends FilterNode implements FileChangeListener {
        private FileObject sourceFolder;
        public RootNode(FileObject sourceFolder, Node n, org.openide.nodes.Children children) {
            super(n,  children);
            assert sourceFolder != null;
            disableDelegation(DELEGATE_GET_DISPLAY_NAME|
                    DELEGATE_SET_DISPLAY_NAME|DELEGATE_GET_SHORT_DESCRIPTION|
                    DELEGATE_GET_ACTIONS);
            setDisplayName(
                    NbBundle.getMessage(IcanproViews.class, "LBL_ProcessFiles"));
            this.sourceFolder = sourceFolder;
            sourceFolder.addFileChangeListener(this);
            
        }

        protected void finalize() {
            super.finalize();
            sourceFolder.removeFileChangeListener(this);
        }

// TODO r        
//        public RootNode(Node n, DataFolder dataFolder) {
//            super(n,  dataFolder.createNodeChildren( NO_FOLDERS_FILTER));
//            disableDelegation(DELEGATE_GET_DISPLAY_NAME|
//                    DELEGATE_SET_DISPLAY_NAME|DELEGATE_GET_SHORT_DESCRIPTION|
//                    DELEGATE_GET_ACTIONS);
//            setDisplayName(
//                    NbBundle.getMessage(IcanproViews.class, "LBL_ProcessFiles"));
//            
//        }
        
        @Override
        public Action[] getActions(boolean context) {
            return new Action[] {
                CommonProjectActions.newFileAction(),
                null,
                org.openide.util.actions.SystemAction.get( org.openide.actions.FileSystemAction.class ),
                null,
                org.openide.util.actions.SystemAction.get( org.openide.actions.FindAction.class ),
                null,
                org.openide.util.actions.SystemAction.get( org.openide.actions.PasteAction.class ),
                null,
                org.openide.util.actions.SystemAction.get( org.openide.actions.ToolsAction.class ),
            };
        }
        
        public boolean canDestroy() {
            return false;
        }
        
        @Override
        public boolean canRename() {
            return false;
        }
        
        @Override
        public boolean canCopy() {
            return false;
        }
        
        @Override
        public boolean canCut() {
            return false;
        }
        
        void addScriptMapNode(ScriptTransformationsNode node) {
            assert node != null;
            org.openide.nodes.Children children = getChildren();
            if (children == null || isExistChildNode(children, node)) {
                return;
            } 
            
            children.add(new Node[] {node});
        }
        
        void removeScriptMapNode(String foName) {
            org.openide.nodes.Children children = getChildren();
            if (children == null) {
                return;
            }
            Node scriptMapNode = null;
            Node[] nodes = children.getNodes();
            for (Node elem : nodes) {
                if (elem instanceof ScriptTransformationsNode) {
                    children.remove(new Node[]{elem});
                    break;
                }
            }
        }
        
        private boolean isExistChildNode(org.openide.nodes.Children children,
                Node node) 
        {
            return children.findChild(node.getName()) != null;
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
            FileObject fo = fe.getFile();
            if (isScriptMapFile(fo)) {
                ScriptTransformationsNode scriptMapNode 
                        = NodeFactory.createScriptTransformationsNode(fo);
                if (scriptMapNode != null) {
                    addScriptMapNode(scriptMapNode);
                }
            }
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
            FileObject fo = fe.getFile();
            if (isScriptMapFile(fo)) {
                removeScriptMapNode(fo.getNameExt());
            }
        }

        public void fileRenamed(FileRenameEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
    
    static final class NoFoldersDataFilter implements ChangeListener, ChangeableDataFilter {
        
        EventListenerList ell = new EventListenerList();
        
        public NoFoldersDataFilter() {
            VisibilityQuery.getDefault().addChangeListener( this );
        }
        
        public boolean acceptDataObject(DataObject obj) {
            FileObject fo = obj.getPrimaryFile();
            
            // TODO r
            if (isScriptMapFile(fo)) {
                return false;
            }
            
            return  VisibilityQuery.getDefault().isVisible( fo );
        }
        
        public void stateChanged( ChangeEvent e) {
            Object[] listeners = ell.getListenerList();
            ChangeEvent event = null;
            for (int i = listeners.length-2; i>=0; i-=2) {
                if (listeners[i] == ChangeListener.class) {
                    if ( event == null) {
                        event = new ChangeEvent( this );
                    }
                    ((ChangeListener)listeners[i+1]).stateChanged( event );
                }
            }
        }
        
        public void addChangeListener( ChangeListener listener ) {
            ell.add( ChangeListener.class, listener );
        }
        
        public void removeChangeListener( ChangeListener listener ) {
            ell.remove( ChangeListener.class, listener );
        }
        
    }
    
    // TODO m
    // doesn't show scriptmap file
    public static boolean isScriptMapFile(FileObject fo) {
        if (fo == null) {
            return false;
        }
        Project project = FileOwnerQuery.getOwner(fo);
        FileObject srcFolder =null;
        if (project != null) {
            srcFolder = Util.getSrcFolder(project);
        }
        
        // TODO m
        return ScriptproConstants.SCRIPTMAP_XML.equals(fo.getNameExt())
        && srcFolder != null
                && srcFolder.equals(fo.getParent());
    }
    
}
