package it.imolinfo.jbi4ejb.nbm;

import it.imolinfo.jbi4ejb.nbm.WsdlGeneratorContext.EJBLOOKUP;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/**
 * This class executes the wsdl generation.
 */
public class WsdlGeneratorContext {

    /** The logger */
    private static final Logger LOG = Logger.getLogger(WsdlGeneratorContext.class.getName());

    public static final String WIZARD_DESCRIPTOR = "it.imolinfo.jbi4ejb.WsdlGenerator";

/** The 'look up' way to retrieving an ejb. */
    public enum EJBLOOKUP {

        CORBANAME, JNDI
    }
    {
    }

    /** The remote interface name associated to the ejb. */
    private String remoteInterfaceName = null;

    /** The 'look up' method selected. */
    private EJBLOOKUP ejbLookupMode = EJBLOOKUP.CORBANAME;

    /** the corbaname */
    private String corbaName = null;

    private File earFile = null;

    private String wsdlFileAbsoluteName = null;

    /**
     * The 'ORB properties' when the ejbLookupMode is CORBANAME,
     * or the 'JBDI properties' when the ejbLookupMode is JNDI.
     */
    private Map<String, String> ejbLookupProperties = new HashMap<String, String>();

    /**
     * A map to associate the class of the EJB remote interface with their UID.
     */
    private Map<String, String> classNameAndSerialVersionUidMap = new HashMap<String, String>();


    /**
     * The default constructor.
     */
    public WsdlGeneratorContext() {
        // NOP
    }

    public String toString() {
        return "[WsdlGenerator{" + "earFileName=" + earFile == null ? null : earFile.getAbsolutePath() + "; remoteInterfaceName=" + getRemoteInterfaceName() + "; wsdlFileName=" + getWsdlFileAbsoluteName() + "; ejbLookupMode=" + getEjbLookupMode() + "; corbaName=" + getCorbaName() + "; properties.size=" + (getEjbLookupProperties() == null ? 0 : getEjbLookupProperties().size()) + "}]";
    }

//  public String toString() {
//    return ToStringBuilder.reflectionToString(this);
//  }
//
// public boolean equals(Object obj) {
//   return EqualsBuilder.reflectionEquals(this, obj);
// }
    public String getRemoteInterfaceName() {
        return remoteInterfaceName;
    }

    public void setRemoteInterfaceName(String remoteInterfaceName) {
        this.remoteInterfaceName = remoteInterfaceName;
    }

    public EJBLOOKUP getEjbLookupMode() {
        return ejbLookupMode;
    }

    public void setEjbLookupMode(EJBLOOKUP ejbLookupMode) {
        this.ejbLookupMode = ejbLookupMode;
    }

    public Map<String, String> getEjbLookupProperties() {
        return ejbLookupProperties;
    }

    public void setEjbLookupProperties(Map<String, String> ejbLookupProperties) {
        this.ejbLookupProperties = ejbLookupProperties;
    }

    public String getCorbaName() {
        return corbaName;
    }

    public void setCorbaName(String corbaName) {
        this.corbaName = corbaName;
    }

    public Map<String, String> getClassNameAndSerialVersionUidMap() {
        return classNameAndSerialVersionUidMap;
    }

    public void setClassNameAndSerialVersionUidMap(Map<String, String> classNameAndSerialVersionUidMap) {
    }


    public File getEarFile() {
        return earFile;
    }

    public void setEarFile(File earFile) {
        this.earFile = earFile;
    }

    public String getWsdlFileAbsoluteName() {
        return wsdlFileAbsoluteName;
    }

    public void setWsdlFileAbsoluteName(String wsdlFileAbsoluteName) {
        this.wsdlFileAbsoluteName = wsdlFileAbsoluteName;
    }
}
