package it.imolinfo.jbi4ejb.nbm;

import it.imolinfo.jbi4ejb.nbm.util.WsdlGeneratorUtil;
import java.awt.Component;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;

public class SelectWsdlFileNameWizardPanel implements WizardDescriptor.Panel {

    /**
     * The visual component that displays this panel. If you need to access the
     * component from this class, just use getComponent().
     */
    private SelectWsdlFileNameVisualPanel component;        
    
    private WizardDescriptor templateDescriptor; 
    
    public SelectWsdlFileNameWizardPanel(WizardDescriptor templateDescriptor) {
        this.templateDescriptor = templateDescriptor;
    }

    // Get the visual component for the panel. In this template, the component
// is kept separate. This can be more efficient: if the wizard is created
    // but never displayed, or not all panels are displayed, it is better to
    // create only those which really need to be visible.
    public Component getComponent() {
        if (component == null) {
            component = new SelectWsdlFileNameVisualPanel(this);
        }
        return component;
    }

    public HelpCtx getHelp() {
        // Show no Help button for this panel:
        return HelpCtx.DEFAULT_HELP;
        // If you have context help:
        // return new HelpCtx(SampleWizardPanel1.class);
    }

    /**
     * If the interface is selected, returns true;
     */
    public boolean isValid() {
        
        return true;
    }


    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1); // or can use ChangeSupport in NB 6.0

    public final void addChangeListener(ChangeListener l) {
        synchronized (listeners) {
            listeners.add(l);
        }
    }

    public final void removeChangeListener(ChangeListener l) {
        synchronized (listeners) {
            listeners.remove(l);
        }
    }

    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        synchronized (listeners) {
            it = new HashSet<ChangeListener>(listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }


    // You can use a settings object to keep track of state. Normally the
    // settings object will be the WizardDescriptor, so you can use
    // WizardDescriptor.getProperty & putProperty to store information entered
    // by the user.
    public void readSettings(Object settings) {
            
        WizardDescriptor wd = (WizardDescriptor) settings;
    
        WsdlGeneratorContext context = (WsdlGeneratorContext)
            wd.getProperty(WsdlGeneratorContext.WIZARD_DESCRIPTOR);                       
                                
    }

    public void storeSettings(Object settings) {
        WizardDescriptor wd = (WizardDescriptor) settings;        
                
        WsdlGeneratorContext context = (WsdlGeneratorContext) wd.getProperty(WsdlGeneratorContext.WIZARD_DESCRIPTOR);
        
        if (context == null) {
            context = new WsdlGeneratorContext();
            wd.putProperty(WsdlGeneratorContext.WIZARD_DESCRIPTOR, context);
        }
        
        // Gets the absolute file name
        File directory = FileUtil.toFile(Templates.getTargetFolder(templateDescriptor));
        String fileName = directory.getAbsolutePath() + File.separator + Templates.getTargetName(templateDescriptor);       
        context.setWsdlFileAbsoluteName(fileName);
                            
    }
}
