package it.imolinfo.jbi4ejb.nbm;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;

public class SelectEJBArchiveWizardPanel implements WizardDescriptor.Panel, PropertyChangeListener {
           
    /* Set <ChangeListeners>. */
    protected final Set listeners = new HashSet(1);

    /* The selected file. */
    private File fileSelected = null;

    /**
     * The visual component that displays this panel. If you need to access the
     * component from this class, just use getComponent().
     */
    private SelectEJBArchiveVisualPanel component;    

    /*
     * Get the component panel
     */
    public Component getComponent() {
        if (component == null) {
            component = new SelectEJBArchiveVisualPanel(this);
        }
        component.addPropertyChangeListener(this);
        return component;
    }

    /**
     * Gets the Help
     */
    public HelpCtx getHelp() {
        // Show no Help button for this panel:
        return HelpCtx.DEFAULT_HELP;
        // If you have context help:
        // return new HelpCtx(SampleWizardPanel1.class);
    }

    /**
     * Return true to abilitate the "next" button.
     */
    public boolean isValid() {
        if (fileSelected != null) {
            return true;
        } else {
            return false;
        }
    }


    // You can use a settings object to keep track of state. Normally the
    // settings object will be the WizardDescriptor, so you can use
    // WizardDescriptor.getProperty & putProperty to store information entered
    // by the user.
    public void readSettings(Object settings) {
    }

    /**
     * Store the file object
     */
    public void storeSettings(Object settings) {
        
        WizardDescriptor wd = (WizardDescriptor) settings;
    
        WsdlGeneratorContext context = (WsdlGeneratorContext)
            wd.getProperty(WsdlGeneratorContext.WIZARD_DESCRIPTOR);

        if (context == null) {
            context = new WsdlGeneratorContext();
            wd.putProperty(WsdlGeneratorContext.WIZARD_DESCRIPTOR, context);
        }   
        
        // Sets the file selected
        context.setEarFile(fileSelected);
    }


    public final void addChangeListener(final ChangeListener l) {
        synchronized (this.listeners) {
            this.listeners.add(l);
        }
    }

    public void fireChangeEvent() {
        Iterator it;

        synchronized (this.listeners) {
            it = new HashSet(this.listeners).iterator();
        }

        final ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener) it.next()).stateChanged(ev);
        }
    }


    public final void removeChangeListener(final ChangeListener l) {
        synchronized (this.listeners) {
            this.listeners.remove(l);
        }
    }

    // JFileChooser dialog
    public void propertyChange(PropertyChangeEvent evt) {
        
        if (JFileChooser.SELECTED_FILE_CHANGED_PROPERTY.equals(evt.getPropertyName())) {            
            JFileChooser chooser = (JFileChooser) evt.getSource();            

            // The selected file should always be the same as newFile
            fileSelected = chooser.getSelectedFile();
            
            if ((fileSelected != null) && (fileSelected.exists())) {
                fireChangeEvent();
            }
        }
    }
}
