package it.imolinfo.jbi4corba.netbeansplugin.wsdlextension;

import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;

public enum CorbaQName {

    ADDRESS(createCORBAQName("address")),
    BINDING(createCORBAQName("binding")),
//    FAULT(createCORBAQName("fault")),
    OPERATION(createCORBAQName("operation")),
    MESSAGE(createCORBAQName("message"));

    public static final String CORBA_NS_URI
                    = "uri://schemas.imola.it/jbi/wsdl-extensions/corba/";
    public static final String CORBA_NS_PREFIX = "corba";

    private static Set<QName> qNames;
    private final QName qName;

    private CorbaQName(QName qName) {
        this.qName = qName;
    }

    public static QName createCORBAQName(String localName){
        return new QName(CORBA_NS_URI, localName, CORBA_NS_PREFIX);
    }

    public QName getQName(){
        return qName;
    }

    public static Set<QName> getQNames() {
        if (qNames == null) {
            qNames = new HashSet<QName>();
            for (CorbaQName q : values()) {
                qNames.add(q.getQName());
            }
        }
        return qNames;
    }
}
