/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.aspect.editor.property;

import java.io.File;
import org.netbeans.modules.aspect.editor.jaxbmodel.AdviceType;
import org.openide.ErrorManager;
import org.openide.nodes.Sheet;
import org.openide.nodes.Children;
import org.openide.nodes.PropertySupport;
import org.netbeans.modules.aspect.editor.property.propBeans.logging;
import org.openide.nodes.AbstractNode;

/**
 *
 * @author nk160297
 */
public class loggingNode extends AbstractNode {

    private AdviceType ad;    
        
    public loggingNode(AdviceType ad) {
        
        super(Children.LEAF); 
        this.ad = ad;
        setDisplayName(ad.getType());
    }

    @Override
    public boolean canCopy() {
        return false;
    }
    
    @Override
    public boolean canRename() {
        return false;
    }
    
    @Override 
    public boolean canCut() {
        return false;
    }
    
    @Override
    public boolean canDestroy() {
        return true;
    }
    
    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = sheet.createPropertiesSet();
        logging obj = new logging(ad);
        try {
            Property levelProp = new PropertySupport.Reflection(obj, String.class, "getLevel", "setLevel");
            Property policyProp = new PropertySupport.Reflection(obj, String.class, "getRotationPolicy", "setRotationPolicy");
            Property locationProp = new PropertySupport.Reflection(obj, String.class, "getLogFileLocation", "setLogFileLocation");
            
            levelProp.setName("Log Level");
            policyProp.setName ("Rotation Policy");
            locationProp.setName("Log File");
            
            set.put (levelProp);
            set.put (policyProp);   
            set.put (locationProp);
            
        } catch (Exception ex) {
            ErrorManager.getDefault().notify(ex);
        }
        sheet.put(set);
        return sheet;
    }
   
  }
    

