/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html

 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package org.netbeans.modules.aspect.editor.graph.panels;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.List;

import org.netbeans.modules.aspect.editor.model.Advice;
import org.netbeans.modules.aspect.editor.model.Util;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.aspect.editor.jaxbmodel.AdviceType;
import org.netbeans.modules.aspect.editor.jaxbutils.Utiltools;
/**
 *
 * @author  karthikeyan s
 */
public class EditChainPanel extends javax.swing.JPanel {
    
    //private List<Advice> list; JAXB
    private List<AdviceType> list;
    
    /** Creates new form EditChainPanel */
    public EditChainPanel() {
        initComponents();
        adviceChainTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        adviceChainTable.addMouseListener(new MouseListener(){
            public void mouseClicked(MouseEvent e) {                
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
                JTable table = (JTable)e.getSource();
                if(table.getSelectedRow() == 0) {
                    moveUp.setEnabled(false);
                } else {
                    moveUp.setEnabled(true);
                }                
                if(table.getSelectedRow() == table.getRowCount() - 1) {
                    moveDown.setEnabled(false);
                } else {
                    moveDown.setEnabled(true);
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
            
        });
    }
    
    //public void populateAdviceChain(List<Advice> adviceList) { JAXB
    public void populateAdviceChain(List<AdviceType> adviceList) {
        //list = Util.getSortedAdviceList(adviceList); JAXB
        list = Utiltools.getSortedAdviceList(adviceList);
        Object[] header = new Object[2];
        header[0] = "Order No";
        header[1] = "Advice Type";
        final DefaultTableModel model = new DefaultTableModel(header, list.size());
        Iterator it = list.iterator();
        int i = 1;
        while(it.hasNext()) {
            //Advice adv = (Advice)it.next(); //JAXB
            AdviceType adv = (AdviceType)it.next();
            model.setValueAt(String.valueOf(i), i - 1, 0);
            model.setValueAt(adv.getType(), i - 1, 1);
            //adv.setOrderNo(String.valueOf(i++)); JAXB
            adv.setOrder(Byte.parseByte(String.valueOf(i++)));
        }
        SwingUtilities.invokeLater(new Runnable(){
            public void run() {
                adviceChainTable.setModel(model);
            }
        });
    }
    
    //public List<Advice> getAdviceChain() { JAXB
    public List<AdviceType> getAdviceChain() {
        return list;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jScrollPane1 = new javax.swing.JScrollPane();
        adviceChainTable = new javax.swing.JTable();
        jPanel1 = new javax.swing.JPanel();
        moveUp = new javax.swing.JButton();
        moveDown = new javax.swing.JButton();

        jScrollPane1.setToolTipText(org.openide.util.NbBundle.getMessage(EditChainPanel.class, "EditChainPanel.jScrollPane1.toolTipText")); // NOI18N
        jScrollPane1.setAutoscrolls(true);
        adviceChainTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Title 1", "Title 2"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jScrollPane1.setViewportView(adviceChainTable);

        moveUp.setText(org.openide.util.NbBundle.getMessage(EditChainPanel.class, "EditChainPanel.moveUp.text")); // NOI18N
        moveUp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                moveUpActionPerformed(evt);
            }
        });

        moveDown.setText(org.openide.util.NbBundle.getMessage(EditChainPanel.class, "EditChainPanel.moveDown.text")); // NOI18N
        moveDown.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                moveDownActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(moveUp)
            .add(moveDown, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 87, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .add(moveUp)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(moveDown))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 213, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 126, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    private void moveDownActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_moveDownActionPerformed
        int selRow = adviceChainTable.getSelectedRow();
        //Advice adv = (Advice)list.get(selRow); JAXB
        AdviceType adv = (AdviceType)list.get(selRow);
        //adv.setOrderNo(String.valueOf(selRow + 1)); JAXB
        adv.setOrder(Byte.parseByte(String.valueOf(selRow + 1)));
        //Advice otherAdv = (Advice) list.get(selRow + 1); JAXB
        AdviceType otherAdv = (AdviceType) list.get(selRow + 1);
        //otherAdv.setOrderNo(String.valueOf(selRow)); JAXB
        otherAdv.setOrder(Byte.parseByte(String.valueOf(selRow)));
        updateAdviceChain(list);
    }//GEN-LAST:event_moveDownActionPerformed
    
    private void moveUpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_moveUpActionPerformed
        int selRow = adviceChainTable.getSelectedRow();
        //Advice adv = (Advice)list.get(selRow); JAXB
        AdviceType adv = (AdviceType)list.get(selRow);
        //adv.setOrderNo(String.valueOf(selRow)); JAXB
        adv.setOrder(Byte.parseByte(String.valueOf(selRow)));
        //Advice otherAdv = (Advice) list.get(selRow - 1); JAXB
        AdviceType otherAdv = (AdviceType) list.get(selRow - 1);
        //otherAdv.setOrderNo(String.valueOf(selRow + 1)); JAXB
        otherAdv.setOrder(Byte.parseByte(String.valueOf(selRow + 1)));
        updateAdviceChain(list);
    }//GEN-LAST:event_moveUpActionPerformed
    
    //private void updateAdviceChain(List<Advice> adviceList) { JAXB
    private void updateAdviceChain(List<AdviceType> adviceList) {
        //list = Util.getSortedAdviceList(adviceList); JAXB
        list = Utiltools.getSortedAdviceList(adviceList);
        final DefaultTableModel model = (DefaultTableModel) adviceChainTable.getModel();
        Iterator it = list.iterator();
        int i = 1;
        while(it.hasNext()) {
            //Advice adv = (Advice)it.next(); JAXB
            AdviceType adv = (AdviceType)it.next();
            model.setValueAt(String.valueOf(i), i - 1, 0);
            model.setValueAt(adv.getType(), i - 1, 1);
            //adv.setOrderNo(String.valueOf(i++)); //JAXB
            adv.setOrder(Byte.parseByte(String.valueOf(i++)));
        }
        SwingUtilities.invokeLater(new Runnable(){
            public void run() {
                adviceChainTable.setModel(model);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    javax.swing.JTable adviceChainTable;
    javax.swing.JPanel jPanel1;
    javax.swing.JScrollPane jScrollPane1;
    javax.swing.JButton moveDown;
    javax.swing.JButton moveUp;
    // End of variables declaration//GEN-END:variables
    
}
