/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 *
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2005 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.dcomwizard.builder.wsdl;

// IMPORTANT! You need to compile this class against ant.jar. So add the
// JAR ide5/ant/lib/ant.jar from your IDE installation directory (or any
// other version of Ant you wish to use) to your classpath. Or if
// writing your own build target, use e.g.:
// <classpath>
// <pathelement location="${ant.home}/lib/ant.jar"/>
// </classpath>

import java.io.File;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.BuildException;


/**
 * @author Chandrakanth Belde
 */
public class GenerateWSDL extends Task {

    private String mSrcDirectoryLocation;

    private String mBuildDirectoryLocation;

    private String mWSDLFileName;

    private String mWsdlGenFilePath;

    private String mBinaryFilePath;

    private String mWsdlGenExePath;
    
    public GenerateWSDL() {

    }

    /**
     * @return Returns the WsdlGenFilePath.
     */
    public String getWsdlGenFilePath() {
        return this.mWsdlGenFilePath;
    }

    /**
     * @param WsdlGenFilePath The WsdlGenFilePath to set.
     */
    public void setWsdlGenFilePath(final String wsdlGenFilePath) {
        this.mWsdlGenFilePath = wsdlGenFilePath;
    }

	/**
     * @return Returns the BinaryFilePath.
     */
    public String getBinaryFilePath() {
        return this.mBinaryFilePath;
    }

    /**
     * @param BinaryFilePath The BinaryFilePath to set.
     */
    public void setBinaryFilePath(final String binaryFilePath) {
        this.mBinaryFilePath = binaryFilePath;
    }
	
	/**
     * @return Returns the WsdlGenExePath.
     */
    public String getWsdlGenExePath() {
        return this.mWsdlGenExePath;
    }

    /**
     * @param WsdlGenExePath The wsdlGenExePath to set.
     */
    public void setWsdlGenExePath(final String wsdlGenExePath) {
        this.mWsdlGenExePath = wsdlGenExePath;
    }

	/**
     * @return Returns the srcDirectoryLocation.
     */
    public String getSrcDirectoryLocation() {
        return this.mSrcDirectoryLocation;
    }

    /**
     * @param srcDirectoryLocation The srcDirectoryLocation to set.
     */
    public void setSrcDirectoryLocation(final String srcDirectoryLocation) {
        this.mSrcDirectoryLocation = srcDirectoryLocation;
    }

    /**
     * @return Returns the srcDirectoryLocation.
     */
    public String getBuildDirectoryLocation() {
        return this.mBuildDirectoryLocation;
    }

    /**
     * @param buildDirectoryLocation The buildDirectoryLocation to set.
     */
    public void setBuildDirectoryLocation(final String buildDirectoryLocation) {
        this.mBuildDirectoryLocation = buildDirectoryLocation;
    }

    /**
     * get wsdl file name
     * 
     * @return
     */
    public String getWSDLFileName() {
        return this.mWSDLFileName;
    }

    /**
     * set wsdl file name
     * 
     * @param wsdlFileName
     */
    public void setWSDLFileName(final String wsdlFileName) {
        this.mWSDLFileName = wsdlFileName;
    }

    /**
     * generate wsdl
     * 
     * @throws BuildException
     */
    public void execute() throws BuildException {
        final File srcDir = new File(this.mSrcDirectoryLocation);
        final File genFile = new File(this.mWsdlGenFilePath);
        final File binaryFile = new File(this.mBinaryFilePath);
        final File exePath = new File(this.mWsdlGenExePath);

        if (!srcDir.exists()){
            throw new BuildException("Directory " + this.mSrcDirectoryLocation + " does not exit.");
        } else if (!genFile.exists()){
            throw new BuildException("File " + this.mWsdlGenFilePath + " does not exit.");
        } else if (!binaryFile.exists()){
            throw new BuildException("File " + this.mBinaryFilePath + " does not exit.");
        } else if (!exePath.exists()){
            throw new BuildException("File " + this.mWsdlGenExePath + " does not exit.");
        }
        try {
            final String srcDirPath = srcDir.getAbsolutePath();
            // get the xsd file name and xsd top element name
            final WSDLGenerator wsdlgen = new WSDLGenerator(this.mWSDLFileName, srcDirPath, 
                                    this.mWsdlGenFilePath, this.mBinaryFilePath,this.mWsdlGenExePath);
            //wsdlgen.setTopEleName();
            //wsdlgen.setXSDName();
            wsdlgen.generateWSDL();
        } catch (final Exception e) {
            throw new BuildException(e.getMessage());
        }
    }

    public static void main(final String[] args) {
    /*      GenerateWSDL tsk = new GenerateWSDL();
         tsk.setSrcDirectoryLocation("C:/temp");
         tsk.setWsdlGenFilePath("C:/temp/staging/helloworld.wgen");
         tsk.setBinaryFilePath("C:/temp/helloworld.dll");
         tsk.setWsdlGenExePath("E:/DCOM/MSSOAP/Binaries/wsdlstb3.exe");
         tsk.setWSDLFileName("helloworld");
         tsk.execute(); */
    }
}