/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.sql.framework.ui.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;

import org.netbeans.modules.model.database.DBTable;
import org.netbeans.modules.sql.framework.common.jdbc.SQLDBConnectionDefinition;
import org.netbeans.modules.sql.framework.common.jdbc.SQLUtils;
import org.netbeans.modules.sql.framework.evaluators.database.DB;
import org.netbeans.modules.sql.framework.evaluators.database.DBFactory;
import org.netbeans.modules.sql.framework.evaluators.database.StatementContext;
import org.netbeans.modules.sql.framework.highlighter.SQLEditorPane;
import org.netbeans.modules.sql.framework.model.SQLConstants;
import org.netbeans.modules.sql.framework.model.SQLDefinition;
import org.netbeans.modules.sql.framework.model.SQLObject;
import org.netbeans.modules.sql.framework.model.SourceTable;
import org.netbeans.modules.sql.framework.model.ValidationInfo;
import org.netbeans.modules.sql.framework.model.utils.SQLObjectUtil;
import org.netbeans.modules.sql.framework.model.visitors.SQLValidationVisitor;
import org.netbeans.modules.sql.framework.model.visitors.SQLVisitedObject;
import org.netbeans.modules.sql.framework.ui.SwingWorker;
import org.netbeans.modules.sql.framework.ui.graph.ICommand;
import org.netbeans.modules.sql.framework.ui.utils.UIUtil;
import org.netbeans.modules.sql.framework.ui.view.conditionbuilder.ConditionBuilderUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.NotifyDescriptor.Message;
import org.openide.util.NbBundle;

import com.sun.sql.framework.exception.BaseException;
import com.sun.sql.framework.jdbc.DBConnectionFactory;
import com.sun.sql.framework.jdbc.DBConstants;
import com.sun.sql.framework.utils.Logger;

/**
 * This is a view to show sql code.
 *
 * @author Ritesh Adval
 * @author Ahimanikya Satapathy
 * @version $Revision: 1.2 $
 */
public class SQLStatementPanel extends JPanel implements IMessageView {
    
    private class SQLViewActionListener implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src.equals(refreshButton)) {
                sqlView.execute(ICommand.SHOW_SQL_CMD, new Object[] { sqlObj});
            }
        }
    }
    
    public class ShowSQLWorkerThread extends SwingWorker {
        protected Exception  ex;
        protected SQLObject sqlObjectLocalRef;
        protected String sqlText = "";
        public ShowSQLWorkerThread() {
            sqlObjectLocalRef = sqlObj;
        }
        
        /** Must be executed in AWT Thread and before stopProgressBar() is called. **/
        protected void startProgressBar() {
            String title = NbBundle.getMessage(SQLStatementPanel.class, "MSG_ShowSQL");
            String message = NbBundle.getMessage(SQLStatementPanel.class, "MSG_GeneratingSQL");
            UIUtil.startProgressDialog(title, message);
        }
        
        protected void stopProgressBar() {
            UIUtil.stopProgressDialog();
        }
        
        public boolean hasValidationErrors() throws BaseException {
            return hasValidationErrorsDisplayed(sqlObj);
        }
        
        public Object construct() {
            try {
                startProgressBar();
                
                String sql = null;
                SQLStatementPanel.this.textArea.setText("");
                
                // Sql object is not valid we just want to show validation messages
                if (hasValidationErrors()) {
                    return "";
                }
                
                refreshDBType();
                
                DB db = DBFactory.getInstance().getDatabase(currentDbType);
                StatementContext context = new StatementContext();
                
                if (sqlObjectLocalRef.getObjectType() == SQLConstants.SOURCE_TABLE) {
                    sql = NbBundle.getMessage(SQLStatementPanel.class, "LBL_source_select_sql");
                    sql += db.getStatements().getSelectStatement((SourceTable) sqlObj, context).getSQL();
                } else {
                    context.setUseSourceTableAliasName(true);
                    sql = db.getEvaluatorFactory().evaluate(sqlObj, context);
                }
                
                if (sql != null) {
                    sqlText= sql;
                }
                
            } catch (Exception exp) {
                this.ex = exp;
                sqlText = NbBundle.getMessage(SQLStatementPanel.class, "MSG_cant_evaluate_sql", sqlObj.getDisplayName());
                Logger.printThrowable(Logger.ERROR, this.getClass().getName(), this, "Cannot evaluate SQL for " + sqlObj.getDisplayName(), ex);
                Logger.printThrowable(Logger.ERROR, DataOutputPanel.class.getName(), null, "Can't get contents for table "
                        + ((sqlObj != null) ? sqlObj.getDisplayName() : ""), ex);
            }
            return "";
        }
        
        // Runs on the event-dispatching thread.
        public void finished() {
            SQLStatementPanel.this.textArea.setText(this.sqlText);
            stopProgressBar();
            if (this.ex != null) {
                String errorMsg = NbBundle.getMessage(DataOutputPanel.class, "MSG_error_fetch_failed", sqlObj.getDisplayName(), this.ex.getMessage());
                DialogDisplayer.getDefault().notify(new Message(errorMsg, NotifyDescriptor.ERROR_MESSAGE));
            }
        }
    }
    
    private static final String NL = System.getProperty("line.separator", "\n");
    
    /* Indicates initial DB type name as indicated by the SQLObject or its parent. */
    private String actualDbTypeName;
    
    /* Indicates current DB type; determines "flavor" of generated SQL */
    private int currentDbType;
    
    private JTextField dbTypesBox;
    
    private JButton refreshButton;
    
    /* SQLObject whose applicable SQL content will be generated */
    private SQLObject sqlObj;
    
    private IGraphViewContainer sqlView;
    
    /* Text area to contain SQL content */
    private SQLEditorPane textArea;
    
    /**
     * Creates a new instance of SQLSqlView associated with the given SQLObject.
     *
     * @param sqlView TopComponent which will host this view
     * @param obj SQLObject whose SQL content will be generated
     */
    public SQLStatementPanel(IGraphViewContainer sqlView, SQLObject obj) {
        this.sqlObj = obj;
        this.sqlView = sqlView;
        
        //do not show tab view if there is only one tab
        putClientProperty("TabPolicy", "HideWhenAlone"); //NOI18N
        putClientProperty("PersistenceType", "Never"); //NOI18N
        
        this.setName(NbBundle.getMessage(SQLStatementPanel.class, "LBL_tab_sql", obj.getDisplayName()));
        this.setLayout(new BorderLayout());
        
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(FlowLayout.LEFT));
        panel.setBorder(BorderFactory.createEtchedBorder());
        
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        panel.add(toolbar);
        
        JLabel label = new JLabel(NbBundle.getMessage(SQLStatementPanel.class, "LBL_db_type"));
        toolbar.add(label);
        
        String dbName = getDBType(obj);
        actualDbTypeName = dbName;
        SQLDefinition sqlDefinition = SQLObjectUtil.getAncestralSQLDefinition(sqlObj);
        if (sqlDefinition != null && sqlDefinition.requiresPipelineProcess()) {
            dbName = DBConstants.AXION_STR;
        }
        
        currentDbType = SQLUtils.getSupportedDBType(dbName);
        dbTypesBox = new JTextField(dbName);
        toolbar.add(dbTypesBox);
        dbTypesBox.setEnabled(false);
        
        SQLViewActionListener aListener = new SQLViewActionListener();
        
        //add refresh button
        URL url = getClass().getResource("/org/netbeans/modules/sql/framework/ui/resources/images/refresh.gif");
        refreshButton = new JButton(new ImageIcon(url));
        refreshButton.setToolTipText("Refresh SQL");
        refreshButton.addActionListener(aListener);
        toolbar.add(refreshButton);
        
        this.add(panel, BorderLayout.NORTH);
        
        textArea = new SQLEditorPane();
        
        List tableList = new ArrayList();
        tableList.addAll(sqlDefinition.getSourceTables());
        tableList.addAll(sqlDefinition.getTargetTables());
        
        textArea.setTables(tableList);
        textArea.setFont(new Font("Monospaced", Font.PLAIN, 12));
        textArea.setBackground(Color.white);
        textArea.setEditable(false);
        JScrollPane sPane = new JScrollPane(textArea);
        this.add(sPane, BorderLayout.CENTER);
    }
    
    /**
     * Appends given String to the conetnt view.
     *
     * @param str String to append
     */
    public synchronized void appendToView(String str) {
        try {
            textArea.getDocument().insertString(textArea.getDocument().getLength(), str, null);
        } catch (BadLocationException e) {
            //ignore
        }
    }
    
    public void clearView() {
        textArea.setText(" ");
    }
    
    /**
     * Writes validation errors, if any, associated with the given SQLObject.
     *
     * @param sqlObj2
     * @return
     */
    public boolean hasValidationErrorsDisplayed(SQLObject object) throws BaseException {
        boolean validationErrors = false;
        String errMsg = "";
        
        if (object instanceof SQLVisitedObject) {
            SQLVisitedObject vObject = (SQLVisitedObject) object;
            SQLValidationVisitor vVisitor = new SQLValidationVisitor();
            vObject.visit(vVisitor);
            List invalidObjectList = vVisitor.getValidationInfoList();
            // Ignore validation errors related to custom operator as they can be deferred
            // to test colloboration. validation at this stage has no meaning as
            // the reference for validation is only the host database
            invalidObjectList = ConditionBuilderUtil.filterValidations(invalidObjectList);
            if (invalidObjectList.size() > 0) {
                Iterator iter = invalidObjectList.iterator();
                while (iter.hasNext()) {
                    ValidationInfo invalidObj = (ValidationInfo) iter.next();
                    if (invalidObj.getValidationType() == ValidationInfo.VALIDATION_ERROR) {
                        errMsg += invalidObj.getDescription().trim() + NL;
                        validationErrors = true;
                    }
                }
                if (validationErrors) {
                    throw new BaseException(errMsg);
                }
            }
        }
        
        return validationErrors;
    }
    
    /**
     * Regenerates SQL content based on current settings and state of the associated
     * SQLObject.
     */
    public synchronized void refreshSql() {
        ShowSQLWorkerThread showSqlThread = new ShowSQLWorkerThread();
        showSqlThread.start();
    }
    
    /**
     * refresh view with this new string
     *
     * @param str String to refresh with
     */
    public void refreshView(String str) {
        refreshDBType();
        textArea.setText(str);
    }
    
    public void updateSQLObject(SQLObject obj) {
        this.sqlObj = obj;
        this.setName(NbBundle.getMessage(SQLStatementPanel.class, "LBL_tab_sql", obj.getDisplayName()));
    }
    
    private String getDBType(SQLObject obj) {
        String dbName = DBConstants.ANSI92_STR;
        if (obj instanceof DBTable) {
            DBTable tbl = (DBTable) obj;
            
            // Connection definition should always be of ETL
            SQLDBConnectionDefinition connDef = (SQLDBConnectionDefinition) tbl.getParent().getConnectionDefinition();
            try {
                int srcType = DBConnectionFactory.getInstance().getDatabaseVersion(connDef.getConnectionProperties());
                dbName = SQLUtils.getSupportedDBType(srcType);
            } catch (BaseException e) {
                // ignore
            }
        }
        return dbName;
    }
    
    private void refreshDBType() {
        //here we check if we need to force use of axion db
        SQLDefinition sqlDefinition = SQLObjectUtil.getAncestralSQLDefinition(sqlObj);
        if (sqlDefinition != null && sqlDefinition.requiresPipelineProcess()) {
            currentDbType = DBConstants.AXION;
            dbTypesBox.setText(DBConstants.AXION_STR);
        } else {
            currentDbType = SQLUtils.getSupportedDBType(actualDbTypeName);
            dbTypesBox.setText(actualDbTypeName);
        }
    }
    
}

