/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.sun.manager.jbi.management.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Retrieves the status of JBI Shared Assemblies deployed on the
 * JBI Container on the Server
 *
 * @author Graj
 */
public class JBIServiceAssemblyStatus implements Serializable {

    /** status Deployed. */
    public static final String DEPLOYED_STATUS = "DEPLOYED"; // NOI18N

    /** state  Loaded status.  */
    public static final String UNKNOWN_STATUS = "Unknown"; // NOI18N
    /** status Deployed. */
    public static final String SHUTDOWN_STATUS = "Shutdown"; // NOI18N
    /** Stopped status  */
    public static final String STOP_STATUS = "Stopped"; // NOI18N
    /** Started status */
    public static final String START_STATUS = "Started"; // NOI18N

    String serviceAssemblyName; // {01000000-31778EC7020100-0A124913-01}
    String serviceAssemblyDescription; // Represents this Assembly Unit
    String status; // DEPLOYED

    List<JBIServiceUnitStatus> jbiServiceUnitStatusList = 
            new ArrayList<JBIServiceUnitStatus>();

    /**
     *
     */
    public JBIServiceAssemblyStatus() {
        super();
    }

    /**
     * @param serviceAssemblyName
     * @param serviceAssemblyDescription
     * @param status
     */
    public JBIServiceAssemblyStatus(String serviceAssemblyName,
            String serviceAssemblyDescription, String status) {
        super();
        this.serviceAssemblyName = serviceAssemblyName;
        this.serviceAssemblyDescription = serviceAssemblyDescription;
        this.status = status;
    }


    /**
     * @param serviceAssemblyName
     * @param serviceAssemblyDescription
     * @param status
     * @param jbiServiceUnitStatusList
     */
    public JBIServiceAssemblyStatus(String serviceAssemblyName,
            String serviceAssemblyDescription, String status,
            List<JBIServiceUnitStatus> jbiServiceUnitStatusList) {
        super();
        this.serviceAssemblyName = serviceAssemblyName;
        this.serviceAssemblyDescription = serviceAssemblyDescription;
        this.status = status;
        this.jbiServiceUnitStatusList = jbiServiceUnitStatusList;
    }
    /**
     * @return Returns the jbiServiceUnitList.
     */
    public List<JBIServiceUnitStatus> getJbiServiceUnitStatusList() {
        return this.jbiServiceUnitStatusList;
    }
    /**
     * @param jbiServiceUnitList The jbiServiceUnitList to set.
     */
    public void setJbiServiceUnitStatusList(List<JBIServiceUnitStatus> jbiServiceUnitStatusList) {
        this.jbiServiceUnitStatusList = jbiServiceUnitStatusList;
    }
    /**
     * @return Returns the serviceAssemblyDescription.
     */
    public String getServiceAssemblyDescription() {
        return this.serviceAssemblyDescription;
    }
    /**
     * @param serviceAssemblyDescription The serviceAssemblyDescription to set.
     */
    public void setServiceAssemblyDescription(String serviceAssemblyDescription) {
        this.serviceAssemblyDescription = serviceAssemblyDescription;
    }
    /**
     * @return Returns the serviceAssemblyName.
     */
    public String getServiceAssemblyName() {
        return this.serviceAssemblyName;
    }
    /**
     * @param serviceAssemblyName The serviceAssemblyName to set.
     */
    public void setServiceAssemblyName(String serviceAssemblyName) {
        this.serviceAssemblyName = serviceAssemblyName;
    }
    /**
     * @return Returns the status.
     */
    public String getStatus() {
        return this.status;
    }
    /**
     * @param status The status to set.
     */
    public void setStatus(String status) {
        this.status = status;
    }
    public void dump() {
        System.out.println("/////////////////////////////////////////////////"); // NOI18N
        System.out.println("//  -- JBI Component --                        //"); // NOI18N
        System.out.println("/////////////////////////////////////////////////"); // NOI18N

        System.out.println("//  name is: "+ serviceAssemblyName); // NOI18N
        System.out.println("//  description is: "+ serviceAssemblyDescription); // NOI18N
        System.out.println("//  state is: "+ status); // NOI18N
        JBIServiceUnitStatus unitStatus = null;
        Iterator iterator = this.jbiServiceUnitStatusList.iterator();
        while(iterator.hasNext() == true) {
            unitStatus = (JBIServiceUnitStatus)iterator.next();
            if(unitStatus != null) {
                System.out.println("// --------------------------------------"); // NOI18N
                System.out.println("// ------ Service Unit ------------------"); // NOI18N
                System.out.println("// --------------------------------------"); // NOI18N
                System.out.println("//    name is: "+ unitStatus.getServiceUnitName()); // NOI18N
                System.out.println("//    description is: "+ unitStatus.getServiceUnitDescription()); // NOI18N
                System.out.println("//    state is: "+ unitStatus.getStatus()); // NOI18N
                System.out.println("//    Target Name is: "+ unitStatus.getTargetName()); // NOI18N
            }
        }
        System.out.println("/////////////////////////////////////////////////"); // NOI18N
    }

    public static void main(String[] args) {
    }
}

