/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.impl;


import org.netbeans.modules.bpel.model.api.Assign;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.ConditionHolder;
import org.netbeans.modules.bpel.model.api.ForEach;
import org.netbeans.modules.bpel.model.api.TimeEventHolder;
import org.netbeans.modules.bpel.xpath.view.AbstractBPELElementExpressionView;
import org.netbeans.modules.bpel.xpath.view.BPELExpressionViewFactory;
import org.netbeans.modules.xml.xam.Model.State;

/**
 * @author radval
 *
 *
 */
public class BPELExpressionViewFactoryImpl extends BPELExpressionViewFactory {

    public AbstractBPELElementExpressionView getBPELExpressionView(BpelEntity element) {
        
        if (element == null || element.getBpelModel().getState().equals(State.NOT_WELL_FORMED)) {
            return DefaultExpressionView.getDefault();
        }
        
        AbstractBPELElementExpressionView expressionView = null;
        
        if (element instanceof Assign) {
            expressionView = new AssignExpressionView(element);
        } else if (element instanceof TimeEventHolder) {
            expressionView = new ForOrUntilReferenceExpressionView(element);
        } else if (element instanceof ConditionHolder) {
            expressionView = new ConditionReferenceXPathExpressionView(element);
        } else if (element instanceof ForEach) {
            expressionView = new ForEachExpressionView(element);
        } else {
            expressionView = DefaultExpressionView.getDefault();
        }
        
        return expressionView;
    }
    
    public boolean hasBPELExpressionView(BpelEntity element) {
        
        if (element == null || element.getBpelModel().getState().equals(State.NOT_WELL_FORMED)) {
            return false;
        }
        
        if        (element instanceof Assign) {
            return true;
        } else if (element instanceof TimeEventHolder) {
            return true;
        } else if (element instanceof ConditionHolder) {
            return true;
        } else if (element instanceof ForEach) {
            return true;
        }
        
        return false;
    }
    
}
