/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.model.node.visitor;

import org.netbeans.modules.bpel.xpath.model.nodes.BooleanPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.BranchesPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.DeadlinePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.DurationPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.FinalCounterValuePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.PartNode;
import org.netbeans.modules.bpel.xpath.model.nodes.PredicatePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.StartCounterValuePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariableNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariablesNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathLocationStepNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathOperatorNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathPredicateNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathPredicatesNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDAttributeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDComplexTypeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDElementNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDSimpleTypeNode;
import org.netbeans.modules.bpel.xpath.model.xsd.visitor.XSDToolTipTextGeneratorVisitor;
import org.netbeans.modules.xml.schema.model.Attribute;
import org.netbeans.modules.xml.schema.model.Element;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.LocalSimpleType;
import org.netbeans.modules.xml.schema.model.SimpleTypeDefinition;
import org.netbeans.modules.xml.schema.model.SimpleTypeRestriction;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xpath.LocationStep;
import org.netbeans.modules.xml.xpath.XPathPredicateExpression;
import org.openide.util.NbBundle;



/**
 *
 * @author radval
 *
 */
public class NodeToolTipTextGeneratorVisitor extends AbstractNodeVisitor {
    
    private StringBuffer mToolTipTextBuffer = new StringBuffer(20);
    
    public NodeToolTipTextGeneratorVisitor() {
    }
    
    public String getToolTipText() {
        return this.mToolTipTextBuffer.toString();
    }
    
    public void visit(VariablesNode node) {
    }
    
    public void visit(VariableNode node) {
        // TODO Temporarily disable for performance reasons, currently
        // exploring why variable.getMessageType() is taking so long. - jsandusky
        
//		Variable variable = node.getVariable();
//		WSDLReference<Message> messageRef = variable.getMessageType();
//                SchemaReference<GlobalElement> elementRef = variable.getElement();
//                SchemaReference<GlobalType> typeRef = variable.getType();
//
//		if (messageRef != null) {
//                        Message message = messageRef.get();
//                        if (message != null) {
//                            mToolTipTextBuffer.append("variable is of type wsdl message: " + message.getName());
//                        }
//		} else if (elementRef != null) {
//                        GlobalElement element = elementRef.get();
//                        if (element != null) {
//                            mToolTipTextBuffer.append("variable is of type xsd element: " + element.getName());
//                        }
//		} else if (typeRef != null) {
//                        GlobalType type = typeRef.get();
//                        if (type != null) {
//                            mToolTipTextBuffer.append("variable is of type xsd type: " + type.getName());
//                        }
//		}
    }
    
    public void visit(PartNode node) {
        Part part = node.getPart();
        
        NamedComponentReference<GlobalElement> elementRef = part.getElement();
        NamedComponentReference<GlobalType>  typeRef = part.getType();
        if(elementRef != null) {
            GlobalElement element = elementRef.get();
            if(element != null) {
                mToolTipTextBuffer.append(
                        NbBundle.getMessage(NodeToolTipTextGeneratorVisitor.class,
                            "STR_PART_IS_XSD_ELEMENT")  // NOI18N
                            + element.getName());
            }
        } else if(typeRef != null) {
            GlobalType type = typeRef.get();
            if(type != null) {
                mToolTipTextBuffer.append(
                        NbBundle.getMessage(NodeToolTipTextGeneratorVisitor.class,
                            "STR_PART_IS_XSD_TYPE") // NOI18N
                            + type.getName());
            }
        }
    }
    
    public void visit(XSDAttributeNode node) {
        Attribute attr = node.getAttribute();
        XSDToolTipTextGeneratorVisitor xTTGen = new XSDToolTipTextGeneratorVisitor();
        attr.accept(xTTGen);
        
        String attributeTypeName = xTTGen.getToolTipText();
        
        if(attributeTypeName != null) {
            mToolTipTextBuffer.append(attributeTypeName);
        }
    }
    
    public void visit(XSDElementNode node) {
        Element element = node.getElement();
        XSDToolTipTextGeneratorVisitor xTTGen = new XSDToolTipTextGeneratorVisitor();
        element.accept(xTTGen);
        
        String elementTypeName = xTTGen.getToolTipText();
        
        
        
        if(elementTypeName != null) {
            mToolTipTextBuffer.append(elementTypeName);
        }
    }
    
    public void visit(XSDComplexTypeNode node) {
    }
    
    public void visit(XSDSimpleTypeNode node) {
    }
    
    
    public void visit(XPathOperatorNode node) {
    }
    
    public void visit(XPathPredicateNode node) {
        XPathPredicateExpression predicateExpression = node.getPredicateExpression();
        mToolTipTextBuffer.append(
                NbBundle.getMessage(NodeToolTipTextGeneratorVisitor.class,
                    "STR_XPATH_PREDICATE_IS")   // NOI18N
                    + predicateExpression.getExpressionString());
    }
    
    public void visit(XPathPredicatesNode node) {
        XPathPredicateExpression[] predicateExpression = node.getPredicateExpression();
        mToolTipTextBuffer.append(
                NbBundle.getMessage(NodeToolTipTextGeneratorVisitor.class,
                "PREFIX_XPATH_PREDICATE_IS"));  // NOI18N
        for(int i = 0; i < predicateExpression.length; i++) {
            mToolTipTextBuffer.append(predicateExpression[i].getExpressionString());
        }
    }
    
    public void visit(XPathLocationStepNode node) {
        LocationStep step = node.getLocationStep();
        mToolTipTextBuffer.append(
                NbBundle.getMessage(NodeToolTipTextGeneratorVisitor.class,
                    "PREFIX_XPATH_STEP_IS") // NOI18N
                    + step.getExpressionString());
    }
    
    public void visit(BooleanPlaceHolderNode node) {
        mToolTipTextBuffer.append(
                NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                    "BooleanPlaceHolderNode_Tooltip")); // NOI18N
    }
    
    public void visit(StartCounterValuePlaceHolderNode node) {
        mToolTipTextBuffer.append(
                NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                    "StartCounterValuePlaceHolderNode_Tooltip"));   // NOI18N
    }
    
    public void visit(FinalCounterValuePlaceHolderNode node) {
        mToolTipTextBuffer.append(
                NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                "FinalCounterValuePlaceHolderNode_Tooltip"));   // NOI18N
    }
    
    public void visit(BranchesPlaceHolderNode node) {
        mToolTipTextBuffer.append(
                NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                "BranchesPlaceHolderNode_DisplayName"));    // NOI18N
    }
    
    public void visit(DeadlinePlaceHolderNode node) {
        mToolTipTextBuffer.append(
                NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                    "DeadlinePlaceHolderNode_Tooltip"));    // NOI18N
    }
    
    public void visit(DurationPlaceHolderNode node) {
        mToolTipTextBuffer.append(
                NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                    "DurationPlaceHolderNode_Tooltip"));    // NOI18N
    }
    
    public void visit(PredicatePlaceHolderNode node) {
        mToolTipTextBuffer.append(
                NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                    "PredicatePlaceHolderNode_Tooltip"));   // NOI18N
    }
    
    private String findTypeName(SimpleTypeDefinition std) {
        if(std != null && std instanceof SimpleTypeRestriction) {
            SimpleTypeRestriction str = (SimpleTypeRestriction) std;
            NamedComponentReference<GlobalSimpleType> gst = str.getBase();
            
            return findTypeName(gst.get());
        }
        
        return null;
    }
    
    private String findTypeName(GlobalSimpleType gst) {
        String typeName = null;
        if(gst != null) {
            if(gst.getName()!= null) {
                typeName = gst.getName();
            } else {
                SimpleTypeDefinition std = gst.getDefinition();
                typeName = findTypeName(std);
            }
        }
        
        return typeName;
    }
    
    private String findTypeName(LocalSimpleType lst) {
        String typeName = null;
        if(lst != null) {
            SimpleTypeDefinition std = lst.getDefinition();
            typeName = findTypeName(std);
        }
        
        return typeName;
    }
    
    private String findTypeName(GlobalType gt) {
        if(gt != null) {
            return gt.getName();
        }
        
        return null;
    }
}

