/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.debugger.ui.variable;

import java.util.LinkedList;
import org.netbeans.modules.bpel.debugger.api.variables.SimpleValue;
import org.netbeans.modules.bpel.debugger.api.variables.Value;
import org.netbeans.modules.bpel.debugger.api.variables.WsdlMessageValue;
import org.netbeans.modules.bpel.debugger.api.variables.XmlElementValue;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 *
 * @author Alexander Zgursky
 */
public class HelperTreeModel implements TreeModel {
    private ContextProvider myContextProvider;
    
    /** Creates a new instance of ValueTreeModel */
    public HelperTreeModel(ContextProvider contextProvider) {
        myContextProvider = contextProvider;
    }

    public Object getRoot() {
        return null;
    }

    public Object[] getChildren(Object object, int from, int to) throws UnknownTypeException {
        if (object instanceof Value) {
            return getValueChildren((Value)object, from, to);
        } else if (object instanceof Node) {
            return getNodeChildren((Node)object, from, to);
        } else {
            throw new UnknownTypeException(object);
        }
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        return getChildrenCount(object) == 0;
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        return getChildren(object, 0, 0).length;
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }
    
    private Object[] getValueChildren(Value value, int from, int to) throws UnknownTypeException {
        if (value instanceof SimpleValue) {
            return new Object[0];
        } else if (value instanceof WsdlMessageValue) {
            return ((WsdlMessageValue)value).getParts();
        } else if (value instanceof XmlElementValue) {
            return getChildren(
                    ((XmlElementValue)value).getElement(), from, to);
        } else {
            return new Object[0];
        }
    }
    
    private Object[] getNodeChildren(Node node, int from, int to) throws UnknownTypeException {
        LinkedList<Object> result = new LinkedList<Object>();
        if (node.getNodeType() == Node.ELEMENT_NODE) {
            Element element = (Element)node;
            NamedNodeMap attrs = element.getAttributes();
            int attrsCount = attrs.getLength();
            for (int i=0; i<attrsCount; i++) {
                result.add(attrs.item(i));
            }
        }
        
        NodeList nodes = node.getChildNodes();
        int nodeCount = nodes.getLength();
        if (    nodeCount == 1 && 
                nodes.item(0).getNodeType() == Node.TEXT_NODE)
        {
            //don't add any children - merge the child text node with its parent
        } else {
            for (int i=0 ; i <nodeCount ; i++) {
                Node child = nodes.item(i);
                if (child.getNodeType() == Node.COMMENT_NODE) {
                    continue;
                } else if (child.getNodeType() == Node.TEXT_NODE) {
                    if (    child.getNodeValue() == null ||
                            child.getNodeValue().trim().equals("")
                        ) {
                        continue;
                    }
                }
                result.add(child);
            }
        }
        return result.toArray(new Object[result.size()]);
    }
    
}
