/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.debugger.ui.variable;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Vector;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.netbeans.modules.bpel.debugger.api.BpelDebugger;
import org.netbeans.modules.bpel.debugger.api.ProcessInstance;
import org.netbeans.modules.bpel.debugger.api.variables.NamedValueHost;
import org.netbeans.modules.bpel.debugger.api.variables.Value;
import org.netbeans.modules.bpel.debugger.api.variables.XmlElementValue;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/**
 *
 * @author Alexander Zgursky
 */
public class BpelVariableTreeModel implements TreeModel {
    public static final String VIEW_NAME = "BpelVariablesView";

    private BpelDebugger myDebugger;
    private PositionListener myListener;
    private Vector myListeners = new Vector();
    private DocumentBuilder myDocumentBuilder;
    private ContextProvider myContextProvider;
    private HelperTreeModel myHelperTreeModel;

    
    /**
     * Creates a new instance of BpelVariableTreeModel.
     *
     * @param lookupProvider debugger context
     */
    public BpelVariableTreeModel(ContextProvider contextProvider) {
        myContextProvider = contextProvider;
        myDebugger = 
            (BpelDebugger) contextProvider.lookupFirst(null, BpelDebugger.class);
    }

    
    public Object getRoot() {
        return ROOT;
    }

    public Object[] getChildren(Object object, int from, int to) throws UnknownTypeException {
        if (object.equals(ROOT)) {
            return getVariables(from, to);
        } else if (object instanceof NamedValueHost) {
            NamedValueHost valueHost = (NamedValueHost)object;
            Value value = valueHost.getValue();
            if (value != null) {
                return getHelperTreeModel().getChildren(value, from, to);
            } else {
                return new Object[0];
            }
        } else {
            throw new UnknownTypeException(object);
        }
    }

    /**
     * Returns number of children for given node.
     * 
     * @param   node the parent node
     * @throws  UnknownTypeException if this TreeModel implementation is not
     *          able to resolve children for given node type
     *
     * @return  true if node is leaf
     */
    public int getChildrenCount(Object object) throws UnknownTypeException {
        return getChildren(object, 0, 0).length;
//        if (node.equals(ROOT)) {
//            return getVariableCount();
//        } else if (node instanceof VariablesNode) {
//            return ((VariablesNode) node).getChildrenCount();
//        } else {
//            throw new UnknownTypeException(node);
//        }
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        return getChildrenCount(object) == 0;
//        if (o.equals(ROOT)) {
//            return false;
//        } else if (o instanceof VariablesNode) {
//            if (((VariablesNode) o).getChildrenCount() > 0) {
//                return false;
//            } else {
//                return true;
//            }
//        } else if (o.equals("More")) { // NOI18N
//            return true;
//        } else if (o.equals("NoInfo")) { // NOI18N
//            return true;
//        } else {
//            throw new UnknownTypeException(o);
//        }
    }

    public void addModelListener(ModelListener l) {
        myListeners.add(l);
        if (myListener == null) {
            myListener = new PositionListener(this, getDebugger());
        }
    }

    public void removeModelListener(ModelListener l) {
        myListeners.remove(l);
        if (myListeners.size() == 0) {
            myListener.destroy();
            myListener = null;
        }
    }

    void fireTreeChanged() {
        Vector v = (Vector) myListeners.clone();
        int i, k = v.size();
        for (i = 0; i < k; i++)
            ((ModelListener) v.get(i)).modelChanged(new ModelEvent.TreeChanged(this));
    }

    void fireTableValueChangedChanged(Object node, String propertyName) {
        Vector v = (Vector) myListeners.clone();
        int i, k = v.size();
        for (i = 0; i < k; i++)
            ((ModelListener) v.get(i)).modelChanged(new ModelEvent.TableValueChanged(this, node,
                    propertyName));
    }

    // private methods .........................................................
    
    private HelperTreeModel getHelperTreeModel() {
        if (myHelperTreeModel == null) {
            List models = myContextProvider.lookup(VIEW_NAME, TreeModel.class);
            for (Object model : models) {
                if (model instanceof HelperTreeModel) {
                    myHelperTreeModel = (HelperTreeModel)model;
                    break;
                }
            }
        }
        return myHelperTreeModel;
    }

    private BpelDebugger getDebugger() {
        return myDebugger;
    }
    
    private Object[] getVariables(int from, int to) {
        ProcessInstance processInstance = myDebugger.getCurrentProcessInstance();
        if (processInstance != null) {
            return processInstance.getVariables();
        } else {
            //return generateTestData();
            return new Object[0];
        }
    }
    
    private Object[] generateTestData() {
        File file = new File("C:/temp/sample.xml");

        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document doc = null;
        try {
            doc = factory.newDocumentBuilder().parse(file);
        } catch (IOException ex) {
            ex.printStackTrace();
        } catch (SAXException ex) {
            ex.printStackTrace();
        } catch (ParserConfigurationException ex) {
            ex.printStackTrace();
        }
        
        if (doc == null) {
            return new Object[0];
        }

        class TestVariable implements NamedValueHost {
            private final Document myDocument;
            private XmlElementValue myValue;
            public String getName() {
                return "test";
            }
            
            public TestVariable(Document doc) {
                myDocument = doc;
                myValue = new XmlElementValue() {
                    public Element getElement() {
                        return myDocument.getDocumentElement();
                    }
                    public NamedValueHost getValueHost() {
                        return TestVariable.this;
                    }
                };
                
                XmlElementValue.Helper.bind(doc, myValue);
            }

            public Value getValue() {
                return myValue;
            }
        }
        
        return new Object[] {new TestVariable(doc)};
    }

    // innerclasses ............................................................

    private static class PositionListener implements PropertyChangeListener {

        private BpelDebugger myDebugger;
        private WeakReference myModel;

        private PositionListener(BpelVariableTreeModel tm, BpelDebugger debugger) {
            myDebugger = debugger;
            myModel = new WeakReference(tm);
            debugger.addPropertyChangeListener(this);
        }

        void destroy() {
            myDebugger.removePropertyChangeListener(this);
            if (task != null) {
                // cancel old task
                task.cancel();
                task = null;
            }
        }

        private BpelVariableTreeModel getModel() {
            BpelVariableTreeModel tm = (BpelVariableTreeModel) myModel.get();
            if (tm == null) {
                destroy();
            }
            return tm;
        }

        // currently waiting / running refresh task
        // there is at most one
        private RequestProcessor.Task task;

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == BpelDebugger.PROP_CURRENT_POSITION) {
                final BpelVariableTreeModel ltm = getModel();
                if (ltm == null)
                    return;
                if (task != null) {
                    // cancel old task
                    task.cancel();
                    task = null;
                }
                task = RequestProcessor.getDefault().post(new Runnable() {
                    public void run() {
                        ltm.fireTreeChanged();
                    }
                }, 500);
            }
        }
    }
}
